/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.20.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * DecisionDefinitionDto
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-27T07:19:49.896034Z[Etc/UTC]")
public class DecisionDefinitionDto {
  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_KEY = "key";
  @SerializedName(SERIALIZED_NAME_KEY)
  private String key;

  public static final String SERIALIZED_NAME_CATEGORY = "category";
  @SerializedName(SERIALIZED_NAME_CATEGORY)
  private String category;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_VERSION = "version";
  @SerializedName(SERIALIZED_NAME_VERSION)
  private Integer version;

  public static final String SERIALIZED_NAME_RESOURCE = "resource";
  @SerializedName(SERIALIZED_NAME_RESOURCE)
  private String resource;

  public static final String SERIALIZED_NAME_DEPLOYMENT_ID = "deploymentId";
  @SerializedName(SERIALIZED_NAME_DEPLOYMENT_ID)
  private String deploymentId;

  public static final String SERIALIZED_NAME_TENANT_ID = "tenantId";
  @SerializedName(SERIALIZED_NAME_TENANT_ID)
  private String tenantId;

  public static final String SERIALIZED_NAME_DECISION_REQUIREMENTS_DEFINITION_ID = "decisionRequirementsDefinitionId";
  @SerializedName(SERIALIZED_NAME_DECISION_REQUIREMENTS_DEFINITION_ID)
  private String decisionRequirementsDefinitionId;

  public static final String SERIALIZED_NAME_DECISION_REQUIREMENTS_DEFINITION_KEY = "decisionRequirementsDefinitionKey";
  @SerializedName(SERIALIZED_NAME_DECISION_REQUIREMENTS_DEFINITION_KEY)
  private String decisionRequirementsDefinitionKey;

  public static final String SERIALIZED_NAME_HISTORY_TIME_TO_LIVE = "historyTimeToLive";
  @SerializedName(SERIALIZED_NAME_HISTORY_TIME_TO_LIVE)
  private Integer historyTimeToLive;

  public static final String SERIALIZED_NAME_VERSION_TAG = "versionTag";
  @SerializedName(SERIALIZED_NAME_VERSION_TAG)
  private String versionTag;


  public DecisionDefinitionDto id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * The id of the decision definition
   * @return id
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id of the decision definition")

  public String getId() {
    return id;
  }


  public void setId(String id) {
    this.id = id;
  }


  public DecisionDefinitionDto key(String key) {
    
    this.key = key;
    return this;
  }

   /**
   * The key of the decision definition, i.e., the id of the DMN 1.0 XML decision definition.
   * @return key
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The key of the decision definition, i.e., the id of the DMN 1.0 XML decision definition.")

  public String getKey() {
    return key;
  }


  public void setKey(String key) {
    this.key = key;
  }


  public DecisionDefinitionDto category(String category) {
    
    this.category = category;
    return this;
  }

   /**
   * The category of the decision definition.
   * @return category
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The category of the decision definition.")

  public String getCategory() {
    return category;
  }


  public void setCategory(String category) {
    this.category = category;
  }


  public DecisionDefinitionDto name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * The name of the decision definition.
   * @return name
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The name of the decision definition.")

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }


  public DecisionDefinitionDto version(Integer version) {
    
    this.version = version;
    return this;
  }

   /**
   * The version of the decision definition that the engine assigned to it.
   * @return version
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The version of the decision definition that the engine assigned to it.")

  public Integer getVersion() {
    return version;
  }


  public void setVersion(Integer version) {
    this.version = version;
  }


  public DecisionDefinitionDto resource(String resource) {
    
    this.resource = resource;
    return this;
  }

   /**
   * The file name of the decision definition.
   * @return resource
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The file name of the decision definition.")

  public String getResource() {
    return resource;
  }


  public void setResource(String resource) {
    this.resource = resource;
  }


  public DecisionDefinitionDto deploymentId(String deploymentId) {
    
    this.deploymentId = deploymentId;
    return this;
  }

   /**
   * The deployment id of the decision definition.
   * @return deploymentId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The deployment id of the decision definition.")

  public String getDeploymentId() {
    return deploymentId;
  }


  public void setDeploymentId(String deploymentId) {
    this.deploymentId = deploymentId;
  }


  public DecisionDefinitionDto tenantId(String tenantId) {
    
    this.tenantId = tenantId;
    return this;
  }

   /**
   * The tenant id of the decision definition.
   * @return tenantId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The tenant id of the decision definition.")

  public String getTenantId() {
    return tenantId;
  }


  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }


  public DecisionDefinitionDto decisionRequirementsDefinitionId(String decisionRequirementsDefinitionId) {
    
    this.decisionRequirementsDefinitionId = decisionRequirementsDefinitionId;
    return this;
  }

   /**
   * The id of the decision requirements definition this decision definition belongs to.
   * @return decisionRequirementsDefinitionId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The id of the decision requirements definition this decision definition belongs to.")

  public String getDecisionRequirementsDefinitionId() {
    return decisionRequirementsDefinitionId;
  }


  public void setDecisionRequirementsDefinitionId(String decisionRequirementsDefinitionId) {
    this.decisionRequirementsDefinitionId = decisionRequirementsDefinitionId;
  }


  public DecisionDefinitionDto decisionRequirementsDefinitionKey(String decisionRequirementsDefinitionKey) {
    
    this.decisionRequirementsDefinitionKey = decisionRequirementsDefinitionKey;
    return this;
  }

   /**
   * The key of the decision requirements definition this decision definition belongs to.
   * @return decisionRequirementsDefinitionKey
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The key of the decision requirements definition this decision definition belongs to.")

  public String getDecisionRequirementsDefinitionKey() {
    return decisionRequirementsDefinitionKey;
  }


  public void setDecisionRequirementsDefinitionKey(String decisionRequirementsDefinitionKey) {
    this.decisionRequirementsDefinitionKey = decisionRequirementsDefinitionKey;
  }


  public DecisionDefinitionDto historyTimeToLive(Integer historyTimeToLive) {
    
    this.historyTimeToLive = historyTimeToLive;
    return this;
  }

   /**
   * History time to live value of the decision definition. Is used within [History cleanup](https://docs.camunda.org/manual/7.20/user-guide/process-engine/history/#history-cleanup).
   * minimum: 0
   * @return historyTimeToLive
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "History time to live value of the decision definition. Is used within [History cleanup](https://docs.camunda.org/manual/7.20/user-guide/process-engine/history/#history-cleanup).")

  public Integer getHistoryTimeToLive() {
    return historyTimeToLive;
  }


  public void setHistoryTimeToLive(Integer historyTimeToLive) {
    this.historyTimeToLive = historyTimeToLive;
  }


  public DecisionDefinitionDto versionTag(String versionTag) {
    
    this.versionTag = versionTag;
    return this;
  }

   /**
   * The version tag of the decision definition.
   * @return versionTag
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The version tag of the decision definition.")

  public String getVersionTag() {
    return versionTag;
  }


  public void setVersionTag(String versionTag) {
    this.versionTag = versionTag;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DecisionDefinitionDto decisionDefinitionDto = (DecisionDefinitionDto) o;
    return Objects.equals(this.id, decisionDefinitionDto.id) &&
        Objects.equals(this.key, decisionDefinitionDto.key) &&
        Objects.equals(this.category, decisionDefinitionDto.category) &&
        Objects.equals(this.name, decisionDefinitionDto.name) &&
        Objects.equals(this.version, decisionDefinitionDto.version) &&
        Objects.equals(this.resource, decisionDefinitionDto.resource) &&
        Objects.equals(this.deploymentId, decisionDefinitionDto.deploymentId) &&
        Objects.equals(this.tenantId, decisionDefinitionDto.tenantId) &&
        Objects.equals(this.decisionRequirementsDefinitionId, decisionDefinitionDto.decisionRequirementsDefinitionId) &&
        Objects.equals(this.decisionRequirementsDefinitionKey, decisionDefinitionDto.decisionRequirementsDefinitionKey) &&
        Objects.equals(this.historyTimeToLive, decisionDefinitionDto.historyTimeToLive) &&
        Objects.equals(this.versionTag, decisionDefinitionDto.versionTag);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, key, category, name, version, resource, deploymentId, tenantId, decisionRequirementsDefinitionId, decisionRequirementsDefinitionKey, historyTimeToLive, versionTag);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DecisionDefinitionDto {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    key: ").append(toIndentedString(key)).append("\n");
    sb.append("    category: ").append(toIndentedString(category)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    resource: ").append(toIndentedString(resource)).append("\n");
    sb.append("    deploymentId: ").append(toIndentedString(deploymentId)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    decisionRequirementsDefinitionId: ").append(toIndentedString(decisionRequirementsDefinitionId)).append("\n");
    sb.append("    decisionRequirementsDefinitionKey: ").append(toIndentedString(decisionRequirementsDefinitionKey)).append("\n");
    sb.append("    historyTimeToLive: ").append(toIndentedString(historyTimeToLive)).append("\n");
    sb.append("    versionTag: ").append(toIndentedString(versionTag)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

