/*
 * Camunda Platform REST API
 * OpenApi Spec for Camunda Platform REST API.
 *
 * The version of the OpenAPI document: 7.20.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.camunda.community.rest.client.dto;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * TelemetryLicenseKeyDto
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2023-10-27T07:19:49.896034Z[Etc/UTC]")
public class TelemetryLicenseKeyDto {
  public static final String SERIALIZED_NAME_CUSTOMER = "customer";
  @SerializedName(SERIALIZED_NAME_CUSTOMER)
  private String customer;

  public static final String SERIALIZED_NAME_TYPE = "type";
  @SerializedName(SERIALIZED_NAME_TYPE)
  private String type;

  public static final String SERIALIZED_NAME_VALID_UNTIL = "valid-until";
  @SerializedName(SERIALIZED_NAME_VALID_UNTIL)
  private Date validUntil;

  public static final String SERIALIZED_NAME_UNLIMITED = "unlimited";
  @SerializedName(SERIALIZED_NAME_UNLIMITED)
  private Boolean unlimited;

  public static final String SERIALIZED_NAME_FEATURES = "features";
  @SerializedName(SERIALIZED_NAME_FEATURES)
  private Map<String, String> features = null;

  public static final String SERIALIZED_NAME_RAW = "raw";
  @SerializedName(SERIALIZED_NAME_RAW)
  private String raw;


  public TelemetryLicenseKeyDto customer(String customer) {
    
    this.customer = customer;
    return this;
  }

   /**
   * The name of the customer the license was issued for.
   * @return customer
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The name of the customer the license was issued for.")

  public String getCustomer() {
    return customer;
  }


  public void setCustomer(String customer) {
    this.customer = customer;
  }


  public TelemetryLicenseKeyDto type(String type) {
    
    this.type = type;
    return this;
  }

   /**
   * The license type.
   * @return type
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The license type.")

  public String getType() {
    return type;
  }


  public void setType(String type) {
    this.type = type;
  }


  public TelemetryLicenseKeyDto validUntil(Date validUntil) {
    
    this.validUntil = validUntil;
    return this;
  }

   /**
   * The expiration date of the license.
   * @return validUntil
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The expiration date of the license.")

  public Date getValidUntil() {
    return validUntil;
  }


  public void setValidUntil(Date validUntil) {
    this.validUntil = validUntil;
  }


  public TelemetryLicenseKeyDto unlimited(Boolean unlimited) {
    
    this.unlimited = unlimited;
    return this;
  }

   /**
   * Flag that indicates if the license is unlimited.
   * @return unlimited
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Flag that indicates if the license is unlimited.")

  public Boolean getUnlimited() {
    return unlimited;
  }


  public void setUnlimited(Boolean unlimited) {
    this.unlimited = unlimited;
  }


  public TelemetryLicenseKeyDto features(Map<String, String> features) {
    
    this.features = features;
    return this;
  }

  public TelemetryLicenseKeyDto putFeaturesItem(String key, String featuresItem) {
    if (this.features == null) {
      this.features = new HashMap<String, String>();
    }
    this.features.put(key, featuresItem);
    return this;
  }

   /**
   * A map of features included in the license.
   * @return features
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "A map of features included in the license.")

  public Map<String, String> getFeatures() {
    return features;
  }


  public void setFeatures(Map<String, String> features) {
    this.features = features;
  }


  public TelemetryLicenseKeyDto raw(String raw) {
    
    this.raw = raw;
    return this;
  }

   /**
   * The raw license information.
   * @return raw
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The raw license information.")

  public String getRaw() {
    return raw;
  }


  public void setRaw(String raw) {
    this.raw = raw;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TelemetryLicenseKeyDto telemetryLicenseKeyDto = (TelemetryLicenseKeyDto) o;
    return Objects.equals(this.customer, telemetryLicenseKeyDto.customer) &&
        Objects.equals(this.type, telemetryLicenseKeyDto.type) &&
        Objects.equals(this.validUntil, telemetryLicenseKeyDto.validUntil) &&
        Objects.equals(this.unlimited, telemetryLicenseKeyDto.unlimited) &&
        Objects.equals(this.features, telemetryLicenseKeyDto.features) &&
        Objects.equals(this.raw, telemetryLicenseKeyDto.raw);
  }

  @Override
  public int hashCode() {
    return Objects.hash(customer, type, validUntil, unlimited, features, raw);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TelemetryLicenseKeyDto {\n");
    sb.append("    customer: ").append(toIndentedString(customer)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    validUntil: ").append(toIndentedString(validUntil)).append("\n");
    sb.append("    unlimited: ").append(toIndentedString(unlimited)).append("\n");
    sb.append("    features: ").append(toIndentedString(features)).append("\n");
    sb.append("    raw: ").append(toIndentedString(raw)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

