/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.api;

import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Call;
import org.camunda.community.rest.client.dto.ActivityInstanceDto;
import org.camunda.community.rest.client.dto.BatchDto;
import org.camunda.community.rest.client.dto.CommentDto;
import org.camunda.community.rest.client.dto.CorrelationMessageAsyncDto;
import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.DeleteProcessInstancesDto;
import org.camunda.community.rest.client.dto.PatchVariablesDto;
import org.camunda.community.rest.client.dto.ProcessInstanceDto;
import org.camunda.community.rest.client.dto.ProcessInstanceModificationDto;
import org.camunda.community.rest.client.dto.ProcessInstanceQueryDto;
import org.camunda.community.rest.client.dto.ProcessInstanceSuspensionStateAsyncDto;
import org.camunda.community.rest.client.dto.ProcessInstanceSuspensionStateDto;
import org.camunda.community.rest.client.dto.SetJobRetriesByProcessDto;
import org.camunda.community.rest.client.dto.SetVariablesAsyncDto;
import org.camunda.community.rest.client.dto.SuspensionStateDto;
import org.camunda.community.rest.client.dto.VariableValueDto;
import org.camunda.community.rest.client.invoker.ApiCallback;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiResponse;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

public class ProcessInstanceApi {
    private ApiClient localVarApiClient;

    public ProcessInstanceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ProcessInstanceApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call correlateMessageAsyncOperationCall(CorrelationMessageAsyncDto correlationMessageAsyncDto, ApiCallback _callback) throws ApiException {
        CorrelationMessageAsyncDto localVarPostBody = correlationMessageAsyncDto;
        String localVarPath = "/process-instance/message-async";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call correlateMessageAsyncOperationValidateBeforeCall(CorrelationMessageAsyncDto correlationMessageAsyncDto, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.correlateMessageAsyncOperationCall(correlationMessageAsyncDto, _callback);
        return localVarCall;
    }

    public BatchDto correlateMessageAsyncOperation(CorrelationMessageAsyncDto correlationMessageAsyncDto) throws ApiException {
        ApiResponse<BatchDto> localVarResp = this.correlateMessageAsyncOperationWithHttpInfo(correlationMessageAsyncDto);
        return localVarResp.getData();
    }

    public ApiResponse<BatchDto> correlateMessageAsyncOperationWithHttpInfo(CorrelationMessageAsyncDto correlationMessageAsyncDto) throws ApiException {
        Call localVarCall = this.correlateMessageAsyncOperationValidateBeforeCall(correlationMessageAsyncDto, null);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call correlateMessageAsyncOperationAsync(CorrelationMessageAsyncDto correlationMessageAsyncDto, ApiCallback<BatchDto> _callback) throws ApiException {
        Call localVarCall = this.correlateMessageAsyncOperationValidateBeforeCall(correlationMessageAsyncDto, _callback);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteAsyncHistoricQueryBasedCall(DeleteProcessInstancesDto deleteProcessInstancesDto, ApiCallback _callback) throws ApiException {
        DeleteProcessInstancesDto localVarPostBody = deleteProcessInstancesDto;
        String localVarPath = "/process-instance/delete-historic-query-based";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteAsyncHistoricQueryBasedValidateBeforeCall(DeleteProcessInstancesDto deleteProcessInstancesDto, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.deleteAsyncHistoricQueryBasedCall(deleteProcessInstancesDto, _callback);
        return localVarCall;
    }

    public BatchDto deleteAsyncHistoricQueryBased(DeleteProcessInstancesDto deleteProcessInstancesDto) throws ApiException {
        ApiResponse<BatchDto> localVarResp = this.deleteAsyncHistoricQueryBasedWithHttpInfo(deleteProcessInstancesDto);
        return localVarResp.getData();
    }

    public ApiResponse<BatchDto> deleteAsyncHistoricQueryBasedWithHttpInfo(DeleteProcessInstancesDto deleteProcessInstancesDto) throws ApiException {
        Call localVarCall = this.deleteAsyncHistoricQueryBasedValidateBeforeCall(deleteProcessInstancesDto, null);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteAsyncHistoricQueryBasedAsync(DeleteProcessInstancesDto deleteProcessInstancesDto, ApiCallback<BatchDto> _callback) throws ApiException {
        Call localVarCall = this.deleteAsyncHistoricQueryBasedValidateBeforeCall(deleteProcessInstancesDto, _callback);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call deleteProcessInstanceCall(String id, Boolean skipCustomListeners, Boolean skipIoMappings, Boolean skipSubprocesses, Boolean failIfNotExists, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/process-instance/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (skipCustomListeners != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("skipCustomListeners", skipCustomListeners));
        }
        if (skipIoMappings != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("skipIoMappings", skipIoMappings));
        }
        if (skipSubprocesses != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("skipSubprocesses", skipSubprocesses));
        }
        if (failIfNotExists != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("failIfNotExists", failIfNotExists));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteProcessInstanceValidateBeforeCall(String id, Boolean skipCustomListeners, Boolean skipIoMappings, Boolean skipSubprocesses, Boolean failIfNotExists, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteProcessInstance(Async)");
        }
        Call localVarCall = this.deleteProcessInstanceCall(id, skipCustomListeners, skipIoMappings, skipSubprocesses, failIfNotExists, _callback);
        return localVarCall;
    }

    public void deleteProcessInstance(String id, Boolean skipCustomListeners, Boolean skipIoMappings, Boolean skipSubprocesses, Boolean failIfNotExists) throws ApiException {
        this.deleteProcessInstanceWithHttpInfo(id, skipCustomListeners, skipIoMappings, skipSubprocesses, failIfNotExists);
    }

    public ApiResponse<Void> deleteProcessInstanceWithHttpInfo(String id, Boolean skipCustomListeners, Boolean skipIoMappings, Boolean skipSubprocesses, Boolean failIfNotExists) throws ApiException {
        Call localVarCall = this.deleteProcessInstanceValidateBeforeCall(id, skipCustomListeners, skipIoMappings, skipSubprocesses, failIfNotExists, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteProcessInstanceAsync(String id, Boolean skipCustomListeners, Boolean skipIoMappings, Boolean skipSubprocesses, Boolean failIfNotExists, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteProcessInstanceValidateBeforeCall(id, skipCustomListeners, skipIoMappings, skipSubprocesses, failIfNotExists, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteProcessInstanceVariableCall(String id, String varName, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/process-instance/{id}/variables/{varName}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString())).replaceAll("\\{varName\\}", this.localVarApiClient.escapeString(varName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteProcessInstanceVariableValidateBeforeCall(String id, String varName, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling deleteProcessInstanceVariable(Async)");
        }
        if (varName == null) {
            throw new ApiException("Missing the required parameter 'varName' when calling deleteProcessInstanceVariable(Async)");
        }
        Call localVarCall = this.deleteProcessInstanceVariableCall(id, varName, _callback);
        return localVarCall;
    }

    public void deleteProcessInstanceVariable(String id, String varName) throws ApiException {
        this.deleteProcessInstanceVariableWithHttpInfo(id, varName);
    }

    public ApiResponse<Void> deleteProcessInstanceVariableWithHttpInfo(String id, String varName) throws ApiException {
        Call localVarCall = this.deleteProcessInstanceVariableValidateBeforeCall(id, varName, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call deleteProcessInstanceVariableAsync(String id, String varName, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.deleteProcessInstanceVariableValidateBeforeCall(id, varName, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call deleteProcessInstancesAsyncOperationCall(DeleteProcessInstancesDto deleteProcessInstancesDto, ApiCallback _callback) throws ApiException {
        DeleteProcessInstancesDto localVarPostBody = deleteProcessInstancesDto;
        String localVarPath = "/process-instance/delete";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteProcessInstancesAsyncOperationValidateBeforeCall(DeleteProcessInstancesDto deleteProcessInstancesDto, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.deleteProcessInstancesAsyncOperationCall(deleteProcessInstancesDto, _callback);
        return localVarCall;
    }

    public BatchDto deleteProcessInstancesAsyncOperation(DeleteProcessInstancesDto deleteProcessInstancesDto) throws ApiException {
        ApiResponse<BatchDto> localVarResp = this.deleteProcessInstancesAsyncOperationWithHttpInfo(deleteProcessInstancesDto);
        return localVarResp.getData();
    }

    public ApiResponse<BatchDto> deleteProcessInstancesAsyncOperationWithHttpInfo(DeleteProcessInstancesDto deleteProcessInstancesDto) throws ApiException {
        Call localVarCall = this.deleteProcessInstancesAsyncOperationValidateBeforeCall(deleteProcessInstancesDto, null);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call deleteProcessInstancesAsyncOperationAsync(DeleteProcessInstancesDto deleteProcessInstancesDto, ApiCallback<BatchDto> _callback) throws ApiException {
        Call localVarCall = this.deleteProcessInstancesAsyncOperationValidateBeforeCall(deleteProcessInstancesDto, _callback);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getActivityInstanceTreeCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/process-instance/{id}/activity-instances".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getActivityInstanceTreeValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getActivityInstanceTree(Async)");
        }
        Call localVarCall = this.getActivityInstanceTreeCall(id, _callback);
        return localVarCall;
    }

    public ActivityInstanceDto getActivityInstanceTree(String id) throws ApiException {
        ApiResponse<ActivityInstanceDto> localVarResp = this.getActivityInstanceTreeWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<ActivityInstanceDto> getActivityInstanceTreeWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.getActivityInstanceTreeValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<ActivityInstanceDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getActivityInstanceTreeAsync(String id, ApiCallback<ActivityInstanceDto> _callback) throws ApiException {
        Call localVarCall = this.getActivityInstanceTreeValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<ActivityInstanceDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getProcessInstanceCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/process-instance/{id}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getProcessInstanceValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getProcessInstance(Async)");
        }
        Call localVarCall = this.getProcessInstanceCall(id, _callback);
        return localVarCall;
    }

    public ProcessInstanceDto getProcessInstance(String id) throws ApiException {
        ApiResponse<ProcessInstanceDto> localVarResp = this.getProcessInstanceWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<ProcessInstanceDto> getProcessInstanceWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.getProcessInstanceValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<ProcessInstanceDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getProcessInstanceAsync(String id, ApiCallback<ProcessInstanceDto> _callback) throws ApiException {
        Call localVarCall = this.getProcessInstanceValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<ProcessInstanceDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getProcessInstanceCommentsCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/process-instance/{id}/comment".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getProcessInstanceCommentsValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getProcessInstanceComments(Async)");
        }
        Call localVarCall = this.getProcessInstanceCommentsCall(id, _callback);
        return localVarCall;
    }

    public List<CommentDto> getProcessInstanceComments(String id) throws ApiException {
        ApiResponse<List<CommentDto>> localVarResp = this.getProcessInstanceCommentsWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<List<CommentDto>> getProcessInstanceCommentsWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.getProcessInstanceCommentsValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<List<CommentDto>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getProcessInstanceCommentsAsync(String id, ApiCallback<List<CommentDto>> _callback) throws ApiException {
        Call localVarCall = this.getProcessInstanceCommentsValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<List<CommentDto>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getProcessInstanceVariableCall(String id, String varName, Boolean deserializeValue, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/process-instance/{id}/variables/{varName}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString())).replaceAll("\\{varName\\}", this.localVarApiClient.escapeString(varName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (deserializeValue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("deserializeValue", deserializeValue));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getProcessInstanceVariableValidateBeforeCall(String id, String varName, Boolean deserializeValue, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getProcessInstanceVariable(Async)");
        }
        if (varName == null) {
            throw new ApiException("Missing the required parameter 'varName' when calling getProcessInstanceVariable(Async)");
        }
        Call localVarCall = this.getProcessInstanceVariableCall(id, varName, deserializeValue, _callback);
        return localVarCall;
    }

    public VariableValueDto getProcessInstanceVariable(String id, String varName, Boolean deserializeValue) throws ApiException {
        ApiResponse<VariableValueDto> localVarResp = this.getProcessInstanceVariableWithHttpInfo(id, varName, deserializeValue);
        return localVarResp.getData();
    }

    public ApiResponse<VariableValueDto> getProcessInstanceVariableWithHttpInfo(String id, String varName, Boolean deserializeValue) throws ApiException {
        Call localVarCall = this.getProcessInstanceVariableValidateBeforeCall(id, varName, deserializeValue, null);
        Type localVarReturnType = new TypeToken<VariableValueDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getProcessInstanceVariableAsync(String id, String varName, Boolean deserializeValue, ApiCallback<VariableValueDto> _callback) throws ApiException {
        Call localVarCall = this.getProcessInstanceVariableValidateBeforeCall(id, varName, deserializeValue, _callback);
        Type localVarReturnType = new TypeToken<VariableValueDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getProcessInstanceVariableBinaryCall(String id, String varName, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/process-instance/{id}/variables/{varName}/data".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString())).replaceAll("\\{varName\\}", this.localVarApiClient.escapeString(varName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/octet-stream", "text/plain", "application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getProcessInstanceVariableBinaryValidateBeforeCall(String id, String varName, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getProcessInstanceVariableBinary(Async)");
        }
        if (varName == null) {
            throw new ApiException("Missing the required parameter 'varName' when calling getProcessInstanceVariableBinary(Async)");
        }
        Call localVarCall = this.getProcessInstanceVariableBinaryCall(id, varName, _callback);
        return localVarCall;
    }

    public File getProcessInstanceVariableBinary(String id, String varName) throws ApiException {
        ApiResponse<File> localVarResp = this.getProcessInstanceVariableBinaryWithHttpInfo(id, varName);
        return localVarResp.getData();
    }

    public ApiResponse<File> getProcessInstanceVariableBinaryWithHttpInfo(String id, String varName) throws ApiException {
        Call localVarCall = this.getProcessInstanceVariableBinaryValidateBeforeCall(id, varName, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getProcessInstanceVariableBinaryAsync(String id, String varName, ApiCallback<File> _callback) throws ApiException {
        Call localVarCall = this.getProcessInstanceVariableBinaryValidateBeforeCall(id, varName, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getProcessInstanceVariablesCall(String id, Boolean deserializeValues, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/process-instance/{id}/variables".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (deserializeValues != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("deserializeValues", deserializeValues));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getProcessInstanceVariablesValidateBeforeCall(String id, Boolean deserializeValues, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getProcessInstanceVariables(Async)");
        }
        Call localVarCall = this.getProcessInstanceVariablesCall(id, deserializeValues, _callback);
        return localVarCall;
    }

    public Map<String, VariableValueDto> getProcessInstanceVariables(String id, Boolean deserializeValues) throws ApiException {
        ApiResponse<Map<String, VariableValueDto>> localVarResp = this.getProcessInstanceVariablesWithHttpInfo(id, deserializeValues);
        return localVarResp.getData();
    }

    public ApiResponse<Map<String, VariableValueDto>> getProcessInstanceVariablesWithHttpInfo(String id, Boolean deserializeValues) throws ApiException {
        Call localVarCall = this.getProcessInstanceVariablesValidateBeforeCall(id, deserializeValues, null);
        Type localVarReturnType = new TypeToken<Map<String, VariableValueDto>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getProcessInstanceVariablesAsync(String id, Boolean deserializeValues, ApiCallback<Map<String, VariableValueDto>> _callback) throws ApiException {
        Call localVarCall = this.getProcessInstanceVariablesValidateBeforeCall(id, deserializeValues, _callback);
        Type localVarReturnType = new TypeToken<Map<String, VariableValueDto>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getProcessInstancesCall(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String processInstanceIds, String businessKey, String businessKeyLike, String caseInstanceId, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionKeyNotIn, String deploymentId, String superProcessInstance, String subProcessInstance, String superCaseInstance, String subCaseInstance, Boolean active, Boolean suspended, Boolean withIncident, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, Boolean withoutTenantId, Boolean processDefinitionWithoutTenantId, String activityIdIn, Boolean rootProcessInstances, Boolean leafProcessInstances, String variables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/process-instance";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (sortBy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortBy", sortBy));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sortOrder", sortOrder));
        }
        if (firstResult != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("firstResult", firstResult));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("maxResults", maxResults));
        }
        if (processInstanceIds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processInstanceIds", processInstanceIds));
        }
        if (businessKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("businessKey", businessKey));
        }
        if (businessKeyLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("businessKeyLike", businessKeyLike));
        }
        if (caseInstanceId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("caseInstanceId", caseInstanceId));
        }
        if (processDefinitionId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionId", processDefinitionId));
        }
        if (processDefinitionKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
        }
        if (processDefinitionKeyIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionKeyIn", processDefinitionKeyIn));
        }
        if (processDefinitionKeyNotIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionKeyNotIn", processDefinitionKeyNotIn));
        }
        if (deploymentId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("deploymentId", deploymentId));
        }
        if (superProcessInstance != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("superProcessInstance", superProcessInstance));
        }
        if (subProcessInstance != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("subProcessInstance", subProcessInstance));
        }
        if (superCaseInstance != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("superCaseInstance", superCaseInstance));
        }
        if (subCaseInstance != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("subCaseInstance", subCaseInstance));
        }
        if (active != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("active", active));
        }
        if (suspended != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("suspended", suspended));
        }
        if (withIncident != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withIncident", withIncident));
        }
        if (incidentId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("incidentId", incidentId));
        }
        if (incidentType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("incidentType", incidentType));
        }
        if (incidentMessage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("incidentMessage", incidentMessage));
        }
        if (incidentMessageLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("incidentMessageLike", incidentMessageLike));
        }
        if (tenantIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }
        if (withoutTenantId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }
        if (processDefinitionWithoutTenantId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionWithoutTenantId", processDefinitionWithoutTenantId));
        }
        if (activityIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("activityIdIn", activityIdIn));
        }
        if (rootProcessInstances != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("rootProcessInstances", rootProcessInstances));
        }
        if (leafProcessInstances != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("leafProcessInstances", leafProcessInstances));
        }
        if (variables != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("variables", variables));
        }
        if (variableNamesIgnoreCase != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("variableNamesIgnoreCase", variableNamesIgnoreCase));
        }
        if (variableValuesIgnoreCase != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("variableValuesIgnoreCase", variableValuesIgnoreCase));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getProcessInstancesValidateBeforeCall(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String processInstanceIds, String businessKey, String businessKeyLike, String caseInstanceId, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionKeyNotIn, String deploymentId, String superProcessInstance, String subProcessInstance, String superCaseInstance, String subCaseInstance, Boolean active, Boolean suspended, Boolean withIncident, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, Boolean withoutTenantId, Boolean processDefinitionWithoutTenantId, String activityIdIn, Boolean rootProcessInstances, Boolean leafProcessInstances, String variables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getProcessInstancesCall(sortBy, sortOrder, firstResult, maxResults, processInstanceIds, businessKey, businessKeyLike, caseInstanceId, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processDefinitionKeyNotIn, deploymentId, superProcessInstance, subProcessInstance, superCaseInstance, subCaseInstance, active, suspended, withIncident, incidentId, incidentType, incidentMessage, incidentMessageLike, tenantIdIn, withoutTenantId, processDefinitionWithoutTenantId, activityIdIn, rootProcessInstances, leafProcessInstances, variables, variableNamesIgnoreCase, variableValuesIgnoreCase, _callback);
        return localVarCall;
    }

    public List<ProcessInstanceDto> getProcessInstances(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String processInstanceIds, String businessKey, String businessKeyLike, String caseInstanceId, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionKeyNotIn, String deploymentId, String superProcessInstance, String subProcessInstance, String superCaseInstance, String subCaseInstance, Boolean active, Boolean suspended, Boolean withIncident, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, Boolean withoutTenantId, Boolean processDefinitionWithoutTenantId, String activityIdIn, Boolean rootProcessInstances, Boolean leafProcessInstances, String variables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase) throws ApiException {
        ApiResponse<List<ProcessInstanceDto>> localVarResp = this.getProcessInstancesWithHttpInfo(sortBy, sortOrder, firstResult, maxResults, processInstanceIds, businessKey, businessKeyLike, caseInstanceId, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processDefinitionKeyNotIn, deploymentId, superProcessInstance, subProcessInstance, superCaseInstance, subCaseInstance, active, suspended, withIncident, incidentId, incidentType, incidentMessage, incidentMessageLike, tenantIdIn, withoutTenantId, processDefinitionWithoutTenantId, activityIdIn, rootProcessInstances, leafProcessInstances, variables, variableNamesIgnoreCase, variableValuesIgnoreCase);
        return localVarResp.getData();
    }

    public ApiResponse<List<ProcessInstanceDto>> getProcessInstancesWithHttpInfo(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String processInstanceIds, String businessKey, String businessKeyLike, String caseInstanceId, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionKeyNotIn, String deploymentId, String superProcessInstance, String subProcessInstance, String superCaseInstance, String subCaseInstance, Boolean active, Boolean suspended, Boolean withIncident, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, Boolean withoutTenantId, Boolean processDefinitionWithoutTenantId, String activityIdIn, Boolean rootProcessInstances, Boolean leafProcessInstances, String variables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase) throws ApiException {
        Call localVarCall = this.getProcessInstancesValidateBeforeCall(sortBy, sortOrder, firstResult, maxResults, processInstanceIds, businessKey, businessKeyLike, caseInstanceId, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processDefinitionKeyNotIn, deploymentId, superProcessInstance, subProcessInstance, superCaseInstance, subCaseInstance, active, suspended, withIncident, incidentId, incidentType, incidentMessage, incidentMessageLike, tenantIdIn, withoutTenantId, processDefinitionWithoutTenantId, activityIdIn, rootProcessInstances, leafProcessInstances, variables, variableNamesIgnoreCase, variableValuesIgnoreCase, null);
        Type localVarReturnType = new TypeToken<List<ProcessInstanceDto>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getProcessInstancesAsync(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String processInstanceIds, String businessKey, String businessKeyLike, String caseInstanceId, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionKeyNotIn, String deploymentId, String superProcessInstance, String subProcessInstance, String superCaseInstance, String subCaseInstance, Boolean active, Boolean suspended, Boolean withIncident, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, Boolean withoutTenantId, Boolean processDefinitionWithoutTenantId, String activityIdIn, Boolean rootProcessInstances, Boolean leafProcessInstances, String variables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, ApiCallback<List<ProcessInstanceDto>> _callback) throws ApiException {
        Call localVarCall = this.getProcessInstancesValidateBeforeCall(sortBy, sortOrder, firstResult, maxResults, processInstanceIds, businessKey, businessKeyLike, caseInstanceId, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processDefinitionKeyNotIn, deploymentId, superProcessInstance, subProcessInstance, superCaseInstance, subCaseInstance, active, suspended, withIncident, incidentId, incidentType, incidentMessage, incidentMessageLike, tenantIdIn, withoutTenantId, processDefinitionWithoutTenantId, activityIdIn, rootProcessInstances, leafProcessInstances, variables, variableNamesIgnoreCase, variableValuesIgnoreCase, _callback);
        Type localVarReturnType = new TypeToken<List<ProcessInstanceDto>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getProcessInstancesCountCall(String processInstanceIds, String businessKey, String businessKeyLike, String caseInstanceId, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionKeyNotIn, String deploymentId, String superProcessInstance, String subProcessInstance, String superCaseInstance, String subCaseInstance, Boolean active, Boolean suspended, Boolean withIncident, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, Boolean withoutTenantId, Boolean processDefinitionWithoutTenantId, String activityIdIn, Boolean rootProcessInstances, Boolean leafProcessInstances, String variables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/process-instance/count";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (processInstanceIds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processInstanceIds", processInstanceIds));
        }
        if (businessKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("businessKey", businessKey));
        }
        if (businessKeyLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("businessKeyLike", businessKeyLike));
        }
        if (caseInstanceId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("caseInstanceId", caseInstanceId));
        }
        if (processDefinitionId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionId", processDefinitionId));
        }
        if (processDefinitionKey != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionKey", processDefinitionKey));
        }
        if (processDefinitionKeyIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionKeyIn", processDefinitionKeyIn));
        }
        if (processDefinitionKeyNotIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionKeyNotIn", processDefinitionKeyNotIn));
        }
        if (deploymentId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("deploymentId", deploymentId));
        }
        if (superProcessInstance != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("superProcessInstance", superProcessInstance));
        }
        if (subProcessInstance != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("subProcessInstance", subProcessInstance));
        }
        if (superCaseInstance != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("superCaseInstance", superCaseInstance));
        }
        if (subCaseInstance != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("subCaseInstance", subCaseInstance));
        }
        if (active != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("active", active));
        }
        if (suspended != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("suspended", suspended));
        }
        if (withIncident != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withIncident", withIncident));
        }
        if (incidentId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("incidentId", incidentId));
        }
        if (incidentType != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("incidentType", incidentType));
        }
        if (incidentMessage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("incidentMessage", incidentMessage));
        }
        if (incidentMessageLike != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("incidentMessageLike", incidentMessageLike));
        }
        if (tenantIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("tenantIdIn", tenantIdIn));
        }
        if (withoutTenantId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("withoutTenantId", withoutTenantId));
        }
        if (processDefinitionWithoutTenantId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("processDefinitionWithoutTenantId", processDefinitionWithoutTenantId));
        }
        if (activityIdIn != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("activityIdIn", activityIdIn));
        }
        if (rootProcessInstances != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("rootProcessInstances", rootProcessInstances));
        }
        if (leafProcessInstances != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("leafProcessInstances", leafProcessInstances));
        }
        if (variables != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("variables", variables));
        }
        if (variableNamesIgnoreCase != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("variableNamesIgnoreCase", variableNamesIgnoreCase));
        }
        if (variableValuesIgnoreCase != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("variableValuesIgnoreCase", variableValuesIgnoreCase));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getProcessInstancesCountValidateBeforeCall(String processInstanceIds, String businessKey, String businessKeyLike, String caseInstanceId, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionKeyNotIn, String deploymentId, String superProcessInstance, String subProcessInstance, String superCaseInstance, String subCaseInstance, Boolean active, Boolean suspended, Boolean withIncident, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, Boolean withoutTenantId, Boolean processDefinitionWithoutTenantId, String activityIdIn, Boolean rootProcessInstances, Boolean leafProcessInstances, String variables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.getProcessInstancesCountCall(processInstanceIds, businessKey, businessKeyLike, caseInstanceId, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processDefinitionKeyNotIn, deploymentId, superProcessInstance, subProcessInstance, superCaseInstance, subCaseInstance, active, suspended, withIncident, incidentId, incidentType, incidentMessage, incidentMessageLike, tenantIdIn, withoutTenantId, processDefinitionWithoutTenantId, activityIdIn, rootProcessInstances, leafProcessInstances, variables, variableNamesIgnoreCase, variableValuesIgnoreCase, _callback);
        return localVarCall;
    }

    public CountResultDto getProcessInstancesCount(String processInstanceIds, String businessKey, String businessKeyLike, String caseInstanceId, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionKeyNotIn, String deploymentId, String superProcessInstance, String subProcessInstance, String superCaseInstance, String subCaseInstance, Boolean active, Boolean suspended, Boolean withIncident, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, Boolean withoutTenantId, Boolean processDefinitionWithoutTenantId, String activityIdIn, Boolean rootProcessInstances, Boolean leafProcessInstances, String variables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = this.getProcessInstancesCountWithHttpInfo(processInstanceIds, businessKey, businessKeyLike, caseInstanceId, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processDefinitionKeyNotIn, deploymentId, superProcessInstance, subProcessInstance, superCaseInstance, subCaseInstance, active, suspended, withIncident, incidentId, incidentType, incidentMessage, incidentMessageLike, tenantIdIn, withoutTenantId, processDefinitionWithoutTenantId, activityIdIn, rootProcessInstances, leafProcessInstances, variables, variableNamesIgnoreCase, variableValuesIgnoreCase);
        return localVarResp.getData();
    }

    public ApiResponse<CountResultDto> getProcessInstancesCountWithHttpInfo(String processInstanceIds, String businessKey, String businessKeyLike, String caseInstanceId, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionKeyNotIn, String deploymentId, String superProcessInstance, String subProcessInstance, String superCaseInstance, String subCaseInstance, Boolean active, Boolean suspended, Boolean withIncident, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, Boolean withoutTenantId, Boolean processDefinitionWithoutTenantId, String activityIdIn, Boolean rootProcessInstances, Boolean leafProcessInstances, String variables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase) throws ApiException {
        Call localVarCall = this.getProcessInstancesCountValidateBeforeCall(processInstanceIds, businessKey, businessKeyLike, caseInstanceId, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processDefinitionKeyNotIn, deploymentId, superProcessInstance, subProcessInstance, superCaseInstance, subCaseInstance, active, suspended, withIncident, incidentId, incidentType, incidentMessage, incidentMessageLike, tenantIdIn, withoutTenantId, processDefinitionWithoutTenantId, activityIdIn, rootProcessInstances, leafProcessInstances, variables, variableNamesIgnoreCase, variableValuesIgnoreCase, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getProcessInstancesCountAsync(String processInstanceIds, String businessKey, String businessKeyLike, String caseInstanceId, String processDefinitionId, String processDefinitionKey, String processDefinitionKeyIn, String processDefinitionKeyNotIn, String deploymentId, String superProcessInstance, String subProcessInstance, String superCaseInstance, String subCaseInstance, Boolean active, Boolean suspended, Boolean withIncident, String incidentId, String incidentType, String incidentMessage, String incidentMessageLike, String tenantIdIn, Boolean withoutTenantId, Boolean processDefinitionWithoutTenantId, String activityIdIn, Boolean rootProcessInstances, Boolean leafProcessInstances, String variables, Boolean variableNamesIgnoreCase, Boolean variableValuesIgnoreCase, ApiCallback<CountResultDto> _callback) throws ApiException {
        Call localVarCall = this.getProcessInstancesCountValidateBeforeCall(processInstanceIds, businessKey, businessKeyLike, caseInstanceId, processDefinitionId, processDefinitionKey, processDefinitionKeyIn, processDefinitionKeyNotIn, deploymentId, superProcessInstance, subProcessInstance, superCaseInstance, subCaseInstance, active, suspended, withIncident, incidentId, incidentType, incidentMessage, incidentMessageLike, tenantIdIn, withoutTenantId, processDefinitionWithoutTenantId, activityIdIn, rootProcessInstances, leafProcessInstances, variables, variableNamesIgnoreCase, variableValuesIgnoreCase, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call modifyProcessInstanceCall(String id, ProcessInstanceModificationDto processInstanceModificationDto, ApiCallback _callback) throws ApiException {
        ProcessInstanceModificationDto localVarPostBody = processInstanceModificationDto;
        String localVarPath = "/process-instance/{id}/modification".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call modifyProcessInstanceValidateBeforeCall(String id, ProcessInstanceModificationDto processInstanceModificationDto, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling modifyProcessInstance(Async)");
        }
        Call localVarCall = this.modifyProcessInstanceCall(id, processInstanceModificationDto, _callback);
        return localVarCall;
    }

    public void modifyProcessInstance(String id, ProcessInstanceModificationDto processInstanceModificationDto) throws ApiException {
        this.modifyProcessInstanceWithHttpInfo(id, processInstanceModificationDto);
    }

    public ApiResponse<Void> modifyProcessInstanceWithHttpInfo(String id, ProcessInstanceModificationDto processInstanceModificationDto) throws ApiException {
        Call localVarCall = this.modifyProcessInstanceValidateBeforeCall(id, processInstanceModificationDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call modifyProcessInstanceAsync(String id, ProcessInstanceModificationDto processInstanceModificationDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.modifyProcessInstanceValidateBeforeCall(id, processInstanceModificationDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call modifyProcessInstanceAsyncOperationCall(String id, ProcessInstanceModificationDto processInstanceModificationDto, ApiCallback _callback) throws ApiException {
        ProcessInstanceModificationDto localVarPostBody = processInstanceModificationDto;
        String localVarPath = "/process-instance/{id}/modification-async".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call modifyProcessInstanceAsyncOperationValidateBeforeCall(String id, ProcessInstanceModificationDto processInstanceModificationDto, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling modifyProcessInstanceAsyncOperation(Async)");
        }
        Call localVarCall = this.modifyProcessInstanceAsyncOperationCall(id, processInstanceModificationDto, _callback);
        return localVarCall;
    }

    public BatchDto modifyProcessInstanceAsyncOperation(String id, ProcessInstanceModificationDto processInstanceModificationDto) throws ApiException {
        ApiResponse<BatchDto> localVarResp = this.modifyProcessInstanceAsyncOperationWithHttpInfo(id, processInstanceModificationDto);
        return localVarResp.getData();
    }

    public ApiResponse<BatchDto> modifyProcessInstanceAsyncOperationWithHttpInfo(String id, ProcessInstanceModificationDto processInstanceModificationDto) throws ApiException {
        Call localVarCall = this.modifyProcessInstanceAsyncOperationValidateBeforeCall(id, processInstanceModificationDto, null);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call modifyProcessInstanceAsyncOperationAsync(String id, ProcessInstanceModificationDto processInstanceModificationDto, ApiCallback<BatchDto> _callback) throws ApiException {
        Call localVarCall = this.modifyProcessInstanceAsyncOperationValidateBeforeCall(id, processInstanceModificationDto, _callback);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call modifyProcessInstanceVariablesCall(String id, PatchVariablesDto patchVariablesDto, ApiCallback _callback) throws ApiException {
        PatchVariablesDto localVarPostBody = patchVariablesDto;
        String localVarPath = "/process-instance/{id}/variables".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call modifyProcessInstanceVariablesValidateBeforeCall(String id, PatchVariablesDto patchVariablesDto, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling modifyProcessInstanceVariables(Async)");
        }
        Call localVarCall = this.modifyProcessInstanceVariablesCall(id, patchVariablesDto, _callback);
        return localVarCall;
    }

    public void modifyProcessInstanceVariables(String id, PatchVariablesDto patchVariablesDto) throws ApiException {
        this.modifyProcessInstanceVariablesWithHttpInfo(id, patchVariablesDto);
    }

    public ApiResponse<Void> modifyProcessInstanceVariablesWithHttpInfo(String id, PatchVariablesDto patchVariablesDto) throws ApiException {
        Call localVarCall = this.modifyProcessInstanceVariablesValidateBeforeCall(id, patchVariablesDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call modifyProcessInstanceVariablesAsync(String id, PatchVariablesDto patchVariablesDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.modifyProcessInstanceVariablesValidateBeforeCall(id, patchVariablesDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call queryProcessInstancesCall(Integer firstResult, Integer maxResults, ProcessInstanceQueryDto processInstanceQueryDto, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        ProcessInstanceQueryDto localVarPostBody = processInstanceQueryDto;
        String localVarPath = "/process-instance";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (firstResult != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("firstResult", firstResult));
        }
        if (maxResults != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("maxResults", maxResults));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call queryProcessInstancesValidateBeforeCall(Integer firstResult, Integer maxResults, ProcessInstanceQueryDto processInstanceQueryDto, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.queryProcessInstancesCall(firstResult, maxResults, processInstanceQueryDto, _callback);
        return localVarCall;
    }

    public List<ProcessInstanceDto> queryProcessInstances(Integer firstResult, Integer maxResults, ProcessInstanceQueryDto processInstanceQueryDto) throws ApiException {
        ApiResponse<List<ProcessInstanceDto>> localVarResp = this.queryProcessInstancesWithHttpInfo(firstResult, maxResults, processInstanceQueryDto);
        return localVarResp.getData();
    }

    public ApiResponse<List<ProcessInstanceDto>> queryProcessInstancesWithHttpInfo(Integer firstResult, Integer maxResults, ProcessInstanceQueryDto processInstanceQueryDto) throws ApiException {
        Call localVarCall = this.queryProcessInstancesValidateBeforeCall(firstResult, maxResults, processInstanceQueryDto, null);
        Type localVarReturnType = new TypeToken<List<ProcessInstanceDto>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call queryProcessInstancesAsync(Integer firstResult, Integer maxResults, ProcessInstanceQueryDto processInstanceQueryDto, ApiCallback<List<ProcessInstanceDto>> _callback) throws ApiException {
        Call localVarCall = this.queryProcessInstancesValidateBeforeCall(firstResult, maxResults, processInstanceQueryDto, _callback);
        Type localVarReturnType = new TypeToken<List<ProcessInstanceDto>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call queryProcessInstancesCountCall(ProcessInstanceQueryDto processInstanceQueryDto, ApiCallback _callback) throws ApiException {
        ProcessInstanceQueryDto localVarPostBody = processInstanceQueryDto;
        String localVarPath = "/process-instance/count";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call queryProcessInstancesCountValidateBeforeCall(ProcessInstanceQueryDto processInstanceQueryDto, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.queryProcessInstancesCountCall(processInstanceQueryDto, _callback);
        return localVarCall;
    }

    public CountResultDto queryProcessInstancesCount(ProcessInstanceQueryDto processInstanceQueryDto) throws ApiException {
        ApiResponse<CountResultDto> localVarResp = this.queryProcessInstancesCountWithHttpInfo(processInstanceQueryDto);
        return localVarResp.getData();
    }

    public ApiResponse<CountResultDto> queryProcessInstancesCountWithHttpInfo(ProcessInstanceQueryDto processInstanceQueryDto) throws ApiException {
        Call localVarCall = this.queryProcessInstancesCountValidateBeforeCall(processInstanceQueryDto, null);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call queryProcessInstancesCountAsync(ProcessInstanceQueryDto processInstanceQueryDto, ApiCallback<CountResultDto> _callback) throws ApiException {
        Call localVarCall = this.queryProcessInstancesCountValidateBeforeCall(processInstanceQueryDto, _callback);
        Type localVarReturnType = new TypeToken<CountResultDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call setProcessInstanceVariableCall(String id, String varName, VariableValueDto variableValueDto, ApiCallback _callback) throws ApiException {
        VariableValueDto localVarPostBody = variableValueDto;
        String localVarPath = "/process-instance/{id}/variables/{varName}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString())).replaceAll("\\{varName\\}", this.localVarApiClient.escapeString(varName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call setProcessInstanceVariableValidateBeforeCall(String id, String varName, VariableValueDto variableValueDto, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling setProcessInstanceVariable(Async)");
        }
        if (varName == null) {
            throw new ApiException("Missing the required parameter 'varName' when calling setProcessInstanceVariable(Async)");
        }
        Call localVarCall = this.setProcessInstanceVariableCall(id, varName, variableValueDto, _callback);
        return localVarCall;
    }

    public void setProcessInstanceVariable(String id, String varName, VariableValueDto variableValueDto) throws ApiException {
        this.setProcessInstanceVariableWithHttpInfo(id, varName, variableValueDto);
    }

    public ApiResponse<Void> setProcessInstanceVariableWithHttpInfo(String id, String varName, VariableValueDto variableValueDto) throws ApiException {
        Call localVarCall = this.setProcessInstanceVariableValidateBeforeCall(id, varName, variableValueDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call setProcessInstanceVariableAsync(String id, String varName, VariableValueDto variableValueDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.setProcessInstanceVariableValidateBeforeCall(id, varName, variableValueDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call setProcessInstanceVariableBinaryCall(String id, String varName, File data, String valueType, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/process-instance/{id}/variables/{varName}/data".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString())).replaceAll("\\{varName\\}", this.localVarApiClient.escapeString(varName.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (data != null) {
            localVarFormParams.put("data", data);
        }
        if (valueType != null) {
            localVarFormParams.put("valueType", valueType);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call setProcessInstanceVariableBinaryValidateBeforeCall(String id, String varName, File data, String valueType, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling setProcessInstanceVariableBinary(Async)");
        }
        if (varName == null) {
            throw new ApiException("Missing the required parameter 'varName' when calling setProcessInstanceVariableBinary(Async)");
        }
        Call localVarCall = this.setProcessInstanceVariableBinaryCall(id, varName, data, valueType, _callback);
        return localVarCall;
    }

    public void setProcessInstanceVariableBinary(String id, String varName, File data, String valueType) throws ApiException {
        this.setProcessInstanceVariableBinaryWithHttpInfo(id, varName, data, valueType);
    }

    public ApiResponse<Void> setProcessInstanceVariableBinaryWithHttpInfo(String id, String varName, File data, String valueType) throws ApiException {
        Call localVarCall = this.setProcessInstanceVariableBinaryValidateBeforeCall(id, varName, data, valueType, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call setProcessInstanceVariableBinaryAsync(String id, String varName, File data, String valueType, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.setProcessInstanceVariableBinaryValidateBeforeCall(id, varName, data, valueType, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call setRetriesByProcessCall(SetJobRetriesByProcessDto setJobRetriesByProcessDto, ApiCallback _callback) throws ApiException {
        SetJobRetriesByProcessDto localVarPostBody = setJobRetriesByProcessDto;
        String localVarPath = "/process-instance/job-retries";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call setRetriesByProcessValidateBeforeCall(SetJobRetriesByProcessDto setJobRetriesByProcessDto, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.setRetriesByProcessCall(setJobRetriesByProcessDto, _callback);
        return localVarCall;
    }

    public BatchDto setRetriesByProcess(SetJobRetriesByProcessDto setJobRetriesByProcessDto) throws ApiException {
        ApiResponse<BatchDto> localVarResp = this.setRetriesByProcessWithHttpInfo(setJobRetriesByProcessDto);
        return localVarResp.getData();
    }

    public ApiResponse<BatchDto> setRetriesByProcessWithHttpInfo(SetJobRetriesByProcessDto setJobRetriesByProcessDto) throws ApiException {
        Call localVarCall = this.setRetriesByProcessValidateBeforeCall(setJobRetriesByProcessDto, null);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call setRetriesByProcessAsync(SetJobRetriesByProcessDto setJobRetriesByProcessDto, ApiCallback<BatchDto> _callback) throws ApiException {
        Call localVarCall = this.setRetriesByProcessValidateBeforeCall(setJobRetriesByProcessDto, _callback);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call setRetriesByProcessHistoricQueryBasedCall(SetJobRetriesByProcessDto setJobRetriesByProcessDto, ApiCallback _callback) throws ApiException {
        SetJobRetriesByProcessDto localVarPostBody = setJobRetriesByProcessDto;
        String localVarPath = "/process-instance/job-retries-historic-query-based";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call setRetriesByProcessHistoricQueryBasedValidateBeforeCall(SetJobRetriesByProcessDto setJobRetriesByProcessDto, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.setRetriesByProcessHistoricQueryBasedCall(setJobRetriesByProcessDto, _callback);
        return localVarCall;
    }

    public BatchDto setRetriesByProcessHistoricQueryBased(SetJobRetriesByProcessDto setJobRetriesByProcessDto) throws ApiException {
        ApiResponse<BatchDto> localVarResp = this.setRetriesByProcessHistoricQueryBasedWithHttpInfo(setJobRetriesByProcessDto);
        return localVarResp.getData();
    }

    public ApiResponse<BatchDto> setRetriesByProcessHistoricQueryBasedWithHttpInfo(SetJobRetriesByProcessDto setJobRetriesByProcessDto) throws ApiException {
        Call localVarCall = this.setRetriesByProcessHistoricQueryBasedValidateBeforeCall(setJobRetriesByProcessDto, null);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call setRetriesByProcessHistoricQueryBasedAsync(SetJobRetriesByProcessDto setJobRetriesByProcessDto, ApiCallback<BatchDto> _callback) throws ApiException {
        Call localVarCall = this.setRetriesByProcessHistoricQueryBasedValidateBeforeCall(setJobRetriesByProcessDto, _callback);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call setVariablesAsyncOperationCall(SetVariablesAsyncDto setVariablesAsyncDto, ApiCallback _callback) throws ApiException {
        SetVariablesAsyncDto localVarPostBody = setVariablesAsyncDto;
        String localVarPath = "/process-instance/variables-async";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call setVariablesAsyncOperationValidateBeforeCall(SetVariablesAsyncDto setVariablesAsyncDto, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.setVariablesAsyncOperationCall(setVariablesAsyncDto, _callback);
        return localVarCall;
    }

    public BatchDto setVariablesAsyncOperation(SetVariablesAsyncDto setVariablesAsyncDto) throws ApiException {
        ApiResponse<BatchDto> localVarResp = this.setVariablesAsyncOperationWithHttpInfo(setVariablesAsyncDto);
        return localVarResp.getData();
    }

    public ApiResponse<BatchDto> setVariablesAsyncOperationWithHttpInfo(SetVariablesAsyncDto setVariablesAsyncDto) throws ApiException {
        Call localVarCall = this.setVariablesAsyncOperationValidateBeforeCall(setVariablesAsyncDto, null);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call setVariablesAsyncOperationAsync(SetVariablesAsyncDto setVariablesAsyncDto, ApiCallback<BatchDto> _callback) throws ApiException {
        Call localVarCall = this.setVariablesAsyncOperationValidateBeforeCall(setVariablesAsyncDto, _callback);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSuspensionStateCall(ProcessInstanceSuspensionStateDto processInstanceSuspensionStateDto, ApiCallback _callback) throws ApiException {
        ProcessInstanceSuspensionStateDto localVarPostBody = processInstanceSuspensionStateDto;
        String localVarPath = "/process-instance/suspended";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSuspensionStateValidateBeforeCall(ProcessInstanceSuspensionStateDto processInstanceSuspensionStateDto, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.updateSuspensionStateCall(processInstanceSuspensionStateDto, _callback);
        return localVarCall;
    }

    public void updateSuspensionState(ProcessInstanceSuspensionStateDto processInstanceSuspensionStateDto) throws ApiException {
        this.updateSuspensionStateWithHttpInfo(processInstanceSuspensionStateDto);
    }

    public ApiResponse<Void> updateSuspensionStateWithHttpInfo(ProcessInstanceSuspensionStateDto processInstanceSuspensionStateDto) throws ApiException {
        Call localVarCall = this.updateSuspensionStateValidateBeforeCall(processInstanceSuspensionStateDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call updateSuspensionStateAsync(ProcessInstanceSuspensionStateDto processInstanceSuspensionStateDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.updateSuspensionStateValidateBeforeCall(processInstanceSuspensionStateDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public Call updateSuspensionStateAsyncOperationCall(ProcessInstanceSuspensionStateAsyncDto processInstanceSuspensionStateAsyncDto, ApiCallback _callback) throws ApiException {
        ProcessInstanceSuspensionStateAsyncDto localVarPostBody = processInstanceSuspensionStateAsyncDto;
        String localVarPath = "/process-instance/suspended-async";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSuspensionStateAsyncOperationValidateBeforeCall(ProcessInstanceSuspensionStateAsyncDto processInstanceSuspensionStateAsyncDto, ApiCallback _callback) throws ApiException {
        Call localVarCall = this.updateSuspensionStateAsyncOperationCall(processInstanceSuspensionStateAsyncDto, _callback);
        return localVarCall;
    }

    public BatchDto updateSuspensionStateAsyncOperation(ProcessInstanceSuspensionStateAsyncDto processInstanceSuspensionStateAsyncDto) throws ApiException {
        ApiResponse<BatchDto> localVarResp = this.updateSuspensionStateAsyncOperationWithHttpInfo(processInstanceSuspensionStateAsyncDto);
        return localVarResp.getData();
    }

    public ApiResponse<BatchDto> updateSuspensionStateAsyncOperationWithHttpInfo(ProcessInstanceSuspensionStateAsyncDto processInstanceSuspensionStateAsyncDto) throws ApiException {
        Call localVarCall = this.updateSuspensionStateAsyncOperationValidateBeforeCall(processInstanceSuspensionStateAsyncDto, null);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call updateSuspensionStateAsyncOperationAsync(ProcessInstanceSuspensionStateAsyncDto processInstanceSuspensionStateAsyncDto, ApiCallback<BatchDto> _callback) throws ApiException {
        Call localVarCall = this.updateSuspensionStateAsyncOperationValidateBeforeCall(processInstanceSuspensionStateAsyncDto, _callback);
        Type localVarReturnType = new TypeToken<BatchDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call updateSuspensionStateByIdCall(String id, SuspensionStateDto suspensionStateDto, ApiCallback _callback) throws ApiException {
        SuspensionStateDto localVarPostBody = suspensionStateDto;
        String localVarPath = "/process-instance/{id}/suspended".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[0];
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateSuspensionStateByIdValidateBeforeCall(String id, SuspensionStateDto suspensionStateDto, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling updateSuspensionStateById(Async)");
        }
        Call localVarCall = this.updateSuspensionStateByIdCall(id, suspensionStateDto, _callback);
        return localVarCall;
    }

    public void updateSuspensionStateById(String id, SuspensionStateDto suspensionStateDto) throws ApiException {
        this.updateSuspensionStateByIdWithHttpInfo(id, suspensionStateDto);
    }

    public ApiResponse<Void> updateSuspensionStateByIdWithHttpInfo(String id, SuspensionStateDto suspensionStateDto) throws ApiException {
        Call localVarCall = this.updateSuspensionStateByIdValidateBeforeCall(id, suspensionStateDto, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    public Call updateSuspensionStateByIdAsync(String id, SuspensionStateDto suspensionStateDto, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.updateSuspensionStateByIdValidateBeforeCall(id, suspensionStateDto, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
}

