/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.api;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.camunda.community.rest.client.dto.CommentDto;
import org.camunda.community.rest.client.invoker.ApiCallback;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.ApiResponse;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

public class TaskCommentApi {
    private ApiClient localVarApiClient;

    public TaskCommentApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TaskCommentApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public Call createCommentCall(String id, CommentDto commentDto, ApiCallback _callback) throws ApiException {
        CommentDto localVarPostBody = commentDto;
        String localVarPath = "/task/{id}/comment/create".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createCommentValidateBeforeCall(String id, CommentDto commentDto, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling createComment(Async)");
        }
        Call localVarCall = this.createCommentCall(id, commentDto, _callback);
        return localVarCall;
    }

    public CommentDto createComment(String id, CommentDto commentDto) throws ApiException {
        ApiResponse<CommentDto> localVarResp = this.createCommentWithHttpInfo(id, commentDto);
        return localVarResp.getData();
    }

    public ApiResponse<CommentDto> createCommentWithHttpInfo(String id, CommentDto commentDto) throws ApiException {
        Call localVarCall = this.createCommentValidateBeforeCall(id, commentDto, null);
        Type localVarReturnType = new TypeToken<CommentDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call createCommentAsync(String id, CommentDto commentDto, ApiCallback<CommentDto> _callback) throws ApiException {
        Call localVarCall = this.createCommentValidateBeforeCall(id, commentDto, _callback);
        Type localVarReturnType = new TypeToken<CommentDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCommentCall(String id, String commentId, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/task/{id}/comment/{commentId}".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString())).replaceAll("\\{commentId\\}", this.localVarApiClient.escapeString(commentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCommentValidateBeforeCall(String id, String commentId, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getComment(Async)");
        }
        if (commentId == null) {
            throw new ApiException("Missing the required parameter 'commentId' when calling getComment(Async)");
        }
        Call localVarCall = this.getCommentCall(id, commentId, _callback);
        return localVarCall;
    }

    public CommentDto getComment(String id, String commentId) throws ApiException {
        ApiResponse<CommentDto> localVarResp = this.getCommentWithHttpInfo(id, commentId);
        return localVarResp.getData();
    }

    public ApiResponse<CommentDto> getCommentWithHttpInfo(String id, String commentId) throws ApiException {
        Call localVarCall = this.getCommentValidateBeforeCall(id, commentId, null);
        Type localVarReturnType = new TypeToken<CommentDto>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCommentAsync(String id, String commentId, ApiCallback<CommentDto> _callback) throws ApiException {
        Call localVarCall = this.getCommentValidateBeforeCall(id, commentId, _callback);
        Type localVarReturnType = new TypeToken<CommentDto>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call getCommentsCall(String id, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/task/{id}/comment".replaceAll("\\{id\\}", this.localVarApiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getCommentsValidateBeforeCall(String id, ApiCallback _callback) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getComments(Async)");
        }
        Call localVarCall = this.getCommentsCall(id, _callback);
        return localVarCall;
    }

    public List<CommentDto> getComments(String id) throws ApiException {
        ApiResponse<List<CommentDto>> localVarResp = this.getCommentsWithHttpInfo(id);
        return localVarResp.getData();
    }

    public ApiResponse<List<CommentDto>> getCommentsWithHttpInfo(String id) throws ApiException {
        Call localVarCall = this.getCommentsValidateBeforeCall(id, null);
        Type localVarReturnType = new TypeToken<List<CommentDto>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call getCommentsAsync(String id, ApiCallback<List<CommentDto>> _callback) throws ApiException {
        Call localVarCall = this.getCommentsValidateBeforeCall(id, _callback);
        Type localVarReturnType = new TypeToken<List<CommentDto>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

