/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.ActivityInstanceIncidentDto;
import org.camunda.community.rest.client.dto.TransitionInstanceDto;

@ApiModel(description="A JSON object corresponding to the Activity Instance tree of the given process instance.")
public class ActivityInstanceDto {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_PARENT_ACTIVITY_INSTANCE_ID = "parentActivityInstanceId";
    @SerializedName(value="parentActivityInstanceId")
    private String parentActivityInstanceId;
    public static final String SERIALIZED_NAME_ACTIVITY_ID = "activityId";
    @SerializedName(value="activityId")
    private String activityId;
    public static final String SERIALIZED_NAME_ACTIVITY_NAME = "activityName";
    @SerializedName(value="activityName")
    private String activityName;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_ACTIVITY_TYPE = "activityType";
    @SerializedName(value="activityType")
    private String activityType;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_ID = "processInstanceId";
    @SerializedName(value="processInstanceId")
    private String processInstanceId;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_ID = "processDefinitionId";
    @SerializedName(value="processDefinitionId")
    private String processDefinitionId;
    public static final String SERIALIZED_NAME_CHILD_ACTIVITY_INSTANCES = "childActivityInstances";
    @SerializedName(value="childActivityInstances")
    private List<ActivityInstanceDto> childActivityInstances = null;
    public static final String SERIALIZED_NAME_CHILD_TRANSITION_INSTANCES = "childTransitionInstances";
    @SerializedName(value="childTransitionInstances")
    private List<TransitionInstanceDto> childTransitionInstances = null;
    public static final String SERIALIZED_NAME_EXECUTION_IDS = "executionIds";
    @SerializedName(value="executionIds")
    private List<String> executionIds = null;
    public static final String SERIALIZED_NAME_INCIDENT_IDS = "incidentIds";
    @SerializedName(value="incidentIds")
    private List<String> incidentIds = null;
    public static final String SERIALIZED_NAME_INCIDENTS = "incidents";
    @SerializedName(value="incidents")
    private List<ActivityInstanceIncidentDto> incidents = null;

    public ActivityInstanceDto id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the activity instance.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ActivityInstanceDto parentActivityInstanceId(String parentActivityInstanceId) {
        this.parentActivityInstanceId = parentActivityInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the parent activity instance, for example a sub process instance.")
    public String getParentActivityInstanceId() {
        return this.parentActivityInstanceId;
    }

    public void setParentActivityInstanceId(String parentActivityInstanceId) {
        this.parentActivityInstanceId = parentActivityInstanceId;
    }

    public ActivityInstanceDto activityId(String activityId) {
        this.activityId = activityId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the activity.")
    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public ActivityInstanceDto activityName(String activityName) {
        this.activityName = activityName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the activity")
    public String getActivityName() {
        return this.activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public ActivityInstanceDto name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the activity. This property is deprecated. Please use 'activityName'.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ActivityInstanceDto activityType(String activityType) {
        this.activityType = activityType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of activity (corresponds to the XML element name in the BPMN 2.0, e.g., 'userTask')")
    public String getActivityType() {
        return this.activityType;
    }

    public void setActivityType(String activityType) {
        this.activityType = activityType;
    }

    public ActivityInstanceDto processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the process instance this activity instance is part of.")
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public ActivityInstanceDto processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the process definition.")
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public ActivityInstanceDto childActivityInstances(List<ActivityInstanceDto> childActivityInstances) {
        this.childActivityInstances = childActivityInstances;
        return this;
    }

    public ActivityInstanceDto addChildActivityInstancesItem(ActivityInstanceDto childActivityInstancesItem) {
        if (this.childActivityInstances == null) {
            this.childActivityInstances = new ArrayList<ActivityInstanceDto>();
        }
        this.childActivityInstances.add(childActivityInstancesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of child activity instances.")
    public List<ActivityInstanceDto> getChildActivityInstances() {
        return this.childActivityInstances;
    }

    public void setChildActivityInstances(List<ActivityInstanceDto> childActivityInstances) {
        this.childActivityInstances = childActivityInstances;
    }

    public ActivityInstanceDto childTransitionInstances(List<TransitionInstanceDto> childTransitionInstances) {
        this.childTransitionInstances = childTransitionInstances;
        return this;
    }

    public ActivityInstanceDto addChildTransitionInstancesItem(TransitionInstanceDto childTransitionInstancesItem) {
        if (this.childTransitionInstances == null) {
            this.childTransitionInstances = new ArrayList<TransitionInstanceDto>();
        }
        this.childTransitionInstances.add(childTransitionInstancesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of child transition instances. A transition instance represents an execution waiting in an asynchronous continuation.")
    public List<TransitionInstanceDto> getChildTransitionInstances() {
        return this.childTransitionInstances;
    }

    public void setChildTransitionInstances(List<TransitionInstanceDto> childTransitionInstances) {
        this.childTransitionInstances = childTransitionInstances;
    }

    public ActivityInstanceDto executionIds(List<String> executionIds) {
        this.executionIds = executionIds;
        return this;
    }

    public ActivityInstanceDto addExecutionIdsItem(String executionIdsItem) {
        if (this.executionIds == null) {
            this.executionIds = new ArrayList<String>();
        }
        this.executionIds.add(executionIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of execution ids.")
    public List<String> getExecutionIds() {
        return this.executionIds;
    }

    public void setExecutionIds(List<String> executionIds) {
        this.executionIds = executionIds;
    }

    public ActivityInstanceDto incidentIds(List<String> incidentIds) {
        this.incidentIds = incidentIds;
        return this;
    }

    public ActivityInstanceDto addIncidentIdsItem(String incidentIdsItem) {
        if (this.incidentIds == null) {
            this.incidentIds = new ArrayList<String>();
        }
        this.incidentIds.add(incidentIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of incident ids.")
    public List<String> getIncidentIds() {
        return this.incidentIds;
    }

    public void setIncidentIds(List<String> incidentIds) {
        this.incidentIds = incidentIds;
    }

    public ActivityInstanceDto incidents(List<ActivityInstanceIncidentDto> incidents) {
        this.incidents = incidents;
        return this;
    }

    public ActivityInstanceDto addIncidentsItem(ActivityInstanceIncidentDto incidentsItem) {
        if (this.incidents == null) {
            this.incidents = new ArrayList<ActivityInstanceIncidentDto>();
        }
        this.incidents.add(incidentsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of JSON objects containing incident specific properties: * `id`: the id of the incident * `activityId`: the activity id in which the incident occurred")
    public List<ActivityInstanceIncidentDto> getIncidents() {
        return this.incidents;
    }

    public void setIncidents(List<ActivityInstanceIncidentDto> incidents) {
        this.incidents = incidents;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActivityInstanceDto activityInstanceDto = (ActivityInstanceDto)o;
        return Objects.equals(this.id, activityInstanceDto.id) && Objects.equals(this.parentActivityInstanceId, activityInstanceDto.parentActivityInstanceId) && Objects.equals(this.activityId, activityInstanceDto.activityId) && Objects.equals(this.activityName, activityInstanceDto.activityName) && Objects.equals(this.name, activityInstanceDto.name) && Objects.equals(this.activityType, activityInstanceDto.activityType) && Objects.equals(this.processInstanceId, activityInstanceDto.processInstanceId) && Objects.equals(this.processDefinitionId, activityInstanceDto.processDefinitionId) && Objects.equals(this.childActivityInstances, activityInstanceDto.childActivityInstances) && Objects.equals(this.childTransitionInstances, activityInstanceDto.childTransitionInstances) && Objects.equals(this.executionIds, activityInstanceDto.executionIds) && Objects.equals(this.incidentIds, activityInstanceDto.incidentIds) && Objects.equals(this.incidents, activityInstanceDto.incidents);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.parentActivityInstanceId, this.activityId, this.activityName, this.name, this.activityType, this.processInstanceId, this.processDefinitionId, this.childActivityInstances, this.childTransitionInstances, this.executionIds, this.incidentIds, this.incidents);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ActivityInstanceDto {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    parentActivityInstanceId: ").append(this.toIndentedString(this.parentActivityInstanceId)).append("\n");
        sb.append("    activityId: ").append(this.toIndentedString(this.activityId)).append("\n");
        sb.append("    activityName: ").append(this.toIndentedString(this.activityName)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    activityType: ").append(this.toIndentedString(this.activityType)).append("\n");
        sb.append("    processInstanceId: ").append(this.toIndentedString(this.processInstanceId)).append("\n");
        sb.append("    processDefinitionId: ").append(this.toIndentedString(this.processDefinitionId)).append("\n");
        sb.append("    childActivityInstances: ").append(this.toIndentedString(this.childActivityInstances)).append("\n");
        sb.append("    childTransitionInstances: ").append(this.toIndentedString(this.childTransitionInstances)).append("\n");
        sb.append("    executionIds: ").append(this.toIndentedString(this.executionIds)).append("\n");
        sb.append("    incidentIds: ").append(this.toIndentedString(this.incidentIds)).append("\n");
        sb.append("    incidents: ").append(this.toIndentedString(this.incidents)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

