/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.HistoricBatchQueryDtoSorting;

@ApiModel(description="Query for the historic batches to set the removal time for.")
public class HistoricBatchQueryDto {
    public static final String SERIALIZED_NAME_BATCH_ID = "batchId";
    @SerializedName(value="batchId")
    private String batchId;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;
    public static final String SERIALIZED_NAME_COMPLETED = "completed";
    @SerializedName(value="completed")
    private Boolean completed;
    public static final String SERIALIZED_NAME_TENANT_ID_IN = "tenantIdIn";
    @SerializedName(value="tenantIdIn")
    private List<String> tenantIdIn = null;
    public static final String SERIALIZED_NAME_WITHOUT_TENANT_ID = "withoutTenantId";
    @SerializedName(value="withoutTenantId")
    private Boolean withoutTenantId;
    public static final String SERIALIZED_NAME_SORTING = "sorting";
    @SerializedName(value="sorting")
    private List<HistoricBatchQueryDtoSorting> sorting = null;

    public HistoricBatchQueryDto batchId(String batchId) {
        this.batchId = batchId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by batch id.")
    public String getBatchId() {
        return this.batchId;
    }

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    public HistoricBatchQueryDto type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by batch type. See the [User Guide](https://docs.camunda.org/manual/7.20/user-guide/process-engine/batch/#creating-a-batch) for more information about batch types.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public HistoricBatchQueryDto completed(Boolean completed) {
        this.completed = completed;
        return this;
    }

    @Nullable
    @ApiModelProperty(value=" Filter completed or not completed batches. If the value is `true`, only completed batches, i.e., end time is set, are returned. Otherwise, if the value is `false`, only running batches, i.e., end time is null, are returned.")
    public Boolean getCompleted() {
        return this.completed;
    }

    public void setCompleted(Boolean completed) {
        this.completed = completed;
    }

    public HistoricBatchQueryDto tenantIdIn(List<String> tenantIdIn) {
        this.tenantIdIn = tenantIdIn;
        return this;
    }

    public HistoricBatchQueryDto addTenantIdInItem(String tenantIdInItem) {
        if (this.tenantIdIn == null) {
            this.tenantIdIn = new ArrayList<String>();
        }
        this.tenantIdIn.add(tenantIdInItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Filter by a comma-separated list of tenant ids. A batch matches if it has one of the given tenant ids.")
    public List<String> getTenantIdIn() {
        return this.tenantIdIn;
    }

    public void setTenantIdIn(List<String> tenantIdIn) {
        this.tenantIdIn = tenantIdIn;
    }

    public HistoricBatchQueryDto withoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Only include batches which belong to no tenant. Value can effectively only be `true`, as `false` is the default behavior.")
    public Boolean getWithoutTenantId() {
        return this.withoutTenantId;
    }

    public void setWithoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
    }

    public HistoricBatchQueryDto sorting(List<HistoricBatchQueryDtoSorting> sorting) {
        this.sorting = sorting;
        return this;
    }

    public HistoricBatchQueryDto addSortingItem(HistoricBatchQueryDtoSorting sortingItem) {
        if (this.sorting == null) {
            this.sorting = new ArrayList<HistoricBatchQueryDtoSorting>();
        }
        this.sorting.add(sortingItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array of criteria to sort the result by. Each element of the array is                        an object that specifies one ordering. The position in the array                        identifies the rank of an ordering, i.e., whether it is primary, secondary,                        etc. Has no effect for the `/count` endpoint")
    public List<HistoricBatchQueryDtoSorting> getSorting() {
        return this.sorting;
    }

    public void setSorting(List<HistoricBatchQueryDtoSorting> sorting) {
        this.sorting = sorting;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistoricBatchQueryDto historicBatchQueryDto = (HistoricBatchQueryDto)o;
        return Objects.equals(this.batchId, historicBatchQueryDto.batchId) && Objects.equals(this.type, historicBatchQueryDto.type) && Objects.equals(this.completed, historicBatchQueryDto.completed) && Objects.equals(this.tenantIdIn, historicBatchQueryDto.tenantIdIn) && Objects.equals(this.withoutTenantId, historicBatchQueryDto.withoutTenantId) && Objects.equals(this.sorting, historicBatchQueryDto.sorting);
    }

    public int hashCode() {
        return Objects.hash(this.batchId, this.type, this.completed, this.tenantIdIn, this.withoutTenantId, this.sorting);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HistoricBatchQueryDto {\n");
        sb.append("    batchId: ").append(this.toIndentedString(this.batchId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    completed: ").append(this.toIndentedString(this.completed)).append("\n");
        sb.append("    tenantIdIn: ").append(this.toIndentedString(this.tenantIdIn)).append("\n");
        sb.append("    withoutTenantId: ").append(this.toIndentedString(this.withoutTenantId)).append("\n");
        sb.append("    sorting: ").append(this.toIndentedString(this.sorting)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

