/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Nullable;

public class HistoricTaskInstanceDto {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_KEY = "processDefinitionKey";
    @SerializedName(value="processDefinitionKey")
    private String processDefinitionKey;
    public static final String SERIALIZED_NAME_PROCESS_DEFINITION_ID = "processDefinitionId";
    @SerializedName(value="processDefinitionId")
    private String processDefinitionId;
    public static final String SERIALIZED_NAME_PROCESS_INSTANCE_ID = "processInstanceId";
    @SerializedName(value="processInstanceId")
    private String processInstanceId;
    public static final String SERIALIZED_NAME_EXECUTION_ID = "executionId";
    @SerializedName(value="executionId")
    private String executionId;
    public static final String SERIALIZED_NAME_CASE_DEFINITION_KEY = "caseDefinitionKey";
    @SerializedName(value="caseDefinitionKey")
    private String caseDefinitionKey;
    public static final String SERIALIZED_NAME_CASE_DEFINITION_ID = "caseDefinitionId";
    @SerializedName(value="caseDefinitionId")
    private String caseDefinitionId;
    public static final String SERIALIZED_NAME_CASE_INSTANCE_ID = "caseInstanceId";
    @SerializedName(value="caseInstanceId")
    private String caseInstanceId;
    public static final String SERIALIZED_NAME_CASE_EXECUTION_ID = "caseExecutionId";
    @SerializedName(value="caseExecutionId")
    private String caseExecutionId;
    public static final String SERIALIZED_NAME_ACTIVITY_INSTANCE_ID = "activityInstanceId";
    @SerializedName(value="activityInstanceId")
    private String activityInstanceId;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_DELETE_REASON = "deleteReason";
    @SerializedName(value="deleteReason")
    private String deleteReason;
    public static final String SERIALIZED_NAME_OWNER = "owner";
    @SerializedName(value="owner")
    private String owner;
    public static final String SERIALIZED_NAME_ASSIGNEE = "assignee";
    @SerializedName(value="assignee")
    private String assignee;
    public static final String SERIALIZED_NAME_START_TIME = "startTime";
    @SerializedName(value="startTime")
    private Date startTime;
    public static final String SERIALIZED_NAME_END_TIME = "endTime";
    @SerializedName(value="endTime")
    private Date endTime;
    public static final String SERIALIZED_NAME_DURATION = "duration";
    @SerializedName(value="duration")
    private Long duration;
    public static final String SERIALIZED_NAME_TASK_DEFINITION_KEY = "taskDefinitionKey";
    @SerializedName(value="taskDefinitionKey")
    private String taskDefinitionKey;
    public static final String SERIALIZED_NAME_PRIORITY = "priority";
    @SerializedName(value="priority")
    private Integer priority;
    public static final String SERIALIZED_NAME_DUE = "due";
    @SerializedName(value="due")
    private Date due;
    public static final String SERIALIZED_NAME_PARENT_TASK_ID = "parentTaskId";
    @SerializedName(value="parentTaskId")
    private String parentTaskId;
    public static final String SERIALIZED_NAME_FOLLOW_UP = "followUp";
    @SerializedName(value="followUp")
    private Date followUp;
    public static final String SERIALIZED_NAME_TENANT_ID = "tenantId";
    @SerializedName(value="tenantId")
    private String tenantId;
    public static final String SERIALIZED_NAME_REMOVAL_TIME = "removalTime";
    @SerializedName(value="removalTime")
    private Date removalTime;
    public static final String SERIALIZED_NAME_ROOT_PROCESS_INSTANCE_ID = "rootProcessInstanceId";
    @SerializedName(value="rootProcessInstanceId")
    private String rootProcessInstanceId;

    public HistoricTaskInstanceDto id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The task id.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public HistoricTaskInstanceDto processDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The key of the process definition the task belongs to.")
    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public HistoricTaskInstanceDto processDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the process definition the task belongs to.")
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public HistoricTaskInstanceDto processInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the process instance the task belongs to.")
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public HistoricTaskInstanceDto executionId(String executionId) {
        this.executionId = executionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the execution the task belongs to.")
    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public HistoricTaskInstanceDto caseDefinitionKey(String caseDefinitionKey) {
        this.caseDefinitionKey = caseDefinitionKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The key of the case definition the task belongs to.")
    public String getCaseDefinitionKey() {
        return this.caseDefinitionKey;
    }

    public void setCaseDefinitionKey(String caseDefinitionKey) {
        this.caseDefinitionKey = caseDefinitionKey;
    }

    public HistoricTaskInstanceDto caseDefinitionId(String caseDefinitionId) {
        this.caseDefinitionId = caseDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the case definition the task belongs to.")
    public String getCaseDefinitionId() {
        return this.caseDefinitionId;
    }

    public void setCaseDefinitionId(String caseDefinitionId) {
        this.caseDefinitionId = caseDefinitionId;
    }

    public HistoricTaskInstanceDto caseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the case instance the task belongs to.")
    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    public HistoricTaskInstanceDto caseExecutionId(String caseExecutionId) {
        this.caseExecutionId = caseExecutionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the case execution the task belongs to.")
    public String getCaseExecutionId() {
        return this.caseExecutionId;
    }

    public void setCaseExecutionId(String caseExecutionId) {
        this.caseExecutionId = caseExecutionId;
    }

    public HistoricTaskInstanceDto activityInstanceId(String activityInstanceId) {
        this.activityInstanceId = activityInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the activity that this object is an instance of.")
    public String getActivityInstanceId() {
        return this.activityInstanceId;
    }

    public void setActivityInstanceId(String activityInstanceId) {
        this.activityInstanceId = activityInstanceId;
    }

    public HistoricTaskInstanceDto name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The task name.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public HistoricTaskInstanceDto description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The task's description.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public HistoricTaskInstanceDto deleteReason(String deleteReason) {
        this.deleteReason = deleteReason;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The task's delete reason.")
    public String getDeleteReason() {
        return this.deleteReason;
    }

    public void setDeleteReason(String deleteReason) {
        this.deleteReason = deleteReason;
    }

    public HistoricTaskInstanceDto owner(String owner) {
        this.owner = owner;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The owner's id.")
    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public HistoricTaskInstanceDto assignee(String assignee) {
        this.assignee = assignee;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The assignee's id.")
    public String getAssignee() {
        return this.assignee;
    }

    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    public HistoricTaskInstanceDto startTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time the task was started. Default [format](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.")
    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public HistoricTaskInstanceDto endTime(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time the task ended. Default [format](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.")
    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public HistoricTaskInstanceDto duration(Long duration) {
        this.duration = duration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time the task took to finish (in milliseconds).")
    public Long getDuration() {
        return this.duration;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public HistoricTaskInstanceDto taskDefinitionKey(String taskDefinitionKey) {
        this.taskDefinitionKey = taskDefinitionKey;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The task's key.")
    public String getTaskDefinitionKey() {
        return this.taskDefinitionKey;
    }

    public void setTaskDefinitionKey(String taskDefinitionKey) {
        this.taskDefinitionKey = taskDefinitionKey;
    }

    public HistoricTaskInstanceDto priority(Integer priority) {
        this.priority = priority;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The task's priority.")
    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public HistoricTaskInstanceDto due(Date due) {
        this.due = due;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The task's due date. Default [format](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.")
    public Date getDue() {
        return this.due;
    }

    public void setDue(Date due) {
        this.due = due;
    }

    public HistoricTaskInstanceDto parentTaskId(String parentTaskId) {
        this.parentTaskId = parentTaskId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the parent task, if this task is a subtask.")
    public String getParentTaskId() {
        return this.parentTaskId;
    }

    public void setParentTaskId(String parentTaskId) {
        this.parentTaskId = parentTaskId;
    }

    public HistoricTaskInstanceDto followUp(Date followUp) {
        this.followUp = followUp;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The follow-up date for the task. Default [format](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.")
    public Date getFollowUp() {
        return this.followUp;
    }

    public void setFollowUp(Date followUp) {
        this.followUp = followUp;
    }

    public HistoricTaskInstanceDto tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The tenant id of the task instance.")
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public HistoricTaskInstanceDto removalTime(Date removalTime) {
        this.removalTime = removalTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time after which the task should be removed by the History Cleanup job. Default [format](https://docs.camunda.org/manual/7.20/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`.")
    public Date getRemovalTime() {
        return this.removalTime;
    }

    public void setRemovalTime(Date removalTime) {
        this.removalTime = removalTime;
    }

    public HistoricTaskInstanceDto rootProcessInstanceId(String rootProcessInstanceId) {
        this.rootProcessInstanceId = rootProcessInstanceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The process instance id of the root process instance that initiated the process containing this task.")
    public String getRootProcessInstanceId() {
        return this.rootProcessInstanceId;
    }

    public void setRootProcessInstanceId(String rootProcessInstanceId) {
        this.rootProcessInstanceId = rootProcessInstanceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistoricTaskInstanceDto historicTaskInstanceDto = (HistoricTaskInstanceDto)o;
        return Objects.equals(this.id, historicTaskInstanceDto.id) && Objects.equals(this.processDefinitionKey, historicTaskInstanceDto.processDefinitionKey) && Objects.equals(this.processDefinitionId, historicTaskInstanceDto.processDefinitionId) && Objects.equals(this.processInstanceId, historicTaskInstanceDto.processInstanceId) && Objects.equals(this.executionId, historicTaskInstanceDto.executionId) && Objects.equals(this.caseDefinitionKey, historicTaskInstanceDto.caseDefinitionKey) && Objects.equals(this.caseDefinitionId, historicTaskInstanceDto.caseDefinitionId) && Objects.equals(this.caseInstanceId, historicTaskInstanceDto.caseInstanceId) && Objects.equals(this.caseExecutionId, historicTaskInstanceDto.caseExecutionId) && Objects.equals(this.activityInstanceId, historicTaskInstanceDto.activityInstanceId) && Objects.equals(this.name, historicTaskInstanceDto.name) && Objects.equals(this.description, historicTaskInstanceDto.description) && Objects.equals(this.deleteReason, historicTaskInstanceDto.deleteReason) && Objects.equals(this.owner, historicTaskInstanceDto.owner) && Objects.equals(this.assignee, historicTaskInstanceDto.assignee) && Objects.equals(this.startTime, historicTaskInstanceDto.startTime) && Objects.equals(this.endTime, historicTaskInstanceDto.endTime) && Objects.equals(this.duration, historicTaskInstanceDto.duration) && Objects.equals(this.taskDefinitionKey, historicTaskInstanceDto.taskDefinitionKey) && Objects.equals(this.priority, historicTaskInstanceDto.priority) && Objects.equals(this.due, historicTaskInstanceDto.due) && Objects.equals(this.parentTaskId, historicTaskInstanceDto.parentTaskId) && Objects.equals(this.followUp, historicTaskInstanceDto.followUp) && Objects.equals(this.tenantId, historicTaskInstanceDto.tenantId) && Objects.equals(this.removalTime, historicTaskInstanceDto.removalTime) && Objects.equals(this.rootProcessInstanceId, historicTaskInstanceDto.rootProcessInstanceId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.processDefinitionKey, this.processDefinitionId, this.processInstanceId, this.executionId, this.caseDefinitionKey, this.caseDefinitionId, this.caseInstanceId, this.caseExecutionId, this.activityInstanceId, this.name, this.description, this.deleteReason, this.owner, this.assignee, this.startTime, this.endTime, this.duration, this.taskDefinitionKey, this.priority, this.due, this.parentTaskId, this.followUp, this.tenantId, this.removalTime, this.rootProcessInstanceId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HistoricTaskInstanceDto {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    processDefinitionKey: ").append(this.toIndentedString(this.processDefinitionKey)).append("\n");
        sb.append("    processDefinitionId: ").append(this.toIndentedString(this.processDefinitionId)).append("\n");
        sb.append("    processInstanceId: ").append(this.toIndentedString(this.processInstanceId)).append("\n");
        sb.append("    executionId: ").append(this.toIndentedString(this.executionId)).append("\n");
        sb.append("    caseDefinitionKey: ").append(this.toIndentedString(this.caseDefinitionKey)).append("\n");
        sb.append("    caseDefinitionId: ").append(this.toIndentedString(this.caseDefinitionId)).append("\n");
        sb.append("    caseInstanceId: ").append(this.toIndentedString(this.caseInstanceId)).append("\n");
        sb.append("    caseExecutionId: ").append(this.toIndentedString(this.caseExecutionId)).append("\n");
        sb.append("    activityInstanceId: ").append(this.toIndentedString(this.activityInstanceId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    deleteReason: ").append(this.toIndentedString(this.deleteReason)).append("\n");
        sb.append("    owner: ").append(this.toIndentedString(this.owner)).append("\n");
        sb.append("    assignee: ").append(this.toIndentedString(this.assignee)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    taskDefinitionKey: ").append(this.toIndentedString(this.taskDefinitionKey)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    due: ").append(this.toIndentedString(this.due)).append("\n");
        sb.append("    parentTaskId: ").append(this.toIndentedString(this.parentTaskId)).append("\n");
        sb.append("    followUp: ").append(this.toIndentedString(this.followUp)).append("\n");
        sb.append("    tenantId: ").append(this.toIndentedString(this.tenantId)).append("\n");
        sb.append("    removalTime: ").append(this.toIndentedString(this.removalTime)).append("\n");
        sb.append("    rootProcessInstanceId: ").append(this.toIndentedString(this.rootProcessInstanceId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

