/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.MigrationInstructionDto;
import org.camunda.community.rest.client.dto.VariableValueDto;

public class MigrationPlanDto {
    public static final String SERIALIZED_NAME_SOURCE_PROCESS_DEFINITION_ID = "sourceProcessDefinitionId";
    @SerializedName(value="sourceProcessDefinitionId")
    private String sourceProcessDefinitionId;
    public static final String SERIALIZED_NAME_TARGET_PROCESS_DEFINITION_ID = "targetProcessDefinitionId";
    @SerializedName(value="targetProcessDefinitionId")
    private String targetProcessDefinitionId;
    public static final String SERIALIZED_NAME_INSTRUCTIONS = "instructions";
    @SerializedName(value="instructions")
    private List<MigrationInstructionDto> instructions = null;
    public static final String SERIALIZED_NAME_VARIABLES = "variables";
    @SerializedName(value="variables")
    private Map<String, VariableValueDto> variables = null;

    public MigrationPlanDto sourceProcessDefinitionId(String sourceProcessDefinitionId) {
        this.sourceProcessDefinitionId = sourceProcessDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the source process definition for the migration.")
    public String getSourceProcessDefinitionId() {
        return this.sourceProcessDefinitionId;
    }

    public void setSourceProcessDefinitionId(String sourceProcessDefinitionId) {
        this.sourceProcessDefinitionId = sourceProcessDefinitionId;
    }

    public MigrationPlanDto targetProcessDefinitionId(String targetProcessDefinitionId) {
        this.targetProcessDefinitionId = targetProcessDefinitionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the target process definition for the migration.")
    public String getTargetProcessDefinitionId() {
        return this.targetProcessDefinitionId;
    }

    public void setTargetProcessDefinitionId(String targetProcessDefinitionId) {
        this.targetProcessDefinitionId = targetProcessDefinitionId;
    }

    public MigrationPlanDto instructions(List<MigrationInstructionDto> instructions) {
        this.instructions = instructions;
        return this;
    }

    public MigrationPlanDto addInstructionsItem(MigrationInstructionDto instructionsItem) {
        if (this.instructions == null) {
            this.instructions = new ArrayList<MigrationInstructionDto>();
        }
        this.instructions.add(instructionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of migration instructions which map equal activities. Each migration instruction is a JSON object with the following properties:")
    public List<MigrationInstructionDto> getInstructions() {
        return this.instructions;
    }

    public void setInstructions(List<MigrationInstructionDto> instructions) {
        this.instructions = instructions;
    }

    public MigrationPlanDto variables(Map<String, VariableValueDto> variables) {
        this.variables = variables;
        return this;
    }

    public MigrationPlanDto putVariablesItem(String key, VariableValueDto variablesItem) {
        if (this.variables == null) {
            this.variables = new HashMap<String, VariableValueDto>();
        }
        this.variables.put(key, variablesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A map of variables which will be set into the process instances' scope. Each key is a variable name and each value a JSON variable value object.")
    public Map<String, VariableValueDto> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, VariableValueDto> variables) {
        this.variables = variables;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MigrationPlanDto migrationPlanDto = (MigrationPlanDto)o;
        return Objects.equals(this.sourceProcessDefinitionId, migrationPlanDto.sourceProcessDefinitionId) && Objects.equals(this.targetProcessDefinitionId, migrationPlanDto.targetProcessDefinitionId) && Objects.equals(this.instructions, migrationPlanDto.instructions) && Objects.equals(this.variables, migrationPlanDto.variables);
    }

    public int hashCode() {
        return Objects.hash(this.sourceProcessDefinitionId, this.targetProcessDefinitionId, this.instructions, this.variables);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MigrationPlanDto {\n");
        sb.append("    sourceProcessDefinitionId: ").append(this.toIndentedString(this.sourceProcessDefinitionId)).append("\n");
        sb.append("    targetProcessDefinitionId: ").append(this.toIndentedString(this.targetProcessDefinitionId)).append("\n");
        sb.append("    instructions: ").append(this.toIndentedString(this.instructions)).append("\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

