/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.api;

import com.fasterxml.jackson.core.type.TypeReference;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.camunda.community.rest.client.dto.CountResultDto;
import org.camunda.community.rest.client.dto.HistoricActivityInstanceDto;
import org.camunda.community.rest.client.dto.HistoricActivityInstanceQueryDto;
import org.camunda.community.rest.client.invoker.ApiClient;
import org.camunda.community.rest.client.invoker.ApiException;
import org.camunda.community.rest.client.invoker.Configuration;
import org.camunda.community.rest.client.invoker.Pair;

public class HistoricActivityInstanceApi {
    private ApiClient apiClient;

    public HistoricActivityInstanceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public HistoricActivityInstanceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public HistoricActivityInstanceDto getHistoricActivityInstance(String id) throws ApiException {
        return this.getHistoricActivityInstance(id, Collections.emptyMap());
    }

    public HistoricActivityInstanceDto getHistoricActivityInstance(String id, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (id == null) {
            throw new ApiException(400, "Missing the required parameter 'id' when calling getHistoricActivityInstance");
        }
        String localVarPath = "/history/activity-instance/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<HistoricActivityInstanceDto> localVarReturnType = new TypeReference<HistoricActivityInstanceDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<HistoricActivityInstanceDto> getHistoricActivityInstances(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String activityInstanceId, String processInstanceId, String processDefinitionId, String executionId, String activityId, String activityName, String activityType, String taskAssignee, Boolean finished, Boolean unfinished, Boolean canceled, Boolean completeScope, OffsetDateTime startedBefore, OffsetDateTime startedAfter, OffsetDateTime finishedBefore, OffsetDateTime finishedAfter, String tenantIdIn, Boolean withoutTenantId) throws ApiException {
        return this.getHistoricActivityInstances(sortBy, sortOrder, firstResult, maxResults, activityInstanceId, processInstanceId, processDefinitionId, executionId, activityId, activityName, activityType, taskAssignee, finished, unfinished, canceled, completeScope, startedBefore, startedAfter, finishedBefore, finishedAfter, tenantIdIn, withoutTenantId, Collections.emptyMap());
    }

    public List<HistoricActivityInstanceDto> getHistoricActivityInstances(String sortBy, String sortOrder, Integer firstResult, Integer maxResults, String activityInstanceId, String processInstanceId, String processDefinitionId, String executionId, String activityId, String activityName, String activityType, String taskAssignee, Boolean finished, Boolean unfinished, Boolean canceled, Boolean completeScope, OffsetDateTime startedBefore, OffsetDateTime startedAfter, OffsetDateTime finishedBefore, OffsetDateTime finishedAfter, String tenantIdIn, Boolean withoutTenantId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/history/activity-instance";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sortBy", sortBy));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("sortOrder", sortOrder));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("firstResult", firstResult));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("maxResults", maxResults));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("activityInstanceId", activityInstanceId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processInstanceId", processInstanceId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processDefinitionId", processDefinitionId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("executionId", executionId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("activityId", activityId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("activityName", activityName));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("activityType", activityType));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("taskAssignee", taskAssignee));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("finished", finished));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("unfinished", unfinished));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("canceled", canceled));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("completeScope", completeScope));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("startedBefore", startedBefore));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("startedAfter", startedAfter));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("finishedBefore", finishedBefore));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("finishedAfter", finishedAfter));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("tenantIdIn", tenantIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withoutTenantId", withoutTenantId));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<List<HistoricActivityInstanceDto>> localVarReturnType = new TypeReference<List<HistoricActivityInstanceDto>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CountResultDto getHistoricActivityInstancesCount(String activityInstanceId, String processInstanceId, String processDefinitionId, String executionId, String activityId, String activityName, String activityType, String taskAssignee, Boolean finished, Boolean unfinished, Boolean canceled, Boolean completeScope, OffsetDateTime startedBefore, OffsetDateTime startedAfter, OffsetDateTime finishedBefore, OffsetDateTime finishedAfter, String tenantIdIn, Boolean withoutTenantId) throws ApiException {
        return this.getHistoricActivityInstancesCount(activityInstanceId, processInstanceId, processDefinitionId, executionId, activityId, activityName, activityType, taskAssignee, finished, unfinished, canceled, completeScope, startedBefore, startedAfter, finishedBefore, finishedAfter, tenantIdIn, withoutTenantId, Collections.emptyMap());
    }

    public CountResultDto getHistoricActivityInstancesCount(String activityInstanceId, String processInstanceId, String processDefinitionId, String executionId, String activityId, String activityName, String activityType, String taskAssignee, Boolean finished, Boolean unfinished, Boolean canceled, Boolean completeScope, OffsetDateTime startedBefore, OffsetDateTime startedAfter, OffsetDateTime finishedBefore, OffsetDateTime finishedAfter, String tenantIdIn, Boolean withoutTenantId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/history/activity-instance/count";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("activityInstanceId", activityInstanceId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processInstanceId", processInstanceId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("processDefinitionId", processDefinitionId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("executionId", executionId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("activityId", activityId));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("activityName", activityName));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("activityType", activityType));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("taskAssignee", taskAssignee));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("finished", finished));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("unfinished", unfinished));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("canceled", canceled));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("completeScope", completeScope));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("startedBefore", startedBefore));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("startedAfter", startedAfter));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("finishedBefore", finishedBefore));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("finishedAfter", finishedAfter));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("tenantIdIn", tenantIdIn));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("withoutTenantId", withoutTenantId));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<HistoricActivityInstanceDto> queryHistoricActivityInstances(Integer firstResult, Integer maxResults, HistoricActivityInstanceQueryDto historicActivityInstanceQueryDto) throws ApiException {
        return this.queryHistoricActivityInstances(firstResult, maxResults, historicActivityInstanceQueryDto, Collections.emptyMap());
    }

    public List<HistoricActivityInstanceDto> queryHistoricActivityInstances(Integer firstResult, Integer maxResults, HistoricActivityInstanceQueryDto historicActivityInstanceQueryDto, Map<String, String> additionalHeaders) throws ApiException {
        HistoricActivityInstanceQueryDto localVarPostBody = historicActivityInstanceQueryDto;
        String localVarPath = "/history/activity-instance";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("firstResult", firstResult));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("maxResults", maxResults));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<List<HistoricActivityInstanceDto>> localVarReturnType = new TypeReference<List<HistoricActivityInstanceDto>>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public CountResultDto queryHistoricActivityInstancesCount(HistoricActivityInstanceQueryDto historicActivityInstanceQueryDto) throws ApiException {
        return this.queryHistoricActivityInstancesCount(historicActivityInstanceQueryDto, Collections.emptyMap());
    }

    public CountResultDto queryHistoricActivityInstancesCount(HistoricActivityInstanceQueryDto historicActivityInstanceQueryDto, Map<String, String> additionalHeaders) throws ApiException {
        HistoricActivityInstanceQueryDto localVarPostBody = historicActivityInstanceQueryDto;
        String localVarPath = "/history/activity-instance/count";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"basicAuth"};
        TypeReference<CountResultDto> localVarReturnType = new TypeReference<CountResultDto>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

