/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.MigrationInstructionDto;
import org.camunda.community.rest.client.dto.VariableValueDto;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"sourceProcessDefinitionId", "targetProcessDefinitionId", "instructions", "variables"})
public class MigrationPlanDto {
    public static final String JSON_PROPERTY_SOURCE_PROCESS_DEFINITION_ID = "sourceProcessDefinitionId";
    private JsonNullable<String> sourceProcessDefinitionId = JsonNullable.undefined();
    public static final String JSON_PROPERTY_TARGET_PROCESS_DEFINITION_ID = "targetProcessDefinitionId";
    private JsonNullable<String> targetProcessDefinitionId = JsonNullable.undefined();
    public static final String JSON_PROPERTY_INSTRUCTIONS = "instructions";
    private JsonNullable<List<MigrationInstructionDto>> instructions = JsonNullable.undefined();
    public static final String JSON_PROPERTY_VARIABLES = "variables";
    private JsonNullable<Map<String, VariableValueDto>> variables = JsonNullable.undefined();

    public MigrationPlanDto sourceProcessDefinitionId(String sourceProcessDefinitionId) {
        this.sourceProcessDefinitionId = JsonNullable.of((Object)sourceProcessDefinitionId);
        return this;
    }

    @Nullable
    @JsonIgnore
    public String getSourceProcessDefinitionId() {
        return (String)this.sourceProcessDefinitionId.orElse(null);
    }

    @JsonProperty(value="sourceProcessDefinitionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getSourceProcessDefinitionId_JsonNullable() {
        return this.sourceProcessDefinitionId;
    }

    @JsonProperty(value="sourceProcessDefinitionId")
    public void setSourceProcessDefinitionId_JsonNullable(JsonNullable<String> sourceProcessDefinitionId) {
        this.sourceProcessDefinitionId = sourceProcessDefinitionId;
    }

    public void setSourceProcessDefinitionId(String sourceProcessDefinitionId) {
        this.sourceProcessDefinitionId = JsonNullable.of((Object)sourceProcessDefinitionId);
    }

    public MigrationPlanDto targetProcessDefinitionId(String targetProcessDefinitionId) {
        this.targetProcessDefinitionId = JsonNullable.of((Object)targetProcessDefinitionId);
        return this;
    }

    @Nullable
    @JsonIgnore
    public String getTargetProcessDefinitionId() {
        return (String)this.targetProcessDefinitionId.orElse(null);
    }

    @JsonProperty(value="targetProcessDefinitionId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getTargetProcessDefinitionId_JsonNullable() {
        return this.targetProcessDefinitionId;
    }

    @JsonProperty(value="targetProcessDefinitionId")
    public void setTargetProcessDefinitionId_JsonNullable(JsonNullable<String> targetProcessDefinitionId) {
        this.targetProcessDefinitionId = targetProcessDefinitionId;
    }

    public void setTargetProcessDefinitionId(String targetProcessDefinitionId) {
        this.targetProcessDefinitionId = JsonNullable.of((Object)targetProcessDefinitionId);
    }

    public MigrationPlanDto instructions(List<MigrationInstructionDto> instructions) {
        this.instructions = JsonNullable.of(instructions);
        return this;
    }

    public MigrationPlanDto addInstructionsItem(MigrationInstructionDto instructionsItem) {
        if (this.instructions == null || !this.instructions.isPresent()) {
            this.instructions = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.instructions.get()).add(instructionsItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @JsonIgnore
    public List<MigrationInstructionDto> getInstructions() {
        return (List)this.instructions.orElse(null);
    }

    @JsonProperty(value="instructions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<MigrationInstructionDto>> getInstructions_JsonNullable() {
        return this.instructions;
    }

    @JsonProperty(value="instructions")
    public void setInstructions_JsonNullable(JsonNullable<List<MigrationInstructionDto>> instructions) {
        this.instructions = instructions;
    }

    public void setInstructions(List<MigrationInstructionDto> instructions) {
        this.instructions = JsonNullable.of(instructions);
    }

    public MigrationPlanDto variables(Map<String, VariableValueDto> variables) {
        this.variables = JsonNullable.of(variables);
        return this;
    }

    public MigrationPlanDto putVariablesItem(String key, VariableValueDto variablesItem) {
        if (this.variables == null || !this.variables.isPresent()) {
            this.variables = JsonNullable.of(new HashMap());
        }
        try {
            ((Map)this.variables.get()).put(key, variablesItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @JsonIgnore
    public Map<String, VariableValueDto> getVariables() {
        return (Map)this.variables.orElse(null);
    }

    @JsonProperty(value="variables")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Map<String, VariableValueDto>> getVariables_JsonNullable() {
        return this.variables;
    }

    @JsonProperty(value="variables")
    public void setVariables_JsonNullable(JsonNullable<Map<String, VariableValueDto>> variables) {
        this.variables = variables;
    }

    public void setVariables(Map<String, VariableValueDto> variables) {
        this.variables = JsonNullable.of(variables);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MigrationPlanDto migrationPlanDto = (MigrationPlanDto)o;
        return MigrationPlanDto.equalsNullable(this.sourceProcessDefinitionId, migrationPlanDto.sourceProcessDefinitionId) && MigrationPlanDto.equalsNullable(this.targetProcessDefinitionId, migrationPlanDto.targetProcessDefinitionId) && MigrationPlanDto.equalsNullable(this.instructions, migrationPlanDto.instructions) && MigrationPlanDto.equalsNullable(this.variables, migrationPlanDto.variables);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(MigrationPlanDto.hashCodeNullable(this.sourceProcessDefinitionId), MigrationPlanDto.hashCodeNullable(this.targetProcessDefinitionId), MigrationPlanDto.hashCodeNullable(this.instructions), MigrationPlanDto.hashCodeNullable(this.variables));
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MigrationPlanDto {\n");
        sb.append("    sourceProcessDefinitionId: ").append(this.toIndentedString(this.sourceProcessDefinitionId)).append("\n");
        sb.append("    targetProcessDefinitionId: ").append(this.toIndentedString(this.targetProcessDefinitionId)).append("\n");
        sb.append("    instructions: ").append(this.toIndentedString(this.instructions)).append("\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getSourceProcessDefinitionId() != null) {
            try {
                joiner.add(String.format("%ssourceProcessDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getSourceProcessDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getTargetProcessDefinitionId() != null) {
            try {
                joiner.add(String.format("%stargetProcessDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getTargetProcessDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getInstructions() != null) {
            for (int i = 0; i < this.getInstructions().size(); ++i) {
                if (this.getInstructions().get(i) == null) continue;
                joiner.add(this.getInstructions().get(i).toUrlQueryString(String.format("%sinstructions%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
            }
        }
        if (this.getVariables() != null) {
            for (String _key : this.getVariables().keySet()) {
                if (this.getVariables().get(_key) == null) continue;
                joiner.add(this.getVariables().get(_key).toUrlQueryString(String.format("%svariables%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

