/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import org.camunda.community.rest.client.dto.VariableValueDto;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"errorCode", "errorMessage", "variables"})
public class TaskBpmnErrorDto {
    public static final String JSON_PROPERTY_ERROR_CODE = "errorCode";
    private JsonNullable<String> errorCode = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ERROR_MESSAGE = "errorMessage";
    private JsonNullable<String> errorMessage = JsonNullable.undefined();
    public static final String JSON_PROPERTY_VARIABLES = "variables";
    private JsonNullable<Map<String, VariableValueDto>> variables = JsonNullable.undefined();

    public TaskBpmnErrorDto errorCode(String errorCode) {
        this.errorCode = JsonNullable.of((Object)errorCode);
        return this;
    }

    @Nullable
    @JsonIgnore
    public String getErrorCode() {
        return (String)this.errorCode.orElse(null);
    }

    @JsonProperty(value="errorCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getErrorCode_JsonNullable() {
        return this.errorCode;
    }

    @JsonProperty(value="errorCode")
    public void setErrorCode_JsonNullable(JsonNullable<String> errorCode) {
        this.errorCode = errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = JsonNullable.of((Object)errorCode);
    }

    public TaskBpmnErrorDto errorMessage(String errorMessage) {
        this.errorMessage = JsonNullable.of((Object)errorMessage);
        return this;
    }

    @Nullable
    @JsonIgnore
    public String getErrorMessage() {
        return (String)this.errorMessage.orElse(null);
    }

    @JsonProperty(value="errorMessage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getErrorMessage_JsonNullable() {
        return this.errorMessage;
    }

    @JsonProperty(value="errorMessage")
    public void setErrorMessage_JsonNullable(JsonNullable<String> errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = JsonNullable.of((Object)errorMessage);
    }

    public TaskBpmnErrorDto variables(Map<String, VariableValueDto> variables) {
        this.variables = JsonNullable.of(variables);
        return this;
    }

    public TaskBpmnErrorDto putVariablesItem(String key, VariableValueDto variablesItem) {
        if (this.variables == null || !this.variables.isPresent()) {
            this.variables = JsonNullable.of(new HashMap());
        }
        try {
            ((Map)this.variables.get()).put(key, variablesItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @JsonIgnore
    public Map<String, VariableValueDto> getVariables() {
        return (Map)this.variables.orElse(null);
    }

    @JsonProperty(value="variables")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Map<String, VariableValueDto>> getVariables_JsonNullable() {
        return this.variables;
    }

    @JsonProperty(value="variables")
    public void setVariables_JsonNullable(JsonNullable<Map<String, VariableValueDto>> variables) {
        this.variables = variables;
    }

    public void setVariables(Map<String, VariableValueDto> variables) {
        this.variables = JsonNullable.of(variables);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskBpmnErrorDto taskBpmnErrorDto = (TaskBpmnErrorDto)o;
        return TaskBpmnErrorDto.equalsNullable(this.errorCode, taskBpmnErrorDto.errorCode) && TaskBpmnErrorDto.equalsNullable(this.errorMessage, taskBpmnErrorDto.errorMessage) && TaskBpmnErrorDto.equalsNullable(this.variables, taskBpmnErrorDto.variables);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(TaskBpmnErrorDto.hashCodeNullable(this.errorCode), TaskBpmnErrorDto.hashCodeNullable(this.errorMessage), TaskBpmnErrorDto.hashCodeNullable(this.variables));
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TaskBpmnErrorDto {\n");
        sb.append("    errorCode: ").append(this.toIndentedString(this.errorCode)).append("\n");
        sb.append("    errorMessage: ").append(this.toIndentedString(this.errorMessage)).append("\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getErrorCode() != null) {
            try {
                joiner.add(String.format("%serrorCode%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getErrorCode()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getErrorMessage() != null) {
            try {
                joiner.add(String.format("%serrorMessage%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(this.getErrorMessage()), "UTF-8").replaceAll("\\+", "%20")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getVariables() != null) {
            for (String _key : this.getVariables().keySet()) {
                if (this.getVariables().get(_key) == null) continue;
                joiner.add(this.getVariables().get(_key).toUrlQueryString(String.format("%svariables%s%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix))));
            }
        }
        return joiner.toString();
    }
}

