/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.rest.client.springboot;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.camunda.community.rest.client.api.DeploymentApi;
import org.camunda.community.rest.client.invoker.ApiException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.DigestUtils;

@Configuration
public class CamundaProcessAutodeployment {
    private Logger logger = LoggerFactory.getLogger(CamundaProcessAutodeployment.class);
    @Autowired
    private DeploymentApi deploymentApi;
    @Autowired
    private ResourcePatternResolver patternResolver;
    @Value(value="${camunda.autoDeploy.bpmnResources:}")
    private String bpmnResourcesPattern;
    @Value(value="${camunda.autoDeploy.dmnResources:}")
    private String dmnResourcesPattern;
    @Value(value="${camunda.autoDeploy.formResources:}")
    private String formResourcesPattern;
    @Value(value="${spring.application.name:spring-app}")
    private String applicationName;
    @Value(value="${camunda.autoDeploy.enabled:true}")
    private boolean autoDeployEnabled;

    @PostConstruct
    public void deployCamundaResources() throws IOException, ApiException {
        if (!this.autoDeployEnabled) {
            return;
        }
        if (this.bpmnResourcesPattern == null || this.bpmnResourcesPattern.length() == 0) {
            this.bpmnResourcesPattern = "classpath*:**/*.bpmn";
        }
        if (this.dmnResourcesPattern == null || this.dmnResourcesPattern.length() == 0) {
            this.dmnResourcesPattern = "classpath*:**/*.dmn";
        }
        if (this.formResourcesPattern == null || this.formResourcesPattern.length() == 0) {
            this.formResourcesPattern = "classpath*:**/*.form";
        }
        this.deployResources(Arrays.asList(this.patternResolver.getResources(this.bpmnResourcesPattern)), "bpmn");
        this.deployResources(Arrays.asList(this.patternResolver.getResources(this.dmnResourcesPattern)), "dmn");
        this.deployResources(Arrays.asList(this.patternResolver.getResources(this.formResourcesPattern)), "form");
    }

    private void deployResources(List<Resource> resourcesToDeploy, String type) throws IOException, ApiException {
        this.logger.info("Found resources for deployment of type " + type + ": " + resourcesToDeploy);
        for (Resource camundaResource : resourcesToDeploy) {
            String tempDirectoryName = FileUtils.getTempDirectory().getAbsolutePath();
            String filename = this.getResourceFilename(camundaResource, type);
            File tempFile = new File(tempDirectoryName + File.separator + filename);
            tempFile.deleteOnExit();
            try (FileOutputStream out = new FileOutputStream(tempFile);){
                IOUtils.copy((InputStream)camundaResource.getInputStream(), (OutputStream)out);
            }
            this.logger.info("  - Now deploying: " + camundaResource);
            this.deploymentApi.createDeployment(null, null, Boolean.valueOf(true), Boolean.valueOf(true), this.applicationName + "-" + filename, null, tempFile);
        }
    }

    private String getResourceFilename(Resource camundaResource, String type) throws IOException {
        if (camundaResource.getFilename() != null) {
            return camundaResource.getFilename();
        }
        return DigestUtils.md5DigestAsHex((InputStream)camundaResource.getInputStream()) + '.' + type;
    }
}

