/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.community.process_test_coverage.junit5.common;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mu.KLogging;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.camunda.community.process_test_coverage.core.model.DefaultCollector;
import org.camunda.community.process_test_coverage.core.model.Run;
import org.camunda.community.process_test_coverage.core.model.Suite;
import org.camunda.community.process_test_coverage.report.CoverageReportUtil;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.extension.ExtensionContext;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 *2\u00020\u0001:\u0001*Bi\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0014\b\u0002\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000b\u0012 \b\u0002\u0010\u000e\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000b0\u000f\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J$\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\r2\u0012\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\bH\u0002J\u000e\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0006\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\tH\u0002J\u001d\u0010 \u001a\n !*\u0004\u0018\u00010\u00050\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010\"J\u0010\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010#\u001a\u00020\u00132\u0006\u0010&\u001a\u00020'H\u0002J\u0014\u0010(\u001a\n !*\u0004\u0018\u00010\u00010\u0001*\u00020\u0015H\u0002J\f\u0010)\u001a\u00020\u0013*\u00020\u0015H\u0002R\u001a\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u000e\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000b0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/camunda/community/process_test_coverage/junit5/common/ProcessEngineCoverageExtensionHelper;", "", "coverageCollector", "Lorg/camunda/community/process_test_coverage/core/model/DefaultCollector;", "detailedCoverageLogging", "", "handleTestMethodCoverage", "excludedProcessDefinitionKeys", "", "", "classCoverageAssertionConditions", "", "Lorg/assertj/core/api/Condition;", "", "testMethodNameToCoverageConditions", "", "(Lorg/camunda/community/process_test_coverage/core/model/DefaultCollector;ZZLjava/util/List;Ljava/util/List;Ljava/util/Map;)V", "suiteInitialized", "afterAll", "", "context", "Lorg/junit/jupiter/api/extension/ExtensionContext;", "afterTestExecution", "assertCoverage", "coverage", "conditions", "beforeAll", "beforeTestExecution", "getStore", "Lorg/junit/jupiter/api/extension/ExtensionContext$Store;", "initializeSuite", "name", "isNested", "kotlin.jvm.PlatformType", "(Lorg/junit/jupiter/api/extension/ExtensionContext;)Ljava/lang/Boolean;", "logCoverageDetail", "run", "Lorg/camunda/community/process_test_coverage/core/model/Run;", "suite", "Lorg/camunda/community/process_test_coverage/core/model/Suite;", "getActiveSuiteContextId", "setActiveSuiteContextId", "Companion", "camunda-process-test-coverage-junit5-common"})
@SourceDebugExtension(value={"SMAP\nProcessEngineCoverageExtensionHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessEngineCoverageExtensionHelper.kt\norg/camunda/community/process_test_coverage/junit5/common/ProcessEngineCoverageExtensionHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,175:1\n1849#2,2:176\n*S KotlinDebug\n*F\n+ 1 ProcessEngineCoverageExtensionHelper.kt\norg/camunda/community/process_test_coverage/junit5/common/ProcessEngineCoverageExtensionHelper\n*L\n152#1:176,2\n*E\n"})
public final class ProcessEngineCoverageExtensionHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DefaultCollector coverageCollector;
    private final boolean detailedCoverageLogging;
    private final boolean handleTestMethodCoverage;
    @NotNull
    private final List<String> excludedProcessDefinitionKeys;
    @NotNull
    private final List<Condition<Double>> classCoverageAssertionConditions;
    @NotNull
    private final Map<String, List<Condition<Double>>> testMethodNameToCoverageConditions;
    private boolean suiteInitialized;
    @NotNull
    private static final String KEY_SUITE_CONTEXT_ID = "SUITE_CONTEXT_ID";

    public ProcessEngineCoverageExtensionHelper(@NotNull DefaultCollector coverageCollector, boolean detailedCoverageLogging, boolean handleTestMethodCoverage, @NotNull List<String> excludedProcessDefinitionKeys, @NotNull List<Condition<Double>> classCoverageAssertionConditions, @NotNull Map<String, List<Condition<Double>>> testMethodNameToCoverageConditions) {
        Intrinsics.checkNotNullParameter((Object)coverageCollector, (String)"coverageCollector");
        Intrinsics.checkNotNullParameter(excludedProcessDefinitionKeys, (String)"excludedProcessDefinitionKeys");
        Intrinsics.checkNotNullParameter(classCoverageAssertionConditions, (String)"classCoverageAssertionConditions");
        Intrinsics.checkNotNullParameter(testMethodNameToCoverageConditions, (String)"testMethodNameToCoverageConditions");
        this.coverageCollector = coverageCollector;
        this.detailedCoverageLogging = detailedCoverageLogging;
        this.handleTestMethodCoverage = handleTestMethodCoverage;
        this.excludedProcessDefinitionKeys = excludedProcessDefinitionKeys;
        this.classCoverageAssertionConditions = classCoverageAssertionConditions;
        this.testMethodNameToCoverageConditions = testMethodNameToCoverageConditions;
    }

    public /* synthetic */ ProcessEngineCoverageExtensionHelper(DefaultCollector defaultCollector, boolean bl, boolean bl2, List list, List list2, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            list2 = new ArrayList();
        }
        if ((n & 0x20) != 0) {
            map = new LinkedHashMap();
        }
        this(defaultCollector, bl, bl2, list, list2, map);
    }

    public final void beforeAll(@NotNull ExtensionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!this.suiteInitialized || !Intrinsics.areEqual((Object)context.getUniqueId(), (Object)this.getActiveSuiteContextId(context)) && !this.isNested(context).booleanValue()) {
            String string = context.getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.displayName");
            this.initializeSuite(context, string);
        }
    }

    public final void afterAll(@NotNull ExtensionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (Intrinsics.areEqual((Object)context.getUniqueId(), (Object)this.getActiveSuiteContextId(context))) {
            Suite suite = this.coverageCollector.getActiveSuite();
            double suiteCoveragePercentage = suite.calculateCoverage(this.coverageCollector.getModels());
            Companion.getLogger().info(suite.getName() + " test class coverage is: " + suiteCoveragePercentage);
            this.logCoverageDetail(suite);
            CoverageReportUtil.createReport((DefaultCollector)this.coverageCollector);
            CoverageReportUtil.createJsonReport((DefaultCollector)this.coverageCollector);
            this.assertCoverage(suiteCoveragePercentage, this.classCoverageAssertionConditions);
        }
    }

    public final void beforeTestExecution(@NotNull ExtensionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!this.suiteInitialized) {
            String string = context.getRequiredTestClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.requiredTestClass.name");
            this.initializeSuite(context, string);
        }
        String string = context.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.uniqueId");
        String runId = string;
        String string2 = context.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.displayName");
        this.coverageCollector.createRun(new Run(runId, string2), this.coverageCollector.getActiveSuite().getId());
        this.coverageCollector.activateRun(runId);
    }

    public final void afterTestExecution(@NotNull ExtensionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.handleTestMethodCoverage) {
            this.handleTestMethodCoverage(context);
        }
    }

    private final Boolean isNested(ExtensionContext context) {
        return context.getParent().map(arg_0 -> ProcessEngineCoverageExtensionHelper.isNested$lambda$0((Function1)new Function1<ExtensionContext, Boolean>(this, context){
            final /* synthetic */ ProcessEngineCoverageExtensionHelper this$0;
            final /* synthetic */ ExtensionContext $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
                super(1);
            }

            public final Boolean invoke(ExtensionContext it) {
                return Intrinsics.areEqual((Object)it.getUniqueId(), (Object)ProcessEngineCoverageExtensionHelper.access$getActiveSuiteContextId(this.this$0, this.$context));
            }
        }, arg_0)).orElse(false);
    }

    private final void initializeSuite(ExtensionContext context, String name) {
        String suiteId = context.getRequiredTestClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)suiteId, (String)"suiteId");
        this.coverageCollector.createSuite(new Suite(suiteId, name));
        this.coverageCollector.setExcludedProcessDefinitionKeys(this.excludedProcessDefinitionKeys);
        this.coverageCollector.activateSuite(suiteId);
        this.setActiveSuiteContextId(context);
        this.suiteInitialized = true;
    }

    private final void setActiveSuiteContextId(ExtensionContext $this$setActiveSuiteContextId) {
        ExtensionContext extensionContext = $this$setActiveSuiteContextId.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)extensionContext, (String)"this.root");
        this.getStore(extensionContext).put((Object)KEY_SUITE_CONTEXT_ID, (Object)$this$setActiveSuiteContextId.getUniqueId());
    }

    private final Object getActiveSuiteContextId(ExtensionContext $this$getActiveSuiteContextId) {
        ExtensionContext extensionContext = $this$getActiveSuiteContextId.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)extensionContext, (String)"this.root");
        return this.getStore(extensionContext).get((Object)KEY_SUITE_CONTEXT_ID);
    }

    private final ExtensionContext.Store getStore(ExtensionContext context) {
        Object[] objectArray = new Object[]{this.getClass(), context.getUniqueId()};
        ExtensionContext.Store store = context.getStore(ExtensionContext.Namespace.create((Object[])objectArray));
        Intrinsics.checkNotNullExpressionValue((Object)store, (String)"context.getStore(Extensi\u2026Class, context.uniqueId))");
        return store;
    }

    private final void logCoverageDetail(Suite suite) {
        if (Companion.getLogger().isDebugEnabled() && this.detailedCoverageLogging) {
            Companion.getLogger().debug(suite.toString());
        }
    }

    private final void logCoverageDetail(Run run) {
        if (Companion.getLogger().isDebugEnabled() && this.detailedCoverageLogging) {
            Companion.getLogger().debug(run.toString());
        }
    }

    private final void assertCoverage(double coverage, List<? extends Condition<Double>> conditions) {
        Iterable $this$forEach$iv = conditions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Condition it = (Condition)element$iv;
            boolean bl = false;
            Assertions.assertThat((double)coverage).satisfies(it);
        }
    }

    private final void handleTestMethodCoverage(ExtensionContext context) {
        block1: {
            Suite suite = this.coverageCollector.getActiveSuite();
            String string = context.getUniqueId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.uniqueId");
            Run run = suite.getRun(string);
            if (run == null) {
                return;
            }
            Run run2 = run;
            double coveragePercentage = run2.calculateCoverage(this.coverageCollector.getModels());
            Companion.getLogger().info(run2.getName() + " test method coverage is " + coveragePercentage);
            this.logCoverageDetail(run2);
            List<Condition<Double>> list = this.testMethodNameToCoverageConditions.get(run2.getName());
            if (list == null) break block1;
            List<Condition<Double>> it = list;
            boolean bl = false;
            this.assertCoverage(coveragePercentage, it);
        }
    }

    private static final Boolean isNested$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Object access$getActiveSuiteContextId(ProcessEngineCoverageExtensionHelper $this, ExtensionContext $receiver) {
        return $this.getActiveSuiteContextId($receiver);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/camunda/community/process_test_coverage/junit5/common/ProcessEngineCoverageExtensionHelper$Companion;", "Lmu/KLogging;", "()V", "KEY_SUITE_CONTEXT_ID", "", "camunda-process-test-coverage-junit5-common"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

