/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.spin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.camunda.spin.Spin;
import org.camunda.spin.impl.logging.SpinCoreLogger;
import org.camunda.spin.impl.logging.SpinLogger;
import org.camunda.spin.json.SpinJsonNode;
import org.camunda.spin.spi.DataFormat;
import org.camunda.spin.spi.DataFormatConfigurator;
import org.camunda.spin.spi.DataFormatProvider;
import org.camunda.spin.xml.SpinXmlElement;

public class DataFormats {
    private static SpinCoreLogger LOG = SpinLogger.CORE_LOGGER;
    public static String JSON_DATAFORMAT_NAME = "application/json";
    public static String XML_DATAFORMAT_NAME = "application/xml";
    static DataFormats INSTANCE = new DataFormats();
    protected Map<String, DataFormat<?>> availableDataFormats;

    public static DataFormats getInstance() {
        return INSTANCE;
    }

    public static DataFormat<SpinXmlElement> xml() {
        return DataFormats.getDataFormat(XML_DATAFORMAT_NAME);
    }

    public static DataFormat<SpinJsonNode> json() {
        return DataFormats.getDataFormat(JSON_DATAFORMAT_NAME);
    }

    public static DataFormat<? extends Spin<?>> getDataFormat(String dataFormatName) {
        return INSTANCE.getDataFormatByName(dataFormatName);
    }

    public static Set<DataFormat<? extends Spin<?>>> getAvailableDataFormats() {
        return INSTANCE.getAllAvailableDataFormats();
    }

    public Set<DataFormat<? extends Spin<?>>> getAllAvailableDataFormats() {
        this.ensureDataformatsInitialized();
        return new HashSet(this.availableDataFormats.values());
    }

    public DataFormat<? extends Spin<?>> getDataFormatByName(String name) {
        this.ensureDataformatsInitialized();
        return this.availableDataFormats.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void ensureDataformatsInitialized() {
        if (this.availableDataFormats != null) return;
        Class<DataFormats> clazz = DataFormats.class;
        synchronized (DataFormats.class) {
            if (this.availableDataFormats != null) return;
            this.registerDataFormats(null);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void registerDataFormats(ClassLoader classloader) {
        HashMap dataFormats = new HashMap();
        if (classloader == null) {
            classloader = DataFormats.class.getClassLoader();
        }
        this.registerCustomDataFormats(dataFormats, classloader);
        this.applyConfigurators(dataFormats, classloader);
        LOG.logDataFormats(dataFormats.values());
        this.availableDataFormats = dataFormats;
    }

    protected void registerCustomDataFormats(Map<String, DataFormat<?>> dataFormats, ClassLoader classloader) {
        ServiceLoader<DataFormatProvider> providerLoader = ServiceLoader.load(DataFormatProvider.class, classloader);
        for (DataFormatProvider provider : providerLoader) {
            LOG.logDataFormatProvider(provider);
            this.registerProvider(dataFormats, provider);
        }
    }

    protected void registerProvider(Map<String, DataFormat<?>> dataFormats, DataFormatProvider provider) {
        String dataFormatName = provider.getDataFormatName();
        if (dataFormats.containsKey(dataFormatName)) {
            throw LOG.multipleProvidersForDataformat(dataFormatName);
        }
        DataFormat<?> dataFormatInstance = provider.createInstance();
        dataFormats.put(dataFormatName, dataFormatInstance);
    }

    protected void applyConfigurators(Map<String, DataFormat<?>> dataFormats, ClassLoader classloader) {
        ServiceLoader<DataFormatConfigurator> configuratorLoader = ServiceLoader.load(DataFormatConfigurator.class, classloader);
        for (DataFormatConfigurator configurator : configuratorLoader) {
            LOG.logDataFormatConfigurator(configurator);
            this.applyConfigurator(dataFormats, configurator);
        }
    }

    protected void applyConfigurator(Map<String, DataFormat<?>> dataFormats, DataFormatConfigurator configurator) {
        for (DataFormat<?> dataFormat : dataFormats.values()) {
            if (!configurator.getDataFormatClass().isAssignableFrom(dataFormat.getClass())) continue;
            configurator.configure(dataFormat);
        }
    }

    public static void loadDataFormats() {
        DataFormats.loadDataFormats(null);
    }

    public static void loadDataFormats(ClassLoader classloader) {
        INSTANCE.registerDataFormats(classloader);
    }
}

