/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.spin.impl.json.jackson.format;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import org.camunda.spin.impl.json.jackson.format.AbstractJacksonJsonTypeDetector;

public class CollectionJacksonJsonTypeDetector
extends AbstractJacksonJsonTypeDetector {
    public boolean canHandle(Object object) {
        return object instanceof Collection;
    }

    public String detectType(Object object) {
        return this.constructType(object).toCanonical();
    }

    protected JavaType constructType(Object object) {
        TypeFactory typeFactory = TypeFactory.defaultInstance();
        if (object instanceof Collection && !((Collection)object).isEmpty()) {
            Collection collection = (Collection)object;
            Object firstElement = collection.iterator().next();
            if (this.bindingsArePresent(collection.getClass())) {
                JavaType elementType = this.constructType(firstElement);
                return typeFactory.constructCollectionType(collection.getClass(), elementType);
            }
        }
        return typeFactory.constructType(object.getClass());
    }

    private boolean bindingsArePresent(Class<?> erasedType) {
        int varLen;
        TypeVariable<Class<?>>[] vars = erasedType.getTypeParameters();
        int n = varLen = vars == null ? 0 : vars.length;
        if (varLen == 0) {
            return false;
        }
        if (varLen != 1) {
            throw new IllegalArgumentException("Cannot create TypeBindings for class " + erasedType.getName() + " with 1 type parameter: class expects " + varLen);
        }
        return true;
    }
}

