/*
 * Decompiled with CFR 0.152.
 */
package ceylon.language;

import ceylon.language.AuthorsAnnotation$annotation$;
import ceylon.language.Category$impl;
import ceylon.language.DefaultAnnotation$annotation$;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.FormalAnnotation$annotation$;
import ceylon.language.Iterable;
import ceylon.language.SeeAnnotation$annotation$;
import ceylon.language.SeeAnnotation$annotations$;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.TagsAnnotation$annotation$;
import com.redhat.ceylon.common.NonNull;
import com.redhat.ceylon.compiler.java.metadata.Annotation;
import com.redhat.ceylon.compiler.java.metadata.Annotations;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.TypeParameter;
import com.redhat.ceylon.compiler.java.metadata.TypeParameters;
import com.redhat.ceylon.compiler.java.metadata.Variance;

@Ceylon(major=8, minor=1)
@DocAnnotation$annotation$(description="Abstract supertype of objects that contain other values, \ncalled *elements*, where it is possible to efficiently \ndetermine if a given value is an element. A `Category`\nmay not be finite, and its elements may not even be\ncountable. Thus, unlike [[streams|Iterable]], the \nelements of a generic `Category` are not iterable.\n\n`Category` models a mathematical set, but is distinct \nfrom the [[Set]] collection type which represents finite\nsets.\n\nThe `in` operator may be used to determine if a value\nbelongs to a `Category`:\n\n    if (69 in 0..100) { ... }\n    assert (key->item in { for (n in 0..100) n.string->n**2 });\n\nAn object may be a `Category` of two different disjoint\nelement types. For example, [[String]] is a `Category`\nof its `Character`s and of its substrings.\n\n    if (\"hello\" in \"hello world\") { ... }\n    assert ('.' in string);\n\nEvery meaningful `Category` is formed from elements with\nsome equivalence relation. Ordinarily, that equivalence\nrelation is [[value equality|Object.equals]]. Thus,\nordinarily, `x==y` implies that `x in cat == y in cat`.\nBut this contract is not required since it is possible to \nform a meaningful `Category` using a different \nequivalence relation. For example, an `IdentitySet` is a \nmeaningful `Category`, where the equivalence relation is\n[[identity equality|Identifiable]].\n\nSince [[Null]] is not considered to have any meaningful\nequivalence relation, a `Category` may not contain the\n[[null value|null]].\n\nNote that even though `Category<Element>` is declared\ncontravariant in its [[element type|Element]], most types\nthat inherit `Category` are covariant in their element\ntype, and therefore satisfy `Category<Object>`, resulting\nin some loss of typesafety. For such types, [[contains]] \nshould return `false` for any value that is not an \ninstance of the element type. For example, `String` is a \n`Category<Object>`, not a `Category<Character|String>`,\nand `x in string` evaluates to `false` for every `x` that\nis not a `String` or `Character`.")
@AuthorsAnnotation$annotation$(authors={"Gavin"})
@TagsAnnotation$annotation$(tags={"Collections"})
@SharedAnnotation$annotation$
@Annotations(modifiers=2L, value={@Annotation(value="doc", arguments={"Abstract supertype of objects that contain other values, \ncalled *elements*, where it is possible to efficiently \ndetermine if a given value is an element. A `Category`\nmay not be finite, and its elements may not even be\ncountable. Thus, unlike [[streams|Iterable]], the \nelements of a generic `Category` are not iterable.\n\n`Category` models a mathematical set, but is distinct \nfrom the [[Set]] collection type which represents finite\nsets.\n\nThe `in` operator may be used to determine if a value\nbelongs to a `Category`:\n\n    if (69 in 0..100) { ... }\n    assert (key->item in { for (n in 0..100) n.string->n**2 });\n\nAn object may be a `Category` of two different disjoint\nelement types. For example, [[String]] is a `Category`\nof its `Character`s and of its substrings.\n\n    if (\"hello\" in \"hello world\") { ... }\n    assert ('.' in string);\n\nEvery meaningful `Category` is formed from elements with\nsome equivalence relation. Ordinarily, that equivalence\nrelation is [[value equality|Object.equals]]. Thus,\nordinarily, `x==y` implies that `x in cat == y in cat`.\nBut this contract is not required since it is possible to \nform a meaningful `Category` using a different \nequivalence relation. For example, an `IdentitySet` is a \nmeaningful `Category`, where the equivalence relation is\n[[identity equality|Identifiable]].\n\nSince [[Null]] is not considered to have any meaningful\nequivalence relation, a `Category` may not contain the\n[[null value|null]].\n\nNote that even though `Category<Element>` is declared\ncontravariant in its [[element type|Element]], most types\nthat inherit `Category` are covariant in their element\ntype, and therefore satisfy `Category<Object>`, resulting\nin some loss of typesafety. For such types, [[contains]] \nshould return `false` for any value that is not an \ninstance of the element type. For example, `String` is a \n`Category<Object>`, not a `Category<Character|String>`,\nand `x in string` evaluates to `false` for every `x` that\nis not a `String` or `Character`."}), @Annotation(value="by", arguments={"Gavin"}), @Annotation(value="tagged", arguments={"Collections"})})
@TypeParameters(value={@TypeParameter(value="Element", variance=Variance.IN, satisfies={"ceylon.language::Object"}, caseTypes={}, defaultValue="ceylon.language::Object")})
public interface Category<Element> {
    @Ignore
    public Category$impl<? super Element> $ceylon$language$Category$impl();

    @DocAnnotation$annotation$(description="Returns `true` if the given value belongs to this\n`Category`, that is, if it is an element of this\n`Category`, or `false` otherwise.\n\nFor any instance `c` of `Category`, `c.contains(element)` \nmay be written using the `in` operator:\n\n    element in c\n\nFor most `Category`s, the following relationship is \nsatisfied by every pair of elements `x` and `y`:\n\n- if `x==y`, then `x in category == y in category`\n\nHowever, it is possible to form a useful `Category` \nconsistent with some other equivalence relation, for \nexample `===`. Therefore implementations of `contains()` \nwhich do not satisfy this relationship are tolerated.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.2:ceylon.language::ICategory.FcontainsEvery", "::1.3.2:ceylon.language::ICategory.FcontainsAny"})})
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"Returns `true` if the given value belongs to this\n`Category`, that is, if it is an element of this\n`Category`, or `false` otherwise.\n\nFor any instance `c` of `Category`, `c.contains(element)` \nmay be written using the `in` operator:\n\n    element in c\n\nFor most `Category`s, the following relationship is \nsatisfied by every pair of elements `x` and `y`:\n\n- if `x==y`, then `x in category == y in category`\n\nHowever, it is possible to form a useful `Category` \nconsistent with some other equivalence relation, for \nexample `===`. Therefore implementations of `contains()` \nwhich do not satisfy this relationship are tolerated."}), @Annotation(value="see", arguments={"containsEvery", "containsAny"})})
    public boolean contains(@Name(value="element") @TypeInfo(value="Element") Element var1);

    @DocAnnotation$annotation$(description="Returns `true` if every one of the given values belongs \nto this `Category`, or `false` otherwise.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.2:ceylon.language::ICategory.Fcontains", "::1.3.2:ceylon.language::ICategory.FcontainsAny"})})
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Returns `true` if every one of the given values belongs \nto this `Category`, or `false` otherwise."}), @Annotation(value="see", arguments={"contains", "containsAny"})})
    public boolean containsEvery(@Name(value="elements") @TypeInfo(value="{Element*}") @NonNull Iterable<? extends Element, ? extends Object> var1);

    @DocAnnotation$annotation$(description="Returns `true` if any one of the given values belongs \nto this `Category`, or `false` otherwise.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.2:ceylon.language::ICategory.Fcontains", "::1.3.2:ceylon.language::ICategory.FcontainsEvery"})})
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Returns `true` if any one of the given values belongs \nto this `Category`, or `false` otherwise."}), @Annotation(value="see", arguments={"contains", "containsEvery"})})
    public boolean containsAny(@Name(value="elements") @TypeInfo(value="{Element*}") @NonNull Iterable<? extends Element, ? extends Object> var1);
}

