/*
 * Decompiled with CFR 0.152.
 */
package ceylon.language;

import ceylon.language.ActualAnnotation$annotation$;
import ceylon.language.AuthorsAnnotation$annotation$;
import ceylon.language.Boolean;
import ceylon.language.Callable;
import ceylon.language.Comparison;
import ceylon.language.DefaultAnnotation$annotation$;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.Entry;
import ceylon.language.FormalAnnotation$annotation$;
import ceylon.language.Integer;
import ceylon.language.Iterable;
import ceylon.language.Range;
import ceylon.language.SealedAnnotation$annotation$;
import ceylon.language.SeeAnnotation$annotation$;
import ceylon.language.SeeAnnotation$annotations$;
import ceylon.language.Sequence$impl;
import ceylon.language.Sequential;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.TagsAnnotation$annotation$;
import com.redhat.ceylon.common.NonNull;
import com.redhat.ceylon.common.Nullable;
import com.redhat.ceylon.compiler.java.metadata.Annotation;
import com.redhat.ceylon.compiler.java.metadata.Annotations;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.FunctionalParameter;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.LocalDeclarations;
import com.redhat.ceylon.compiler.java.metadata.Member;
import com.redhat.ceylon.compiler.java.metadata.Members;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.SatisfiedTypes;
import com.redhat.ceylon.compiler.java.metadata.Transient;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.TypeParameter;
import com.redhat.ceylon.compiler.java.metadata.TypeParameters;
import com.redhat.ceylon.compiler.java.metadata.Variance;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;

@Ceylon(major=8, minor=1)
@DocAnnotation$annotation$(description="A nonempty, immutable sequence of values. The type \n`Sequence<Element>` may be abbreviated `[Element+]`.\n\nGiven a possibly-empty sequence of type `[Element*]`, the \n`if (nonempty ...)` construct, or, alternatively, \n`assert (nonempty ...)`, may be used to narrow to a \nsequence type to a nonempty sequence type:\n\n    [Integer*] nums = ... ;\n    if (nonempty nums) {\n        Integer first = nums.first;\n        Integer max = max(nums);\n        [Integer+] squares = nums.collect((Integer i) => i**2));\n        [Integer+] sorted = nums.sort(byIncreasing((Integer i) => i));\n    }\n\nOperations like `first`, `max()`, `collect()`, and `sort()`, \nwhich polymorphically produce a nonempty or non-null output \nwhen given a nonempty input are called \n_emptiness-preserving_.\n\n`Sequence` has the following subtypes:\n\n- [[ArraySequence]], a sequence backed by an [[Array]],\n- [[Range]], an efficient representation of a sequence of \n  adjacent [[enumerable values|Enumerable]],\n- [[Tuple]], a typed linked list, and\n- [[Singleton]], a sequence of just one element.")
@SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.2:ceylon.language::IEmpty", "::1.3.2:ceylon.language::CArraySequence", "::1.3.2:ceylon.language::CRange", "::1.3.2:ceylon.language::CTuple", "::1.3.2:ceylon.language::CSingleton"})})
@AuthorsAnnotation$annotation$(authors={"Gavin"})
@TagsAnnotation$annotation$(tags={"Sequences"})
@SharedAnnotation$annotation$
@SealedAnnotation$annotation$
@Members(value={@Member(klass=impl$Repeat.class), @Member(klass=impl$Reverse.class)})
@LocalDeclarations(value={"1list_"})
@Annotations(modifiers=18L, value={@Annotation(value="doc", arguments={"A nonempty, immutable sequence of values. The type \n`Sequence<Element>` may be abbreviated `[Element+]`.\n\nGiven a possibly-empty sequence of type `[Element*]`, the \n`if (nonempty ...)` construct, or, alternatively, \n`assert (nonempty ...)`, may be used to narrow to a \nsequence type to a nonempty sequence type:\n\n    [Integer*] nums = ... ;\n    if (nonempty nums) {\n        Integer first = nums.first;\n        Integer max = max(nums);\n        [Integer+] squares = nums.collect((Integer i) => i**2));\n        [Integer+] sorted = nums.sort(byIncreasing((Integer i) => i));\n    }\n\nOperations like `first`, `max()`, `collect()`, and `sort()`, \nwhich polymorphically produce a nonempty or non-null output \nwhen given a nonempty input are called \n_emptiness-preserving_.\n\n`Sequence` has the following subtypes:\n\n- [[ArraySequence]], a sequence backed by an [[Array]],\n- [[Range]], an efficient representation of a sequence of \n  adjacent [[enumerable values|Enumerable]],\n- [[Tuple]], a typed linked list, and\n- [[Singleton]], a sequence of just one element."}), @Annotation(value="see", arguments={"Empty", "ArraySequence", "Range", "Tuple", "Singleton"}), @Annotation(value="by", arguments={"Gavin"}), @Annotation(value="tagged", arguments={"Sequences"})})
@SatisfiedTypes(value={"Element[]", "{Element+}"})
@TypeParameters(value={@TypeParameter(value="Element", variance=Variance.OUT, satisfies={}, caseTypes={}, defaultValue="ceylon.language::Anything")})
public interface Sequence<Element>
extends Sequential<Element>,
Iterable<Element, Object> {
    @Ignore
    public Sequence$impl<? extends Element> $ceylon$language$Sequence$impl();

    @Override
    @Ignore
    public <Result> Iterable<? extends Result, ? extends Object> map(TypeDescriptor var1, Callable<? extends Result> var2);

    @Override
    @Ignore
    public <Result, OtherAbsent> Iterable flatMap(TypeDescriptor var1, TypeDescriptor var2, Callable<? extends Iterable<? extends Result, ? extends OtherAbsent>> var3);

    @Override
    @Ignore
    public <Result> Object reduce(TypeDescriptor var1, Callable<? extends Result> var2);

    @Override
    @Ignore
    public <Result, Args extends Sequential<? extends Object>> Callable<? extends Iterable<? extends Result, ? extends Object>> spread(TypeDescriptor var1, TypeDescriptor var2, Callable<? extends Callable<? extends Result>> var3);

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends Object> by(long var1);

    @Override
    @Ignore
    public <Default> Iterable defaultNullElements(TypeDescriptor var1, Default var2);

    @Override
    @Ignore
    public Iterable<? extends Entry<? extends Integer, ? extends Element>, ? extends Object> getIndexed();

    @Override
    @Ignore
    public Iterable<? extends Sequence<? extends Element>, ? extends Object> partition(long var1);

    @Override
    @Ignore
    public <Other, OtherAbsent> Iterable chain(TypeDescriptor var1, TypeDescriptor var2, Iterable<? extends Other, ? extends OtherAbsent> var3);

    @Override
    @Ignore
    public <Other, OtherAbsent> Iterable product(TypeDescriptor var1, TypeDescriptor var2, Iterable<? extends Other, ? extends OtherAbsent> var3);

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends Object> getCycled();

    @Override
    @Ignore
    public <Other> Iterable interpose(TypeDescriptor var1, Other var2);

    @Override
    @Ignore
    public <Other> Iterable interpose(TypeDescriptor var1, Other var2, long var3);

    @Override
    @Ignore
    public Iterable<? extends Element, ? extends Object> getDistinct();

    @Override
    @DocAnnotation$annotation$(description="The first element of the sequence, that is, the element\nwith index `0`.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=194L, value={@Annotation(value="doc", arguments={"The first element of the sequence, that is, the element\nwith index `0`."})})
    @TypeInfo(value="Element", erased=true, untrusted=true)
    public Element getFirst();

    @Override
    @DocAnnotation$annotation$(description="The last element of the sequence, that is, the element\nwith index `sequence.lastIndex`.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=194L, value={@Annotation(value="doc", arguments={"The last element of the sequence, that is, the element\nwith index `sequence.lastIndex`."})})
    @TypeInfo(value="Element", erased=true, untrusted=true)
    public Element getLast();

    @Override
    @DocAnnotation$annotation$(description="Returns `false`, since every `Sequence` contains at\nleast one element.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=66L, value={@Annotation(value="doc", arguments={"Returns `false`, since every `Sequence` contains at\nleast one element."})})
    @Transient
    public boolean getEmpty();

    @Override
    @DocAnnotation$annotation$(description="The non-negative length of this sequence, that is, the\nnumber of elements in this sequence.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=194L, value={@Annotation(value="doc", arguments={"The non-negative length of this sequence, that is, the\nnumber of elements in this sequence."})})
    public long getSize();

    @Override
    @DocAnnotation$annotation$(description="The index of the last element of the sequence.")
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.2:ceylon.language::ISequence.Vsize"})})
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L, value={@Annotation(value="doc", arguments={"The index of the last element of the sequence."}), @Annotation(value="see", arguments={"size"})})
    @Transient
    @NonNull
    public Integer getLastIndex();

    @Override
    @DocAnnotation$annotation$(description="An integer [[Range]] containing all indexes of this \nsequence, that is, the range `0..sequence.lastIndex`.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L, value={@Annotation(value="doc", arguments={"An integer [[Range]] containing all indexes of this \nsequence, that is, the range `0..sequence.lastIndex`."})})
    @TypeInfo(value="ceylon.language::Range<ceylon.language::Integer>")
    @Transient
    @NonNull
    public Range<Integer> getKeys();

    @Override
    @DocAnnotation$annotation$(description="An integer [[Range]] containing all indexes of this \nsequence, that is, the range `0..sequence.lastIndex`.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L, value={@Annotation(value="doc", arguments={"An integer [[Range]] containing all indexes of this \nsequence, that is, the range `0..sequence.lastIndex`."})})
    @TypeInfo(value="ceylon.language::Range<ceylon.language::Integer>", erased=true, untrusted=true)
    @NonNull
    public Range indexes();

    @Override
    @DocAnnotation$annotation$(description="This nonempty sequence.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L, value={@Annotation(value="doc", arguments={"This nonempty sequence."})})
    @TypeInfo(value="[Element+]", erased=true, untrusted=true)
    @NonNull
    public Sequence sequence();

    @Override
    @DocAnnotation$annotation$(description="The rest of the sequence, without the first element.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=194L, value={@Annotation(value="doc", arguments={"The rest of the sequence, without the first element."})})
    @TypeInfo(value="Element[]")
    @NonNull
    public Sequential<? extends Element> getRest();

    @Override
    @DocAnnotation$annotation$(description="A sequence containing the elements of this sequence in\nreverse order to the order in which they occur in this\nsequence.")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=322L, value={@Annotation(value="doc", arguments={"A sequence containing the elements of this sequence in\nreverse order to the order in which they occur in this\nsequence."})})
    @TypeInfo(value="[Element+]")
    @Transient
    @NonNull
    public Sequence<? extends Element> getReversed();

    @Override
    @DocAnnotation$annotation$(description="Produces a sequence formed by repeating the elements of\nthis sequence the given [[number of times|times]], or\nthe [[empty sequence|empty]] if `times<=0`.")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=322L, value={@Annotation(value="doc", arguments={"Produces a sequence formed by repeating the elements of\nthis sequence the given [[number of times|times]], or\nthe [[empty sequence|empty]] if `times<=0`."})})
    @TypeInfo(value="Element[]")
    @NonNull
    public Sequential<? extends Element> repeat(@Name(value="times") long var1);

    @Override
    @DocAnnotation$annotation$(description="This nonempty sequence.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L, value={@Annotation(value="doc", arguments={"This nonempty sequence."})})
    @TypeInfo(value="[Element+]")
    @NonNull
    public Sequence<? extends Element> $clone();

    @Override
    @DocAnnotation$annotation$(description="A nonempty sequence containing the elements of this\ncontainer, sorted according to a function imposing a \npartial order upon the elements.")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=322L, value={@Annotation(value="doc", arguments={"A nonempty sequence containing the elements of this\ncontainer, sorted according to a function imposing a \npartial order upon the elements."})})
    @TypeInfo(value="[Element+]")
    @NonNull
    public Sequence<? extends Element> sort(@Name(value="comparing") @FunctionalParameter(value="(x,y)") @TypeInfo(value="ceylon.language::Comparison(Element, Element)") @Annotations(value={@Annotation(value="doc", arguments={"The function comparing pairs of elements."})}) @NonNull Callable<? extends Comparison> var1);

    @Override
    @DocAnnotation$annotation$(description="A nonempty sequence containing the results of applying \nthe given mapping to the elements of this sequence.")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=322L, value={@Annotation(value="doc", arguments={"A nonempty sequence containing the results of applying \nthe given mapping to the elements of this sequence."})})
    @TypeInfo(value="[Result+]")
    @TypeParameters(value={@TypeParameter(value="Result", variance=Variance.NONE, satisfies={}, caseTypes={})})
    @NonNull
    public <Result> Sequence<? extends Result> collect(@Ignore TypeDescriptor var1, @Name(value="collecting") @FunctionalParameter(value="(element)") @TypeInfo(value="Result(Element)") @Annotations(value={@Annotation(value="doc", arguments={"The transformation applied to the elements."})}) @NonNull Callable<? extends Result> var2);

    @Override
    @DocAnnotation$annotation$(description="Return a nonempty sequence containing the given \n[[element]], followed by the elements of this \nsequence.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L, value={@Annotation(value="doc", arguments={"Return a nonempty sequence containing the given \n[[element]], followed by the elements of this \nsequence."})})
    @TypeInfo(value="[Other, Element+]", erased=true, untrusted=true)
    @TypeParameters(value={@TypeParameter(value="Other", variance=Variance.NONE, satisfies={}, caseTypes={})})
    @NonNull
    public <Other> Sequence withLeading(@Ignore TypeDescriptor var1, @Name(value="element") @TypeInfo(value="Other") Other var2);

    @Override
    @DocAnnotation$annotation$(description="Return a nonempty sequence containing the elements of \nthis sequence, followed by the given [[element]].")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L, value={@Annotation(value="doc", arguments={"Return a nonempty sequence containing the elements of \nthis sequence, followed by the given [[element]]."})})
    @TypeInfo(value="[Element|Other+]", erased=true, untrusted=true)
    @TypeParameters(value={@TypeParameter(value="Other", variance=Variance.NONE, satisfies={}, caseTypes={})})
    @NonNull
    public <Other> Sequence withTrailing(@Ignore TypeDescriptor var1, @Name(value="element") @TypeInfo(value="Other") Other var2);

    @Override
    @DocAnnotation$annotation$(description="Return a nonempty sequence containing the elements of \nthis sequence, followed by the given [[elements]].")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L, value={@Annotation(value="doc", arguments={"Return a nonempty sequence containing the elements of \nthis sequence, followed by the given [[elements]]."})})
    @TypeInfo(value="[Element|Other+]", erased=true, untrusted=true)
    @TypeParameters(value={@TypeParameter(value="Other", variance=Variance.NONE, satisfies={}, caseTypes={})})
    @NonNull
    public <Other> Sequence append(@Ignore TypeDescriptor var1, @Name(value="elements") @TypeInfo(value="Other[]") @NonNull Sequential<? extends Other> var2);

    @Override
    @DocAnnotation$annotation$(description="Return a nonempty sequence containing the given \n[[elements]], followed by the elements of this \nsequence.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L, value={@Annotation(value="doc", arguments={"Return a nonempty sequence containing the given \n[[elements]], followed by the elements of this \nsequence."})})
    @TypeInfo(value="[Element|Other+]", erased=true, untrusted=true)
    @TypeParameters(value={@TypeParameter(value="Other", variance=Variance.NONE, satisfies={}, caseTypes={})})
    @NonNull
    public <Other> Sequence prepend(@Ignore TypeDescriptor var1, @Name(value="elements") @TypeInfo(value="Other[]") @NonNull Sequential<? extends Other> var2);

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L)
    public boolean contains(@Name(value="element") @TypeInfo(value="ceylon.language::Object") @NonNull Object var1);

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L)
    public boolean shorterThan(@Name(value="length") long var1);

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L)
    public boolean longerThan(@Name(value="length") long var1);

    @Override
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=322L)
    @TypeInfo(value="Element?")
    @Nullable
    public Element find(@Name(value="selecting") @FunctionalParameter(value="(elem)") @TypeInfo(value="ceylon.language::Boolean(Element&ceylon.language::Object)") @NonNull Callable<? extends Boolean> var1);

    @Override
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @ActualAnnotation$annotation$
    @Annotations(modifiers=322L)
    @TypeInfo(value="Element?")
    @Nullable
    public Element findLast(@Name(value="selecting") @FunctionalParameter(value="(elem)") @TypeInfo(value="ceylon.language::Boolean(Element&ceylon.language::Object)") @NonNull Callable<? extends Boolean> var1);

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L)
    @TypeInfo(value="Element[][2]", erased=true, untrusted=true)
    @NonNull
    public Sequence slice(@Name(value="index") long var1);

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L)
    @TypeInfo(value="Element[]", erased=true, untrusted=true)
    @NonNull
    public Sequential measure(@Name(value="from") @NonNull Integer var1, @Name(value="length") long var2);

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L)
    @TypeInfo(value="Element[]", erased=true, untrusted=true)
    @NonNull
    public Sequential span(@Name(value="from") @NonNull Integer var1, @Name(value="to") @NonNull Integer var2);

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L)
    @TypeInfo(value="Element[]", erased=true, untrusted=true)
    @NonNull
    public Sequential spanFrom(@Name(value="from") @NonNull Integer var1);

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L)
    @TypeInfo(value="Element[]", erased=true, untrusted=true)
    @NonNull
    public Sequential spanTo(@Name(value="to") @NonNull Integer var1);

    @Override
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L)
    @Transient
    @NonNull
    public String toString();
}

