/*
 * Decompiled with CFR 0.152.
 */
package ceylon.language;

import ceylon.language.AliasesAnnotation$annotation$;
import ceylon.language.Array;
import ceylon.language.AssertionError;
import ceylon.language.Boolean;
import ceylon.language.Callable;
import ceylon.language.Category$impl;
import ceylon.language.Character;
import ceylon.language.Collection$impl;
import ceylon.language.Comparable;
import ceylon.language.Comparable$impl;
import ceylon.language.Comparison;
import ceylon.language.Correspondence$impl;
import ceylon.language.Empty;
import ceylon.language.Entry;
import ceylon.language.FinalAnnotation$annotation$;
import ceylon.language.Finished;
import ceylon.language.Integer;
import ceylon.language.Iterable;
import ceylon.language.Iterable$impl;
import ceylon.language.Iterator;
import ceylon.language.List;
import ceylon.language.List$impl;
import ceylon.language.Map;
import ceylon.language.NativeAnnotation$annotation$;
import ceylon.language.Null;
import ceylon.language.Object;
import ceylon.language.SearchableList;
import ceylon.language.SearchableList$impl;
import ceylon.language.Sequence;
import ceylon.language.Sequential;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.Singleton;
import ceylon.language.Span;
import ceylon.language.StringBuilder;
import ceylon.language.Summable;
import ceylon.language.Tuple;
import ceylon.language.empty_;
import ceylon.language.equal_;
import ceylon.language.finished_;
import ceylon.language.impl.BaseCharacterList;
import ceylon.language.impl.BaseIterable;
import ceylon.language.impl.BaseIterator;
import ceylon.language.larger_;
import ceylon.language.smaller_;
import com.redhat.ceylon.compiler.java.Util;
import com.redhat.ceylon.compiler.java.language.AbstractCallable;
import com.redhat.ceylon.compiler.java.language.StringTokens;
import com.redhat.ceylon.compiler.java.metadata.Annotation;
import com.redhat.ceylon.compiler.java.metadata.Annotations;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Class;
import com.redhat.ceylon.compiler.java.metadata.Defaulted;
import com.redhat.ceylon.compiler.java.metadata.FunctionalParameter;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.SatisfiedTypes;
import com.redhat.ceylon.compiler.java.metadata.Transient;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.TypeParameter;
import com.redhat.ceylon.compiler.java.metadata.TypeParameters;
import com.redhat.ceylon.compiler.java.metadata.ValueType;
import com.redhat.ceylon.compiler.java.runtime.model.ReifiedType;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;
import java.io.Serializable;
import java.util.Locale;

@Ceylon(major=8)
@Class(extendsType="ceylon.language::Object", basic=false, identifiable=false, constructors=true)
@SatisfiedTypes(value={"ceylon.language::SearchableList<ceylon.language::Character>", "ceylon.language::Comparable<ceylon.language::String>", "ceylon.language::Summable<ceylon.language::String>", "ceylon.language::Ranged<ceylon.language::Integer,ceylon.language::Character,ceylon.language::String>"})
@ValueType
@Annotations(value={@Annotation(value="doc", arguments={"A string of characters..."}), @Annotation(value="by", arguments={"Gavin"}), @Annotation(value="shared"), @Annotation(value="final")})
@SharedAnnotation$annotation$
@FinalAnnotation$annotation$
@NativeAnnotation$annotation$(backends={})
public final class String
implements Comparable<String>,
SearchableList<Character>,
Summable<String>,
ReifiedType,
Serializable,
java.lang.Comparable<String> {
    private static final long serialVersionUID = 3920012367456670329L;
    @Ignore
    public static final TypeDescriptor $TypeDescriptor$ = TypeDescriptor.klass(String.class, new TypeDescriptor[0]);
    @Ignore
    public final java.lang.String value;
    @Ignore
    private static Callable<Boolean> WHITESPACE = new AbstractCallable<Boolean>(Boolean.$TypeDescriptor$, TypeDescriptor.klass(Tuple.class, Character.$TypeDescriptor$, Character.$TypeDescriptor$, Empty.$TypeDescriptor$), "whitespace", -1){

        @Override
        public Boolean $call$(java.lang.Object ch) {
            return Boolean.instance(((Character)ch).getWhitespace());
        }
    };
    @Ignore
    private static Callable<Boolean> NEWLINES = new AbstractCallable<Boolean>(Boolean.$TypeDescriptor$, TypeDescriptor.klass(Tuple.class, Character.$TypeDescriptor$, Character.$TypeDescriptor$, Empty.$TypeDescriptor$), "newlines", -1){

        @Override
        public Boolean $call$(java.lang.Object ch) {
            return Boolean.instance(((Character)ch).intValue() == 10);
        }
    };
    @Ignore
    private static Callable<Boolean> RETURNS = new AbstractCallable<Boolean>(Boolean.$TypeDescriptor$, TypeDescriptor.klass(Tuple.class, Character.$TypeDescriptor$, Character.$TypeDescriptor$, Empty.$TypeDescriptor$), "returns", -1){

        @Override
        public Boolean $call$(java.lang.Object ch) {
            return Boolean.instance(((Character)ch).intValue() == 13);
        }
    };
    private static Callable<String> TRIM_RETURNS = new AbstractCallable<String>($TypeDescriptor$, TypeDescriptor.klass(Tuple.class, $TypeDescriptor$, $TypeDescriptor$, Empty.$TypeDescriptor$), "", -1){

        @Override
        public String $call$(java.lang.Object str) {
            return String.instance(String.trimTrailing(((String)str).value, RETURNS));
        }
    };
    private static Callable<String> CONCAT_LINES_WITH_BREAKS = new AbstractCallable<String>($TypeDescriptor$, TypeDescriptor.klass(Tuple.class, TypeDescriptor.klass(Sequence.class, $TypeDescriptor$), TypeDescriptor.klass(Sequence.class, $TypeDescriptor$), Empty.$TypeDescriptor$), "", -1){

        @Override
        public String $call$(java.lang.Object seq) {
            Sequence strings = (Sequence)seq;
            java.lang.String str = ((String)strings.getFirst()).value;
            if (strings.getSize() > 1L) {
                str = str + ((String)strings.getFromFirst((long)1L)).value;
            }
            return String.instance(str);
        }
    };
    private static final TypeDescriptor INT_TO_CHAR_ENTRY_DESCRIPTOR = TypeDescriptor.klass(Entry.class, Integer.$TypeDescriptor$, Character.$TypeDescriptor$);

    public static java.lang.String sum(@TypeInfo(value="{ceylon.language::String*}") @Name(value="strings") Iterable<? extends String, ? extends java.lang.Object> strings) {
        StringBuilder result = new StringBuilder();
        result.appendAll(strings);
        return result.toString();
    }

    @Override
    @Ignore
    public Comparable$impl<String> $ceylon$language$Comparable$impl() {
        return new Comparable$impl<String>($TypeDescriptor$, this);
    }

    public String(@Name(value="characters") @TypeInfo(value="{ceylon.language::Character*}") Iterable<? extends Character, ?> characters) {
        if (characters instanceof String) {
            this.value = ((String)characters).value;
        } else {
            java.lang.String s = null;
            if (characters instanceof Array.ArrayIterable) {
                s = ((Array.ArrayIterable)characters).stringValue();
            }
            if (s != null) {
                this.value = s;
            } else {
                java.lang.Object $tmp;
                java.lang.StringBuilder sb = new java.lang.StringBuilder();
                Iterator<? extends Character> $val$iter$0 = characters.iterator();
                while (!(($tmp = $val$iter$0.next()) instanceof Finished)) {
                    sb.appendCodePoint(((Character)$tmp).codePoint);
                }
                this.value = sb.toString();
            }
        }
    }

    @Ignore
    public String(java.lang.String string) {
        this.value = string;
    }

    @Override
    @Transient
    public java.lang.String toString() {
        return this.value;
    }

    @Ignore
    public static java.lang.String toString(java.lang.String value) {
        return value;
    }

    @Ignore
    public static String instance(java.lang.String s) {
        if (s == null) {
            return null;
        }
        return new String(s);
    }

    @Ignore
    public static String instanceJoining(java.lang.String ... strings) {
        StringBuffer buf = new StringBuffer();
        for (java.lang.String s : strings) {
            buf.append(s);
        }
        return String.instance(buf.toString());
    }

    @Ignore
    public static String instanceJoining(String ... strings) {
        StringBuffer buf = new StringBuffer();
        for (String s : strings) {
            buf.append(s.value);
        }
        return String.instance(buf.toString());
    }

    public java.lang.String getUppercased() {
        return String.getUppercased(this.value);
    }

    @Ignore
    public static java.lang.String getUppercased(java.lang.String value) {
        return value.toUpperCase(Locale.ROOT);
    }

    public java.lang.String getLowercased() {
        return String.getLowercased(this.value);
    }

    @Ignore
    public static java.lang.String getLowercased(java.lang.String value) {
        return value.replace("\u0130", "i\u0307").toLowerCase(Locale.ROOT);
    }

    @Override
    public boolean equals(@Name(value="that") java.lang.Object that) {
        if (that instanceof String) {
            String s = (String)that;
            return this.value.equals(s.value);
        }
        return false;
    }

    @Ignore
    public static boolean equals(java.lang.String value, java.lang.Object that) {
        if (that instanceof String) {
            String s = (String)that;
            return value.equals(s.value);
        }
        return false;
    }

    public boolean equalsIgnoringCase(@Name(value="that") java.lang.String that) {
        return this.value.equalsIgnoreCase(that);
    }

    @Ignore
    public static boolean equalsIgnoringCase(java.lang.String value, java.lang.String that) {
        return value.equalsIgnoreCase(that);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Ignore
    public static int hashCode(java.lang.String value) {
        return value.hashCode();
    }

    private static Comparison comparison(int c) {
        return c < 0 ? smaller_.get_() : (c == 0 ? equal_.get_() : larger_.get_());
    }

    @Override
    public Comparison compare(@Name(value="other") String other) {
        return String.comparison(this.value.compareTo(other.value));
    }

    @Override
    @Ignore
    public int compareTo(String other) {
        return this.value.compareTo(other.value);
    }

    @Ignore
    public static Comparison compare(java.lang.String value, java.lang.String otherValue) {
        return String.comparison(value.compareTo(otherValue));
    }

    public Comparison compareIgnoringCase(@Name(value="other") java.lang.String other) {
        return String.comparison(this.value.compareToIgnoreCase(other));
    }

    @Ignore
    public static Comparison compareIgnoringCase(java.lang.String value, java.lang.String otherValue) {
        return String.comparison(value.compareToIgnoreCase(otherValue));
    }

    @Override
    public String plus(@Name(value="other") String other) {
        return String.instance(this.value + other.value);
    }

    @Ignore
    public static java.lang.String plus(java.lang.String value, java.lang.String otherValue) {
        return value + otherValue;
    }

    @Override
    @TypeInfo(value="ceylon.language::Integer")
    @AliasesAnnotation$annotation$(aliases={"length"})
    public long getSize() {
        return this.value.codePointCount(0, this.value.length());
    }

    @Ignore
    public static long getSize(java.lang.String value) {
        return value.codePointCount(0, value.length());
    }

    @Override
    @TypeInfo(value="ceylon.language::Null|ceylon.language::Integer")
    @Transient
    public Integer getLastIndex() {
        long length = this.getSize();
        return length == 0L ? null : Integer.instance(length - 1L);
    }

    @Ignore
    public static Integer getLastIndex(java.lang.String value) {
        long length = String.getSize(value);
        return length == 0L ? null : Integer.instance(length - 1L);
    }

    @Override
    public boolean getEmpty() {
        return this.value.isEmpty();
    }

    @Ignore
    public static boolean getEmpty(java.lang.String value) {
        return value.isEmpty();
    }

    @Transient
    public boolean getWhitespace() {
        return String.getWhitespace(this.value);
    }

    @Ignore
    public static boolean getWhitespace(java.lang.String value) {
        int codePoint;
        int length = value.length();
        for (int offset = 0; offset < length; offset += java.lang.Character.charCount(codePoint)) {
            codePoint = value.codePointAt(offset);
            if (java.lang.Character.isWhitespace(codePoint)) continue;
            return false;
        }
        return true;
    }

    @Ignore
    public static Character get(java.lang.String value, long key) {
        return String.getFromFirst(value, key);
    }

    @Override
    @TypeInfo(value="ceylon.language::Null|ceylon.language::Character")
    public Character getFromLast(@Name(value="index") long key) {
        return String.getFromLast(this.value, key);
    }

    @Ignore
    public static Character getFromLast(java.lang.String value, long key) {
        int codePoint;
        int index = Util.toInt(key);
        try {
            int offset = value.offsetByCodePoints(value.length(), -index - 1);
            codePoint = value.codePointAt(offset);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
        return Character.instance(codePoint);
    }

    @Override
    @TypeInfo(value="ceylon.language::Null|ceylon.language::Character")
    public Character getFromFirst(@Name(value="index") long key) {
        return String.getFromFirst(this.value, key);
    }

    @Ignore
    public static Character getFromFirst(java.lang.String value, long key) {
        int codePoint;
        int index = Util.toInt(key);
        try {
            int offset = value.offsetByCodePoints(0, index);
            codePoint = value.codePointAt(offset);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
        return Character.instance(codePoint);
    }

    @Override
    public boolean defines(@Name(value="index") Integer key) {
        long index = key.longValue();
        return index >= 0L && index < this.getSize();
    }

    @Ignore
    public static boolean defines(java.lang.String value, long key) {
        return key >= 0L && key < String.getSize(value);
    }

    @Override
    @Transient
    public Sequential<? extends Integer> getKeys() {
        return String.getKeys(this.value);
    }

    @Ignore
    public static Sequential<? extends Integer> getKeys(java.lang.String value) {
        long size = value.codePointCount(0, value.length());
        if (size == 0L) {
            return empty_.get_();
        }
        return new Span<Integer>(Integer.$TypeDescriptor$, Integer.instance(0L), Integer.instance(size - 1L));
    }

    @Ignore
    public static java.lang.Object indexes(java.lang.String value) {
        return String.getKeys(value);
    }

    @Ignore
    public static boolean definesEvery(java.lang.String value, Iterable<? extends Integer, ?> keys) {
        return String.instance(value).definesEvery((Iterable<? extends Integer, ? extends java.lang.Object>)keys);
    }

    @Ignore
    public static boolean definesEvery(java.lang.String value) {
        return true;
    }

    @Ignore
    public static boolean definesAny(java.lang.String value, Iterable<? extends Integer, ?> keys) {
        return String.instance(value).definesAny((Iterable<? extends Integer, ? extends java.lang.Object>)keys);
    }

    @Ignore
    public static boolean definesAny(java.lang.String value) {
        return false;
    }

    @Ignore
    public static <Absent extends Null> Iterable<? extends Character, ? extends Absent> getAll(TypeDescriptor $reifiedAbsent, java.lang.String value, Iterable<? extends Integer, Absent> keys) {
        return String.instance(value).getAll($reifiedAbsent, (Iterable<? extends Integer, ? extends Absent>)keys);
    }

    @Ignore
    public static boolean occurs(java.lang.String value, int element) {
        return String.occurs(value, element, 0L);
    }

    @Ignore
    public static boolean occurs(java.lang.String value, int element, long from) {
        return String.occurs(value, element, from, java.lang.Integer.MAX_VALUE);
    }

    @Ignore
    public static boolean occurs(java.lang.String value, int element, long from, long length) {
        int start;
        if (from >= (long)value.length() || length <= 0L) {
            return false;
        }
        if (from < 0L) {
            length += from;
            from = 0L;
        }
        try {
            start = value.offsetByCodePoints(0, (int)from);
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
        int index = value.indexOf(element, start);
        return index >= 0 && (long)index < length + from;
    }

    @Override
    public boolean occurs(@Name(value="element") Character element, @Defaulted @Name(value="from") long from, @Defaulted @Name(value="length") long length) {
        return String.occurs(this.value, element.codePoint, from, length);
    }

    @Ignore
    public static boolean occursAt(java.lang.String value, long index, int element) {
        if (index < 0L || index >= (long)value.length()) {
            return false;
        }
        try {
            int offset;
            try {
                offset = value.offsetByCodePoints(0, (int)index);
            }
            catch (IndexOutOfBoundsException e) {
                return false;
            }
            return element == value.codePointAt(offset);
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    @Override
    public boolean occursAt(@Name(value="index") long index, @Name(value="element") Character element) {
        return String.occursAt(this.value, index, element.codePoint);
    }

    @Ignore
    public static Iterable<? extends Integer, ?> occurrences(java.lang.String value, int element) {
        return String.occurrences(value, element, 0L);
    }

    @Ignore
    public static Iterable<? extends Integer, ?> occurrences(java.lang.String value, int element, long from) {
        return String.occurrences(value, element, from, java.lang.Integer.MAX_VALUE);
    }

    @Ignore
    public static Iterable<? extends Integer, ?> occurrences(final java.lang.String value, final int element, final long from, final long length) {
        return new BaseIterable<Integer, java.lang.Object>(Integer.$TypeDescriptor$, Null.$TypeDescriptor$){
            final long stop;
            final int start;
            final int len;
            {
                super($reified$Element, $reified$Absent);
                this.stop = length + from;
                this.start = from < 0L ? 0 : Util.toInt(from);
                this.len = java.lang.Character.charCount(element);
            }

            @Override
            public Iterator<? extends Integer> iterator() {
                return new BaseIterator<Integer>(Integer.$TypeDescriptor$){
                    int index;
                    int offset;
                    {
                        this.index = start;
                        try {
                            this.offset = value.offsetByCodePoints(0, start);
                        }
                        catch (IndexOutOfBoundsException e) {
                            this.offset = value.length();
                        }
                    }

                    @Override
                    public java.lang.Object next() {
                        if (this.offset >= value.length() || stop <= 0L) {
                            return finished_.get_();
                        }
                        int result = value.indexOf(element, this.offset);
                        if (result < 0) {
                            return finished_.get_();
                        }
                        this.index += value.codePointCount(this.offset, result);
                        long c = this.index;
                        this.offset = result + len;
                        if ((long)this.index >= stop) {
                            return finished_.get_();
                        }
                        ++this.index;
                        return Integer.instance(c);
                    }
                };
            }

            @Override
            public long getSize() {
                int offset;
                if (this.start >= value.length() || this.stop <= 0L) {
                    return 0L;
                }
                int index = this.start;
                try {
                    offset = value.offsetByCodePoints(0, this.start);
                }
                catch (IndexOutOfBoundsException e) {
                    return 0L;
                }
                int size = 0;
                int result;
                while ((result = value.indexOf(element, offset)) >= 0) {
                    offset = result + this.len;
                    if ((long)(index += value.codePointCount(offset, result)) >= this.stop) {
                        return size;
                    }
                    ++index;
                    ++size;
                }
                return size;
            }
        };
    }

    @Override
    @TypeInfo(value="{ceylon.language::Integer*}")
    public Iterable<? extends Integer, ? extends java.lang.Object> occurrences(@Name(value="element") Character element, @Defaulted @Name(value="from") long from, @Defaulted @Name(value="length") long length) {
        return String.occurrences(this.value, element.codePoint, from, length);
    }

    @Ignore
    public static boolean includes(java.lang.String value, List<? extends Character> sublist) {
        return String.includes(value, sublist, 0L);
    }

    @Ignore
    public static boolean includes(java.lang.String value, List<? extends Character> sublist, long from) {
        if (from > (long)value.length()) {
            return false;
        }
        if (from < 0L) {
            from = 0L;
        }
        if (sublist instanceof String) {
            int offset;
            String string = (String)sublist;
            try {
                offset = value.offsetByCodePoints(0, (int)from);
            }
            catch (IndexOutOfBoundsException e) {
                return value.isEmpty();
            }
            int index = value.indexOf(string.value, offset);
            return index >= 0;
        }
        return String.instance(value).includes(sublist, from);
    }

    @Override
    public boolean includes(@Name(value="sublist") List<? extends Character> sublist, @Defaulted @Name(value="from") long from) {
        if (sublist instanceof String) {
            return String.includes(this.value, sublist, from);
        }
        return this.$ceylon$language$SearchableList$impl().includes(sublist, from);
    }

    @Ignore
    public static boolean includesAt(java.lang.String value, long index, List<? extends Character> sublist) {
        if (index < 0L || index > (long)value.length()) {
            return false;
        }
        if (sublist instanceof String) {
            String string = (String)sublist;
            java.lang.String str = string.value;
            try {
                int offset;
                try {
                    offset = value.offsetByCodePoints(0, (int)index);
                }
                catch (IndexOutOfBoundsException e) {
                    return sublist.getEmpty();
                }
                return value.regionMatches(offset, str, 0, str.length());
            }
            catch (IndexOutOfBoundsException e) {
                return false;
            }
        }
        return String.instance(value).includesAt(index, sublist);
    }

    @Override
    public boolean includesAt(@Name(value="index") long index, @Name(value="sublist") List<? extends Character> sublist) {
        if (sublist instanceof String) {
            return String.includesAt(this.value, index, sublist);
        }
        return this.$ceylon$language$SearchableList$impl().includesAt(index, sublist);
    }

    @Ignore
    public static Iterable<? extends Integer, ?> inclusions(java.lang.String value, List<? extends Character> substring) {
        return String.inclusions(value, substring, 0L);
    }

    @Ignore
    public static Iterable<? extends Integer, ?> inclusions(final java.lang.String value, List<? extends Character> substring, final long from) {
        if (!(substring instanceof String)) {
            return String.instance(value).inclusions(substring, from);
        }
        final String string = (String)substring;
        return new BaseIterable<Integer, java.lang.Object>(Integer.$TypeDescriptor$, Null.$TypeDescriptor$){
            final int start;
            final java.lang.String str;
            final int len;
            {
                super($reified$Element, $reified$Absent);
                this.start = from < 0L ? 0 : Util.toInt(from);
                this.str = string.value;
                this.len = this.str.isEmpty() ? 1 : java.lang.Character.charCount(this.str.codePointAt(0));
            }

            @Override
            public Iterator<? extends Integer> iterator() {
                return new BaseIterator<Integer>(Integer.$TypeDescriptor$){
                    long index;
                    int offset;
                    {
                        this.index = from;
                        try {
                            this.offset = value.offsetByCodePoints(0, start);
                        }
                        catch (IndexOutOfBoundsException e) {
                            this.offset = value.length();
                        }
                    }

                    @Override
                    public java.lang.Object next() {
                        if (this.offset <= value.length()) {
                            int result = value.indexOf(str, this.offset);
                            if (result < 0) {
                                return finished_.get_();
                            }
                            this.index += (long)value.codePointCount(this.offset, result);
                            long i = this.index++;
                            this.offset = result + len;
                            return Integer.instance(i);
                        }
                        return finished_.get_();
                    }
                };
            }

            @Override
            public long getSize() {
                int offset;
                if (this.start > value.length()) {
                    return 0L;
                }
                try {
                    offset = value.offsetByCodePoints(0, this.start);
                }
                catch (IndexOutOfBoundsException e) {
                    return 0L;
                }
                int size = 0;
                while (offset <= value.length()) {
                    int result = value.indexOf(this.str, offset);
                    if (result < 0) {
                        return size;
                    }
                    offset = result + this.len;
                    ++size;
                }
                return size;
            }
        };
    }

    @Override
    @TypeInfo(value="{ceylon.language::Integer*}")
    public Iterable<? extends Integer, ? extends java.lang.Object> inclusions(@Name(value="sublist") List<? extends Character> sublist, @Defaulted @Name(value="from") long from) {
        if (sublist instanceof String) {
            return String.inclusions(this.value, sublist, from);
        }
        return this.$ceylon$language$SearchableList$impl().inclusions(sublist, from);
    }

    @Ignore
    public static Integer firstInclusion(java.lang.String value, List<? extends Character> sublist) {
        return String.firstInclusion(value, sublist, 0L);
    }

    @Ignore
    public static Integer firstInclusion(java.lang.String value, List<? extends Character> sublist, long from) {
        if (from > (long)value.length()) {
            return null;
        }
        if (from < 0L) {
            from = 0L;
        }
        if (sublist instanceof String) {
            int start;
            String string = (String)sublist;
            try {
                start = value.offsetByCodePoints(0, (int)from);
            }
            catch (IndexOutOfBoundsException iobe) {
                return null;
            }
            int index = value.indexOf(string.value, start);
            if (index >= 0) {
                return Integer.instance(from + (long)value.codePointCount(start, index));
            }
            return null;
        }
        return String.instance(value).firstInclusion(sublist, from);
    }

    @Override
    @TypeInfo(value="ceylon.language::Null|ceylon.language::Integer")
    public Integer firstInclusion(@Name(value="sublist") List<? extends Character> sublist, @Defaulted @Name(value="from") long from) {
        if (sublist instanceof String) {
            return String.firstInclusion(this.value, sublist, from);
        }
        return this.$ceylon$language$SearchableList$impl().firstInclusion(sublist, from);
    }

    @Ignore
    public static Integer lastInclusion(java.lang.String value, List<? extends Character> sublist) {
        return String.lastInclusion(value, sublist, 0L);
    }

    @Ignore
    public static Integer lastInclusion(java.lang.String value, List<? extends Character> sublist, long from) {
        if (from > (long)value.length()) {
            return null;
        }
        if (from < 0L) {
            from = 0L;
        }
        if (sublist instanceof String) {
            int start;
            String string = (String)sublist;
            try {
                start = value.offsetByCodePoints(value.length(), -((int)from) - Util.toInt(sublist.getSize()));
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
            int index = value.lastIndexOf(string.value, start);
            if (index >= 0) {
                return Integer.instance(value.codePointCount(0, index));
            }
            return null;
        }
        return String.instance(value).lastInclusion(sublist, from);
    }

    @Override
    @TypeInfo(value="ceylon.language::Null|ceylon.language::Integer")
    public Integer lastInclusion(@Name(value="sublist") List<? extends Character> sublist, @Defaulted @Name(value="from") long from) {
        if (sublist instanceof String) {
            return String.lastInclusion(this.value, sublist, from);
        }
        return this.$ceylon$language$SearchableList$impl().lastInclusion(sublist, from);
    }

    @Ignore
    public static Integer firstOccurrence(java.lang.String value, int element) {
        return String.firstOccurrence(value, element, 0L);
    }

    @Ignore
    public static Integer firstOccurrence(java.lang.String value, int element, long from) {
        return String.firstOccurrence(value, element, from, java.lang.Integer.MAX_VALUE);
    }

    @Ignore
    public static Integer firstOccurrence(java.lang.String value, int element, long from, long length) {
        int start;
        if (from >= (long)value.length() || length <= 0L) {
            return null;
        }
        if (from < 0L) {
            length += from;
            from = 0L;
        }
        try {
            start = value.offsetByCodePoints(0, (int)from);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
        int index = value.indexOf(element, start);
        if (index >= 0) {
            int result = value.codePointCount(start, index);
            if ((long)result >= length) {
                return null;
            }
            return Integer.instance(from + (long)result);
        }
        return null;
    }

    @Override
    @TypeInfo(value="ceylon.language::Null|ceylon.language::Integer")
    public Integer firstOccurrence(@Name(value="element") Character element, @Defaulted @Name(value="from") long from, @Defaulted @Name(value="length") long length) {
        return String.firstOccurrence(this.value, element.codePoint, from, length);
    }

    @Ignore
    public static Integer lastOccurrence(java.lang.String value, int element) {
        return String.lastOccurrence(value, element, 0L);
    }

    @Ignore
    public static Integer lastOccurrence(java.lang.String value, int element, long from) {
        return String.lastOccurrence(value, element, from, java.lang.Integer.MAX_VALUE);
    }

    @Ignore
    public static Integer lastOccurrence(java.lang.String value, int element, long from, long length) {
        int start;
        if (from >= (long)value.length() || length <= 0L) {
            return null;
        }
        if (from < 0L) {
            length += from;
            from = 0L;
        }
        try {
            start = value.offsetByCodePoints(value.length(), -((int)from) - 1);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
        int index = value.lastIndexOf(element, start);
        if (index >= 0) {
            int dist = value.codePointCount(index, start);
            if ((long)dist >= length) {
                return null;
            }
            return Integer.instance(value.codePointCount(0, index));
        }
        return null;
    }

    @Override
    @TypeInfo(value="ceylon.language::Null|ceylon.language::Integer")
    public Integer lastOccurrence(@Name(value="element") Character element, @Defaulted @Name(value="from") long from, @Defaulted @Name(value="length") long length) {
        return String.lastOccurrence(this.value, element.codePoint, from, length);
    }

    @Override
    @TypeInfo(value="ceylon.language::Iterator<ceylon.language::Character>")
    public Iterator<Character> iterator() {
        return new StringIterator(this.value);
    }

    @Ignore
    public static Iterator<Character> iterator(java.lang.String value) {
        return new StringIterator(value);
    }

    @Override
    public boolean contains(@Name(value="element") java.lang.Object element) {
        return String.contains(this.value, element);
    }

    @Ignore
    public static boolean contains(java.lang.String value, java.lang.Object element) {
        if (element instanceof String) {
            return value.indexOf(((String)element).value) >= 0;
        }
        if (element instanceof Character) {
            return value.indexOf(((Character)element).codePoint) >= 0;
        }
        return false;
    }

    @Override
    public boolean startsWith(@Name(value="substring") @TypeInfo(value="ceylon.language::List<ceylon.language::Anything>") List<?> substring) {
        if (substring instanceof String) {
            return this.value.startsWith(((String)substring).value);
        }
        return this.$ceylon$language$List$impl().startsWith(substring);
    }

    @Ignore
    public static boolean startsWith(java.lang.String value, List<?> substring) {
        if (substring instanceof String) {
            return value.startsWith(((String)substring).value);
        }
        return String.instance(value).startsWith(substring);
    }

    @Override
    public boolean endsWith(@Name(value="substring") @TypeInfo(value="ceylon.language::List<ceylon.language::Anything>") List<?> substring) {
        if (substring instanceof String) {
            return this.value.endsWith(((String)substring).value);
        }
        return this.$ceylon$language$List$impl().endsWith(substring);
    }

    @Ignore
    public static boolean endsWith(java.lang.String value, List<?> substring) {
        if (substring instanceof String) {
            return value.endsWith(((String)substring).value);
        }
        return String.instance(value).endsWith(substring);
    }

    @Ignore
    public static boolean containsAny(java.lang.String value, Iterable<?, ?> elements) {
        return String.instance(value).containsAny((Iterable<? extends java.lang.Object, ? extends java.lang.Object>)elements);
    }

    @Ignore
    public static boolean containsEvery(java.lang.String value, Iterable<?, ?> elements) {
        return String.instance(value).containsEvery((Iterable<? extends java.lang.Object, ? extends java.lang.Object>)elements);
    }

    @Override
    public boolean longerThan(@TypeInfo(value="ceylon.language::Integer") @Name(value="length") long length) {
        if ((long)this.value.length() <= length) {
            return false;
        }
        try {
            this.value.offsetByCodePoints(0, (int)length + 1);
            return true;
        }
        catch (IndexOutOfBoundsException iobe) {
            return false;
        }
    }

    @Ignore
    public static boolean longerThan(java.lang.String value, long length) {
        if ((long)value.length() <= length) {
            return false;
        }
        try {
            value.offsetByCodePoints(0, (int)length + 1);
            return true;
        }
        catch (IndexOutOfBoundsException iobe) {
            return false;
        }
    }

    @Override
    public boolean shorterThan(@TypeInfo(value="ceylon.language::Integer") @Name(value="length") long length) {
        if ((long)this.value.length() < length) {
            return true;
        }
        try {
            this.value.offsetByCodePoints(0, (int)length);
            return false;
        }
        catch (IndexOutOfBoundsException iobe) {
            return true;
        }
    }

    @Ignore
    public static boolean shorterThan(java.lang.String value, long length) {
        if ((long)value.length() < length) {
            return true;
        }
        try {
            value.offsetByCodePoints(0, (int)length);
            return false;
        }
        catch (IndexOutOfBoundsException iobe) {
            return true;
        }
    }

    @Transient
    public java.lang.String getTrimmed() {
        return String.getTrimmed(this.value);
    }

    @Ignore
    public static java.lang.String getTrimmed(java.lang.String value) {
        return String.trim(value, WHITESPACE);
    }

    public String trimLeading(@TypeInfo(value="ceylon.language::Boolean(ceylon.language::Character)") @Name(value="trimming") @FunctionalParameter(value="(element)") Callable<? extends Boolean> characters) {
        return String.instance(String.trimLeading(this.value, characters));
    }

    @Ignore
    public static java.lang.String trimLeading(java.lang.String value, Callable<? extends Boolean> characters) {
        int from;
        int c;
        for (from = 0; from < value.length() && characters.$call$((java.lang.Object)Character.instance(c = java.lang.Character.codePointAt(value, from))).booleanValue(); from += java.lang.Character.charCount(c)) {
        }
        return value.substring(from);
    }

    public String trimTrailing(@TypeInfo(value="ceylon.language::Boolean(ceylon.language::Character)") @Name(value="trimming") @FunctionalParameter(value="(element)") Callable<? extends Boolean> characters) {
        return String.instance(String.trimTrailing(this.value, characters));
    }

    @Ignore
    public static java.lang.String trimTrailing(java.lang.String value, Callable<? extends Boolean> characters) {
        int to;
        int c;
        for (to = value.length(); to > 0 && characters.$call$((java.lang.Object)Character.instance(c = java.lang.Character.codePointBefore(value, to))).booleanValue(); to -= java.lang.Character.charCount(c)) {
        }
        return value.substring(0, to);
    }

    public String trim(@TypeInfo(value="ceylon.language::Boolean(ceylon.language::Character)") @Name(value="trimming") @FunctionalParameter(value="(element)") Callable<? extends Boolean> characters) {
        return String.instance(String.trim(this.value, characters));
    }

    @Ignore
    public static java.lang.String trim(java.lang.String value, Callable<? extends Boolean> characters) {
        int to;
        int c;
        int from;
        int c2;
        for (from = 0; from < value.length() && characters.$call$((java.lang.Object)Character.instance(c2 = java.lang.Character.codePointAt(value, from))).booleanValue(); from += java.lang.Character.charCount(c2)) {
        }
        for (to = value.length(); to > from && characters.$call$((java.lang.Object)Character.instance(c = java.lang.Character.codePointBefore(value, to))).booleanValue(); to -= java.lang.Character.charCount(c)) {
        }
        return value.substring(from, to);
    }

    @Transient
    public java.lang.String getNormalized() {
        return String.getNormalized(this.value);
    }

    @Ignore
    public static java.lang.String getNormalized(java.lang.String value) {
        int c;
        java.lang.StringBuilder result = new java.lang.StringBuilder(value.length());
        boolean previousWasWhitespace = false;
        for (int i = 0; i < value.length(); i += java.lang.Character.charCount(c)) {
            c = java.lang.Character.codePointAt(value, i);
            boolean isWhitespace = java.lang.Character.isWhitespace(c);
            if (!isWhitespace) {
                result.appendCodePoint(c);
            } else if (!previousWasWhitespace) {
                result.append(' ');
            }
            previousWasWhitespace = isWhitespace;
        }
        return String.getTrimmed(result.toString());
    }

    public String initial(@TypeInfo(value="ceylon.language::Integer") @Name(value="length") long length) {
        return String.instance(String.initial(this.value, length));
    }

    @Ignore
    public static java.lang.String initial(java.lang.String value, long length) {
        if (length <= 0L) {
            return "";
        }
        if (length >= String.getSize(value)) {
            return value;
        }
        int offset = value.offsetByCodePoints(0, Util.toInt(length));
        return value.substring(0, offset);
    }

    public String terminal(@Name(value="length") long length) {
        return String.instance(String.terminal(this.value, length));
    }

    @Ignore
    public static java.lang.String terminal(java.lang.String value, long length) {
        if (length <= 0L) {
            return "";
        }
        if (length >= String.getSize(value)) {
            return value;
        }
        int offset = value.offsetByCodePoints(0, Util.toInt((long)value.length() - length));
        return value.substring(offset, value.length());
    }

    public java.lang.String join(@Name(value="objects") @TypeInfo(value="{ceylon.language::Object*}") Iterable<? extends java.lang.Object, ?> objects) {
        return String.join(this.value, objects);
    }

    @Ignore
    public static java.lang.String join(java.lang.String value, Iterable<? extends java.lang.Object, ?> objects) {
        java.lang.StringBuilder result;
        block4: {
            result = new java.lang.StringBuilder();
            Iterator<? extends java.lang.Object> it = objects.iterator();
            java.lang.Object elem = it.next();
            if (elem instanceof Finished) break block4;
            result.append(elem);
            if (value.isEmpty()) {
                while (!((elem = it.next()) instanceof Finished)) {
                    result.append(elem);
                }
            } else {
                while (!((elem = it.next()) instanceof Finished)) {
                    result.append(value).append(elem);
                }
            }
        }
        return result.toString();
    }

    @Ignore
    public java.lang.String join() {
        return "";
    }

    @Ignore
    public static java.lang.String join(java.lang.String value) {
        return "";
    }

    @Override
    public String measure(@Name(value="from") Integer from, @Name(value="length") long length) {
        return String.instance(String.measure(this.value, from.longValue(), length));
    }

    @Ignore
    public static java.lang.String measure(java.lang.String value, long from, long length) {
        int end;
        int start;
        long len = value.length();
        if (len == 0L || from >= len || length <= 0L || from + length <= 0L) {
            return "";
        }
        if (from < 0L) {
            length += from;
            from = 0L;
        }
        try {
            start = value.offsetByCodePoints(0, Util.toInt(from));
        }
        catch (IndexOutOfBoundsException ioobe) {
            return "";
        }
        if ((long)start + length >= len) {
            return value.substring(start);
        }
        try {
            end = value.offsetByCodePoints(start, Util.toInt(length));
        }
        catch (IndexOutOfBoundsException ioobe) {
            return value.substring(start);
        }
        return value.substring(start, end);
    }

    @Override
    public String span(@Name(value="from") Integer from, @Name(value="to") Integer to) {
        return String.instance(String.span(this.value, from.longValue(), to.longValue()));
    }

    @Ignore
    public long substring$start() {
        return 0L;
    }

    @Ignore
    public long substring$end() {
        return java.lang.Integer.MAX_VALUE;
    }

    @Ignore
    public java.lang.String substring() {
        return this.value;
    }

    @Ignore
    public java.lang.String substring(long from) {
        return String.measure(this.value, from, java.lang.Integer.MAX_VALUE);
    }

    public java.lang.String substring(@Defaulted @Name(value="from") long from, @Defaulted @Name(value="end") long end) {
        return String.measure(this.value, from, end - from);
    }

    @Override
    public String spanFrom(@Name(value="from") Integer from) {
        return String.instance(String.spanFrom(this.value, from.longValue()));
    }

    @Ignore
    public static java.lang.String spanFrom(java.lang.String value, long from) {
        int start;
        if (from <= 0L) {
            return value;
        }
        long len = value.length();
        if (len == 0L || from >= len) {
            return "";
        }
        try {
            start = value.offsetByCodePoints(0, Util.toInt(from));
        }
        catch (IndexOutOfBoundsException ioobe) {
            return "";
        }
        return value.substring(start);
    }

    @Ignore
    public static List<? extends Character> sublist(java.lang.String value, long from, long to) {
        return String.instance(value).sublist(from, to);
    }

    @Ignore
    public static List<? extends Character> sublistTo(final java.lang.String value, final long to) {
        return new BaseCharacterList(){

            @Override
            public Character getFromFirst(long index) {
                if (index > to) {
                    return null;
                }
                return String.getFromFirst(value, index);
            }

            @Override
            public boolean getEmpty() {
                return to < 0L || value.isEmpty();
            }

            @Override
            public Integer getLastIndex() {
                long size = this.getSize();
                return size > 0L ? Integer.instance(size - 1L) : null;
            }

            @Override
            public long getSize() {
                long size = String.getSize(value);
                return size > to ? to + 1L : size;
            }

            @Override
            public Iterator<? extends Character> iterator() {
                return new BaseIterator<Character>(Character.$TypeDescriptor$){
                    int offset;
                    {
                        this.offset = 0;
                    }

                    @Override
                    public java.lang.Object next() {
                        if (this.offset < value.length() && (long)this.offset <= to) {
                            int codePoint = value.codePointAt(this.offset);
                            this.offset += java.lang.Character.charCount(codePoint);
                            return Character.instance(codePoint);
                        }
                        return finished_.get_();
                    }
                };
            }

            @Override
            public List<? extends Character> sublistTo(long index) {
                if (index >= to) {
                    return this;
                }
                return String.sublistTo(value, to + index);
            }

            @Override
            public boolean contains(java.lang.Object element) {
                int index;
                if (element instanceof String) {
                    index = value.indexOf(((String)element).value);
                } else if (element instanceof Character) {
                    index = value.indexOf(((Character)element).codePoint);
                } else {
                    return false;
                }
                if (index < 0) {
                    return false;
                }
                return (long)value.offsetByCodePoints(0, index) <= to;
            }
        };
    }

    @Override
    public List<? extends Character> sublistTo(@Name(value="to") long to) {
        return String.sublistTo(this.value, to);
    }

    @Ignore
    public static List<? extends Character> sublistFrom(final java.lang.String value, final long from) {
        return new BaseCharacterList(){
            int start;
            {
                if (from <= 0L) {
                    this.start = 0;
                } else {
                    try {
                        this.start = value.offsetByCodePoints(0, Util.toInt(from));
                    }
                    catch (IndexOutOfBoundsException e) {
                        this.start = value.length();
                    }
                }
            }

            @Override
            public Character getFromFirst(long index) {
                try {
                    int offset = value.offsetByCodePoints(this.start, Util.toInt(index));
                    return Character.instance(value.codePointAt(offset));
                }
                catch (IndexOutOfBoundsException e) {
                    return null;
                }
            }

            @Override
            public boolean getEmpty() {
                return this.start >= value.length();
            }

            @Override
            public Integer getLastIndex() {
                long size = this.getSize();
                return size > 0L ? Integer.instance(size - 1L) : null;
            }

            @Override
            public long getSize() {
                return value.codePointCount(this.start, value.length());
            }

            @Override
            public Iterator<? extends Character> iterator() {
                return new BaseIterator<Character>(Character.$TypeDescriptor$){
                    int offset;
                    {
                        this.offset = start;
                    }

                    @Override
                    public java.lang.Object next() {
                        if (this.offset < value.length()) {
                            int codePoint = value.codePointAt(this.offset);
                            this.offset += java.lang.Character.charCount(codePoint);
                            return Character.instance(codePoint);
                        }
                        return finished_.get_();
                    }
                };
            }

            @Override
            public List<? extends Character> sublistFrom(long index) {
                if (index <= 0L) {
                    return this;
                }
                return String.sublistFrom(value, from + index);
            }

            @Override
            public boolean contains(java.lang.Object element) {
                if (element instanceof String) {
                    return value.indexOf(((String)element).value, this.start) >= 0;
                }
                if (element instanceof Character) {
                    return value.indexOf(((Character)element).codePoint, this.start) >= 0;
                }
                return false;
            }
        };
    }

    @Override
    public List<? extends Character> sublistFrom(@Name(value="from") long from) {
        return String.sublistFrom(this.value, from);
    }

    @Override
    public String spanTo(@Name(value="to") Integer to) {
        return String.instance(String.spanTo(this.value, to.longValue()));
    }

    @Ignore
    public static java.lang.String spanTo(java.lang.String value, long to) {
        int end;
        long len = value.length();
        if (len == 0L || to < 0L) {
            return "";
        }
        if (to >= len) {
            return value;
        }
        try {
            end = value.offsetByCodePoints(0, Util.toInt(to + 1L));
        }
        catch (IndexOutOfBoundsException ioobe) {
            return value;
        }
        return value.substring(0, end);
    }

    @Ignore
    public static java.lang.String span(java.lang.String value, long from, long to) {
        java.lang.String result;
        int start;
        boolean reverse;
        long len = value.length();
        if (len == 0L) {
            return "";
        }
        boolean bl = reverse = to < from;
        if (reverse) {
            long _tmp = to;
            to = from;
            from = _tmp;
        }
        if (to < 0L || from >= len) {
            return "";
        }
        long begin = from < 0L ? 0L : from;
        try {
            start = value.offsetByCodePoints(0, Util.toInt(begin));
        }
        catch (IndexOutOfBoundsException ioobe) {
            return "";
        }
        if (to >= len) {
            result = value.substring(start);
        } else {
            int end;
            try {
                end = value.offsetByCodePoints(start, Util.toInt(to + 1L - begin));
            }
            catch (IndexOutOfBoundsException ioobe) {
                return value.substring(start);
            }
            result = value.substring(start, end);
        }
        return reverse ? String.getReversed(result) : result;
    }

    @Ignore
    public static java.lang.String substring(java.lang.String value) {
        return value;
    }

    @Ignore
    public static java.lang.String substring(java.lang.String value, long from) {
        return String.measure(value, from, java.lang.Integer.MAX_VALUE);
    }

    @Ignore
    public static java.lang.String substring(java.lang.String value, long from, long end) {
        return String.measure(value, from, end - from);
    }

    @Transient
    public String getReversed() {
        return String.instance(String.getReversed(this.value));
    }

    @Ignore
    public static java.lang.String getReversed(java.lang.String value) {
        int c;
        long len = String.getSize(value);
        if (len < 2L) {
            return value;
        }
        java.lang.StringBuilder builder = new java.lang.StringBuilder(value.length());
        for (int offset = value.length(); offset > 0; offset -= java.lang.Character.charCount(c)) {
            c = value.codePointBefore(offset);
            builder.appendCodePoint(c);
        }
        return builder.toString();
    }

    public String repeat(@Name(value="times") long times) {
        return String.instance(String.repeat(this.value, times));
    }

    @Ignore
    public static java.lang.String repeat(java.lang.String value, long times) {
        int len = value.length();
        if (times <= 0L || len == 0) {
            return "";
        }
        if (times == 1L) {
            return value;
        }
        java.lang.StringBuilder builder = new java.lang.StringBuilder(Util.toInt((long)len * times));
        int i = 0;
        while ((long)i < times) {
            builder.append(value);
            ++i;
        }
        return builder.toString();
    }

    public java.lang.String removeInitial(@Name(value="prefix") java.lang.String prefix) {
        return String.removeInitial(this.value, prefix);
    }

    @Ignore
    public static java.lang.String removeInitial(java.lang.String value, java.lang.String prefix) {
        return value.startsWith(prefix) ? value.substring(prefix.length()) : value;
    }

    public java.lang.String removeTerminal(@Name(value="postfix") java.lang.String postfix) {
        return String.removeTerminal(this.value, postfix);
    }

    @Ignore
    public static java.lang.String removeTerminal(java.lang.String value, java.lang.String postfix) {
        return value.endsWith(postfix) ? value.substring(0, value.length() - postfix.length()) : value;
    }

    public java.lang.String replace(@Name(value="substring") java.lang.String substring, @Name(value="replacement") java.lang.String replacement) {
        return String.replace(this.value, substring, replacement);
    }

    @Ignore
    public static java.lang.String replace(java.lang.String value, java.lang.String substring, java.lang.String replacement) {
        if (substring.isEmpty()) {
            throw new AssertionError("string to replace must be nonempty");
        }
        int index = value.indexOf(substring);
        if (index < 0) {
            return value;
        }
        java.lang.StringBuilder builder = new java.lang.StringBuilder(value);
        while (index >= 0) {
            builder.replace(index, index + substring.length(), replacement);
            index = builder.indexOf(substring, index + replacement.length());
        }
        return builder.toString();
    }

    public java.lang.String replaceFirst(@Name(value="substring") java.lang.String substring, @Name(value="replacement") java.lang.String replacement) {
        return String.replaceFirst(this.value, substring, replacement);
    }

    @Ignore
    public static java.lang.String replaceFirst(java.lang.String value, java.lang.String substring, java.lang.String replacement) {
        if (substring.isEmpty()) {
            throw new AssertionError("string to replace must be nonempty");
        }
        int index = value.indexOf(substring);
        if (index < 0) {
            return value;
        }
        return value.substring(0, index) + replacement + value.substring(index + substring.length());
    }

    public java.lang.String replaceLast(@Name(value="substring") java.lang.String substring, @Name(value="replacement") java.lang.String replacement) {
        return String.replaceLast(this.value, substring, replacement);
    }

    @Ignore
    public static java.lang.String replaceLast(java.lang.String value, java.lang.String substring, java.lang.String replacement) {
        if (substring.isEmpty()) {
            throw new AssertionError("string to replace must be nonempty");
        }
        int index = value.lastIndexOf(substring);
        if (index < 0) {
            return value;
        }
        return value.substring(0, index) + replacement + value.substring(index + substring.length());
    }

    @TypeInfo(value="{ceylon.language::String+}")
    public Iterable<? extends String, ?> split(@TypeInfo(value="ceylon.language::Boolean(ceylon.language::Character)") @Defaulted @Name(value="splitting") @FunctionalParameter(value="(ch)") Callable<? extends Boolean> splitting, @Defaulted @Name(value="discardSeparators") boolean discardSeparators, @Defaulted @Name(value="groupSeparators") boolean groupSeparators, @Defaulted @Name(value="limit") @TypeInfo(value="ceylon.language::Integer?") Integer limit) {
        if (this.value.isEmpty() || limit != null && !limit.getPositive()) {
            return new Singleton<String>($TypeDescriptor$, this);
        }
        return new StringTokens(this.value, splitting, !discardSeparators, groupSeparators, limit);
    }

    @Ignore
    public static Iterable<? extends String, ?> split(java.lang.String value, Callable<? extends Boolean> splitting, boolean discardSeparators, boolean groupSeparators, Integer limit) {
        if (value.isEmpty() || limit != null && !limit.getPositive()) {
            return new Singleton<String>($TypeDescriptor$, String.instance(value));
        }
        return new StringTokens(value, splitting, !discardSeparators, groupSeparators, limit);
    }

    @Ignore
    public Iterable<? extends String, ?> split(Callable<? extends Boolean> splitting, boolean discardSeparators, boolean groupSeparators) {
        return this.split(splitting, discardSeparators, groupSeparators, String.split$limit(splitting, discardSeparators, groupSeparators));
    }

    @Ignore
    public static Iterable<? extends String, ?> split(java.lang.String value, Callable<? extends Boolean> splitting, boolean discardSeparators, boolean groupSeparators) {
        return String.split(value, splitting, discardSeparators, groupSeparators, String.split$limit(splitting, discardSeparators, groupSeparators));
    }

    @Ignore
    public Iterable<? extends String, ?> split(Callable<? extends Boolean> splitting, boolean discardSeparators) {
        return this.split(splitting, discardSeparators, String.split$groupSeparators(splitting, discardSeparators), String.split$limit(splitting, discardSeparators, String.split$groupSeparators(splitting, discardSeparators)));
    }

    @Ignore
    public static Iterable<? extends String, ?> split(java.lang.String value, Callable<? extends Boolean> splitting, boolean discardSeparators) {
        return String.split(value, splitting, discardSeparators, String.split$groupSeparators(splitting, discardSeparators), String.split$limit(splitting, discardSeparators, String.split$groupSeparators(splitting, discardSeparators)));
    }

    @Ignore
    public Iterable<? extends String, ?> split(Callable<? extends Boolean> splitting) {
        return this.split(splitting, String.split$discardSeparators(splitting));
    }

    @Ignore
    public static Iterable<? extends String, ?> split(java.lang.String value, Callable<? extends Boolean> splitting) {
        return String.split(value, splitting, String.split$discardSeparators(splitting));
    }

    @Ignore
    public Iterable<? extends String, ?> split() {
        return this.split(String.split$splitting());
    }

    @Ignore
    public static Iterable<? extends String, ?> split(java.lang.String value) {
        return String.split(value, String.split$splitting());
    }

    @Ignore
    public static Callable<? extends Boolean> split$splitting() {
        return WHITESPACE;
    }

    @Ignore
    public static boolean split$discardSeparators(java.lang.Object separator) {
        return true;
    }

    @Ignore
    public static boolean split$groupSeparators(java.lang.Object separator, boolean discardSeparators) {
        return true;
    }

    @Ignore
    public static Integer split$limit(java.lang.Object separator, boolean discardSeparators, boolean groupSeparators) {
        return null;
    }

    @Override
    @TypeInfo(value="ceylon.language::Tuple<ceylon.language::String,ceylon.language::String,ceylon.language::Tuple<ceylon.language::String,ceylon.language::String,ceylon.language::Empty>>")
    public Sequence slice(@Name(value="index") long index) {
        return String.slice(this.value, index);
    }

    @Ignore
    public static Sequence slice(java.lang.String value, long index) {
        java.lang.String second;
        java.lang.String first;
        if (index <= 0L) {
            first = "";
            second = value;
        } else if (index >= (long)value.length()) {
            first = value;
            second = "";
        } else {
            int intIndex = value.offsetByCodePoints(0, Util.toInt(index));
            first = value.substring(0, intIndex);
            second = value.substring(intIndex);
        }
        return new Tuple($TypeDescriptor$, new String[]{String.instance(first), String.instance(second)});
    }

    @TypeInfo(value="{ceylon.language::String+}")
    @Transient
    public Iterable<? extends String, ?> getLines() {
        return this.split(NEWLINES, true, false).map($TypeDescriptor$, TRIM_RETURNS);
    }

    @Ignore
    public static Iterable<? extends String, ?> getLines(java.lang.String value) {
        return String.split(value, NEWLINES, true, false).map($TypeDescriptor$, TRIM_RETURNS);
    }

    @TypeInfo(value="{ceylon.language::String+}")
    @Transient
    public Iterable<? extends String, ?> getLinesWithBreaks() {
        return this.split(NEWLINES, false, false).partition(2L).map($TypeDescriptor$, CONCAT_LINES_WITH_BREAKS);
    }

    @Ignore
    public static Iterable<? extends String, ?> getLinesWithBreaks(java.lang.String value) {
        return String.split(value, NEWLINES, false, false).partition(2L).map($TypeDescriptor$, CONCAT_LINES_WITH_BREAKS);
    }

    public String $clone() {
        return this;
    }

    @Ignore
    public static java.lang.String $clone(java.lang.String value) {
        return value;
    }

    @Ignore
    public static <Result> Iterable<? extends Result, ?> map(@Ignore TypeDescriptor $reifiedResult, java.lang.String value, Callable<? extends Result> f) {
        return String.instance(value).map($reifiedResult, f);
    }

    @Ignore
    public static <Result, OtherAbsent> Iterable<? extends Result, ?> flatMap(@Ignore TypeDescriptor $reified$Result, @Ignore TypeDescriptor $reified$OtherAbsent, java.lang.String value, Callable<? extends Iterable<? extends Result, ? extends OtherAbsent>> collecting) {
        return String.instance(value).flatMap($reified$Result, $reified$OtherAbsent, collecting);
    }

    @Ignore
    public static <Type> Iterable narrow(@Ignore TypeDescriptor $reifiedType, java.lang.String value) {
        return String.instance(value).narrow($reifiedType);
    }

    @Ignore
    public static Sequential<? extends Character> select(java.lang.String value, Callable<? extends Boolean> f) {
        return String.instance(value).select(f);
    }

    @Transient
    public String getCoalesced() {
        return this;
    }

    @Ignore
    public static java.lang.String getCoalesced(java.lang.String value) {
        return value;
    }

    @Override
    @Ignore
    public <Default> Iterable<?, ?> defaultNullElements(@Ignore TypeDescriptor $reifiedDefault, Default defaultValue) {
        return this;
    }

    @Ignore
    public static <Default> Iterable<?, ?> defaultNullElements(@Ignore TypeDescriptor $reifiedDefault, java.lang.String string, Default defaultValue) {
        return String.instance(string);
    }

    public String getRest() {
        return this.value.isEmpty() ? this : String.instance(this.value.substring(this.value.offsetByCodePoints(0, 1)));
    }

    @Ignore
    public static java.lang.String getRest(java.lang.String value) {
        return value.isEmpty() ? "" : value.substring(value.offsetByCodePoints(0, 1));
    }

    @Ignore
    public static Iterable<? extends Character, ?> getExceptLast(java.lang.String value) {
        return String.instance(value).getExceptLast();
    }

    @Override
    @TypeInfo(value="ceylon.language::Null|ceylon.language::Character")
    public Character getFirst() {
        return String.getFirst(this.value);
    }

    @Ignore
    public static Character getFirst(java.lang.String value) {
        if (value.isEmpty()) {
            return null;
        }
        return Character.instance(value.codePointAt(0));
    }

    @Override
    @TypeInfo(value="ceylon.language::Null|ceylon.language::Character")
    public Character getLast() {
        return String.getLast(this.value);
    }

    @Ignore
    public static Character getLast(java.lang.String value) {
        if (value.isEmpty()) {
            return null;
        }
        return Character.instance(value.codePointBefore(value.length()));
    }

    @Ignore
    public static Sequential<? extends Character> sequence(java.lang.String value) {
        return String.instance(value).sequence();
    }

    @Override
    @TypeInfo(value="ceylon.language::Null|ceylon.language::Character")
    public Character find(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(ceylon.language::Character)") Callable<? extends Boolean> f) {
        return String.find(this.value, f);
    }

    @Ignore
    public static Character find(java.lang.String value, Callable<? extends Boolean> f) {
        int codePoint;
        int length = value.length();
        for (int offset = 0; offset < length; offset += java.lang.Character.charCount(codePoint)) {
            codePoint = value.codePointAt(offset);
            Character ch = Character.instance(codePoint);
            if (!f.$call$((java.lang.Object)ch).booleanValue()) continue;
            return ch;
        }
        return null;
    }

    @Override
    @TypeInfo(value="ceylon.language::Null|ceylon.language::Character")
    public Character findLast(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(ceylon.language::Character)") Callable<? extends Boolean> f) {
        return String.findLast(this.value, f);
    }

    @Ignore
    public static Character findLast(java.lang.String value, Callable<? extends Boolean> f) {
        int codePoint;
        Character result = null;
        int length = value.length();
        for (int offset = 0; offset < length; offset += java.lang.Character.charCount(codePoint)) {
            codePoint = value.codePointAt(offset);
            Character ch = Character.instance(codePoint);
            if (!f.$call$((java.lang.Object)ch).booleanValue()) continue;
            result = ch;
        }
        return result;
    }

    @Override
    @TypeInfo(value="ceylon.language::Null|ceylon.language::Entry<ceylon.language::Integer,ceylon.language::Character>")
    public Entry<? extends Integer, ? extends Character> locate(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(ceylon.language::Character)") Callable<? extends Boolean> f) {
        return String.locate(this.value, f);
    }

    @Override
    @TypeInfo(value="{ceylon.language::Entry<ceylon.language::Integer,ceylon.language::Character>*}")
    public Iterable<? extends Entry<? extends Integer, ? extends Character>, ? extends java.lang.Object> locations(@Name(value="selecting") @TypeInfo(value="ceylon.language::Boolean(ceylon.language::Character)") @FunctionalParameter(value="(element)") Callable<? extends Boolean> selecting) {
        return String.locations(this.value, selecting);
    }

    @Ignore
    public static Entry<? extends Integer, ? extends Character> locate(java.lang.String value, Callable<? extends Boolean> f) {
        int offset = 0;
        int index = 0;
        while (offset < value.length()) {
            int codePoint = value.codePointAt(offset);
            Character ch = Character.instance(codePoint);
            if (f.$call$((java.lang.Object)ch).booleanValue()) {
                return new Entry<Integer, Character>(Integer.$TypeDescriptor$, Character.$TypeDescriptor$, Integer.instance(index), ch);
            }
            offset += java.lang.Character.charCount(codePoint);
            ++index;
        }
        return null;
    }

    @Override
    @TypeInfo(value="ceylon.language::Null|ceylon.language::Entry<ceylon.language::Integer,ceylon.language::Character>")
    public Entry<? extends Integer, ? extends Character> locateLast(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(ceylon.language::Character)") Callable<? extends Boolean> f) {
        return String.locateLast(this.value, f);
    }

    @Ignore
    public static Entry<? extends Integer, ? extends Character> locateLast(java.lang.String value, Callable<? extends Boolean> f) {
        int codePoint;
        for (int offset = value.length(); offset > 0; offset -= java.lang.Character.charCount(codePoint)) {
            codePoint = value.codePointBefore(offset);
            Character ch = Character.instance(codePoint);
            if (!f.$call$((java.lang.Object)ch).booleanValue()) continue;
            int index = value.codePointCount(0, offset);
            return new Entry<Integer, Character>(Integer.$TypeDescriptor$, Character.$TypeDescriptor$, Integer.instance(index), ch);
        }
        return null;
    }

    @Ignore
    public static Iterable<? extends Entry<? extends Integer, ? extends Character>, ? extends java.lang.Object> locations(final java.lang.String value, final Callable<? extends Boolean> selecting) {
        return new BaseIterable<Entry<? extends Integer, ? extends Character>, java.lang.Object>(INT_TO_CHAR_ENTRY_DESCRIPTOR, Null.$TypeDescriptor$){

            @Override
            public Iterator<? extends Entry<? extends Integer, ? extends Character>> iterator() {
                return new BaseIterator<Entry<? extends Integer, ? extends Character>>(INT_TO_CHAR_ENTRY_DESCRIPTOR){
                    int offset;
                    int index;
                    {
                        this.offset = 0;
                        this.index = 0;
                    }

                    @Override
                    public java.lang.Object next() {
                        if (this.offset >= value.length()) {
                            return finished_.get_();
                        }
                        while (true) {
                            int cp = value.codePointAt(this.offset);
                            this.offset += java.lang.Character.charCount(cp);
                            if (this.offset >= value.length()) {
                                return finished_.get_();
                            }
                            Character ch = Character.instance(cp);
                            if (((Boolean)selecting.$call$((java.lang.Object)ch)).booleanValue()) {
                                return new Entry<Integer, Character>(Integer.$TypeDescriptor$, Character.$TypeDescriptor$, Integer.instance(this.index++), ch);
                            }
                            ++this.index;
                        }
                    }
                };
            }
        };
    }

    @Ignore
    public static Sequential<? extends Character> sort(java.lang.String value, Callable<? extends Comparison> f) {
        if (value.isEmpty()) {
            return empty_.get_();
        }
        return String.instance(value).sort(f);
    }

    @Ignore
    public static java.lang.Object max(java.lang.String value, Callable<? extends Comparison> comparing) {
        return String.instance(value).max(comparing);
    }

    @Ignore
    public static Iterable<? extends Integer, ?> indexesWhere(final java.lang.String value, final Callable<? extends Boolean> fun) {
        return new BaseIterable<Integer, java.lang.Object>(Integer.$TypeDescriptor$, Null.$TypeDescriptor$){

            @Override
            public Iterator<? extends Integer> iterator() {
                return new BaseIterator<Integer>(Integer.$TypeDescriptor$){
                    int offset;
                    int index;
                    {
                        this.offset = 0;
                        this.index = 0;
                    }

                    @Override
                    public java.lang.Object next() {
                        while (this.offset < value.length()) {
                            int cp = value.codePointAt(this.offset);
                            this.offset += java.lang.Character.charCount(cp);
                            if (((Boolean)fun.$call$((java.lang.Object)Character.instance(cp))).booleanValue()) {
                                return Integer.instance(this.index++);
                            }
                            ++this.index;
                        }
                        return finished_.get_();
                    }
                };
            }
        };
    }

    @Override
    @TypeInfo(value="{ceylon.language::Integer*}")
    public Iterable<? extends Integer, ? extends java.lang.Object> indexesWhere(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(ceylon.language::Character)") Callable<? extends Boolean> fun) {
        return String.indexesWhere(this.value, fun);
    }

    @Ignore
    public static Integer firstIndexWhere(java.lang.String value, Callable<? extends Boolean> fun) {
        int offset = 0;
        int index = 0;
        int length = value.length();
        while (offset < length) {
            int cp = value.codePointAt(offset);
            offset += java.lang.Character.charCount(cp);
            if (fun.$call$((java.lang.Object)Character.instance(cp)).booleanValue()) {
                return Integer.instance(index);
            }
            ++index;
        }
        return null;
    }

    @Override
    @TypeInfo(value="ceylon.language::Null|ceylon.language::Integer")
    public Integer firstIndexWhere(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(ceylon.language::Character)") Callable<? extends Boolean> fun) {
        return String.firstIndexWhere(this.value, fun);
    }

    @Ignore
    public static Integer lastIndexWhere(java.lang.String value, Callable<? extends Boolean> fun) {
        int cp;
        for (int offset = value.length(); offset > 0; offset -= java.lang.Character.charCount(cp)) {
            cp = value.codePointBefore(offset);
            if (!fun.$call$((java.lang.Object)Character.instance(cp)).booleanValue()) continue;
            int index = value.codePointCount(0, offset);
            return Integer.instance(index);
        }
        return null;
    }

    @Override
    @TypeInfo(value="ceylon.language::Null|ceylon.language::Integer")
    public Integer lastIndexWhere(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(ceylon.language::Character)") Callable<? extends Boolean> fun) {
        return String.lastIndexWhere(this.value, fun);
    }

    @Ignore
    public static Iterable<? extends Character, ?> filter(java.lang.String value, Callable<? extends Boolean> f) {
        return String.instance(value).filter(f);
    }

    @Ignore
    public static <Result> Sequential<? extends Result> collect(@Ignore TypeDescriptor $reifiedResult, java.lang.String value, Callable<? extends Result> f) {
        return String.instance(value).collect($reifiedResult, f);
    }

    @Ignore
    public static <Result> Callable<? extends Result> fold(@Ignore TypeDescriptor $reifiedResult, java.lang.String value, Result ini) {
        return String.instance(value).fold($reifiedResult, ini);
    }

    @Ignore
    public static <Result> Callable<? extends Iterable<? extends Result, ? extends java.lang.Object>> scan(@Ignore TypeDescriptor $reifiedResult, java.lang.String value, Result ini) {
        return String.instance(value).scan($reifiedResult, ini);
    }

    @Override
    @TypeInfo(value="Result|ceylon.language::Character|ceylon.language::Null")
    @TypeParameters(value={@TypeParameter(value="Result")})
    public <Result> java.lang.Object reduce(@Ignore TypeDescriptor $reifiedResult, @Name(value="accumulating") @FunctionalParameter(value="(partial,element)") @TypeInfo(value="Result(Result|ceylon.language::Character,ceylon.language::Character)") Callable<? extends Result> f) {
        return String.reduce($reifiedResult, this.value, f);
    }

    @Ignore
    public static <Result> java.lang.Object reduce(@Ignore TypeDescriptor $reifiedResult, java.lang.String value, Callable<? extends Result> f) {
        int codePoint;
        if (value.isEmpty()) {
            return null;
        }
        int initial = value.codePointAt(0);
        Character partial = Character.instance(initial);
        int length = value.length();
        for (int offset = java.lang.Character.charCount(initial); offset < length; offset += java.lang.Character.charCount(codePoint)) {
            codePoint = value.codePointAt(offset);
            partial = f.$call$((java.lang.Object)partial, (java.lang.Object)Character.instance(codePoint));
        }
        return partial;
    }

    @Override
    @TypeInfo(declaredVoid=true, value="ceylon.language::Anything")
    public java.lang.Object each(@Name(value="step") @FunctionalParameter(value="!(element)") @TypeInfo(value="ceylon.language::Callable<ceylon.language::Anything,ceylon.language::Tuple<ceylon.language::Character,ceylon.language::Character,ceylon.language::Empty>>") Callable<? extends java.lang.Object> step) {
        return String.each(this.value, step);
    }

    @Ignore
    public static java.lang.Object each(java.lang.String value, Callable<? extends java.lang.Object> f) {
        int codePoint;
        int length = value.length();
        for (int offset = 0; offset < length; offset += java.lang.Character.charCount(codePoint)) {
            codePoint = value.codePointAt(offset);
            f.$call$((java.lang.Object)Character.instance(codePoint));
        }
        return null;
    }

    @Override
    @TypeInfo(value="ceylon.language::Boolean")
    public boolean any(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(ceylon.language::Character)") Callable<? extends Boolean> f) {
        return String.any(this.value, f);
    }

    @Ignore
    public static boolean any(java.lang.String value, Callable<? extends Boolean> f) {
        int codePoint;
        int length = value.length();
        for (int offset = 0; offset < length; offset += java.lang.Character.charCount(codePoint)) {
            codePoint = value.codePointAt(offset);
            if (!f.$call$((java.lang.Object)Character.instance(codePoint)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    @TypeInfo(value="ceylon.language::Boolean")
    public boolean every(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(ceylon.language::Character)") Callable<? extends Boolean> f) {
        return String.every(this.value, f);
    }

    @Ignore
    public static boolean every(java.lang.String value, Callable<? extends Boolean> f) {
        int codePoint;
        int length = value.length();
        for (int offset = 0; offset < length; offset += java.lang.Character.charCount(codePoint)) {
            codePoint = value.codePointAt(offset);
            if (f.$call$((java.lang.Object)Character.instance(codePoint)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Ignore
    public static Iterable<? extends Character, ?> skip(java.lang.String value, long skip) {
        return String.instance(value).skip(skip);
    }

    @Ignore
    public static Iterable<? extends Character, ?> take(java.lang.String value, long take) {
        return String.instance(value).take(take);
    }

    @Ignore
    public static Iterable<? extends Character, ?> takeWhile(java.lang.String value, Callable<? extends Boolean> take) {
        return String.instance(value).takeWhile(take);
    }

    @Ignore
    public static Iterable<? extends Character, ?> skipWhile(java.lang.String value, Callable<? extends Boolean> skip) {
        return String.instance(value).skipWhile(skip);
    }

    @Ignore
    public static Iterable<? extends Character, ?> by(java.lang.String value, long step) {
        return String.instance(value).by(step);
    }

    @Override
    @TypeInfo(value="ceylon.language::Integer")
    public long count(@Name(value="selecting") @FunctionalParameter(value="(element)") @TypeInfo(value="ceylon.language::Boolean(ceylon.language::Character)") Callable<? extends Boolean> f) {
        return String.count(this.value, f);
    }

    @Ignore
    public static long count(java.lang.String value, Callable<? extends Boolean> f) {
        int codePoint;
        int count = 0;
        int length = value.length();
        for (int offset = 0; offset < length; offset += java.lang.Character.charCount(codePoint)) {
            codePoint = value.codePointAt(offset);
            if (!f.$call$((java.lang.Object)Character.instance(codePoint)).booleanValue()) continue;
            ++count;
        }
        return count;
    }

    @Ignore
    public static Iterable<? extends Entry<? extends Integer, ? extends Character>, ?> getIndexed(java.lang.String value) {
        if (value.isEmpty()) {
            return String.instance(value);
        }
        return String.instance(value).getIndexed();
    }

    @Ignore
    public static <Other, Absent> Iterable chain(@Ignore TypeDescriptor $reifiedOther, @Ignore TypeDescriptor $reifiedOtherAbsent, java.lang.String value, Iterable<? extends Other, ? extends Absent> other) {
        if (value.isEmpty()) {
            return other;
        }
        return String.instance(value).chain($reifiedOther, $reifiedOtherAbsent, other);
    }

    @Ignore
    public static <Other> Iterable follow(@Ignore TypeDescriptor $reifiedOther, java.lang.String value, Other other) {
        return String.instance(value).follow($reifiedOther, other);
    }

    @Ignore
    public static <Other> Iterable<? extends java.lang.Object, ? extends java.lang.Object> interpose(@Ignore TypeDescriptor $reifiedOther, java.lang.String value, Other other) {
        return String.instance(value).interpose($reifiedOther, other);
    }

    @Ignore
    public static <Other> Iterable interpose(@Ignore TypeDescriptor $reifiedOther, java.lang.String value, Other other, long step) {
        return String.instance(value).interpose($reifiedOther, other, step);
    }

    @Ignore
    public static <Other, OtherAbsent> Iterable product(@Ignore TypeDescriptor $reified$Other, @Ignore TypeDescriptor $reified$OtherAbsent, java.lang.String value, Iterable<? extends Other, ? extends OtherAbsent> other) {
        return String.instance(value).product($reified$Other, $reified$OtherAbsent, other);
    }

    @Ignore
    public static <Other> List patch(@Ignore TypeDescriptor $reifiedOther, java.lang.String value, List<? extends Other> list, long from, long length) {
        return String.instance(value).patch($reifiedOther, list, from, length);
    }

    @Ignore
    public static <Other> List patch(@Ignore TypeDescriptor $reifiedOther, java.lang.String value, List<? extends Other> list, long from) {
        return String.instance(value).patch($reifiedOther, list, from, 0L);
    }

    @Ignore
    public static Iterable<? extends Character, ?> getCycled(java.lang.String value) {
        return String.instance(value).getCycled();
    }

    @Override
    @Ignore
    public TypeDescriptor $getType$() {
        return $TypeDescriptor$;
    }

    @Ignore
    public static boolean largerThan(java.lang.String value, String other) {
        return value.compareTo(other.value) > 0;
    }

    @Ignore
    public static boolean largerThan(java.lang.String value, java.lang.String other) {
        return value.compareTo(other) > 0;
    }

    @Override
    public boolean largerThan(@Name(value="other") String other) {
        return this.value.compareTo(other.value) > 0;
    }

    @Ignore
    public static boolean notSmallerThan(java.lang.String value, String other) {
        return value.compareTo(other.value) >= 0;
    }

    @Ignore
    public static boolean notSmallerThan(java.lang.String value, java.lang.String other) {
        return value.compareTo(other) >= 0;
    }

    @Override
    public boolean notSmallerThan(@Name(value="other") String other) {
        return this.value.compareTo(other.value) >= 0;
    }

    @Ignore
    public static boolean smallerThan(java.lang.String value, String other) {
        return value.compareTo(other.value) < 0;
    }

    @Ignore
    public static boolean smallerThan(java.lang.String value, java.lang.String other) {
        return value.compareTo(other) < 0;
    }

    @Override
    public boolean smallerThan(@Name(value="other") String other) {
        return this.value.compareTo(other.value) < 0;
    }

    @Ignore
    public static boolean notLargerThan(java.lang.String value, String other) {
        return value.compareTo(other.value) <= 0;
    }

    @Ignore
    public static boolean notLargerThan(java.lang.String value, java.lang.String other) {
        return value.compareTo(other) <= 0;
    }

    @Override
    public boolean notLargerThan(@Name(value="other") String other) {
        return this.value.compareTo(other.value) <= 0;
    }

    @Ignore
    public static <Result, Args extends Sequential<? extends java.lang.Object>> Callable<? extends Iterable<? extends Result, ?>> spread(@Ignore TypeDescriptor $reifiedResult, @Ignore TypeDescriptor $reifiedArgs, java.lang.String value, Callable<? extends Callable<? extends Result>> method) {
        return String.instance(value).spread($reifiedResult, $reifiedArgs, method);
    }

    public java.lang.String pad(@Name(value="size") long size, @Name(value="character") @TypeInfo(value="ceylon.language::Character") @Defaulted int character) {
        return String.pad(this.value, size, character);
    }

    @Ignore
    public java.lang.String pad(long size) {
        return String.pad(this.value, size, String.pad$character(size));
    }

    @Ignore
    public static java.lang.String pad(java.lang.String value, long size) {
        return String.pad(value, size, String.pad$character(size));
    }

    @Ignore
    public static int pad$character(long size) {
        return 32;
    }

    @Ignore
    public static java.lang.String pad(java.lang.String value, long size, int character) {
        long length = String.getSize(value);
        if (size <= length) {
            return value;
        }
        long leftPad = (size - length) / 2L;
        long rightPad = leftPad + (size - length) % 2L;
        java.lang.StringBuilder builder = new java.lang.StringBuilder();
        int i = 0;
        while ((long)i < leftPad) {
            builder.appendCodePoint(character);
            ++i;
        }
        builder.append(value);
        i = 0;
        while ((long)i < rightPad) {
            builder.appendCodePoint(character);
            ++i;
        }
        return builder.toString();
    }

    public java.lang.String padLeading(@Name(value="size") long size, @Name(value="character") @TypeInfo(value="ceylon.language::Character") @Defaulted int character) {
        return String.padLeading(this.value, size, character);
    }

    @Ignore
    public java.lang.String padLeading(long size) {
        return String.padLeading(this.value, size, String.padLeading$character(size));
    }

    @Ignore
    public static java.lang.String padLeading(java.lang.String value, long size) {
        return String.padLeading(value, size, String.padLeading$character(size));
    }

    @Ignore
    public static int padLeading$character(long size) {
        return 32;
    }

    @Ignore
    public static java.lang.String padLeading(java.lang.String value, long size, int character) {
        long length = String.getSize(value);
        if (size <= length) {
            return value;
        }
        long leftPad = size - length;
        java.lang.StringBuilder builder = new java.lang.StringBuilder();
        int i = 0;
        while ((long)i < leftPad) {
            builder.appendCodePoint(character);
            ++i;
        }
        builder.append(value);
        return builder.toString();
    }

    public java.lang.String padTrailing(@Name(value="size") long size, @Name(value="character") @TypeInfo(value="ceylon.language::Character") @Defaulted int character) {
        return String.padTrailing(this.value, size, character);
    }

    @Ignore
    public java.lang.String padTrailing(long size) {
        return String.padTrailing(this.value, size, String.padTrailing$character(size));
    }

    @Ignore
    public static java.lang.String padTrailing(java.lang.String value, long size) {
        return String.padTrailing(value, size, String.padTrailing$character(size));
    }

    @Ignore
    public static int padTrailing$character(long size) {
        return 32;
    }

    @Ignore
    public static java.lang.String padTrailing(java.lang.String value, long size, int character) {
        long length = String.getSize(value);
        if (size <= length) {
            return value;
        }
        long rightPad = size - length;
        java.lang.StringBuilder builder = new java.lang.StringBuilder(value);
        int i = 0;
        while ((long)i < rightPad) {
            builder.appendCodePoint(character);
            ++i;
        }
        return builder.toString();
    }

    @Ignore
    public static Iterable getPaired(java.lang.String value) {
        return String.instance(value).getPaired();
    }

    @Ignore
    public static Iterable<? extends Sequence<? extends Character>, ? extends java.lang.Object> partition(java.lang.String value, long length) {
        return String.instance(value).partition(length);
    }

    @Ignore
    public long copyTo$sourcePosition(Array<? super Character> destination) {
        return 0L;
    }

    @Ignore
    public long copyTo$destinationPosition(Array<? super Character> destination, long sourcePosition) {
        return 0L;
    }

    @Ignore
    public long copyTo$length(Array<? super Character> destination, long sourcePosition, long destinationPosition) {
        return Math.min((long)this.value.length() - sourcePosition, destination.getSize() - destinationPosition);
    }

    @Ignore
    public static void copyTo(java.lang.String value, Array<? super Character> destination) {
        String.copyTo(value, destination, 0L, 0L);
    }

    @Ignore
    public static void copyTo(java.lang.String value, Array<? super Character> destination, long sourcePosition) {
        String.copyTo(value, destination, sourcePosition, 0L);
    }

    @Ignore
    public static void copyTo(java.lang.String value, Array<? super Character> destination, long sourcePosition, long destinationPosition) {
        String.copyTo(value, destination, sourcePosition, destinationPosition, Math.min((long)value.length() - sourcePosition, destination.getSize() - destinationPosition));
    }

    @Ignore
    public void copyTo(Array<? super Character> destination) {
        String.copyTo(this.value, destination, 0L, 0L);
    }

    @Ignore
    public void copyTo(Array<? super Character> destination, long sourcePosition) {
        String.copyTo(this.value, destination, sourcePosition, 0L);
    }

    @Ignore
    public void copyTo(Array<? super Character> destination, long sourcePosition, long destinationPosition) {
        String.copyTo(this.value, destination, sourcePosition, destinationPosition, this.copyTo$length(destination, sourcePosition, destinationPosition));
    }

    @Ignore
    public static void copyTo(java.lang.String value, Array<? super Character> destination, long sourcePosition, long destinationPosition, long length) {
        int count = 0;
        int src = Util.toInt(sourcePosition);
        int dest = Util.toInt(destinationPosition);
        try {
            if (destination.toArray() instanceof int[]) {
                int[] array = (int[])destination.toArray();
                int index = value.offsetByCodePoints(0, src);
                while ((long)count < length) {
                    int codePoint;
                    array[count + dest] = codePoint = value.codePointAt(index);
                    index += java.lang.Character.charCount(codePoint);
                    ++count;
                }
            } else {
                java.lang.Object[] array = (java.lang.Object[])destination.toArray();
                int index = value.offsetByCodePoints(0, src);
                while ((long)count < length) {
                    int codePoint = value.codePointAt(index);
                    array[count + dest] = Character.instance(codePoint);
                    index += java.lang.Character.charCount(codePoint);
                    ++count;
                }
            }
        }
        catch (IndexOutOfBoundsException iob) {
            throw new AssertionError(iob.getMessage());
        }
    }

    public void copyTo(@TypeInfo(value="ceylon.language::Array<in ceylon.language::Character>") @Name(value="destination") Array<? super Character> destination, @Name(value="sourcePosition") @Defaulted long sourcePosition, @Name(value="destinationPosition") @Defaulted long destinationPosition, @Name(value="length") @Defaulted long length) {
        String.copyTo(this.value, destination, sourcePosition, destinationPosition, length);
    }

    @Ignore
    public static Iterable<? extends Sequence<? extends Character>, ? extends java.lang.Object> getPermutations(java.lang.String value) {
        return String.instance(value).getPermutations();
    }

    @Ignore
    public static Iterable<? extends Sequence<? extends Character>, ? extends java.lang.Object> combinations(java.lang.String value, long length) {
        return String.instance(value).combinations(length);
    }

    @Ignore
    public static <Group> Iterable<? extends Entry<? extends Group, ? extends Sequence<? extends Character>>, ? extends java.lang.Object> group(java.lang.String value, TypeDescriptor $reifiedGroup, Callable<? extends Group> fun) {
        return String.instance(value).group($reifiedGroup, fun);
    }

    @Ignore
    public static <Group, Result> Iterable<? extends Entry<? extends Group, ? extends Result>, ? extends java.lang.Object> summarize(java.lang.String value, TypeDescriptor $reifiedGroup, TypeDescriptor $reifiedResult, Callable<? extends Group> fun, Callable<? extends Result> fold) {
        return String.instance(value).summarize($reifiedGroup, $reifiedResult, fun, fold);
    }

    @Ignore
    public static Iterable<? extends Character, ? extends java.lang.Object> getDistinct(java.lang.String value) {
        return String.instance(value).getDistinct();
    }

    @Override
    @Ignore
    public Collection$impl<? extends Character> $ceylon$language$Collection$impl() {
        return new Collection$impl<Character>(Character.$TypeDescriptor$, this);
    }

    @Override
    @Ignore
    public Iterable<? extends Sequence<? extends Character>, ? extends java.lang.Object> getPermutations() {
        return this.$ceylon$language$Collection$impl().getPermutations();
    }

    @Override
    @Ignore
    public Iterable<? extends Sequence<? extends Character>, ? extends java.lang.Object> combinations(long length) {
        return this.$ceylon$language$Collection$impl().combinations(length);
    }

    @Override
    @Ignore
    public Iterable$impl<? extends Character, ? extends java.lang.Object> $ceylon$language$Iterable$impl() {
        return new Iterable$impl<Character, java.lang.Object>(Character.$TypeDescriptor$, Null.$TypeDescriptor$, this);
    }

    @Override
    @Ignore
    public Iterable<? extends Character, ? extends java.lang.Object> by(long step) {
        return this.$ceylon$language$Iterable$impl().by(step);
    }

    @Override
    @Ignore
    public <Other, OtherAbsent> Iterable chain(TypeDescriptor arg0, TypeDescriptor arg1, Iterable<? extends Other, ? extends OtherAbsent> arg2) {
        return this.$ceylon$language$Iterable$impl().chain(arg0, arg1, arg2);
    }

    @Override
    @Ignore
    public Iterable<? extends Character, ? extends java.lang.Object> filter(Callable<? extends Boolean> arg0) {
        return this.$ceylon$language$Iterable$impl().filter(arg0);
    }

    @Override
    @Ignore
    public <Result, OtherAbsent> Iterable flatMap(TypeDescriptor arg0, TypeDescriptor arg1, Callable<? extends Iterable<? extends Result, ? extends OtherAbsent>> arg2) {
        return this.$ceylon$language$Iterable$impl().flatMap(arg0, arg1, arg2);
    }

    @Override
    @Ignore
    public <Result> Callable<? extends Result> fold(TypeDescriptor arg0, Result arg1) {
        return this.$ceylon$language$Iterable$impl().fold(arg0, arg1);
    }

    @Override
    @Ignore
    public <Other> Iterable follow(TypeDescriptor arg0, Other arg1) {
        return this.$ceylon$language$Iterable$impl().follow(arg0, arg1);
    }

    @Override
    @Ignore
    public Iterable<? extends Character, ? extends java.lang.Object> getCycled() {
        return this.$ceylon$language$Iterable$impl().getCycled();
    }

    @Override
    @Ignore
    public Iterable<? extends Character, ? extends java.lang.Object> getDistinct() {
        return this.$ceylon$language$Iterable$impl().getDistinct();
    }

    @Override
    @Ignore
    public Iterable<? extends Character, ? extends java.lang.Object> getExceptLast() {
        return this.$ceylon$language$Iterable$impl().getExceptLast();
    }

    @Override
    @Ignore
    public Iterable<? extends Entry<? extends Integer, ? extends Character>, ? extends java.lang.Object> getIndexed() {
        return this.$ceylon$language$Iterable$impl().getIndexed();
    }

    @Override
    @Ignore
    public Iterable<? extends Sequence<? extends Character>, ? extends java.lang.Object> getPaired() {
        return this.$ceylon$language$Iterable$impl().getPaired();
    }

    @Override
    @Ignore
    public <Group> Map<? extends Group, ? extends Sequence<? extends Character>> group(TypeDescriptor arg0, Callable<? extends Group> arg1) {
        return this.$ceylon$language$Iterable$impl().group(arg0, arg1);
    }

    @Override
    @Ignore
    public <Group, Result> Map<? extends Group, ? extends Result> summarize(TypeDescriptor arg0, TypeDescriptor arg1, Callable<? extends Group> arg2, Callable<? extends Result> arg3) {
        return this.$ceylon$language$Iterable$impl().summarize(arg0, arg1, arg2, arg3);
    }

    @Override
    @Ignore
    public java.lang.Object indexes() {
        return this.$ceylon$language$Iterable$impl().indexes();
    }

    @Override
    @Ignore
    public <Other> Iterable interpose(TypeDescriptor arg0, Other arg1) {
        return this.$ceylon$language$Iterable$impl().interpose(arg0, arg1);
    }

    @Override
    @Ignore
    public <Other> Iterable interpose(TypeDescriptor arg0, Other arg1, long arg2) {
        return this.$ceylon$language$Iterable$impl().interpose(arg0, arg1, arg2);
    }

    @Override
    @Ignore
    public <Other> long interpose$step(TypeDescriptor arg0, Other arg1) {
        return this.$ceylon$language$Iterable$impl().interpose$step(arg0, arg1);
    }

    @Override
    @Ignore
    public <Result> Iterable<? extends Result, ? extends java.lang.Object> map(TypeDescriptor arg0, Callable<? extends Result> arg1) {
        return this.$ceylon$language$Iterable$impl().map(arg0, arg1);
    }

    @Override
    @Ignore
    public java.lang.Object max(Callable<? extends Comparison> arg0) {
        return this.$ceylon$language$Iterable$impl().max(arg0);
    }

    @Override
    @Ignore
    public <Type> Iterable narrow(TypeDescriptor arg0) {
        return this.$ceylon$language$Iterable$impl().narrow(arg0);
    }

    @Override
    @Ignore
    public Iterable<? extends Sequence<? extends Character>, ? extends java.lang.Object> partition(long arg0) {
        return this.$ceylon$language$Iterable$impl().partition(arg0);
    }

    @Override
    @Ignore
    public <Other, OtherAbsent> Iterable product(TypeDescriptor arg0, TypeDescriptor arg1, Iterable<? extends Other, ? extends OtherAbsent> arg2) {
        return this.$ceylon$language$Iterable$impl().product(arg0, arg1, arg2);
    }

    @Override
    @Ignore
    public <Result> Callable<? extends Iterable<? extends Result, ? extends java.lang.Object>> scan(TypeDescriptor arg0, Result arg1) {
        return this.$ceylon$language$Iterable$impl().scan(arg0, arg1);
    }

    @Override
    @Ignore
    public Sequential<? extends Character> select(Callable<? extends Boolean> arg0) {
        return this.$ceylon$language$Iterable$impl().select(arg0);
    }

    @Override
    @Ignore
    public Sequential<? extends Character> sequence() {
        return this.$ceylon$language$Iterable$impl().sequence();
    }

    @Override
    @Ignore
    public Iterable<? extends Character, ? extends java.lang.Object> skip(long arg0) {
        return this.$ceylon$language$Iterable$impl().skip(arg0);
    }

    @Override
    @Ignore
    public Iterable<? extends Character, ? extends java.lang.Object> skipWhile(Callable<? extends Boolean> arg0) {
        return this.$ceylon$language$Iterable$impl().skipWhile(arg0);
    }

    @Override
    @Ignore
    public Sequential<? extends Character> sort(Callable<? extends Comparison> arg0) {
        return this.$ceylon$language$Iterable$impl().sort(arg0);
    }

    @Override
    @Ignore
    public <Result, Args extends Sequential<? extends java.lang.Object>> Callable<? extends Iterable<? extends Result, ? extends java.lang.Object>> spread(TypeDescriptor arg0, TypeDescriptor arg1, Callable<? extends Callable<? extends Result>> arg2) {
        return this.$ceylon$language$Iterable$impl().spread(arg0, arg1, arg2);
    }

    @Override
    @Ignore
    public Iterable<? extends Character, ? extends java.lang.Object> take(long arg0) {
        return this.$ceylon$language$Iterable$impl().take(arg0);
    }

    @Override
    @Ignore
    public Iterable<? extends Character, ? extends java.lang.Object> takeWhile(Callable<? extends Boolean> arg0) {
        return this.$ceylon$language$Iterable$impl().takeWhile(arg0);
    }

    @Override
    @Ignore
    public Category$impl<? super java.lang.Object> $ceylon$language$Category$impl() {
        return new Category$impl<java.lang.Object>(Object.$TypeDescriptor$, this);
    }

    @Override
    @Ignore
    public boolean containsAny(Iterable<? extends java.lang.Object, ? extends java.lang.Object> arg0) {
        return this.$ceylon$language$Category$impl().containsAny(arg0);
    }

    @Override
    @Ignore
    public boolean containsEvery(Iterable<? extends java.lang.Object, ? extends java.lang.Object> arg0) {
        return this.$ceylon$language$Category$impl().containsEvery(arg0);
    }

    @Override
    @Ignore
    public Correspondence$impl<? super Integer, ? extends Character> $ceylon$language$Correspondence$impl() {
        return new Correspondence$impl<Integer, Character>(Integer.$TypeDescriptor$, Character.$TypeDescriptor$, this);
    }

    @Override
    @Ignore
    public boolean definesAny(Iterable<? extends Integer, ? extends java.lang.Object> arg0) {
        return this.$ceylon$language$Correspondence$impl().definesAny(arg0);
    }

    @Override
    @Ignore
    public boolean definesEvery(Iterable<? extends Integer, ? extends java.lang.Object> arg0) {
        return this.$ceylon$language$Correspondence$impl().definesEvery(arg0);
    }

    @Override
    @Ignore
    public <Absent> Iterable<? extends Character, ? extends Absent> getAll(TypeDescriptor arg0, Iterable<? extends Integer, ? extends Absent> arg1) {
        return this.$ceylon$language$Correspondence$impl().getAll(arg0, arg1);
    }

    @Override
    @Ignore
    public List$impl<? extends Character> $ceylon$language$List$impl() {
        return new List$impl<Character>(Character.$TypeDescriptor$, this);
    }

    @Override
    @Ignore
    public <Result> Sequential<? extends Result> collect(TypeDescriptor arg0, Callable<? extends Result> arg1) {
        return this.$ceylon$language$List$impl().collect(arg0, arg1);
    }

    @Override
    @Ignore
    public Character get(Integer index) {
        return String.getFromFirst(this.value, index.value);
    }

    @Override
    @Ignore
    public <Other> List patch(TypeDescriptor arg0, List<? extends Other> arg1) {
        return this.$ceylon$language$List$impl().patch(arg0, arg1);
    }

    @Override
    @Ignore
    public <Other> List patch(TypeDescriptor arg0, List<? extends Other> arg1, long arg2) {
        return this.$ceylon$language$List$impl().patch(arg0, arg1, arg2);
    }

    @Override
    @Ignore
    public <Other> List patch(TypeDescriptor arg0, List<? extends Other> arg1, long arg2, long arg3) {
        return this.$ceylon$language$List$impl().patch(arg0, arg1, arg2, arg3);
    }

    @Override
    @Ignore
    public <Other> long patch$from(TypeDescriptor arg0, List<? extends Other> arg1) {
        return this.$ceylon$language$List$impl().patch$from(arg0, arg1);
    }

    @Override
    @Ignore
    public <Other> long patch$length(TypeDescriptor arg0, List<? extends Other> arg1, long arg2) {
        return this.$ceylon$language$List$impl().patch$length(arg0, arg1, arg2);
    }

    @Override
    @Ignore
    public List<? extends Character> sublist(long arg0, long arg1) {
        return this.$ceylon$language$List$impl().sublist(arg0, arg1);
    }

    @Override
    @Ignore
    public SearchableList$impl<Character> $ceylon$language$SearchableList$impl() {
        return new SearchableList$impl<Character>(Character.$TypeDescriptor$, this);
    }

    @Override
    @Ignore
    public Integer firstInclusion(List<? extends Character> arg0) {
        return String.firstInclusion(this.value, arg0);
    }

    @Override
    @Ignore
    public long firstInclusion$from(List<? extends Character> arg0) {
        return 0L;
    }

    @Override
    @Ignore
    public Integer firstOccurrence(Character element) {
        return String.firstOccurrence(this.value, element.codePoint);
    }

    @Override
    @Ignore
    public Integer firstOccurrence(Character element, long from) {
        return String.firstOccurrence(this.value, element.codePoint, from);
    }

    @Override
    @Ignore
    public long firstOccurrence$from(Character arg0) {
        return 0L;
    }

    @Override
    @Ignore
    public long firstOccurrence$length(Character arg0, long arg1) {
        return java.lang.Integer.MAX_VALUE;
    }

    @Override
    @Ignore
    public boolean includes(List<? extends Character> arg0) {
        return String.includes(this.value, arg0);
    }

    @Override
    @Ignore
    public long includes$from(List<? extends Character> arg0) {
        return 0L;
    }

    @Override
    @Ignore
    public Iterable<? extends Integer, ? extends java.lang.Object> inclusions(List<? extends Character> arg0) {
        return String.inclusions(this.value, arg0);
    }

    @Override
    @Ignore
    public long inclusions$from(List<? extends Character> arg0) {
        return 0L;
    }

    @Override
    @Ignore
    public Integer lastInclusion(List<? extends Character> arg0) {
        return String.lastInclusion(this.value, arg0);
    }

    @Override
    @Ignore
    public long lastInclusion$from(List<? extends Character> arg0) {
        return 0L;
    }

    @Override
    @Ignore
    public Integer lastOccurrence(Character element) {
        return String.lastOccurrence(this.value, element.codePoint);
    }

    @Override
    @Ignore
    public Integer lastOccurrence(Character element, long from) {
        return String.lastOccurrence(this.value, element.codePoint, from);
    }

    @Override
    @Ignore
    public long lastOccurrence$from(Character arg0) {
        return 0L;
    }

    @Override
    @Ignore
    public long lastOccurrence$length(Character arg0, long arg1) {
        return java.lang.Integer.MAX_VALUE;
    }

    @Override
    @Ignore
    public Iterable<? extends Integer, ? extends java.lang.Object> occurrences(Character element) {
        return String.occurrences(this.value, element.codePoint);
    }

    @Override
    @Ignore
    public Iterable<? extends Integer, ? extends java.lang.Object> occurrences(Character element, long from) {
        return String.occurrences(this.value, element.codePoint, from);
    }

    @Override
    @Ignore
    public long occurrences$from(Character arg0) {
        return 0L;
    }

    @Override
    @Ignore
    public long occurrences$length(Character arg0, long arg1) {
        return java.lang.Integer.MAX_VALUE;
    }

    @Override
    @Ignore
    public boolean occurs(Character element) {
        return String.occurs(this.value, element.codePoint);
    }

    @Override
    @Ignore
    public boolean occurs(Character element, long arg1) {
        return String.occurs(this.value, element.codePoint, arg1);
    }

    @Override
    @Ignore
    public long occurs$from(Character arg0) {
        return 0L;
    }

    @Override
    @Ignore
    public long occurs$length(Character arg0, long arg1) {
        return java.lang.Integer.MAX_VALUE;
    }

    @Override
    @Ignore
    public <Item> Map<? extends Character, ? extends Item> tabulate(TypeDescriptor arg0, Callable<? extends Item> arg1) {
        return this.$ceylon$language$Iterable$impl().tabulate(arg0, arg1);
    }

    @Override
    @Ignore
    public Map<? extends Character, ? extends Integer> frequencies() {
        return this.$ceylon$language$Iterable$impl().frequencies();
    }

    @Ignore
    public static <Item> Map<? extends Character, ? extends Item> tabulate(TypeDescriptor arg0, java.lang.String value, Callable<? extends Item> arg1) {
        return String.instance(value).tabulate(arg0, arg1);
    }

    @Ignore
    public static <Item> Map<? extends Character, ? extends Integer> frequencies(java.lang.String value) {
        return String.instance(value).frequencies();
    }

    @Ignore
    public static <Result> List<? extends Result> mapElements(@Ignore TypeDescriptor $reifiedResult, java.lang.String value, Callable<? extends Result> f) {
        return String.instance(value).mapElements($reifiedResult, f);
    }

    @Override
    @Ignore
    public <Result> List<? extends Result> mapElements(TypeDescriptor arg0, Callable<? extends Result> arg1) {
        return this.$ceylon$language$List$impl().mapElements(arg0, arg1);
    }

    @Ignore
    public final long indexOf(java.lang.String string) {
        return String.indexOf(this.value, string);
    }

    @Ignore
    public final long indexOf$from(java.lang.String string) {
        return 0L;
    }

    @TypeInfo(value="ceylon.language::Integer")
    public final long indexOf(@Name(value="string") @TypeInfo(value="ceylon.language::String") java.lang.String string, @Name(value="from") @Defaulted @TypeInfo(value="ceylon.language::Integer") long from) {
        return String.indexOf(this.value, string, from);
    }

    @Ignore
    public static long indexOf(java.lang.String value, java.lang.String string) {
        return value.indexOf(string);
    }

    @Ignore
    public static long indexOf(java.lang.String value, java.lang.String string, long from) {
        int start;
        if (from > (long)value.length()) {
            return -1L;
        }
        if (from < 0L) {
            from = 0L;
        }
        try {
            start = value.offsetByCodePoints(0, (int)from);
        }
        catch (IndexOutOfBoundsException iobe) {
            return -1L;
        }
        return value.indexOf(string, start);
    }

    @Ignore
    public final long lastIndexOf(java.lang.String string) {
        return String.lastIndexOf(this.value, string);
    }

    @Ignore
    public final long lastIndexOf$from(java.lang.String string) {
        return Long.MAX_VALUE;
    }

    @TypeInfo(value="ceylon.language::Integer")
    public final long lastIndexOf(@Name(value="string") @TypeInfo(value="ceylon.language::String") java.lang.String string, @Name(value="to") @Defaulted @TypeInfo(value="ceylon.language::Integer") long to) {
        return String.lastIndexOf(this.value, string, to);
    }

    @Ignore
    public static long lastIndexOf(java.lang.String value, java.lang.String string) {
        return value.lastIndexOf(string);
    }

    @Ignore
    public static long lastIndexOf(java.lang.String value, java.lang.String string, long to) {
        int start;
        if (to > (long)value.length()) {
            return String.lastIndexOf(value, string);
        }
        if (to < 0L) {
            return -1L;
        }
        try {
            start = value.offsetByCodePoints(0, (int)to);
        }
        catch (IndexOutOfBoundsException iobe) {
            return String.lastIndexOf(value, string);
        }
        return value.lastIndexOf(string, start);
    }

    @Ignore
    private static class StringIterator
    extends BaseIterator<Character>
    implements ReifiedType {
        private static TypeDescriptor $TypeDescriptor$ = TypeDescriptor.klass(StringIterator.class, new TypeDescriptor[0]);
        final java.lang.String value;
        private int offset = 0;

        public StringIterator(java.lang.String value) {
            super(Character.$TypeDescriptor$);
            this.value = value;
        }

        @Override
        public java.lang.Object next() {
            if (this.offset < this.value.length()) {
                int codePoint = this.value.codePointAt(this.offset);
                this.offset += java.lang.Character.charCount(codePoint);
                return Character.instance(codePoint);
            }
            return finished_.get_();
        }

        @Override
        @Ignore
        public TypeDescriptor $getType$() {
            return $TypeDescriptor$;
        }

        public java.lang.String toString() {
            return '\"' + this.value + '\"' + ".iterator()";
        }
    }
}

