/*
 * Decompiled with CFR 0.152.
 */
package ceylon.language;

import ceylon.language.AssertionError;
import ceylon.language.Character;
import ceylon.language.DeprecationAnnotation$annotation$;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.Integer;
import ceylon.language.Iterable;
import ceylon.language.SeeAnnotation$annotation$;
import ceylon.language.SeeAnnotation$annotations$;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.String;
import ceylon.language.TagsAnnotation$annotation$;
import ceylon.language.ThrownExceptionAnnotation$annotation$;
import ceylon.language.ThrownExceptionAnnotation$annotations$;
import ceylon.language.aIntLower_;
import ceylon.language.empty_;
import ceylon.language.maxRadix_;
import ceylon.language.minRadix_;
import ceylon.language.zeroInt_;
import com.redhat.ceylon.common.NonNull;
import com.redhat.ceylon.common.Nullable;
import com.redhat.ceylon.compiler.java.Util;
import com.redhat.ceylon.compiler.java.metadata.Annotation;
import com.redhat.ceylon.compiler.java.metadata.Annotations;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Defaulted;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Method;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;

@Ceylon(major=8, minor=1)
@Method
public final class formatInteger_ {
    private formatInteger_() {
    }

    @Ignore
    @Deprecated
    public static java.lang.String formatInteger(long integer) {
        long $ceylontmp$radix$23 = formatInteger_.formatInteger$radix(integer);
        Character $ceylontmp$groupingSeparator$24 = formatInteger_.formatInteger$groupingSeparator(integer, $ceylontmp$radix$23);
        return formatInteger_.formatInteger(integer, $ceylontmp$radix$23, $ceylontmp$groupingSeparator$24);
    }

    @Ignore
    public static final long formatInteger$radix(long integer) {
        return 10L;
    }

    @Ignore
    @Deprecated
    public static java.lang.String formatInteger(long integer, long radix) {
        Character $ceylontmp$groupingSeparator$25 = formatInteger_.formatInteger$groupingSeparator(integer, radix);
        return formatInteger_.formatInteger(integer, radix, $ceylontmp$groupingSeparator$25);
    }

    @Ignore
    public static final Character formatInteger$groupingSeparator(long integer, long radix) {
        return null;
    }

    @DocAnnotation$annotation$(description="The string representation of the given [[integer]] in the \nbase given by [[radix]]. If the given integer is \n[[negative|Integer.negative]], the string representation \nwill begin with `-`. Digits consist of decimal digits `0` \nto `9`, together with and lowercase letters `a` to `z` for \nbases greater than 10.\n\nFor example:\n\n- `formatInteger(-46)` is `\"-46\"`\n- `formatInteger(9,2)` is `\"1001\"`\n- `formatInteger(10,8)` is `\"12\"`\n- `formatInteger(511,16)` is `\"1ff\"`\n- `formatInteger(512,32)` is `\"g0\"`")
    @ThrownExceptionAnnotation$annotations$(value={@ThrownExceptionAnnotation$annotation$(type="::1.3.2:ceylon.language::CAssertionError", when="if [[radix]] is not between [[minRadix]] and \n[[maxRadix]]")})
    @SeeAnnotation$annotations$(value={@SeeAnnotation$annotation$(programElements={"::1.3.2:ceylon.language::CInteger.Fformat"})})
    @TagsAnnotation$annotation$(tags={"Numbers"})
    @DeprecationAnnotation$annotation$(description="Use [[Integer.format]]")
    @SharedAnnotation$annotation$
    @Annotations(modifiers=2L, value={@Annotation(value="doc", arguments={"The string representation of the given [[integer]] in the \nbase given by [[radix]]. If the given integer is \n[[negative|Integer.negative]], the string representation \nwill begin with `-`. Digits consist of decimal digits `0` \nto `9`, together with and lowercase letters `a` to `z` for \nbases greater than 10.\n\nFor example:\n\n- `formatInteger(-46)` is `\"-46\"`\n- `formatInteger(9,2)` is `\"1001\"`\n- `formatInteger(10,8)` is `\"12\"`\n- `formatInteger(511,16)` is `\"1ff\"`\n- `formatInteger(512,32)` is `\"g0\"`"}), @Annotation(value="throws", arguments={"AssertionError", "if [[radix]] is not between [[minRadix]] and \n[[maxRadix]]"}), @Annotation(value="see", arguments={"Integer.format"}), @Annotation(value="tagged", arguments={"Numbers"}), @Annotation(value="deprecated", arguments={"Use [[Integer.format]]"})})
    @Deprecated
    @NonNull
    public static java.lang.String formatInteger(@Name(value="integer") @DocAnnotation$annotation$(description="The integer value to format.") @Annotations(value={@Annotation(value="doc", arguments={"The integer value to format."})}) long integer, @Name(value="radix") @Defaulted @DocAnnotation$annotation$(description="The base, between [[minRadix]] and [[maxRadix]] \ninclusive.") @Annotations(value={@Annotation(value="doc", arguments={"The base, between [[minRadix]] and [[maxRadix]] \ninclusive."})}) long radix, @Name(value="groupingSeparator") @Defaulted @TypeInfo(value="ceylon.language::Character?") @DocAnnotation$annotation$(description="If not `null`, `groupingSeparator` will be used to\nseparate each group of three digits if `radix` is 10,\nor each group of four digits if `radix` is 2 or 16.\n\n`groupingSeparator` may not be '-', a digit as\ndefined by the Unicode general category *Nd*, or a\nletter as defined by the Unicode general categories\n*Lu, Ll, Lt, Lm, and Lo*.") @Annotations(value={@Annotation(value="doc", arguments={"If not `null`, `groupingSeparator` will be used to\nseparate each group of three digits if `radix` is 10,\nor each group of four digits if `radix` is 2 or 16.\n\n`groupingSeparator` may not be '-', a digit as\ndefined by the Unicode general category *Nd*, or a\nletter as defined by the Unicode general categories\n*Lu, Ll, Lt, Lm, and Lo*."})}) @Nullable Character groupingSeparator) {
        long i;
        int groupingSeparator$16;
        long $ceylontmp$ifResult$7;
        int groupingSeparator$5;
        long lhs$0 = minRadix_.get_();
        long middle$1 = radix;
        long rhs$2 = maxRadix_.get_();
        if (lhs$0 > middle$1 || middle$1 > rhs$2) {
            throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "minRadix <= radix <= maxRadix" + Util.assertWithinOpFailed(Integer.instance(lhs$0), Integer.instance(middle$1), Integer.instance(rhs$2)));
        }
        Character groupingSeparator$4 = groupingSeparator;
        if (groupingSeparator$4 != null && (Character.getDigit(groupingSeparator$5 = groupingSeparator$4.intValue()) || Character.getLetter(groupingSeparator$5) || groupingSeparator$5 == 45)) {
            throw new AssertionError("Assertion failed: groupingSeparator may not be '-', a digit, or a letter." + System.lineSeparator() + "\tviolated " + "!groupingSeparator.digit\n                && !groupingSeparator.letter\n                && !groupingSeparator == '-'");
        }
        if (integer == 0L) {
            return "0";
        }
        if (groupingSeparator == null) {
            $ceylontmp$ifResult$7 = 0L;
        } else {
            long $ceylontmp$ifResult$9;
            if (radix == 10L) {
                $ceylontmp$ifResult$9 = 3L;
            } else {
                long $ceylontmp$ifResult$11 = radix == 2L || radix == 16L ? 4L : 0L;
                $ceylontmp$ifResult$9 = $ceylontmp$ifResult$11;
            }
            $ceylontmp$ifResult$7 = $ceylontmp$ifResult$9;
        }
        long groupingSize = $ceylontmp$ifResult$7;
        boolean $ceylontmp$if$14 = false;
        Character groupingSeparator$15 = groupingSeparator;
        if (groupingSeparator$15 != null) {
            groupingSeparator$16 = groupingSeparator$15.intValue();
            if (groupingSize != 0L) {
                $ceylontmp$if$14 = true;
            }
        } else {
            groupingSeparator$16 = 0;
        }
        int $ceylontmp$ifResult$13 = $ceylontmp$if$14 ? groupingSeparator$16 : 88;
        int groupingChar = $ceylontmp$ifResult$13;
        long digitNumber = 0L;
        Iterable<Object, Object> digits = empty_.get_();
        long l = i = integer < 0L ? integer : -integer;
        while (i != 0L) {
            int c;
            long d = -(i % radix);
            long middle$18 = d;
            if (0L <= middle$18 && middle$18 < 10L) {
                c = Integer.getCharacter(d + zeroInt_.get_());
            } else {
                long middle$20 = d;
                if (10L <= middle$20 && middle$20 < 36L) {
                    c = Integer.getCharacter(d - 10L + aIntLower_.get_());
                } else {
                    throw new AssertionError("Assertion failed" + System.lineSeparator() + "\tviolated " + "false");
                }
            }
            if (groupingSize != 0L && Integer.divides(groupingSize, digitNumber++) && digitNumber != 1L) {
                digits = digits.follow(Character.$TypeDescriptor$, Character.instance(groupingChar));
            }
            digits = digits.follow(Character.$TypeDescriptor$, Character.instance(c));
            i = (i + d) / radix;
        }
        if (integer < 0L) {
            digits = digits.follow(Character.$TypeDescriptor$, Character.instance(45));
        }
        return new String(digits).toString();
    }
}

