/*
 * Decompiled with CFR 0.152.
 */
package ceylon.language.meta.declaration;

import ceylon.language.ActualAnnotation$annotation$;
import ceylon.language.DefaultAnnotation$annotation$;
import ceylon.language.DocAnnotation$annotation$;
import ceylon.language.FormalAnnotation$annotation$;
import ceylon.language.SealedAnnotation$annotation$;
import ceylon.language.SharedAnnotation$annotation$;
import ceylon.language.SinceAnnotation$annotation$;
import ceylon.language.ThrownExceptionAnnotation$annotation$;
import ceylon.language.ThrownExceptionAnnotation$annotations$;
import ceylon.language.meta.declaration.ClassDeclaration;
import ceylon.language.meta.declaration.FunctionOrValueDeclaration;
import ceylon.language.meta.declaration.GettableDeclaration;
import ceylon.language.meta.declaration.SetterDeclaration;
import ceylon.language.meta.declaration.ValueDeclaration$impl;
import ceylon.language.meta.model.Attribute;
import ceylon.language.meta.model.Type;
import ceylon.language.meta.model.Value;
import com.redhat.ceylon.common.NonNull;
import com.redhat.ceylon.common.Nullable;
import com.redhat.ceylon.compiler.java.metadata.Annotation;
import com.redhat.ceylon.compiler.java.metadata.Annotations;
import com.redhat.ceylon.compiler.java.metadata.Ceylon;
import com.redhat.ceylon.compiler.java.metadata.Ignore;
import com.redhat.ceylon.compiler.java.metadata.Name;
import com.redhat.ceylon.compiler.java.metadata.SatisfiedTypes;
import com.redhat.ceylon.compiler.java.metadata.TypeInfo;
import com.redhat.ceylon.compiler.java.metadata.TypeParameter;
import com.redhat.ceylon.compiler.java.metadata.TypeParameters;
import com.redhat.ceylon.compiler.java.metadata.Variance;
import com.redhat.ceylon.compiler.java.runtime.model.TypeDescriptor;

@Ceylon(major=8, minor=1)
@DocAnnotation$annotation$(description="A value declaration.\n\n<a name=\"toplevel-sample\"></a>\n### Usage sample for toplevel value\n\nGetting a model requires applying type arguments to the\nvalue declaration with [[apply]] in order to be able to read that value. For example, here is how you would\nobtain a value model that you can read from a toplevel attribute declaration:\n\n    String foo = \"Hello\";\n    \n    void test(){\n        // We need to apply the the foo declaration in order to get the foo value model\n        Value<String> valueModel = `value foo`.apply<String>();\n        // This will print: Hello\n        print(valueModel.get());\n    }\n\n<a name=\"member-sample\"></a>\n### Usage sample for attributes\n\nFor attributes it is a bit longer, because attributes need to be applied the containing type, so you should \nuse [[memberApply]] and start by giving the containing closed type:\n\n    class Outer(){\n        shared String foo => \"Hello\";\n    }\n\n    void test(){\n        // Apply the containing closed type `Outer` to the attribute declaration `Outer.foo`\n        Attribute<Outer,String> valueModel = `value Outer.foo`.memberApply<Outer,String>(`Outer`);\n        // We now have an Attribute, which needs to be applied to a containing instance in order to become a\n        // readable value:\n        Value<String> boundValueModel = valueModel(Outer());\n        // This will print: Hello\n        print(boundValueModel.get());\n    }\n")
@SharedAnnotation$annotation$
@SealedAnnotation$annotation$
@Annotations(modifiers=18L, value={@Annotation(value="doc", arguments={"A value declaration.\n\n<a name=\"toplevel-sample\"></a>\n### Usage sample for toplevel value\n\nGetting a model requires applying type arguments to the\nvalue declaration with [[apply]] in order to be able to read that value. For example, here is how you would\nobtain a value model that you can read from a toplevel attribute declaration:\n\n    String foo = \"Hello\";\n    \n    void test(){\n        // We need to apply the the foo declaration in order to get the foo value model\n        Value<String> valueModel = `value foo`.apply<String>();\n        // This will print: Hello\n        print(valueModel.get());\n    }\n\n<a name=\"member-sample\"></a>\n### Usage sample for attributes\n\nFor attributes it is a bit longer, because attributes need to be applied the containing type, so you should \nuse [[memberApply]] and start by giving the containing closed type:\n\n    class Outer(){\n        shared String foo => \"Hello\";\n    }\n\n    void test(){\n        // Apply the containing closed type `Outer` to the attribute declaration `Outer.foo`\n        Attribute<Outer,String> valueModel = `value Outer.foo`.memberApply<Outer,String>(`Outer`);\n        // We now have an Attribute, which needs to be applied to a containing instance in order to become a\n        // readable value:\n        Value<String> boundValueModel = valueModel(Outer());\n        // This will print: Hello\n        print(boundValueModel.get());\n    }\n"})})
@SatisfiedTypes(value={"ceylon.language.meta.declaration::FunctionOrValueDeclaration", "ceylon.language.meta.declaration::GettableDeclaration"})
public interface ValueDeclaration
extends FunctionOrValueDeclaration,
GettableDeclaration {
    @Ignore
    public static final TypeDescriptor $TypeDescriptor$ = TypeDescriptor.klass(ValueDeclaration.class, new TypeDescriptor[0]);

    @Ignore
    public ValueDeclaration$impl $ceylon$language$meta$declaration$ValueDeclaration$impl();

    @DocAnnotation$annotation$(description="True if this declaration is annotated with [[late|ceylon.language::late]].")
    @SinceAnnotation$annotation$(version="1.2.0")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"True if this declaration is annotated with [[late|ceylon.language::late]]."})})
    public boolean getLate();

    @DocAnnotation$annotation$(description="True if this declaration is annotated with [[variable|ceylon.language::variable]].")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"True if this declaration is annotated with [[variable|ceylon.language::variable]]."})})
    public boolean getVariable();

    @DocAnnotation$annotation$(description="True if this declaration is an `object` declaration, whose type is an anonymous class.")
    @SinceAnnotation$annotation$(version="1.1.0")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"True if this declaration is an `object` declaration, whose type is an anonymous class."})})
    public boolean getObjectValue();

    @DocAnnotation$annotation$(description="This value's anonymous class declaration if this value is an object declaration. `null` otherwise.")
    @SinceAnnotation$annotation$(version="1.1.0")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"This value's anonymous class declaration if this value is an object declaration. `null` otherwise."})})
    @TypeInfo(value="ceylon.language.meta.declaration::ClassDeclaration?")
    @Nullable
    public ClassDeclaration getObjectClass();

    @DocAnnotation$annotation$(description="Applies this value declaration in order to obtain a value model. \nSee [this code sample](#toplevel-sample) for an example on how to use this.")
    @ThrownExceptionAnnotation$annotations$(value={@ThrownExceptionAnnotation$annotation$(type="::1.3.2:ceylon.language:meta.model:CIncompatibleTypeException", when="If the specified `Get` or `Set` type arguments are not compatible with the actual result.")})
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"Applies this value declaration in order to obtain a value model. \nSee [this code sample](#toplevel-sample) for an example on how to use this."}), @Annotation(value="throws", arguments={"IncompatibleTypeException", "If the specified `Get` or `Set` type arguments are not compatible with the actual result."})})
    @TypeInfo(value="ceylon.language.meta.model::Value<Get,Set>")
    @TypeParameters(value={@TypeParameter(value="Get", variance=Variance.NONE, satisfies={}, caseTypes={}, defaultValue="ceylon.language::Anything"), @TypeParameter(value="Set", variance=Variance.NONE, satisfies={}, caseTypes={}, defaultValue="ceylon.language::Nothing")})
    @NonNull
    public <Get, Set> Value<? extends Get, ? super Set> apply(@Ignore TypeDescriptor var1, @Ignore TypeDescriptor var2);

    @DocAnnotation$annotation$(description="Applies this `static` value declaration in order to obtain a value model.")
    @ThrownExceptionAnnotation$annotations$(value={@ThrownExceptionAnnotation$annotation$(type="::1.3.2:ceylon.language:meta.model:CIncompatibleTypeException", when="If the specified `Get` or `Set` type arguments are not compatible with the actual result.")})
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"Applies this `static` value declaration in order to obtain a value model."}), @Annotation(value="throws", arguments={"IncompatibleTypeException", "If the specified `Get` or `Set` type arguments are not compatible with the actual result."})})
    @TypeInfo(value="ceylon.language.meta.model::Value<Get,Set>")
    @TypeParameters(value={@TypeParameter(value="Get", variance=Variance.NONE, satisfies={}, caseTypes={}, defaultValue="ceylon.language::Anything"), @TypeParameter(value="Set", variance=Variance.NONE, satisfies={}, caseTypes={}, defaultValue="ceylon.language::Nothing")})
    @NonNull
    public <Get, Set> Value<? extends Get, ? super Set> staticApply(@Ignore TypeDescriptor var1, @Ignore TypeDescriptor var2, @Name(value="containerType") @TypeInfo(value="ceylon.language.meta.model::Type<ceylon.language::Object>") @NonNull Type<? extends Object> var3);

    @DocAnnotation$annotation$(description="Applies the given closed container type to this attribute declaration in order to obtain an attribute model. \nSee [this code sample](#member-sample) for an example on how to use this.")
    @ThrownExceptionAnnotation$annotations$(value={@ThrownExceptionAnnotation$annotation$(type="::1.3.2:ceylon.language:meta.model:CIncompatibleTypeException", when="If the specified `Container`, `Get` or `Set` type arguments are not compatible with the actual result.")})
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"Applies the given closed container type to this attribute declaration in order to obtain an attribute model. \nSee [this code sample](#member-sample) for an example on how to use this."}), @Annotation(value="throws", arguments={"IncompatibleTypeException", "If the specified `Container`, `Get` or `Set` type arguments are not compatible with the actual result."})})
    @TypeInfo(value="ceylon.language.meta.model::Attribute<Container,Get,Set>")
    @TypeParameters(value={@TypeParameter(value="Container", variance=Variance.NONE, satisfies={}, caseTypes={}, defaultValue="ceylon.language::Nothing"), @TypeParameter(value="Get", variance=Variance.NONE, satisfies={}, caseTypes={}, defaultValue="ceylon.language::Anything"), @TypeParameter(value="Set", variance=Variance.NONE, satisfies={}, caseTypes={}, defaultValue="ceylon.language::Nothing")})
    @NonNull
    public <Container, Get, Set> Attribute<? super Container, ? extends Get, ? super Set> memberApply(@Ignore TypeDescriptor var1, @Ignore TypeDescriptor var2, @Ignore TypeDescriptor var3, @Name(value="containerType") @TypeInfo(value="ceylon.language.meta.model::Type<ceylon.language::Object>") @NonNull Type<? extends Object> var4);

    @Override
    @DocAnnotation$annotation$(description="Reads the current value of this toplevel value.")
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L, value={@Annotation(value="doc", arguments={"Reads the current value of this toplevel value."})})
    @TypeInfo(value="ceylon.language::Anything")
    @Nullable
    public Object get();

    @Override
    @DocAnnotation$annotation$(description="Reads the current value of this attribute on the given container instance.")
    @ThrownExceptionAnnotation$annotations$(value={@ThrownExceptionAnnotation$annotation$(type="::1.3.2:ceylon.language:meta.model:CIncompatibleTypeException", when="If the specified container is not compatible with this attribute."), @ThrownExceptionAnnotation$annotation$(type="::1.3.2:ceylon.language:meta.model:CStorageException", when="If this attribute is not stored at runtime, for example if it is neither shared nor captured.")})
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L, value={@Annotation(value="doc", arguments={"Reads the current value of this attribute on the given container instance."}), @Annotation(value="throws", arguments={"IncompatibleTypeException", "If the specified container is not compatible with this attribute."}), @Annotation(value="throws", arguments={"StorageException", "If this attribute is not stored at runtime, for example if it is neither shared nor captured."})})
    @TypeInfo(value="ceylon.language::Anything")
    @Nullable
    public Object memberGet(@Name(value="container") @TypeInfo(value="ceylon.language::Object") @NonNull Object var1);

    @Override
    @DocAnnotation$annotation$(description="Reads the current value of this `static` attribute.")
    @ThrownExceptionAnnotation$annotations$(value={@ThrownExceptionAnnotation$annotation$(type="::1.3.2:ceylon.language:meta.model:CIncompatibleTypeException", when="If the specified `Get` or `Set` type arguments are not compatible with the actual result.")})
    @SharedAnnotation$annotation$
    @ActualAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=322L, value={@Annotation(value="doc", arguments={"Reads the current value of this `static` attribute."}), @Annotation(value="throws", arguments={"IncompatibleTypeException", "If the specified `Get` or `Set` type arguments are not compatible with the actual result."})})
    @TypeInfo(value="ceylon.language::Anything")
    @Nullable
    public Object staticGet(@Name(value="containerType") @TypeInfo(value="ceylon.language.meta.model::Type<ceylon.language::Object>") @NonNull Type<? extends Object> var1);

    @DocAnnotation$annotation$(description="Sets the current value of this toplevel value.")
    @SharedAnnotation$annotation$
    @DefaultAnnotation$annotation$
    @Annotations(modifiers=258L, value={@Annotation(value="doc", arguments={"Sets the current value of this toplevel value."})})
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public Object set(@Name(value="newValue") @TypeInfo(value="ceylon.language::Anything") @Nullable Object var1);

    @DocAnnotation$annotation$(description="Sets the current value of this attribute on the given container instance.")
    @ThrownExceptionAnnotation$annotations$(value={@ThrownExceptionAnnotation$annotation$(type="::1.3.2:ceylon.language:meta.model:CIncompatibleTypeException", when="If the specified container or new value type is not compatible with this attribute."), @ThrownExceptionAnnotation$annotation$(type="::1.3.2:ceylon.language:meta.model:CStorageException", when="If this attribute is not stored at runtime, for example if it is neither shared nor captured.")})
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"Sets the current value of this attribute on the given container instance."}), @Annotation(value="throws", arguments={"IncompatibleTypeException", "If the specified container or new value type is not compatible with this attribute."}), @Annotation(value="throws", arguments={"StorageException", "If this attribute is not stored at runtime, for example if it is neither shared nor captured."})})
    @TypeInfo(value="ceylon.language::Anything", declaredVoid=true)
    @Nullable
    public Object memberSet(@Name(value="container") @TypeInfo(value="ceylon.language::Object") @NonNull Object var1, @Name(value="newValue") @TypeInfo(value="ceylon.language::Anything") @Nullable Object var2);

    @DocAnnotation$annotation$(description="Returns the setter declaration for this variable if there is one, `null` otherwise.")
    @SharedAnnotation$annotation$
    @FormalAnnotation$annotation$
    @Annotations(modifiers=130L, value={@Annotation(value="doc", arguments={"Returns the setter declaration for this variable if there is one, `null` otherwise."})})
    @TypeInfo(value="ceylon.language.meta.declaration::SetterDeclaration?")
    @Nullable
    public SetterDeclaration getSetter();
}

