/*
 * Decompiled with CFR 0.152.
 */
package ceylon.modules.bootstrap.loader;

import ceylon.modules.bootstrap.loader.BootstrapModuleLoader;
import ceylon.modules.bootstrap.loader.SecurityActions;
import com.redhat.ceylon.common.FileUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jboss.modules.LocalModuleLoader;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;

public class DistributionModuleLoader
extends BootstrapModuleLoader {
    private static final String BOOTSTRAP_DISTRIBUTION = "ceylon-runtime-bootstrap";
    private final ModuleLoader delegate;

    public DistributionModuleLoader() {
        String ceylonRepository = DistributionModuleLoader.getCeylonRepository();
        File dir = new File(ceylonRepository, BOOTSTRAP_DISTRIBUTION);
        File zip = new File(dir, "ceylon-runtime-bootstrap.zip");
        if (!zip.exists()) {
            throw new IllegalArgumentException("No such Ceylon Runtime Bootstrap distribution file: " + zip);
        }
        File unzipped = this.unzipDistribution(dir, zip);
        this.delegate = new LocalModuleLoader(new File[]{unzipped});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File unzipDistribution(File dir, File zip) {
        File exploded = new File(dir, "ceylon-runtime-bootstrap-exploded");
        if (exploded.exists()) {
            if (!this.forceBootstrapUpdate()) {
                return exploded;
            }
            DistributionModuleLoader.delete(exploded);
        }
        try (ZipFile zipFile = new ZipFile(zip);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry ze = entries.nextElement();
                File file = new File(exploded, ze.getName());
                if (ze.isDirectory()) {
                    if (FileUtil.mkdirs(file)) continue;
                    throw new IllegalArgumentException("Cannot create dir: " + file);
                }
                FileOutputStream fos = new FileOutputStream(file);
                DistributionModuleLoader.copyStream(zipFile.getInputStream(ze), fos);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return exploded;
    }

    protected boolean forceBootstrapUpdate() {
        return SecurityActions.getBoolean("force.bootstrap.update");
    }

    protected static void delete(File file) {
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                DistributionModuleLoader.delete(f);
            }
        }
        file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void copyStream(InputStream in, OutputStream out) throws IOException {
        byte[] bytes = new byte[8192];
        try {
            int cnt;
            while ((cnt = in.read(bytes)) != -1) {
                out.write(bytes, 0, cnt);
            }
        }
        finally {
            DistributionModuleLoader.safeClose(in);
            DistributionModuleLoader.safeClose(out);
        }
    }

    protected static void safeClose(Closeable c) {
        try {
            c.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected Module preloadModule(ModuleIdentifier identifier) throws ModuleLoadException {
        return this.delegate.loadModule(identifier);
    }

    @Override
    protected ModuleSpec findModule(ModuleIdentifier moduleIdentifier) throws ModuleLoadException {
        throw new ModuleLoadException("Should not be here, by-passing delegate loader?");
    }

    @Override
    public String toString() {
        return "Ceylon Bootstrap Module Loader: " + this.delegate;
    }
}

