/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.ceylondoc;

import com.redhat.ceylon.ceylondoc.CeylonDoc;
import com.redhat.ceylon.ceylondoc.CeylonDocTool;
import com.redhat.ceylon.ceylondoc.Util;
import com.redhat.ceylon.compiler.java.codegen.Decl;
import com.redhat.ceylon.compiler.typechecker.context.PhasedUnit;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.TreeUtil;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.model.typechecker.model.Annotation;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Constructor;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.Functional;
import com.redhat.ceylon.model.typechecker.model.Generic;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.ParameterList;
import com.redhat.ceylon.model.typechecker.model.Referenceable;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Setter;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeAlias;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.Unit;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.runtime.CommonToken;

public abstract class ClassOrPackageDoc
extends CeylonDoc {
    private static final Set<String> simpleDefaultValues = new HashSet<String>();

    public ClassOrPackageDoc(Module module, CeylonDocTool tool, Writer writer) {
        super(module, tool, writer);
    }

    protected final void doc(String name, TypeAlias alias) throws IOException {
        boolean isAlias = Util.nullSafeCompare(name, alias.getName()) != 0;
        this.open("tr");
        this.open("td id='" + name + "' nowrap");
        this.writeIcon(alias);
        this.around("code class='decl-label'", name);
        this.close("td");
        this.open("td");
        this.writeLinkOneSelf(name);
        if (isAlias) {
            this.writeTagged(alias);
            this.writeAlias(alias);
        } else {
            this.writeLinkSource(alias);
            this.writeTagged(alias);
            this.open("code class='signature'");
            this.around("span class='modifiers'", Util.getModifiers(alias));
            this.write(" ");
            this.open("span class='type-identifier'");
            this.write(alias.getName());
            this.close("span");
            if (!alias.getTypeParameters().isEmpty()) {
                this.writeTypeParameters(alias.getTypeParameters(), alias);
                this.writeTypeParametersConstraints(alias.getTypeParameters(), alias);
                this.open("div class='type-alias-specifier'");
            }
            this.around("span class='specifier'", "=> ");
            this.linkRenderer().to(alias.getExtendedType()).useScope(alias).write();
            if (!alias.getTypeParameters().isEmpty()) {
                this.close("div");
            }
            this.close("code");
            this.writeDescription(alias);
        }
        this.close("td");
        this.close("tr");
    }

    protected final void doc(String name, ClassOrInterface d) throws IOException {
        boolean alias = Util.nullSafeCompare(name, d.getName()) != 0;
        this.open("tr");
        this.open("td id='" + name + "' nowrap");
        this.writeIcon(d);
        this.open("a class='decl-label' href='" + this.linkRenderer().to(d).useScope(d).getUrl() + "'");
        this.around("code", name);
        this.close("a");
        this.close("td");
        this.open("td");
        this.writeLinkOneSelf(name);
        if (alias) {
            this.writeTagged(d);
            this.writeAlias(d);
        } else {
            this.writeLinkSourceCode(d);
            this.writeTagged(d);
            this.open("code class='signature'");
            this.around("span class='modifiers'", Util.getModifiers(d));
            this.write(" ");
            if (d.isDynamic()) {
                this.around("span class='dynamic'", "dynamic");
                this.write(" ");
            }
            this.linkRenderer().to(d.getType()).useScope(d).printAbbreviated(!Util.isAbbreviatedType(d)).printTypeParameterDetail(true).write();
            this.writeTypeParametersConstraints(d.getTypeParameters(), d);
            this.close("code");
            this.writeDescription(d);
        }
        this.close("td");
        this.close("tr");
    }

    private void writeAlias(Declaration decl) throws IOException {
        this.write("See ");
        this.open("code class='signature'");
        String cssClass = decl instanceof TypeDeclaration ? "type-identifier" : "identifier";
        this.open("span class='" + cssClass + "'");
        this.linkRenderer().to(decl).useScope(decl).write();
        this.close("span");
        this.close("code");
    }

    protected final void doc(String name, Declaration d) throws IOException {
        this.doc(null, name, d);
    }

    protected final void doc(String id, String name, Declaration d) throws IOException {
        String declarationName = Util.getDeclarationName(d);
        id = id != null ? id : name;
        boolean alias = Util.nullSafeCompare(name, declarationName) != 0;
        this.open("tr");
        this.open("td id='" + id + "' nowrap");
        this.writeIcon(d);
        if (!(d instanceof Constructor)) {
            this.around("code class='decl-label'", name);
            this.close("td");
            this.open("td");
        }
        this.writeLinkOneSelf(id);
        if (alias) {
            this.writeTagged(d);
            this.writeAlias(d);
        } else {
            Setter setter;
            Generic f;
            this.writeLinkSource(d);
            this.writeTagged(d);
            if (d instanceof Functional) {
                this.writeParameterLinksIfRequired((Functional)((Object)d));
            }
            this.open("code class='signature'");
            this.around("span class='modifiers'", Util.getModifiers(d));
            this.write(" ");
            if (!ModelUtil.isConstructor(d)) {
                if (!Decl.isDynamic(d)) {
                    if (d instanceof Functional && ((Functional)((Object)d)).isDeclaredVoid()) {
                        this.around("span class='void'", "void");
                    } else if (d instanceof TypedDeclaration) {
                        this.linkRenderer().to(((TypedDeclaration)d).getType()).useScope(d).write();
                    } else {
                        this.linkRenderer().to(d).useScope(d).write();
                    }
                } else {
                    this.around("span class='dynamic'", "dynamic");
                }
            }
            this.write(" ");
            this.open("span class='identifier'");
            this.write(name);
            this.close("span");
            if (this.isConstantValue(d)) {
                this.writeConstantValue((Value)d);
            }
            if (d instanceof Generic) {
                f = (Generic)((Object)d);
                this.writeTypeParameters(f.getTypeParameters(), d);
            }
            if (d instanceof Functional) {
                this.writeParameterList((Functional)((Object)d), d);
            }
            if (d instanceof Generic) {
                f = (Generic)((Object)d);
                this.writeTypeParametersConstraints(f.getTypeParameters(), d);
            }
            if (d instanceof Value && (setter = ((Value)d).getSetter()) != null && Util.getAnnotation(setter.getUnit(), setter.getAnnotations(), "doc") != null) {
                this.tool.warningSetterDoc(d.getQualifiedNameString(), d);
            }
            this.close("code");
            this.writeDescription(d);
        }
        this.close("td");
        this.close("tr");
    }

    private boolean isConstantValue(Declaration d) {
        Value value;
        if (Decl.isValue(d) && (value = (Value)d).isShared() && !value.isVariable() && !value.isDynamicallyTyped()) {
            Unit unit = value.getUnit();
            Type type = value.getType();
            if (type.isSequential()) {
                type = unit.getSequentialElementType(type);
            }
            if (type.isString() || type.isInteger() || type.isFloat() || type.isCharacter()) {
                return true;
            }
        }
        return false;
    }

    private void writeConstantValue(Value v) throws IOException {
        Node node = this.tool.getNode(v);
        PhasedUnit pu = this.tool.getUnit(v);
        if (pu == null || !(node instanceof Tree.AttributeDeclaration)) {
            return;
        }
        Tree.AttributeDeclaration attribute = (Tree.AttributeDeclaration)node;
        Tree.SpecifierOrInitializerExpression specifierExpression = attribute.getSpecifierOrInitializerExpression();
        if (specifierExpression == null) {
            return;
        }
        String value = this.getSourceCode(pu, specifierExpression);
        int newLineIndex = value.indexOf("\n");
        String valueFirstLine = newLineIndex != -1 ? value.substring(0, newLineIndex) : value;
        this.around("span class='specifier'", valueFirstLine);
        if (newLineIndex != -1) {
            this.around("a class='specifier-ellipsis' href='#' title='Click for expand the rest of value.'", "...");
            this.open("div class='specifier-rest'");
            this.write(value.substring(newLineIndex + 1));
            this.close("div");
        }
    }

    private void writeDescription(Declaration d) throws IOException {
        this.open("div class='description'");
        this.writeDeprecated(d);
        String doc = Util.getDoc(d, this.linkRenderer());
        if (Util.isEmpty(doc)) {
            this.tool.warningMissingDoc(d.getQualifiedNameString(), d);
        }
        this.around("div class='doc section'", doc);
        if (d instanceof FunctionOrValue) {
            this.writeAnnotations(d);
            this.writeParameters(d);
            this.writeThrows(d);
            this.writeBy(d);
            this.writeSee(d);
            this.writeSince(d);
            this.writeLinkToRefinedDeclaration((FunctionOrValue)d);
        }
        if (d instanceof TypeAlias) {
            this.writeAnnotations(d);
            this.writeBy(d);
            this.writeSee(d);
            this.writeSince(d);
        }
        this.writeAliases(d);
        this.close("div");
    }

    private void writeLinkOneSelf(String id) throws IOException {
        String url = this.linkRenderer().to(this.getFromObject()).useAnchor(id).getUrl();
        if (url != null) {
            this.open("a class='link-one-self' title='Link to this declaration' href='" + url + "'");
            this.write("<i class='icon-link'></i>");
            this.close("a");
        }
    }

    private void writeLinkSource(Declaration d) throws IOException {
        if (!this.tool.isIncludeSourceCode()) {
            return;
        }
        String srcUrl = d.isToplevel() ? this.linkRenderer().getSrcUrl(d) : this.linkRenderer().getSrcUrl(d.getContainer());
        int[] lines = this.tool.getDeclarationSrcLocation(d);
        if (lines != null) {
            this.open("a class='link-source-code' title='Link to source code' href='" + srcUrl + "#" + lines[0] + "," + lines[1] + "'");
            this.write("<i class='icon-source-code'></i>");
            this.write("Source Code");
            this.close("a");
        }
    }

    private void writeLinkToRefinedDeclaration(FunctionOrValue d) throws IOException {
        Declaration topMostRefinedDecl = d.getRefinedDeclaration();
        if (topMostRefinedDecl != null && topMostRefinedDecl != d) {
            Declaration bottomMostRefinedDecl = Util.findBottomMostRefinedDeclaration(d);
            this.open("div class='refined section'");
            this.around("span class='title'", "Refines ");
            if (bottomMostRefinedDecl != null && bottomMostRefinedDecl != topMostRefinedDecl) {
                this.linkRenderer().to(bottomMostRefinedDecl).withinText(true).useCustomText(Util.getNameWithContainer(bottomMostRefinedDecl)).write();
                this.around("span class='title'", " ultimately refines ");
                this.linkRenderer().to(topMostRefinedDecl).withinText(true).useCustomText(Util.getNameWithContainer(topMostRefinedDecl)).write();
            } else {
                this.linkRenderer().to(topMostRefinedDecl).withinText(true).useCustomText(Util.getNameWithContainer(topMostRefinedDecl)).write();
            }
            this.close("div");
        }
    }

    protected final void writeTypeParameters(List<TypeParameter> typeParameters, Referenceable scope) throws IOException {
        if (typeParameters != null && !typeParameters.isEmpty()) {
            this.write("&lt;");
            this.write("<span class='type-parameter'>");
            boolean first = true;
            for (TypeParameter typeParam : typeParameters) {
                if (first) {
                    first = false;
                } else {
                    this.write(", ");
                }
                if (typeParam.isContravariant()) {
                    this.write("<span class='type-parameter-keyword'>in </span>");
                }
                if (typeParam.isCovariant()) {
                    this.write("<span class='type-parameter-keyword'>out </span>");
                }
                this.write(typeParam.getName());
                if (!typeParam.isDefaulted() || typeParam.getDefaultTypeArgument() == null) continue;
                this.write("<span class='type-parameter'> = </span>");
                this.write("<span class='type-parameter-value'>");
                this.write(this.linkRenderer().to(typeParam.getDefaultTypeArgument()).useScope(scope).getLink());
                this.write("</span>");
            }
            this.write("</span>");
            this.write("&gt;");
        }
    }

    protected final void writeTypeParametersConstraints(List<TypeParameter> typeParameters, Referenceable scope) throws IOException {
        for (TypeParameter typeParam : typeParameters) {
            if (!typeParam.isConstrained()) continue;
            this.open("div class='type-parameter-constraint'");
            this.write("<span class='type-parameter-keyword'>given</span>");
            this.write(" ");
            this.around("span class='type-parameter'", typeParam.getName());
            this.writeSatisfiedTypes(typeParam, scope);
            this.writeCaseTypes(typeParam, scope);
            this.close("div");
        }
    }

    protected final void writeInheritance(TypeDeclaration typeDeclaration) throws IOException {
        List<Type> satisfiedTypes;
        List<Type> caseTypes = typeDeclaration.getCaseTypes();
        if (caseTypes != null && !caseTypes.isEmpty()) {
            this.open("div class='inheritance-satisfies'");
            this.writeCaseTypes(typeDeclaration, typeDeclaration);
            this.close("div");
        }
        if (typeDeclaration instanceof Class && typeDeclaration.getExtendedType() != null) {
            this.open("div class='inheritance-extends'");
            this.write("<span class='keyword'>extends</span>");
            this.write(" ");
            this.linkRenderer().to(typeDeclaration.getExtendedType()).useScope(typeDeclaration).write();
            this.close("div");
        }
        if ((satisfiedTypes = typeDeclaration.getSatisfiedTypes()) != null && !satisfiedTypes.isEmpty()) {
            this.open("div class='inheritance-of'");
            this.writeSatisfiedTypes(typeDeclaration, typeDeclaration);
            this.close("div");
        }
    }

    private void writeCaseTypes(TypeDeclaration typeDeclaration, Referenceable scope) throws IOException {
        List<Type> caseTypes = typeDeclaration.getCaseTypes();
        if (caseTypes != null && !caseTypes.isEmpty()) {
            this.write(" ");
            this.write("<span class='type-parameter-keyword'>of</span>");
            this.write(" ");
            boolean first = true;
            for (Type caseType : caseTypes) {
                if (first) {
                    first = false;
                } else {
                    this.write(" | ");
                }
                this.linkRenderer().to(caseType).useScope(scope).write();
            }
        }
    }

    private void writeSatisfiedTypes(TypeDeclaration typeDeclaration, Referenceable scope) throws IOException {
        List<Type> satisfiedTypes = typeDeclaration.getSatisfiedTypes();
        if (satisfiedTypes != null && !satisfiedTypes.isEmpty()) {
            this.write(" ");
            this.write("<span class='keyword'>satisfies</span>");
            this.write(" ");
            boolean first = true;
            for (Type satisfiedType : satisfiedTypes) {
                if (first) {
                    first = false;
                } else {
                    this.write(" &amp; ");
                }
                this.linkRenderer().to(satisfiedType).useScope(scope).write();
            }
        }
    }

    protected final void writeParameterLinksIfRequired(Functional f) throws IOException {
        this.writeParameterLinksIfRequired(f, true, "");
    }

    private final void writeParameterLinksIfRequired(Functional f, boolean onlyIfNoDoc, String idPrefix) throws IOException {
        Map<Parameter, Map<Tree.Assertion, List<Tree.Condition>>> parametersAssertions = null;
        if (onlyIfNoDoc) {
            parametersAssertions = this.getParametersAssertions((Declaration)((Object)f));
        }
        for (ParameterList parameterList : f.getParameterLists()) {
            for (Parameter parameter : parameterList.getParameters()) {
                ParameterDocData parameterDocData;
                boolean isRequired = true;
                if (onlyIfNoDoc && !(parameterDocData = this.getParameterDocData(parameter, parametersAssertions)).isEmpty()) {
                    isRequired = false;
                }
                if (!isRequired) continue;
                this.around("a id='" + idPrefix + f.getName() + "-" + parameter.getName() + "'", "");
                if (!(parameter.getModel() instanceof Function)) continue;
                this.writeParameterLinksIfRequired((Function)parameter.getModel(), false, idPrefix + f.getName() + "-");
            }
        }
    }

    protected final void writeParameterList(Functional f, Referenceable scope) throws IOException {
        Unit unit = scope.getUnit();
        for (ParameterList lists : f.getParameterLists()) {
            this.write("(");
            boolean first = true;
            for (Parameter param : lists.getParameters()) {
                String defaultValue;
                if (!first) {
                    this.write(", ");
                } else {
                    first = false;
                }
                if (param.getModel() instanceof Function) {
                    this.writeFunctionalParameter(param, scope);
                } else {
                    if (!Decl.isDynamic(param.getModel())) {
                        Type type = param.getType();
                        if (param.isSequenced()) {
                            type = unit.getSequentialElementType(type);
                        }
                        this.linkRenderer().to(type).useScope(scope).write();
                        if (param.isSequenced()) {
                            this.write(param.isAtLeastOne() ? "+" : "*");
                        }
                    } else {
                        this.around("span class='dynamic'", "dynamic");
                    }
                    this.write(" ");
                    this.around("span class='parameter'", param.getName());
                }
                if (!param.isDefaulted() || (defaultValue = this.getParameterDefaultValue(param)) == null) continue;
                this.around("span class='parameter-default-value'", " = ");
                if (simpleDefaultValues.contains(defaultValue)) {
                    this.around("span class='parameter-default-value' title='Parameter default value'", defaultValue);
                    continue;
                }
                this.around("a class='parameter-default-value' href='#" + f.getName() + "-" + param.getName() + "' title='Go to parameter default value'", "...");
            }
            this.write(")");
        }
    }

    private String getParameterDefaultValue(Parameter param) throws IOException {
        String defaultValue = null;
        if (param.isDefaulted()) {
            Tree.SpecifierOrInitializerExpression defArg;
            PhasedUnit pu = this.tool.getParameterUnit(param);
            Node paramNode = this.tool.getParameterNode(param);
            if (pu != null && paramNode instanceof Tree.Parameter && (defArg = this.getDefaultArgument((Tree.Parameter)paramNode)) != null && (defaultValue = this.getSourceCode(pu, defArg.getExpression())) != null) {
                defaultValue = defaultValue.trim();
            }
        }
        return defaultValue;
    }

    private Tree.SpecifierOrInitializerExpression getDefaultArgument(Tree.Parameter parameter) {
        if (parameter instanceof Tree.InitializerParameter) {
            return ((Tree.InitializerParameter)parameter).getSpecifierExpression();
        }
        if (parameter instanceof Tree.ValueParameterDeclaration) {
            return ((Tree.AttributeDeclaration)((Tree.ValueParameterDeclaration)parameter).getTypedDeclaration()).getSpecifierOrInitializerExpression();
        }
        if (parameter instanceof Tree.FunctionalParameterDeclaration) {
            return ((Tree.MethodDeclaration)((Tree.FunctionalParameterDeclaration)parameter).getTypedDeclaration()).getSpecifierExpression();
        }
        return null;
    }

    private void writeFunctionalParameter(Parameter functionParam, Referenceable scope) throws IOException {
        if (!Decl.isDynamic(functionParam.getModel())) {
            if (functionParam.isDeclaredVoid()) {
                this.around("span class='void'", "void");
            } else {
                this.linkRenderer().to(functionParam.getType()).useScope(scope).write();
            }
        } else {
            this.around("span class='dynamic'", "dynamic");
        }
        this.write(" ");
        this.write(functionParam.getName());
        this.writeParameterList((Function)functionParam.getModel(), scope);
    }

    protected final void writeParameters(Declaration decl) throws IOException {
        if (decl instanceof Functional) {
            Map<Parameter, Map<Tree.Assertion, List<Tree.Condition>>> parametersAssertions = this.getParametersAssertions(decl);
            boolean first = true;
            List<ParameterList> parameterLists = ((Functional)((Object)decl)).getParameterLists();
            for (ParameterList parameterList : parameterLists) {
                for (Parameter parameter : parameterList.getParameters()) {
                    ParameterDocData parameterDocData = this.getParameterDocData(parameter, parametersAssertions);
                    if (parameterDocData.isEmpty()) continue;
                    if (first) {
                        first = false;
                        this.open("div class='parameters section'");
                        this.around("span class='title'", "Parameters: ");
                        this.open("ul");
                    }
                    this.open("li");
                    this.open("code");
                    this.around("span class='parameter' id='" + decl.getName() + "-" + parameter.getName() + "'", parameter.getName());
                    if (parameter.getModel() instanceof Function) {
                        this.writeParameterLinksIfRequired((Function)parameter.getModel(), false, decl.getName() + "-");
                    }
                    if (!Util.isEmpty(parameterDocData.defaultValue)) {
                        this.around("span class='parameter-default-value' title='Parameter default value'", " = " + parameterDocData.defaultValue);
                    }
                    this.close("code");
                    if (!Util.isEmpty(parameterDocData.doc)) {
                        this.around("div class='doc section'", parameterDocData.doc);
                    }
                    this.writeParameterAssertions(decl, parameterDocData.parameterAssertions);
                    this.close("li");
                }
            }
            if (!first) {
                this.close("ul");
                this.close("div");
            }
        }
    }

    private void writeParameterAssertions(Declaration decl, Map<Tree.Assertion, List<Tree.Condition>> parameterAssertions) throws IOException {
        if (parameterAssertions == null || parameterAssertions.isEmpty()) {
            return;
        }
        PhasedUnit pu = this.tool.getUnit(decl);
        this.open("div class='assertions' title='Parameter assertions'");
        this.open("ul");
        for (Tree.Assertion assertion : parameterAssertions.keySet()) {
            ArrayList<Annotation> annotations = new ArrayList<Annotation>();
            TreeUtil.buildAnnotations(assertion.getAnnotationList(), annotations);
            String doc = Util.getRawDoc(decl.getUnit(), annotations);
            if (!Util.isEmpty(doc)) {
                this.open("li");
                this.write("<i class='icon-assertion'></i>");
                this.write(Util.wikiToHTML(doc, this.linkRenderer()));
                this.close("li");
                continue;
            }
            for (Tree.Condition c : parameterAssertions.get(assertion)) {
                String sourceCode = this.getSourceCode(pu, c);
                this.open("li");
                this.write("<i class='icon-assertion'></i>");
                this.around("code", sourceCode);
                this.close("li");
            }
        }
        this.close("ul");
        this.close("div");
    }

    protected final void writeThrows(Declaration decl) throws IOException {
        boolean first = true;
        for (Annotation annotation : decl.getAnnotations()) {
            String excDesc;
            if (!annotation.getName().equals("throws")) continue;
            String excType = annotation.getPositionalArguments().get(0);
            String string = excDesc = annotation.getPositionalArguments().size() == 2 ? annotation.getPositionalArguments().get(1) : null;
            if (first) {
                first = false;
                this.open("div class='throws section'");
                this.around("span class='title'", "Throws ");
                this.open("ul");
            }
            this.open("li");
            this.linkRenderer().to(excType).withinText(true).useScope(decl).write();
            if (excDesc != null) {
                this.write(Util.wikiToHTML(excDesc, this.linkRenderer().useScope(decl)));
            }
            this.close("li");
        }
        if (!first) {
            this.close("ul");
            this.close("div");
        }
        this.tool.warningMissingThrows(decl);
    }

    private void writeDeprecated(Declaration decl) throws IOException {
        Annotation deprecated = Util.findAnnotation(decl, "deprecated");
        if (deprecated != null) {
            String reason;
            this.open("div class='deprecated section'");
            String text = "<span class='title'>Deprecated: </span>";
            if (!deprecated.getPositionalArguments().isEmpty() && (reason = deprecated.getPositionalArguments().get(0)) != null) {
                text = text + reason;
            }
            this.write(Util.wikiToHTML(text, this.linkRenderer().useScope(decl)));
            this.close("div");
        }
    }

    protected final void writeAliases(Declaration decl) throws IOException {
        Annotation see = Util.getAnnotation(decl.getUnit(), decl.getAnnotations(), "aliased");
        if (see == null) {
            return;
        }
        this.open("div class='aliased section'");
        this.around("span class='title'", "Aliases: ");
        this.open("span class='value'");
        boolean first = true;
        for (String target : see.getPositionalArguments()) {
            if (!first) {
                this.write(", ");
            } else {
                first = false;
            }
            this.open("code class='signature'");
            String cssClass = decl instanceof TypeDeclaration ? "type-identifier" : "identifier";
            this.open("span class='" + cssClass + "'");
            this.write(target);
            this.close("span");
            this.close("code");
        }
        this.close("span");
        this.close("div");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSourceCode(PhasedUnit pu, Node node) throws IOException {
        int startIndex = ((CommonToken)node.getToken()).getStartIndex();
        int stopIndex = ((CommonToken)node.getEndToken()).getStopIndex();
        StringBuilder sourceCodeBuilder = new StringBuilder();
        try (BufferedReader sourceCodeReader = new BufferedReader(new InputStreamReader(pu.getUnitFile().getInputStream()));){
            int c;
            while ((c = sourceCodeReader.read()) != -1) {
                if (sourceCodeBuilder.length() > stopIndex) {
                    break;
                }
                sourceCodeBuilder.append((char)c);
            }
        }
        String sourceCode = sourceCodeBuilder.substring(startIndex, stopIndex + 1);
        sourceCode = sourceCode.replaceAll("&", "&amp;");
        sourceCode = sourceCode.replaceAll("<", "&lt;");
        sourceCode = sourceCode.replaceAll(">", "&gt;");
        return sourceCode;
    }

    private Map<Parameter, Map<Tree.Assertion, List<Tree.Condition>>> getParametersAssertions(final Declaration decl) {
        final LinkedHashMap<Parameter, Map<Tree.Assertion, List<Tree.Condition>>> parametersAssertions = new LinkedHashMap<Parameter, Map<Tree.Assertion, List<Tree.Condition>>>();
        if (((Functional)((Object)decl)).getParameterLists().isEmpty()) {
            return parametersAssertions;
        }
        Node node = this.tool.getNode(decl);
        PhasedUnit pu = this.tool.getUnit(decl);
        if (node == null || pu == null) {
            return parametersAssertions;
        }
        Tree.Body body = null;
        if (node instanceof Tree.MethodDefinition) {
            body = ((Tree.MethodDefinition)node).getBlock();
        } else if (node instanceof Tree.ClassDefinition) {
            body = ((Tree.ClassDefinition)node).getClassBody();
        }
        if (body == null) {
            return parametersAssertions;
        }
        final HashMap<String, Parameter> parametersNames = new HashMap<String, Parameter>();
        for (ParameterList parameterList : ((Functional)((Object)decl)).getParameterLists()) {
            for (Parameter parameter : parameterList.getParameters()) {
                parametersNames.put(parameter.getName(), parameter);
            }
        }
        body.visitChildren(new Visitor(){
            private boolean stop = false;
            private Tree.Assertion assertion = null;
            private Set<Parameter> referencedParameters = new HashSet<Parameter>();

            @Override
            public void visit(Tree.Assertion that) {
                this.assertion = that;
                super.visit(that);
                this.assertion = null;
            }

            @Override
            public void visit(Tree.Condition that) {
                this.referencedParameters.clear();
                super.visit(that);
                if (this.assertion != null && !this.referencedParameters.isEmpty()) {
                    for (Parameter referencedParameter : this.referencedParameters) {
                        ArrayList<Tree.Condition> parameterConditions;
                        LinkedHashMap<Tree.Assertion, ArrayList<Tree.Condition>> parameterAssertions = (LinkedHashMap<Tree.Assertion, ArrayList<Tree.Condition>>)parametersAssertions.get(referencedParameter);
                        if (parameterAssertions == null) {
                            parameterAssertions = new LinkedHashMap<Tree.Assertion, ArrayList<Tree.Condition>>();
                            parametersAssertions.put(referencedParameter, parameterAssertions);
                        }
                        if ((parameterConditions = (ArrayList<Tree.Condition>)parameterAssertions.get(this.assertion)) == null) {
                            parameterConditions = new ArrayList<Tree.Condition>();
                            parameterAssertions.put(this.assertion, parameterConditions);
                        }
                        parameterConditions.add(that);
                    }
                }
            }

            @Override
            public void visit(Tree.BaseMemberExpression that) {
                if (this.assertion != null) {
                    Declaration d = that.getDeclaration();
                    Scope realScope = ModelUtil.getRealScope(d.getScope());
                    if (parametersNames.containsKey(d.getName()) && realScope == decl) {
                        this.referencedParameters.add((Parameter)parametersNames.get(d.getName()));
                    }
                }
                super.visit(that);
            }

            @Override
            public void visit(Tree.Statement that) {
                if (this.assertion == null) {
                    this.stop = true;
                }
                super.visit(that);
            }

            @Override
            public void visitAny(Node that) {
                if (!this.stop) {
                    super.visitAny(that);
                }
            }
        });
        return parametersAssertions;
    }

    private ParameterDocData getParameterDocData(Parameter parameter, Map<Parameter, Map<Tree.Assertion, List<Tree.Condition>>> parametersAssertions) throws IOException {
        String doc = Util.getDoc(parameter.getModel(), this.linkRenderer());
        String defaultValue = this.getParameterDefaultValue(parameter);
        Map<Tree.Assertion, List<Tree.Condition>> parameterAssertions = parametersAssertions.get(parameter);
        return new ParameterDocData(doc, defaultValue, parameterAssertions);
    }

    static {
        simpleDefaultValues.add("null");
        simpleDefaultValues.add("true");
        simpleDefaultValues.add("false");
        simpleDefaultValues.add("0");
        simpleDefaultValues.add("1");
        simpleDefaultValues.add("-1");
        simpleDefaultValues.add("0.0");
        simpleDefaultValues.add("1.0");
        simpleDefaultValues.add("-1.0");
        simpleDefaultValues.add("[]");
        simpleDefaultValues.add("\"\"");
    }

    private static class ParameterDocData {
        final String doc;
        final String defaultValue;
        final Map<Tree.Assertion, List<Tree.Condition>> parameterAssertions;

        public ParameterDocData(String doc, String defaultValue, Map<Tree.Assertion, List<Tree.Condition>> parameterAssertions) {
            this.doc = doc;
            this.defaultValue = defaultValue;
            this.parameterAssertions = parameterAssertions;
        }

        boolean isEmpty() {
            return this.doc.isEmpty() && this.defaultValue == null && this.parameterAssertions == null;
        }
    }
}

