/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.ceylondoc;

import com.redhat.ceylon.ceylondoc.CeylonDocTool;
import com.redhat.ceylon.ceylondoc.CeylondMessages;
import com.redhat.ceylon.ceylondoc.Util;
import com.redhat.ceylon.common.config.DefaultToolOptions;
import com.redhat.ceylon.compiler.java.codegen.Decl;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.model.typechecker.model.Annotated;
import com.redhat.ceylon.model.typechecker.model.Annotation;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.ClassOrInterface;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Element;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.Interface;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.NothingType;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.Referenceable;
import com.redhat.ceylon.model.typechecker.model.Scope;
import com.redhat.ceylon.model.typechecker.model.Sourced;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeAlias;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypeParameter;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.Unit;
import com.redhat.ceylon.model.typechecker.model.Value;
import com.redhat.ceylon.model.typechecker.util.TypePrinter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LinkRenderer {
    private Object to;
    private Object from;
    private CeylonDocTool ceylonDocTool;
    private Writer writer;
    private String customText;
    private boolean withinText;
    private Referenceable scope;
    private String anchor;
    private boolean printAbbreviated = true;
    private boolean printTypeParameters = true;
    private boolean printTypeParameterDetail = false;
    private boolean printWikiStyleLinks = false;
    private boolean printLinkDropdownMenu = true;
    private boolean printParenthesisAfterMethodName = true;
    private boolean printMemberContainerName = true;
    private final TypePrinter producedTypeNamePrinter = new TypePrinter(){

        @Override
        public String getSimpleDeclarationName(Declaration declaration, Unit unit) {
            String result = null;
            if (declaration instanceof ClassOrInterface || declaration instanceof NothingType) {
                String typeUrl;
                TypeDeclaration type = (TypeDeclaration)declaration;
                if (LinkRenderer.this.isLinkable(type) && (typeUrl = LinkRenderer.this.getUrl(type, null)) != null) {
                    result = LinkRenderer.this.buildLinkElement(typeUrl, LinkRenderer.this.getLinkText(type), "Go to " + type.getQualifiedNameString());
                }
                if (result == null) {
                    result = LinkRenderer.this.buildSpanElementWithNameAndTooltip(declaration);
                }
            } else {
                result = declaration instanceof TypeParameter ? "<span class='type-parameter'>" + declaration.getName(unit) + "</span>" : (declaration instanceof TypedDeclaration ? LinkRenderer.this.processTypedDeclaration((TypedDeclaration)declaration) : (declaration instanceof TypeAlias ? LinkRenderer.this.processTypeAlias((TypeAlias)declaration) : LinkRenderer.this.buildSpanElementWithNameAndTooltip(declaration)));
            }
            return LinkRenderer.encodeResult(result);
        }

        @Override
        public boolean printAbbreviated() {
            return LinkRenderer.this.printAbbreviated;
        }

        @Override
        public boolean printTypeParameters() {
            return LinkRenderer.this.printTypeParameters;
        }

        @Override
        public boolean printTypeParameterDetail() {
            return LinkRenderer.this.printTypeParameterDetail;
        }

        @Override
        public boolean printQualifyingType() {
            return false;
        }
    };

    public LinkRenderer(CeylonDocTool ceylonDocTool, Writer writer, Object from) {
        this.ceylonDocTool = ceylonDocTool;
        this.writer = writer;
        this.from = from;
    }

    public LinkRenderer(LinkRenderer linkRenderer) {
        this.to = linkRenderer.to;
        this.from = linkRenderer.from;
        this.ceylonDocTool = linkRenderer.ceylonDocTool;
        this.writer = linkRenderer.writer;
        this.customText = linkRenderer.customText;
        this.scope = linkRenderer.scope;
        this.anchor = linkRenderer.anchor;
        this.printAbbreviated = linkRenderer.printAbbreviated;
        this.printTypeParameters = linkRenderer.printTypeParameters;
        this.printTypeParameterDetail = linkRenderer.printTypeParameterDetail;
        this.printLinkDropdownMenu = linkRenderer.printLinkDropdownMenu;
    }

    public LinkRenderer to(Object to) {
        this.to = to;
        return this;
    }

    public LinkRenderer useCustomText(String customText) {
        this.customText = customText;
        return this;
    }

    public LinkRenderer withinText(boolean text) {
        this.withinText = text;
        return this;
    }

    public LinkRenderer useScope(Referenceable scope) {
        this.scope = scope;
        return this;
    }

    public LinkRenderer useAnchor(String anchor) {
        this.anchor = anchor;
        return this;
    }

    public LinkRenderer printAbbreviated(boolean printAbbreviated) {
        this.printAbbreviated = printAbbreviated;
        return this;
    }

    public LinkRenderer printTypeParameters(boolean printTypeParameters) {
        this.printTypeParameters = printTypeParameters;
        return this;
    }

    public LinkRenderer printTypeParameterDetail(boolean printTypeParameterDetail) {
        this.printTypeParameterDetail = printTypeParameterDetail;
        return this;
    }

    public LinkRenderer printWikiStyleLinks(boolean printWikiStyleLinks) {
        this.printWikiStyleLinks = printWikiStyleLinks;
        return this;
    }

    public LinkRenderer printLinkDropdownMenu(boolean printLinkDropdownMenu) {
        this.printLinkDropdownMenu = printLinkDropdownMenu;
        return this;
    }

    public LinkRenderer printParenthesisAfterMethodName(boolean printParenthesisAfterMethodName) {
        this.printParenthesisAfterMethodName = printParenthesisAfterMethodName;
        return this;
    }

    public LinkRenderer printMemberContainerName(boolean printMemberContainerName) {
        this.printMemberContainerName = printMemberContainerName;
        return this;
    }

    public String getLink() {
        String link = null;
        if (this.to instanceof String) {
            link = this.printWikiStyleLinks ? this.processWikiLink((String)this.to) : this.processAnnotationParam((String)this.to);
        } else if (this.to instanceof Type) {
            link = this.processProducedType((Type)this.to);
        } else if (this.to instanceof Declaration) {
            link = this.processDeclaration((Declaration)this.to);
        } else if (this.to instanceof Module) {
            link = this.processModule((Module)this.to);
        } else if (this.to instanceof Package) {
            link = this.processPackage((Package)this.to);
        }
        return link;
    }

    public String getUrl() {
        return this.getUrl(this.to, this.anchor);
    }

    public String getResourceUrl(String to) throws IOException {
        return this.ceylonDocTool.getResourceUrl(this.from, to);
    }

    public String getSrcUrl(Object to) throws IOException {
        return this.ceylonDocTool.getSrcUrl(this.from, to);
    }

    public void write() throws IOException {
        this.writer.write(this.getLink());
    }

    private String processModule(Module module) {
        String moduleUrl = this.getUrl(module, this.anchor);
        if (moduleUrl != null) {
            return this.buildLinkElement(moduleUrl, module.getNameAsString(), "Go to module");
        }
        return module.getNameAsString();
    }

    private String processPackage(Package pkg) {
        String pkgUrl = this.getUrl(pkg, this.anchor);
        if (pkgUrl != null) {
            return this.buildLinkElement(pkgUrl, this.customText != null ? this.customText : pkg.getNameAsString(), "Go to package " + pkg.getNameAsString());
        }
        return pkg.getNameAsString();
    }

    private String processDeclaration(Declaration decl) {
        if (decl instanceof TypeDeclaration) {
            return this.processProducedType(((TypeDeclaration)decl).getType());
        }
        return this.processTypedDeclaration((TypedDeclaration)decl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String processProducedType(Type producedType) {
        String result;
        boolean wasWithinText = this.withinText;
        this.withinText = false;
        try {
            result = this.producedTypeNamePrinter.print(producedType, null);
        }
        finally {
            this.withinText = wasWithinText;
        }
        result = LinkRenderer.decodeResult(result);
        if (this.withinText && this.customText == null) {
            result = "<code>" + result + "</code>";
        }
        result = this.decorateWithLinkDropdownMenu(result, producedType);
        return result;
    }

    private String processTypedDeclaration(TypedDeclaration decl) {
        String url;
        String declName = Util.getDeclarationName(decl);
        Scope declContainer = decl.getContainer();
        if (this.isLinkable(decl) && (url = this.getUrl(declContainer, declName)) != null) {
            return this.buildLinkElement(url, this.getLinkText(decl), "Go to " + decl.getQualifiedNameString());
        }
        String result = declName;
        if (this.withinText) {
            result = "<code>" + result + "</code>";
        }
        if (this.customText != null) {
            result = this.customText;
        }
        return result;
    }

    private String processTypeAlias(TypeAlias alias) {
        String url;
        String aliasName = alias.getName();
        Scope aliasContainer = alias.getContainer();
        if (this.isLinkable(alias) && (url = this.getUrl(aliasContainer, aliasName)) != null) {
            return this.buildLinkElement(url, aliasName, "Go to " + alias.getQualifiedNameString());
        }
        return this.buildSpanElementWithNameAndTooltip(alias);
    }

    private String processWikiLink(String docLinkText) {
        Annotation docAnnotation;
        Declaration refinedDeclaration;
        Tree.DocLink docLink = this.findDocLink(docLinkText, this.scope);
        if (docLink == null && this.scope instanceof Declaration && (refinedDeclaration = ((Declaration)this.scope).getRefinedDeclaration()) != this.scope) {
            docLink = this.findDocLink(docLinkText, refinedDeclaration);
        }
        if (docLink != null) {
            if (docLink.getQualified() != null && docLink.getQualified().size() > 0) {
                return this.processDeclaration(docLink.getQualified().get(docLink.getQualified().size() - 1));
            }
            if (docLink.getBase() != null) {
                this.printAbbreviated = !Util.isAbbreviatedType(docLink.getBase());
                return this.processDeclaration(docLink.getBase());
            }
            if (docLink.getModule() != null) {
                return this.processModule(docLink.getModule());
            }
            if (docLink.getPkg() != null) {
                return this.processPackage(docLink.getPkg());
            }
        }
        if (docLink != null && this.scope instanceof Annotated && (docAnnotation = Util.getAnnotation(this.scope.getUnit(), ((Annotated)((Object)this.scope)).getAnnotations(), "doc")) != null) {
            this.ceylonDocTool.warningBrokenLink(docLinkText, docLink, this.scope);
        }
        return this.getUnresolvableLink(docLinkText);
    }

    private String processAnnotationParam(String text) {
        String currentDeclName;
        Scope currentScope;
        String declName;
        Class clazz;
        Interface interf;
        Package pkg;
        Module mod;
        if (text.equals("module") && (mod = this.getCurrentModule()) != null) {
            return this.processModule(mod);
        }
        if (text.startsWith("module ")) {
            String modName = text.substring(7);
            for (Module m : this.ceylonDocTool.getTypeChecker().getContext().getModules().getListOfModules()) {
                if (!m.getNameAsString().equals(modName)) continue;
                return this.processModule(m);
            }
        }
        if (text.equals("package") && (pkg = this.getCurrentPackage()) != null) {
            return this.processPackage(pkg);
        }
        if (text.startsWith("package ")) {
            String pkgName = text.substring(8);
            for (Module m : this.ceylonDocTool.getTypeChecker().getContext().getModules().getListOfModules()) {
                Package pkg2;
                if (!pkgName.startsWith(m.getNameAsString() + ".") || (pkg2 = m.getPackage(pkgName)) == null) continue;
                return this.processPackage(pkg2);
            }
        }
        if (text.equals("interface") && (interf = this.getCurrentInterface()) != null) {
            return this.processProducedType(interf.getType());
        }
        if (text.equals("class") && (clazz = this.getCurrentClass()) != null) {
            return this.processProducedType(clazz.getType());
        }
        int pkgSeparatorIndex = text.indexOf("::");
        if (pkgSeparatorIndex == -1) {
            declName = text;
            currentScope = this.resolveScope(this.scope);
        } else {
            String pkgName = text.substring(0, pkgSeparatorIndex);
            declName = text.substring(pkgSeparatorIndex + 2, text.length());
            currentScope = this.ceylonDocTool.getCurrentModule().getPackage(pkgName);
        }
        String[] declNames = declName.split("\\.");
        Declaration currentDecl = null;
        boolean isNested = false;
        String[] arr$ = declNames;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (currentDecl = this.resolveDeclaration(currentScope, currentDeclName = arr$[i$], isNested)) != null; ++i$) {
            if (this.isValueWithTypeObject(currentDecl)) {
                TypeDeclaration objectType = ((Value)currentDecl).getTypeDeclaration();
                currentScope = objectType;
                currentDecl = objectType;
            } else {
                currentScope = this.resolveScope(currentDecl);
            }
            isNested = true;
        }
        if (currentDecl != null && !this.isParameter(currentDecl)) {
            if (currentDecl instanceof TypeDeclaration) {
                return this.processProducedType(((TypeDeclaration)currentDecl).getType());
            }
            return this.processTypedDeclaration((TypedDeclaration)currentDecl);
        }
        return this.getUnresolvableLink(text);
    }

    private boolean isLinkable(Declaration decl) {
        if (decl == null) {
            return false;
        }
        if (decl.isParameter()) {
            return true;
        }
        if (!this.ceylonDocTool.isIncludeNonShared()) {
            if (!decl.isShared()) {
                return false;
            }
            for (Scope c = decl.getContainer(); c != null; c = c.getContainer()) {
                boolean isShared = true;
                if (c instanceof Declaration) {
                    isShared = ((Declaration)((Object)c)).isShared();
                }
                if (c instanceof Package) {
                    isShared = ((Package)c).isShared();
                }
                if (isShared) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isValueWithTypeObject(Declaration decl) {
        TypeDeclaration typeDeclaration;
        return Decl.isValue(decl) && (typeDeclaration = ((Value)decl).getTypeDeclaration()) instanceof Class && typeDeclaration.isAnonymous();
    }

    private boolean isParameter(Declaration decl) {
        return decl instanceof FunctionOrValue && ((FunctionOrValue)decl).isParameter();
    }

    private Declaration resolveDeclaration(Scope scope, String declName, boolean isNested) {
        Declaration decl = null;
        if (scope != null) {
            decl = scope.getMember(declName, null, false);
            if (decl == null && !isNested && scope instanceof Element) {
                decl = scope.getUnit().getImportedDeclaration(declName, null, false);
            }
            if (decl == null && !isNested && !scope.getQualifiedNameString().equals("ceylon.language")) {
                decl = this.resolveDeclaration(scope.getContainer(), declName, isNested);
            }
            if (decl == null && declName.equals("Nothing") && scope.getQualifiedNameString().equals("ceylon.language")) {
                decl = new NothingType(scope.getUnit());
            }
        } else {
            Package pkg = this.ceylonDocTool.getCurrentModule().getPackage("ceylon.language");
            if (pkg != null) {
                decl = this.resolveDeclaration(pkg, declName, isNested);
            }
        }
        return decl;
    }

    private Scope resolveScope(Referenceable referenceable) {
        if (referenceable instanceof Module) {
            return ((Module)referenceable).getPackage(referenceable.getNameAsString());
        }
        if (referenceable instanceof Scope) {
            return (Scope)((Object)referenceable);
        }
        if (referenceable instanceof Declaration) {
            return ((Declaration)referenceable).getContainer();
        }
        return null;
    }

    private boolean isInCurrentModule(Object obj) {
        Module objModule = null;
        if (obj instanceof Module) {
            objModule = (Module)obj;
        } else if (obj instanceof Scope) {
            objModule = this.getPackage((Scope)obj).getModule();
        } else if (obj instanceof Element) {
            objModule = this.getPackage(((Element)obj).getScope()).getModule();
        }
        Module currentModule = this.ceylonDocTool.getCurrentModule();
        if (currentModule != null && objModule != null) {
            return currentModule.equals(objModule);
        }
        return false;
    }

    private String getUnresolvableLink(String docLinkText) {
        boolean hasCustomText;
        StringBuilder unresolvable = new StringBuilder();
        unresolvable.append("<span class='link-unresolvable'>");
        boolean bl = hasCustomText = this.customText != null && !this.customText.equals(docLinkText);
        if (hasCustomText) {
            unresolvable.append(this.customText);
            unresolvable.append(" (");
        }
        if (this.withinText) {
            unresolvable.append("<code>");
        }
        int index = docLinkText.indexOf(124) + 1;
        unresolvable.append(docLinkText.substring(index));
        if (this.withinText) {
            unresolvable.append("</code>");
        }
        if (hasCustomText) {
            unresolvable.append(")");
        }
        unresolvable.append("</span>");
        return unresolvable.toString();
    }

    private String getLinkText(Declaration decl) {
        String result;
        if (this.customText != null) {
            return this.customText;
        }
        String name = Util.getDeclarationName(decl);
        if (this.scope != null && this.scope.getUnit() != null) {
            name = this.scope.getUnit().getAliasedName(decl, name);
        }
        if (decl instanceof TypeDeclaration) {
            result = "<span class='type-identifier'>" + name + "</span>";
        } else {
            if (decl instanceof Function && this.printParenthesisAfterMethodName) {
                name = name + "()";
            }
            result = "<span class='identifier'>" + name + "</span>";
        }
        if (this.printMemberContainerName && decl.isMember() && decl.getContainer() != this.from) {
            result = this.getLinkText((Declaration)((Object)decl.getContainer())) + '.' + result;
        }
        return result;
    }

    private Package getPackage(Scope scope) {
        while (!(scope instanceof Package)) {
            scope = scope.getContainer();
        }
        return (Package)scope;
    }

    private String getUrl(Object to, String anchor) {
        ArrayList<Function> methods = new ArrayList<Function>();
        while (to instanceof Function) {
            Function method = (Function)to;
            methods.add(method);
            to = method.getContainer();
        }
        String url = this.isInCurrentModule(to) ? this.getLocalUrl(to) : this.getExternalUrl(to);
        if (url != null && anchor != null) {
            String sectionPackageAnchor = "#section-package";
            if (url.endsWith(sectionPackageAnchor)) {
                url = url.substring(0, url.length() - sectionPackageAnchor.length());
            }
            StringBuilder fragment = new StringBuilder();
            if (!methods.isEmpty()) {
                Collections.reverse(methods);
                for (Function method : methods) {
                    fragment.append(method.getName());
                    fragment.append("-");
                }
            }
            fragment.append(anchor);
            url = url + "#" + fragment;
        }
        return url;
    }

    private String getLocalUrl(Object to) {
        try {
            return this.ceylonDocTool.getObjectUrl(this.from, to);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String getExternalUrl(Object to) {
        ClassOrInterface klass;
        Package pkg;
        String url = null;
        if (to instanceof Module) {
            url = this.getExternalModuleUrl((Module)to);
            if (url != null) {
                url = url + "index.html";
            }
        } else if (to instanceof Package) {
            Package pkg2 = (Package)to;
            url = this.getExternalModuleUrl(pkg2.getModule());
            if (url != null) {
                url = url + this.buildPackageUrlPath(pkg2);
                url = url + "index.html";
            }
        } else if (to instanceof ClassOrInterface && (url = this.getExternalModuleUrl((pkg = this.getPackage(klass = (ClassOrInterface)to)).getModule())) != null) {
            url = url + this.buildPackageUrlPath(pkg);
            url = url + this.ceylonDocTool.getFileName(klass);
        }
        return url;
    }

    private String getExternalModuleUrl(Module module) {
        if (this.ceylonDocTool.getLinks() != null) {
            String moduleName = module.getNameAsString();
            for (String link : this.ceylonDocTool.getLinks()) {
                String[] linkParts = LinkRenderer.divideToPatternAndUrl(link);
                String moduleNamePattern = linkParts[0];
                String moduleRepoUrl = linkParts[1];
                if (moduleNamePattern == null) {
                    String moduleDocUrl = this.buildModuleUrl(moduleRepoUrl, module);
                    if (LinkRenderer.isHttpProtocol(moduleDocUrl) && this.checkHttpUrlExist(moduleDocUrl)) {
                        return moduleDocUrl;
                    }
                    if (!LinkRenderer.isFileProtocol(moduleDocUrl) || !this.checkFileUrlExist(moduleDocUrl)) continue;
                    return moduleDocUrl;
                }
                if (!moduleName.startsWith(moduleNamePattern)) continue;
                return this.buildModuleUrl(moduleRepoUrl, module);
            }
        }
        return null;
    }

    private String buildLinkElement(String url, String text, String toolTip) {
        StringBuilder linkBuilder = new StringBuilder();
        linkBuilder.append("<a ");
        if (this.customText != null) {
            linkBuilder.append("class='link-custom-text'");
        } else {
            linkBuilder.append("class='link'");
        }
        linkBuilder.append(" href='").append(url).append("'");
        if (toolTip != null) {
            linkBuilder.append(" title='").append(toolTip).append("'");
        }
        linkBuilder.append(">");
        if (this.customText == null && this.withinText) {
            linkBuilder.append("<code>");
        }
        linkBuilder.append(text);
        if (this.customText == null && this.withinText) {
            linkBuilder.append("</code>");
        }
        linkBuilder.append("</a>");
        return linkBuilder.toString();
    }

    private String buildSpanElementWithNameAndTooltip(Declaration d) {
        StringBuilder spanBuilder = new StringBuilder();
        spanBuilder.append("<span title='");
        spanBuilder.append(d.getQualifiedNameString());
        spanBuilder.append("'>");
        if (this.withinText) {
            spanBuilder.append("<code>");
        }
        spanBuilder.append(this.getLinkText(d));
        if (this.withinText) {
            spanBuilder.append("</code>");
        }
        spanBuilder.append("</span>");
        return spanBuilder.toString();
    }

    private String buildModuleUrl(String moduleRepoUrl, Module module) {
        StringBuilder moduleUrlBuilder = new StringBuilder();
        moduleUrlBuilder.append(moduleRepoUrl);
        if (!moduleRepoUrl.endsWith("/")) {
            moduleUrlBuilder.append("/");
        }
        moduleUrlBuilder.append(Util.join("/", module.getName()));
        moduleUrlBuilder.append("/");
        moduleUrlBuilder.append(module.getVersion());
        moduleUrlBuilder.append("/module-doc/api/");
        return moduleUrlBuilder.toString();
    }

    private String buildPackageUrlPath(Package pkg) {
        List<String> packagePath = pkg.getName().subList(pkg.getModule().getName().size(), pkg.getName().size());
        if (!packagePath.isEmpty()) {
            return Util.join("/", packagePath) + "/";
        }
        return "";
    }

    public static String[] divideToPatternAndUrl(String link) {
        String moduleRepoUrl = null;
        String moduleNamePattern = null;
        int indexOfSeparator = link.indexOf("=");
        if (indexOfSeparator != -1) {
            moduleNamePattern = link.substring(0, indexOfSeparator);
            moduleRepoUrl = link.substring(indexOfSeparator + 1);
        } else {
            moduleRepoUrl = link;
        }
        return new String[]{moduleNamePattern, moduleRepoUrl};
    }

    public static boolean isHttpProtocol(String url) {
        return url.startsWith("http://") || url.startsWith("https://");
    }

    public static boolean isFileProtocol(String url) {
        return url.startsWith("file://");
    }

    private boolean checkHttpUrlExist(String moduleUrl) {
        Boolean result = this.ceylonDocTool.getModuleUrlAvailabilityCache().get(moduleUrl);
        if (result == null) {
            try {
                URL url = new URL(moduleUrl + "index.html");
                Proxy proxy = DefaultToolOptions.getDefaultProxy();
                HttpURLConnection con = proxy != null ? (HttpURLConnection)url.openConnection(proxy) : (HttpURLConnection)url.openConnection();
                con.setConnectTimeout((int)DefaultToolOptions.getDefaultTimeout());
                con.setReadTimeout((int)DefaultToolOptions.getDefaultTimeout() * 10);
                con.setRequestMethod("HEAD");
                int responseCode = con.getResponseCode();
                if (responseCode == 200) {
                    result = Boolean.TRUE;
                } else {
                    this.ceylonDocTool.getLogger().warning(CeylondMessages.msg("info.urlDoesNotExist", moduleUrl));
                    result = Boolean.FALSE;
                }
            }
            catch (IOException e) {
                this.ceylonDocTool.getLogger().warning(CeylondMessages.msg("info.urlDoesNotExist", moduleUrl));
                result = Boolean.FALSE;
            }
            this.ceylonDocTool.getModuleUrlAvailabilityCache().put(moduleUrl, result);
        }
        return result;
    }

    private boolean checkFileUrlExist(String moduleUrl) {
        Boolean result = this.ceylonDocTool.getModuleUrlAvailabilityCache().get(moduleUrl);
        if (result == null) {
            File moduleDocDir = new File(moduleUrl.substring("file://".length()));
            if (moduleDocDir.isDirectory() && moduleDocDir.exists()) {
                result = Boolean.TRUE;
            } else {
                this.ceylonDocTool.getLogger().warning(CeylondMessages.msg("info.urlDoesNotExist", moduleUrl));
                result = Boolean.FALSE;
            }
            this.ceylonDocTool.getModuleUrlAvailabilityCache().put(moduleUrl, result);
        }
        return result;
    }

    private static String encodeResult(String text) {
        if (text != null) {
            text = text.replaceAll("<", "#LT;");
            text = text.replaceAll(">", "#GT;");
        }
        return text;
    }

    private static String decodeResult(String text) {
        if (text != null) {
            text = text.replaceAll("&", "&amp;");
            text = text.replaceAll("<", "&lt;");
            text = text.replaceAll(">", "&gt;");
            text = text.replaceAll("#LT;", "<");
            text = text.replaceAll("#GT;", ">");
            text = text.replaceAll("&lt;in ", "&lt;<span class='type-parameter-keyword'>in </span>");
            text = text.replaceAll(",in ", ",<span class='type-parameter-keyword'>in </span>");
            text = text.replaceAll("&lt;out ", "&lt;<span class='type-parameter-keyword'>out </span>");
            text = text.replaceAll(",out ", ",<span class='type-parameter-keyword'>out </span>");
        }
        return text;
    }

    private String decorateWithLinkDropdownMenu(String link, Type producedType) {
        if (!(this.printLinkDropdownMenu && this.printAbbreviated && this.canLinkToCeylonLanguageModule())) {
            return link;
        }
        ArrayList<Type> producedTypes = new ArrayList<Type>();
        this.decompose(producedType, producedTypes);
        boolean containsOptional = false;
        boolean containsSequential = false;
        boolean containsSequence = false;
        boolean containsIterable = false;
        boolean containsEntry = false;
        boolean containsCallable = false;
        boolean containsTuple = false;
        for (Type pt : producedTypes) {
            if (TypePrinter.abbreviateOptional(pt)) {
                containsOptional = true;
                continue;
            }
            if (TypePrinter.abbreviateSequential(pt) && !link.contains("'Go to ceylon.language::Sequential'")) {
                containsSequential = true;
                continue;
            }
            if (TypePrinter.abbreviateSequence(pt) && !link.contains("'Go to ceylon.language::Sequence'")) {
                containsSequence = true;
                continue;
            }
            if (TypePrinter.abbreviateIterable(pt) && !link.contains("'Go to ceylon.language::Iterable'")) {
                containsIterable = true;
                continue;
            }
            if (TypePrinter.abbreviateEntry(pt) && !link.contains("'Go to ceylon.language::Entry'")) {
                containsEntry = true;
                continue;
            }
            if (TypePrinter.abbreviateCallable(pt) && !link.contains("'Go to ceylon.language::Callable'")) {
                containsCallable = true;
                continue;
            }
            if (!TypePrinter.abbreviateTuple(pt) || link.contains("'Go to ceylon.language::Tuple'")) continue;
            containsTuple = true;
        }
        Unit unit = producedType.getDeclaration().getUnit();
        if (containsOptional || containsSequential || containsSequence || containsIterable || containsEntry || containsCallable || containsTuple) {
            StringBuilder sb = new StringBuilder();
            sb.append("<span class='link-dropdown'>");
            sb.append(link.replaceAll("class='link'", "class='link type-identifier'"));
            sb.append("<span class='dropdown'>");
            sb.append("<a class='dropdown-toggle' data-toggle='dropdown' href='#'><b title='Show more links' class='caret'></b></a>");
            sb.append("<ul class='dropdown-menu'>");
            if (containsOptional) {
                sb.append(this.getLinkMenuItem(unit.getNullDeclaration(), "abbreviations X? means Null|X"));
            }
            if (containsSequential) {
                sb.append(this.getLinkMenuItem(unit.getSequentialDeclaration(), "abbreviation X[] or [X*] means Sequential&lt;X&gt;"));
            }
            if (containsSequence) {
                sb.append(this.getLinkMenuItem(unit.getSequenceDeclaration(), "abbreviation [X+] means Sequence&lt;X&gt;"));
            }
            if (containsIterable) {
                sb.append(this.getLinkMenuItem(unit.getIterableDeclaration(), "abbreviation {X+} or {X*} means Iterable&lt;X,Nothing&gt; or Iterable&lt;X,Null&gt;"));
            }
            if (containsEntry) {
                sb.append(this.getLinkMenuItem(unit.getEntryDeclaration(), "abbreviation X-&gt;Y means Entry&lt;X,Y&gt;"));
            }
            if (containsCallable) {
                sb.append(this.getLinkMenuItem(unit.getCallableDeclaration(), "abbreviation X(Y,Z) means Callable&lt;X,[Y,Z]&gt;"));
            }
            if (containsTuple) {
                sb.append(this.getLinkMenuItem(unit.getTupleDeclaration(), "abbreviation [X,Y] means Tuple&lt;X|Y,X,Tuple&lt;Y,Y,[]&gt;&gt;"));
            }
            sb.append("</ul>");
            sb.append("</span>");
            sb.append("</span>");
            return sb.toString();
        }
        return link;
    }

    private boolean canLinkToCeylonLanguageModule() {
        Module currentModule = this.ceylonDocTool.getCurrentModule();
        if (currentModule.isLanguageModule()) {
            return true;
        }
        Module languageModule = currentModule.getLanguageModule();
        String languageModuleUrl = this.getExternalModuleUrl(languageModule);
        return languageModuleUrl != null;
    }

    private void decompose(Type pt, List<Type> producedTypes) {
        if (!producedTypes.contains(pt)) {
            producedTypes.add(pt);
            if (pt.isIntersection()) {
                for (Type satisfiedType : pt.getSatisfiedTypes()) {
                    this.decompose(satisfiedType, producedTypes);
                }
            } else if (pt.isUnion()) {
                for (Type caseType : pt.getCaseTypes()) {
                    this.decompose(caseType, producedTypes);
                }
            }
            if (!pt.getTypeArgumentList().isEmpty()) {
                for (Type typeArgument : pt.getTypeArgumentList()) {
                    this.decompose(typeArgument, producedTypes);
                }
            }
        }
    }

    private String getLinkMenuItem(Declaration decl, String description) {
        String url = new LinkRenderer(this).to(decl).useCustomText("").printLinkDropdownMenu(false).printAbbreviated(false).printTypeParameters(false).getUrl();
        StringBuilder sb = new StringBuilder();
        sb.append("<li>");
        sb.append("<a class='link' href='").append(url).append("'>");
        sb.append("Go to ").append(decl.getName()).append(" ");
        sb.append("<small>").append(description).append("</small>");
        sb.append("</a>");
        sb.append("</li>");
        return sb.toString();
    }

    private Tree.DocLink findDocLink(final String docLinkText, Referenceable referenceable) {
        final Tree.DocLink[] docLinks = new Tree.DocLink[1];
        Node scopeNode = this.ceylonDocTool.getNode(referenceable);
        if (scopeNode != null) {
            scopeNode.visit(new Visitor(){

                @Override
                public void visit(Tree.DocLink docLink) {
                    String s2;
                    String s1 = Util.normalizeSpaces(docLinkText);
                    if (s1.equals(s2 = Util.normalizeSpaces(docLink.getText()))) {
                        docLinks[0] = docLink;
                        return;
                    }
                }
            });
        }
        return docLinks[0];
    }

    private Module getCurrentModule() {
        if (this.scope instanceof Module) {
            return (Module)this.scope;
        }
        if (this.scope instanceof Package) {
            return ((Package)this.scope).getModule();
        }
        if (this.scope instanceof Declaration) {
            return this.scope.getUnit().getPackage().getModule();
        }
        return null;
    }

    private Package getCurrentPackage() {
        if (this.scope instanceof Module) {
            return ((Module)this.scope).getRootPackage();
        }
        if (this.scope instanceof Package) {
            return (Package)this.scope;
        }
        if (this.scope instanceof Declaration) {
            return this.scope.getUnit().getPackage();
        }
        return null;
    }

    private Interface getCurrentInterface() {
        Sourced o = this.scope;
        while (o != null) {
            if (o instanceof Interface) {
                return (Interface)o;
            }
            if (o instanceof Declaration) {
                o = ((Declaration)o).getContainer();
                continue;
            }
            o = null;
        }
        return null;
    }

    private Class getCurrentClass() {
        Sourced o = this.scope;
        while (o != null) {
            if (o instanceof Class) {
                return (Class)o;
            }
            if (o instanceof Declaration) {
                o = ((Declaration)o).getContainer();
                continue;
            }
            o = null;
        }
        return null;
    }
}

