/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.ceylondoc;

import com.github.rjeschke.txtmark.BlockEmitter;
import com.github.rjeschke.txtmark.Configuration;
import com.github.rjeschke.txtmark.Processor;
import com.github.rjeschke.txtmark.SpanEmitter;
import com.redhat.ceylon.ceylondoc.LinkRenderer;
import com.redhat.ceylon.compiler.java.codegen.Decl;
import com.redhat.ceylon.compiler.typechecker.context.PhasedUnit;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.model.typechecker.model.Annotated;
import com.redhat.ceylon.model.typechecker.model.Annotation;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Import;
import com.redhat.ceylon.model.typechecker.model.ModelUtil;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.ModuleImport;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.Referenceable;
import com.redhat.ceylon.model.typechecker.model.Type;
import com.redhat.ceylon.model.typechecker.model.TypeDeclaration;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.Unit;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.io.IOException;
import java.io.StringReader;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.DTD;
import javax.swing.text.html.parser.DocumentParser;
import javax.swing.text.html.parser.ParserDelegator;

public class Util {
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("(?: |\\u00A0|\\s|[\\s&&[^ ]])\\s*");
    private static final Set<String> ABBREVIATED_TYPES = new HashSet<String>();
    private static final int FIRST_LINE_MAX_SIZE = 120;

    public static String normalizeSpaces(String str) {
        if (str == null) {
            return null;
        }
        return WHITESPACE_PATTERN.matcher(str).replaceAll(" ");
    }

    public static boolean isAbbreviatedType(Declaration decl) {
        return ABBREVIATED_TYPES.contains(decl.getQualifiedNameString());
    }

    public static String join(String separator, List<String> parts) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = parts.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(separator);
        }
        return stringBuilder.toString();
    }

    public static String getDoc(Declaration decl, LinkRenderer linkRenderer) {
        return Util.wikiToHTML(Util.getRawDoc(decl), linkRenderer.useScope(decl));
    }

    public static String getDoc(Module module, LinkRenderer linkRenderer) {
        return Util.wikiToHTML(Util.getRawDoc(module.getUnit(), module.getAnnotations()), linkRenderer.useScope(module));
    }

    public static String getDoc(ModuleImport moduleImport, LinkRenderer linkRenderer) {
        return Util.wikiToHTML(Util.getRawDoc(moduleImport.getModule().getUnit(), moduleImport.getAnnotations()), linkRenderer);
    }

    public static String getDoc(Package pkg, LinkRenderer linkRenderer) {
        return Util.wikiToHTML(Util.getRawDoc(pkg.getUnit(), pkg.getAnnotations()), linkRenderer.useScope(pkg));
    }

    public static String getDocFirstLine(Declaration decl, LinkRenderer linkRenderer) {
        return Util.getDocFirstLine(Util.getRawDoc(decl), linkRenderer.useScope(decl));
    }

    public static String getDocFirstLine(Package pkg, LinkRenderer linkRenderer) {
        return Util.getDocFirstLine(Util.getRawDoc(pkg.getUnit(), pkg.getAnnotations()), linkRenderer.useScope(pkg));
    }

    public static String getDocFirstLine(Module module, LinkRenderer linkRenderer) {
        return Util.getDocFirstLine(Util.getRawDoc(module.getUnit(), module.getAnnotations()), linkRenderer.useScope(module));
    }

    public static String getDocFirstLine(String text, LinkRenderer linkRenderer) {
        String html = Util.wikiToHTML(text, linkRenderer);
        FirstLineParser parser = new FirstLineParser();
        return parser.parseFirstLine(html);
    }

    public static <T extends Referenceable & Annotated> List<String> getTags(T decl) {
        ArrayList<String> tags = new ArrayList<String>();
        Annotation tagged = Util.getAnnotation(decl.getUnit(), ((Annotated)decl).getAnnotations(), "tagged");
        if (tagged != null) {
            tags.addAll(tagged.getPositionalArguments());
        }
        return tags;
    }

    public static String wikiToHTML(String text, LinkRenderer linkRenderer) {
        if (text == null || text.length() == 0) {
            return text;
        }
        Configuration config = Configuration.builder().forceExtentedProfile().setCodeBlockEmitter(CeylondocBlockEmitter.INSTANCE).setSpecialLinkEmitter(new CeylondocSpanEmitter(linkRenderer)).build();
        return Processor.process(text, config);
    }

    private static String getRawDoc(Declaration decl) {
        Annotation a = Util.findAnnotation(decl, "doc");
        if (a != null) {
            return a.getPositionalArguments().get(0);
        }
        return "";
    }

    public static String getRawDoc(Unit unit, List<Annotation> anns) {
        Annotation a = Util.getAnnotation(unit, anns, "doc");
        if (a != null && a.getPositionalArguments() != null && !a.getPositionalArguments().isEmpty()) {
            return a.getPositionalArguments().get(0);
        }
        return "";
    }

    public static Annotation getAnnotation(ModuleImport moduleImport, String name) {
        return Util.getAnnotation(moduleImport.getModule().getUnit(), moduleImport.getAnnotations(), name);
    }

    public static Annotation getAnnotation(Unit unit, List<Annotation> annotations, String name) {
        Declaration importedDeclaration;
        String aliasedName = Util.resolveAliasedName(unit, name);
        if (name.equals(aliasedName) && unit != null && (importedDeclaration = unit.getImportedDeclaration(name, null, false)) != null && !importedDeclaration.getNameAsString().startsWith("ceylon.language::")) {
            return null;
        }
        if (annotations != null) {
            for (Annotation a : annotations) {
                if (!a.getName().equals(aliasedName)) continue;
                return a;
            }
        }
        return null;
    }

    public static Annotation findAnnotation(Declaration decl, String name) {
        Annotation a = Util.getAnnotation(decl.getUnit(), decl.getAnnotations(), name);
        if (a == null && decl.isActual() && decl.getRefinedDeclaration() != decl) {
            a = Util.findAnnotation(decl.getRefinedDeclaration(), name);
        }
        return a;
    }

    private static String resolveAliasedName(Unit unit, String name) {
        if (unit != null) {
            for (Import i : unit.getImports()) {
                if (i.isAmbiguous() || !i.getDeclaration().getQualifiedNameString().equals("ceylon.language::" + name)) continue;
                return i.getAlias();
            }
        }
        return name;
    }

    public static String capitalize(String text) {
        char[] buffer = text.toCharArray();
        boolean capitalizeNext = true;
        for (int i = 0; i < buffer.length; ++i) {
            char ch = buffer[i];
            if (Character.isWhitespace(ch)) {
                capitalizeNext = true;
                continue;
            }
            if (!capitalizeNext) continue;
            buffer[i] = Character.toTitleCase(ch);
            capitalizeNext = false;
        }
        return new String(buffer);
    }

    public static String getModifiers(Declaration d) {
        StringBuilder modifiers = new StringBuilder();
        if (d.isShared()) {
            modifiers.append("shared ");
        }
        if (d.isStatic()) {
            modifiers.append("static ");
        }
        if (d.isFormal()) {
            modifiers.append("formal ");
        } else {
            if (d.isActual()) {
                modifiers.append("actual ");
            }
            if (d.isDefault()) {
                modifiers.append("default ");
            }
        }
        if (Decl.isValue(d)) {
            Value v = (Value)d;
            if (v.isVariable()) {
                modifiers.append("variable ");
            }
        } else if (d instanceof Class) {
            Class c = (Class)d;
            if (c.isAbstract()) {
                modifiers.append("abstract ");
            }
            if (c.isFinal() && !c.isAnonymous()) {
                modifiers.append("final ");
            }
            if (c.isSealed()) {
                modifiers.append("sealed ");
            }
        }
        return modifiers.toString().trim();
    }

    public static List<TypeDeclaration> getAncestors(TypeDeclaration decl) {
        ArrayList<TypeDeclaration> ancestors = new ArrayList<TypeDeclaration>();
        for (Type ancestor = decl.getExtendedType(); ancestor != null; ancestor = ancestor.getExtendedType()) {
            ancestors.add(ancestor.getDeclaration());
        }
        return ancestors;
    }

    public static List<TypeDeclaration> getSuperInterfaces(TypeDeclaration decl) {
        HashSet<TypeDeclaration> superInterfaces = new HashSet<TypeDeclaration>();
        for (Type satisfiedType : decl.getSatisfiedTypes()) {
            superInterfaces.add(satisfiedType.getDeclaration());
            superInterfaces.addAll(Util.getSuperInterfaces(satisfiedType.getDeclaration()));
        }
        ArrayList<TypeDeclaration> list = new ArrayList<TypeDeclaration>();
        list.addAll(superInterfaces);
        Util.removeDuplicates(list);
        return list;
    }

    private static void removeDuplicates(List<TypeDeclaration> superInterfaces) {
        block0: for (int i = 0; i < superInterfaces.size(); ++i) {
            TypeDeclaration decl1 = superInterfaces.get(i);
            for (int j = i + 1; j < superInterfaces.size(); ++j) {
                TypeDeclaration decl2 = superInterfaces.get(j);
                if (!decl1.equals(decl2)) continue;
                if (decl1.getType().isSubtypeOf(decl2.getType())) {
                    superInterfaces.remove(j);
                    continue block0;
                }
                superInterfaces.remove(i);
                --i;
                continue block0;
            }
        }
    }

    public static boolean isEmpty(String s) {
        return s == null || s.isEmpty();
    }

    public static boolean isEmpty(Collection<?> c) {
        return c == null || c.isEmpty();
    }

    public static boolean isThrowable(TypeDeclaration c) {
        if (c instanceof Class) {
            if ("ceylon.language::Throwable".equals(c.getQualifiedNameString())) {
                return true;
            }
            if (c.getExtendedType() != null) {
                return Util.isThrowable(c.getExtendedType().getDeclaration());
            }
        }
        return false;
    }

    public static String getUnitPackageName(PhasedUnit unit) {
        String file;
        String path = unit.getPathRelativeToSrcDir();
        if (!path.endsWith(file = unit.getUnitFile().getName())) {
            throw new RuntimeException("Unit relative path does not end with unit file name: " + path + " and " + file);
        }
        if ((path = path.substring(0, path.length() - file.length())).endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path.replace('/', '.');
    }

    public static String getQuotedFQN(String pkgName, Tree.Declaration decl) {
        String name = decl.getIdentifier().getText();
        return pkgName.isEmpty() ? name : com.redhat.ceylon.compiler.java.util.Util.quoteJavaKeywords(pkgName) + "." + name;
    }

    public static Declaration findBottomMostRefinedDeclaration(TypedDeclaration d) {
        if (d.getContainer() instanceof TypeDeclaration) {
            LinkedList<TypeDeclaration> queue = new LinkedList<TypeDeclaration>();
            queue.add((TypeDeclaration)d.getContainer());
            return Util.findBottomMostRefinedDeclaration(d, queue);
        }
        return null;
    }

    private static Declaration findBottomMostRefinedDeclaration(TypedDeclaration d, Queue<TypeDeclaration> queue) {
        TypeDeclaration type = queue.poll();
        if (type != null) {
            Declaration member;
            if (type != d.getContainer() && (member = type.getDirectMember(d.getName(), null, false)) != null && member.isActual()) {
                return member;
            }
            if (type.getExtendedType() != null) {
                queue.add(type.getExtendedType().getDeclaration());
            }
            for (Type satisfiedType : type.getSatisfiedTypes()) {
                queue.add(satisfiedType.getDeclaration());
            }
            return Util.findBottomMostRefinedDeclaration(d, queue);
        }
        return null;
    }

    public static String getNameWithContainer(Declaration d) {
        return "<code><span class='type-identifier'>" + ((TypeDeclaration)d.getContainer()).getName() + "</span>.<span class='" + (d instanceof TypeDeclaration ? "type-identifier" : "identifier") + "'>" + d.getName() + "</span></code>";
    }

    static int nullSafeCompare(String s1, String s2) {
        if (s1 == s2) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        return s1.compareTo(s2);
    }

    public static boolean isEnumerated(TypeDeclaration klass) {
        return klass.getCaseTypes() != null && !klass.getCaseTypes().isEmpty();
    }

    public static String getDeclarationName(Declaration decl) {
        String name = decl.getName();
        if (ModelUtil.isConstructor(decl) && name == null) {
            name = ((TypeDeclaration)decl.getContainer()).getName();
        }
        return name;
    }

    static {
        ABBREVIATED_TYPES.add("ceylon.language::Empty");
        ABBREVIATED_TYPES.add("ceylon.language::Entry");
        ABBREVIATED_TYPES.add("ceylon.language::Sequence");
        ABBREVIATED_TYPES.add("ceylon.language::Sequential");
        ABBREVIATED_TYPES.add("ceylon.language::Iterable");
    }

    public static class ModuleImportComparatorByName
    implements Comparator<ModuleImport> {
        public static final ModuleImportComparatorByName INSTANCE = new ModuleImportComparatorByName();

        @Override
        public int compare(ModuleImport a, ModuleImport b) {
            return Util.nullSafeCompare(a.getModule().getNameAsString(), b.getModule().getNameAsString());
        }
    }

    public static class TypeComparatorByName
    implements Comparator<Type> {
        public static final TypeComparatorByName INSTANCE = new TypeComparatorByName();

        @Override
        public int compare(Type a, Type b) {
            return Util.nullSafeCompare(a.getDeclaration().getName(), b.getDeclaration().getName());
        }
    }

    public static class ReferenceableComparatorByName
    implements Comparator<Referenceable> {
        public static final ReferenceableComparatorByName INSTANCE = new ReferenceableComparatorByName();

        @Override
        public int compare(Referenceable a, Referenceable b) {
            return Util.nullSafeCompare(a.getNameAsString(), b.getNameAsString());
        }
    }

    private static class CeylondocSpanEmitter
    implements SpanEmitter {
        private final LinkRenderer linkRenderer;

        public CeylondocSpanEmitter(LinkRenderer linkRenderer) {
            this.linkRenderer = linkRenderer;
        }

        @Override
        public void emitSpan(StringBuilder out, String content) {
            int pipeIndex = content.indexOf("|");
            String customText = pipeIndex != -1 ? content.substring(0, pipeIndex) : null;
            String link = new LinkRenderer(this.linkRenderer).to(content).withinText(true).useCustomText(customText).printTypeParameters(false).printWikiStyleLinks(true).getLink();
            out.append(link);
        }
    }

    private static class CeylondocBlockEmitter
    implements BlockEmitter {
        private static final CeylondocBlockEmitter INSTANCE = new CeylondocBlockEmitter();

        private CeylondocBlockEmitter() {
        }

        @Override
        public void emitBlock(StringBuilder out, List<String> lines, String meta) {
            if (lines.isEmpty()) {
                return;
            }
            if (meta == null || meta.length() == 0) {
                out.append("<pre data-language=\"ceylon\">");
            } else {
                out.append("<pre data-language=\"").append(meta).append("\">");
            }
            for (String s : lines) {
                block6: for (int i = 0; i < s.length(); ++i) {
                    char c = s.charAt(i);
                    switch (c) {
                        case '&': {
                            out.append("&amp;");
                            continue block6;
                        }
                        case '<': {
                            out.append("&lt;");
                            continue block6;
                        }
                        case '>': {
                            out.append("&gt;");
                            continue block6;
                        }
                        default: {
                            out.append(c);
                        }
                    }
                }
                out.append('\n');
            }
            out.append("</pre>\n");
        }
    }

    private static class FirstLineParser
    extends DocumentParser {
        private boolean done = false;
        private boolean dots = false;
        private int lastPosition = 0;
        private List<HTML.Tag> impliedTags = new ArrayList<HTML.Tag>();
        private List<HTML.Tag> openedTags = new ArrayList<HTML.Tag>();
        private StringBuilder textBuilder = new StringBuilder();

        private static DTD getDTD() {
            try {
                new ParserDelegator();
                return DTD.getDTD("html32");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private FirstLineParser() {
            super(FirstLineParser.getDTD());
        }

        private String parseFirstLine(String html) {
            try {
                this.parse(new StringReader(html), new FirstLineParserCallback(), true);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            StringBuilder result = new StringBuilder();
            result.append(html.substring(0, this.lastPosition).replaceAll("\\s*$", ""));
            if (this.dots) {
                result.append("\u2026");
            }
            if (!this.openedTags.isEmpty()) {
                Collections.reverse(this.openedTags);
                for (HTML.Tag t : this.openedTags) {
                    result.append("</").append(t).append(">");
                }
            }
            return result.toString();
        }

        private class FirstLineParserCallback
        extends HTMLEditorKit.ParserCallback {
            private FirstLineParserCallback() {
            }

            @Override
            public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
                if (FirstLineParser.this.done) {
                    return;
                }
                if (a.isDefined(IMPLIED)) {
                    FirstLineParser.this.impliedTags.add(t);
                    return;
                }
                if (t.isBlock() && FirstLineParser.this.textBuilder.length() > 0) {
                    FirstLineParser.this.done = true;
                    return;
                }
                FirstLineParser.this.openedTags.add(t);
                FirstLineParser.this.lastPosition = FirstLineParser.this.getCurrentPos();
            }

            @Override
            public void handleEndTag(HTML.Tag t, int pos) {
                if (FirstLineParser.this.done) {
                    return;
                }
                if (FirstLineParser.this.impliedTags.contains(t)) {
                    FirstLineParser.this.impliedTags.remove(t);
                    return;
                }
                int lastIndexOf = FirstLineParser.this.openedTags.lastIndexOf(t);
                if (lastIndexOf != -1) {
                    FirstLineParser.this.openedTags.remove(lastIndexOf);
                }
                FirstLineParser.this.lastPosition = FirstLineParser.this.getCurrentPos();
            }

            @Override
            public void handleSimpleTag(HTML.Tag t, MutableAttributeSet a, int pos) {
                if (FirstLineParser.this.done) {
                    return;
                }
                FirstLineParser.this.lastPosition = FirstLineParser.this.getCurrentPos();
            }

            @Override
            public void handleText(char[] data, int pos) {
                if (FirstLineParser.this.done) {
                    return;
                }
                FirstLineParser.this.textBuilder.append(data);
                String text = FirstLineParser.this.textBuilder.toString().replaceAll("\\s*$", "");
                String firstLine = this.trimFirstLine(text);
                if (!text.equals(firstLine)) {
                    FirstLineParser.this.done = true;
                    FirstLineParser.this.lastPosition += data.length - (text.length() - firstLine.length());
                    return;
                }
                FirstLineParser.this.lastPosition = FirstLineParser.this.getCurrentPos();
            }

            private String trimFirstLine(String text) {
                if (text == null) {
                    return "";
                }
                BreakIterator breaker = BreakIterator.getSentenceInstance();
                breaker.setText(text);
                breaker.first();
                int dot = breaker.next();
                if (dot != -1 && dot <= 120) {
                    return text.substring(0, dot).replaceAll("\\s*$", "");
                }
                if (text.length() <= 120) {
                    return text;
                }
                breaker = BreakIterator.getWordInstance();
                breaker.setText(text);
                int pos = breaker.first();
                while (pos < 120 && pos != -1) {
                    pos = breaker.next();
                }
                if (pos != -1 && breaker.previous() != -1) {
                    FirstLineParser.this.dots = true;
                    return text.substring(0, breaker.current()).replaceAll("\\s*$", "");
                }
                FirstLineParser.this.dots = true;
                return text.substring(0, 119);
            }
        }
    }
}

