/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.CmrRepository;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.impl.AbstractCeylonArtifactResult;
import com.redhat.ceylon.cmr.impl.AbstractRepository;
import com.redhat.ceylon.cmr.impl.NodeUtils;
import com.redhat.ceylon.cmr.spi.Node;
import com.redhat.ceylon.cmr.spi.OpenNode;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.cmr.Repository;
import com.redhat.ceylon.model.cmr.RepositoryException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class DefaultRepository
extends AbstractRepository {
    public static final String NAMESPACE = "ceylon";

    public DefaultRepository(OpenNode root) {
        super(root);
    }

    @Override
    protected ArtifactResult getArtifactResultInternal(RepositoryManager manager, Node node) {
        return new DefaultArtifactResult(this, manager, node);
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    protected static class DefaultArtifactResult
    extends AbstractCeylonArtifactResult {
        private Node node;

        protected DefaultArtifactResult(CmrRepository repository, RepositoryManager manager, Node node) {
            super((Repository)repository, manager, ArtifactContext.fromNode(node).getName(), ArtifactContext.fromNode(node).getVersion());
            this.node = node;
        }

        @Override
        protected File artifactInternal() throws RepositoryException {
            try {
                return this.node.getContent(File.class);
            }
            catch (IOException e) {
                throw new RepositoryException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String repositoryDisplayString() {
            String repositoryDisplayString = NodeUtils.getRepositoryDisplayString(this.node);
            File artifact = this.artifact();
            File originFile = new File(artifact.getParentFile(), artifact.getName() + ".origin");
            if (originFile.exists()) {
                try (BufferedReader reader = new BufferedReader(new FileReader(originFile));){
                    String line = reader.readLine();
                    if (line != null && !line.trim().isEmpty()) {
                        repositoryDisplayString = line;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return repositoryDisplayString;
        }
    }
}

