/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.api.AbstractDependencyResolverAndModuleInfoReader;
import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.DependencyContext;
import com.redhat.ceylon.cmr.api.ModuleDependencyInfo;
import com.redhat.ceylon.cmr.api.ModuleInfo;
import com.redhat.ceylon.cmr.api.ModuleVersionArtifact;
import com.redhat.ceylon.cmr.api.ModuleVersionDetails;
import com.redhat.ceylon.cmr.api.Overrides;
import com.redhat.ceylon.cmr.resolver.javascript.JavaScriptResolver;
import com.redhat.ceylon.cmr.spi.Node;
import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class JSUtils
extends AbstractDependencyResolverAndModuleInfoReader {
    private JavaScriptResolver resolver = new JavaScriptResolver();

    @Override
    public ModuleInfo resolve(DependencyContext context, Overrides overrides) {
        if (context.ignoreInner()) {
            return null;
        }
        ArtifactResult result = context.result();
        File mod = result.artifact();
        if (mod != null && (mod.getName().toLowerCase().endsWith("-model.js") || mod.getName().toLowerCase().endsWith(".js"))) {
            return this.readModuleInformation(result.name(), mod, overrides);
        }
        return null;
    }

    @Override
    public ModuleInfo resolveFromFile(File file, String name, String version2, Overrides overrides) {
        throw new UnsupportedOperationException("Operation not supported for .js files");
    }

    @Override
    public ModuleInfo resolveFromInputStream(InputStream stream, String name, String version2, Overrides overrides) {
        throw new UnsupportedOperationException("Operation not supported for .js files");
    }

    @Override
    public Node descriptor(Node artifact) {
        return null;
    }

    private ModuleInfo readModuleInformation(String moduleName, File jarFile, Overrides overrides) {
        Map<String, Object> model = this.loadJsonModel(jarFile);
        String version2 = this.asString(this.metaModelProperty(model, "$mod-version"));
        return this.getModuleInfo(model, moduleName, version2, overrides);
    }

    @Override
    public int[] getBinaryVersions(String moduleName, String version2, File moduleArchive) {
        int major = 0;
        int minor = 0;
        ModuleVersionDetails mvd = this.readModuleInfo(moduleName, version2, moduleArchive, false, null);
        ModuleVersionArtifact mva = (ModuleVersionArtifact)mvd.getArtifactTypes().first();
        if (mva.getMajorBinaryVersion() != null) {
            major = mva.getMajorBinaryVersion();
        }
        if (mva.getMinorBinaryVersion() != null) {
            minor = mva.getMinorBinaryVersion();
        }
        return new int[]{major, minor};
    }

    private ModuleInfo getModuleInfo(Map<String, Object> model, String module, String version2, Overrides overrides) {
        try {
            return this.getModuleInfo(this.metaModelProperty(model, "$mod-deps"), module, version2, overrides);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to parse module JS file", ex);
        }
    }

    @Override
    public ModuleVersionDetails readModuleInfo(String moduleName, String moduleVersion, File moduleArchive, boolean includeMembers, Overrides overrides) {
        Map<String, Object> model = this.loadJsonModel(moduleArchive);
        String name = this.asString(this.metaModelProperty(model, "$mod-name"));
        if (!moduleName.equals(name)) {
            throw new RuntimeException("Incorrect module");
        }
        String version2 = this.asString(this.metaModelProperty(model, "$mod-version"));
        Set<ModuleDependencyInfo> dependencies = this.getModuleInfo(model, moduleName, version2, overrides).getDependencies();
        String type = ArtifactContext.getSuffixFromFilename(moduleArchive.getName());
        Integer major = null;
        Integer minor = null;
        String bin = this.asString(this.metaModelProperty(model, "$mod-bin"));
        if (bin != null) {
            int p = bin.indexOf(46);
            if (p >= 0) {
                major = Integer.parseInt(bin.substring(0, p));
                minor = Integer.parseInt(bin.substring(p + 1));
            } else {
                major = Integer.parseInt(bin);
            }
        }
        ModuleVersionDetails mvd = new ModuleVersionDetails(null, moduleName, version2, null, null);
        mvd.getArtifactTypes().add(new ModuleVersionArtifact(type, major, minor));
        mvd.getDependencies().addAll(dependencies);
        Object anns = this.metaModelProperty(model, "$mod-anns");
        List annotations = null;
        if (anns instanceof Map) {
            annotations = new ArrayList<Map>(1);
            annotations.add((Map)anns);
        } else if (anns instanceof List) {
            annotations = (List)anns;
        }
        if (annotations != null) {
            for (Map annot : annotations) {
                Iterable by;
                if (annot.containsKey("doc")) {
                    mvd.setDoc(this.asString(annot.get("doc")));
                }
                if (annot.containsKey("license")) {
                    mvd.setLicense(this.asString(annot.get("license")));
                }
                if (!annot.containsKey("by") || (by = (Iterable)annot.get("by")) == null) continue;
                for (String author : by) {
                    mvd.getAuthors().add(author);
                }
            }
        }
        if (includeMembers) {
            mvd.setMembers(this.getMembers(moduleName, moduleArchive));
        }
        return mvd;
    }

    private Set<String> getMembers(String moduleName, File moduleArchive) {
        throw new RuntimeException("Not implemented yet");
    }

    private Object metaModelProperty(Map<String, Object> model, String propName) {
        return model.get(propName);
    }

    private String asString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Iterable) {
            Iterator iter = ((Iterable)obj).iterator();
            return iter.hasNext() ? (String)iter.next() : null;
        }
        return obj.toString();
    }

    private ModuleInfo getModuleInfo(Object obj, String moduleName, String version2, Overrides overrides) {
        if (obj == null) {
            return new ModuleInfo(moduleName, version2, null, null, null, Collections.emptySet());
        }
        if (!(obj instanceof Iterable)) {
            throw new RuntimeException("Expected something Iterable");
        }
        Iterable array = (Iterable)obj;
        HashSet<ModuleDependencyInfo> deps = new HashSet<ModuleDependencyInfo>();
        for (Object o : array) {
            String module;
            boolean optional = false;
            boolean exported = false;
            if (o instanceof String) {
                module = this.asString(o);
            } else {
                Map m = (Map)o;
                module = m.get("path").toString();
                optional = m.containsKey("opt");
                exported = m.containsKey("exp");
            }
            String depUri = ModuleUtil.moduleName(module);
            String namespace = ModuleUtil.getNamespaceFromUri(depUri);
            String modName = ModuleUtil.getModuleNameFromUri(depUri);
            deps.add(new ModuleDependencyInfo(namespace, modName, ModuleUtil.moduleVersion(module), optional, exported, Backends.JS));
        }
        ModuleInfo result = new ModuleInfo(moduleName, version2, null, null, null, deps);
        if (overrides != null) {
            result = overrides.applyOverrides(moduleName, version2, result);
        }
        return result;
    }

    @Override
    public boolean matchesModuleInfo(String moduleName, String moduleVersion, File moduleArchive, String query, Overrides overrides) {
        ModuleVersionDetails mvd = this.readModuleInfo(moduleName, moduleVersion, moduleArchive, false, overrides);
        if (mvd.getDoc() != null && this.matches(mvd.getDoc(), query)) {
            return true;
        }
        if (mvd.getLicense() != null && this.matches(mvd.getLicense(), query)) {
            return true;
        }
        for (String author : mvd.getAuthors()) {
            if (!this.matches(author, query)) continue;
            return true;
        }
        for (ModuleDependencyInfo dep : mvd.getDependencies()) {
            if (!this.matches(dep.getModuleName(), query)) continue;
            return true;
        }
        return false;
    }

    private boolean matches(String string, String query) {
        return string.toLowerCase().contains(query);
    }

    private Map<String, Object> loadJsonModel(File jsFile) {
        try {
            Map<String, Object> model;
            String name = jsFile.getName().toLowerCase();
            if (!name.endsWith("-model.js") && name.endsWith(".js")) {
                name = jsFile.getName();
                name = name.substring(0, name.length() - 3) + "-model.js";
                File modelFile = new File(jsFile.getParentFile(), name);
                if (modelFile.isFile()) {
                    jsFile = modelFile;
                }
            }
            if ((model = JavaScriptResolver.readJsonModel(jsFile)) == null) {
                throw new RuntimeException("Unable to read meta model from file " + jsFile);
            }
            return model;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

