/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.impl.AbstractContentStore;
import com.redhat.ceylon.cmr.impl.DefaultNode;
import com.redhat.ceylon.cmr.impl.FileContentStore;
import com.redhat.ceylon.cmr.impl.RootNode;
import com.redhat.ceylon.cmr.resolver.javascript.JavaScriptResolver;
import com.redhat.ceylon.cmr.spi.ContentHandle;
import com.redhat.ceylon.cmr.spi.ContentOptions;
import com.redhat.ceylon.cmr.spi.Node;
import com.redhat.ceylon.cmr.spi.OpenNode;
import com.redhat.ceylon.common.log.Logger;
import com.redhat.ceylon.model.cmr.RepositoryException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

public class NpmContentStore
extends AbstractContentStore {
    private final File out;
    private final FileContentStore[] stores;
    private final FileContentStore outstore;
    private String npmCommand;
    private String path;

    public NpmContentStore(File[] roots, File out, Logger log, boolean offline) {
        super(log, offline, -1);
        assert (roots.length > 0);
        this.stores = new FileContentStore[roots.length];
        int i = 0;
        for (File root : roots) {
            this.stores[i++] = new FileContentStore(root);
        }
        this.out = out;
        this.outstore = out != null ? new FileContentStore(out) : null;
    }

    @Override
    public Iterable<File> getBaseDirectories() {
        ArrayList<File> baseDirectories = new ArrayList<File>(this.stores.length);
        for (FileContentStore store : this.stores) {
            for (File baseDir : store.getBaseDirectories()) {
                baseDirectories.add(baseDir);
            }
        }
        baseDirectories.add(this.out);
        return baseDirectories;
    }

    @Override
    public OpenNode createRoot() {
        return new RootNode(this, this);
    }

    @Override
    public OpenNode find(Node parent, String child) {
        DefaultNode node = null;
        if (!this.hasContent(child)) {
            node = new DefaultNode(child);
            node.setContentMarker();
            return node;
        }
        if (ArtifactContext.getSuffixFromFilename(child).equals(".js")) {
            child = this.getTrueArtifactName(parent);
        }
        for (FileContentStore store : this.stores) {
            OpenNode result = store.find(parent, child);
            if (result == null) continue;
            return result;
        }
        this.installNpmModule(parent);
        return this.outstore.find(parent, child);
    }

    @Override
    public ContentHandle peekContent(Node node) {
        for (FileContentStore store : this.stores) {
            ContentHandle result = store.peekContent(node);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getTrueArtifactName(Node parent) {
        Node node = parent.getChild("package.json");
        try {
            File json = node.getContent(File.class);
            if (!json.exists()) throw new RepositoryException("npm descriptor not found: " + json);
            if (!json.isFile()) throw new RepositoryException("npm descriptor not found: " + json);
            if (!json.canRead()) throw new RepositoryException("npm descriptor not found: " + json);
            try (FileReader reader = new FileReader(json);){
                Map<String, Object> descriptor = JavaScriptResolver.readNpmDescriptor(json);
                Object main = descriptor.get("main");
                if (main instanceof String) {
                    String string = (String)main;
                    return string;
                }
                if (main == null) {
                    String string = "index.js";
                    return string;
                }
                throw new RepositoryException("unexpected value for 'main' in npm descriptor: " + json);
            }
        }
        catch (IOException ex) {
            throw new RepositoryException("error reading npm descriptor: " + this.out + "/package.json", ex);
        }
    }

    @Override
    public ContentHandle getContent(Node node) throws IOException {
        ContentHandle result = this.peekContent(node);
        if (result != null) {
            return result;
        }
        if (this.outstore != null) {
            this.installNpmModule(node);
            return this.outstore.getContent(node);
        }
        return this.stores[0].getContent(node);
    }

    public void installNpmModule(Node node) {
        try {
            String module;
            if (!this.out.exists()) {
                this.out.mkdirs();
            }
            ArtifactContext ac = ArtifactContext.fromNode(node);
            String name = ac.getName();
            String version2 = ac.getVersion();
            String string = module = version2.isEmpty() ? name : name + "@" + version2;
            if (this.log != null) {
                this.log.debug("installing npm module " + module + " in " + this.out);
            }
            String npmCmd = this.npmCommand != null ? this.npmCommand : System.getProperty("ceylon.command.npm", "npm");
            ProcessBuilder pb = new ProcessBuilder(new String[0]).command(npmCmd, "install", "--silent", "--no-bin-links", module).directory(this.out.getParentFile()).inheritIO();
            Map<String, String> env = pb.environment();
            String pathVariableName = "PATH";
            for (String key : env.keySet()) {
                if (!key.equalsIgnoreCase("path")) continue;
                pathVariableName = key;
                break;
            }
            String pathForRunningNpm = this.path != null ? this.path : System.getProperty("ceylon.command.path", System.getenv("PATH"));
            env.put(pathVariableName, pathForRunningNpm);
            Process p = pb.start();
            p.waitFor();
            if (p.exitValue() != 0) {
                throw new RepositoryException("npm installer failed with exit code: " + p.exitValue());
            }
        }
        catch (IOException | InterruptedException ex) {
            throw new RepositoryException("error running npm installer (make sure 'npm' is installed and available in your PATH)", ex);
        }
    }

    @Override
    public ContentHandle putContent(Node node, InputStream stream, ContentOptions options) throws IOException {
        if (this.outstore != null) {
            return this.outstore.putContent(node, stream, options);
        }
        return null;
    }

    @Override
    public OpenNode create(Node parent, String child) {
        if (this.outstore != null) {
            return this.outstore.create(parent, child);
        }
        return null;
    }

    @Override
    public Iterable<? extends OpenNode> find(Node parent) {
        return Collections.emptyList();
    }

    @Override
    public String getDisplayString() {
        String name = "npm";
        if (this.offline) {
            name = name + " (offline)";
        }
        return name;
    }

    @Override
    public boolean isHerd() {
        return false;
    }

    @Override
    public boolean canHandleFolders() {
        return false;
    }

    public void setNpmCommand(String npmCommand) {
        this.npmCommand = npmCommand;
    }

    public void setPathForRunningNpm(String path) {
        this.path = path;
    }
}

