/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.api.CmrRepository;
import com.redhat.ceylon.cmr.api.RepositoryBuilder;
import com.redhat.ceylon.cmr.impl.NpmContentStore;
import com.redhat.ceylon.cmr.impl.NpmRepository;
import com.redhat.ceylon.common.FileUtil;
import com.redhat.ceylon.common.log.Logger;
import java.io.File;

public class NpmRepositoryBuilder
implements RepositoryBuilder {
    @Override
    public String absolute(File cwd, String token) {
        if (token.equals("npm:") || token.equals("npm:/#")) {
            return "npm:";
        }
        if (token.startsWith("npm:")) {
            token = token.substring(4);
            File f = FileUtil.absoluteFile(FileUtil.applyCwd(cwd, new File(token)));
            token = f.getAbsolutePath();
            return "npm:" + token;
        }
        return null;
    }

    @Override
    public CmrRepository[] buildRepository(String token) throws Exception {
        return this.buildRepository(token, EMPTY_CONFIG);
    }

    @Override
    public CmrRepository[] buildRepository(String token, RepositoryBuilder.RepositoryBuilderConfig config) throws Exception {
        if (token.equals("npm:/#")) {
            token = "npm:";
        }
        if (token.startsWith("npm:")) {
            CmrRepository repo = NpmRepositoryBuilder.createNpmRepository(token, config.log, config.offline, config.currentDirectory);
            return new CmrRepository[]{repo};
        }
        return null;
    }

    public static CmrRepository createNpmRepository(String token, Logger log, boolean offline, String currentDirectory) {
        File[] roots;
        File local = new File(currentDirectory, "node_modules");
        String nodePath = token.substring(4);
        if (nodePath.isEmpty() && ((nodePath = System.getenv("NODE_PATH")) == null || nodePath.isEmpty())) {
            nodePath = local.getAbsolutePath();
        }
        File out = (roots = FileUtil.pathToFileArray(currentDirectory, nodePath)).length > 1 ? local : roots[0];
        NpmContentStore cs = new NpmContentStore(roots, out, log, offline);
        return new NpmRepository(cs.createRoot());
    }
}

