/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.api.AbstractDependencyResolverAndModuleInfoReader;
import com.redhat.ceylon.cmr.api.ArtifactContext;
import com.redhat.ceylon.cmr.api.DependencyContext;
import com.redhat.ceylon.cmr.api.ModuleDependencyInfo;
import com.redhat.ceylon.cmr.api.ModuleInfo;
import com.redhat.ceylon.cmr.api.ModuleVersionArtifact;
import com.redhat.ceylon.cmr.api.ModuleVersionDetails;
import com.redhat.ceylon.cmr.api.Overrides;
import com.redhat.ceylon.cmr.impl.NodeUtils;
import com.redhat.ceylon.cmr.resolver.javascript.JavaScriptResolver;
import com.redhat.ceylon.cmr.spi.Node;
import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class NpmUtils
extends AbstractDependencyResolverAndModuleInfoReader {
    private JavaScriptResolver resolver = new JavaScriptResolver();

    @Override
    public ModuleInfo resolve(DependencyContext context, Overrides overrides) {
        if (context.ignoreInner()) {
            return null;
        }
        ArtifactResult result = context.result();
        File mod = result.artifact();
        File pkgFile = this.findNpmDescriptor(mod);
        if (pkgFile != null) {
            return this.readModuleInformation(result.name(), pkgFile, overrides);
        }
        return null;
    }

    @Override
    public ModuleInfo resolveFromFile(File file, String name, String version2, Overrides overrides) {
        throw new UnsupportedOperationException("Operation not supported for .js files");
    }

    @Override
    public ModuleInfo resolveFromInputStream(InputStream stream, String name, String version2, Overrides overrides) {
        throw new UnsupportedOperationException("Operation not supported for .js files");
    }

    @Override
    public Node descriptor(Node artifact) {
        return NodeUtils.firstParent(artifact).getChild("package.json");
    }

    @Override
    public int[] getBinaryVersions(String moduleName, String version2, File moduleArchive) {
        int major = 0;
        int minor = 0;
        ModuleVersionDetails mvd = this.readModuleInfo(moduleName, version2, moduleArchive, false, null);
        ModuleVersionArtifact mva = (ModuleVersionArtifact)mvd.getArtifactTypes().first();
        if (mva.getMajorBinaryVersion() != null) {
            major = mva.getMajorBinaryVersion();
        }
        if (mva.getMinorBinaryVersion() != null) {
            minor = mva.getMinorBinaryVersion();
        }
        return new int[]{major, minor};
    }

    private ModuleInfo readModuleInformation(String moduleName, File jarFile, Overrides overrides) {
        Map<String, Object> model = this.loadJsonModel(jarFile);
        String version2 = this.asString(this.metaModelProperty(model, "version"));
        return this.getModuleInfo(model, moduleName, version2, overrides);
    }

    @Override
    public ModuleVersionDetails readModuleInfo(String moduleName, String moduleVersion, File moduleArchive, boolean includeMembers, Overrides overrides) {
        Iterable contributors;
        Map<String, Object> model = this.loadJsonModel(moduleArchive);
        String name = this.asString(this.metaModelProperty(model, "name"));
        if (!moduleName.equals(name)) {
            throw new RuntimeException("Incorrect module");
        }
        String version2 = this.asString(this.metaModelProperty(model, "version"));
        Set<ModuleDependencyInfo> dependencies = this.getModuleInfo(model, moduleName, version2, overrides).getDependencies();
        String type = ArtifactContext.getSuffixFromFilename(moduleArchive.getName());
        ModuleVersionDetails mvd = new ModuleVersionDetails(null, moduleName, version2, null, null);
        mvd.getArtifactTypes().add(new ModuleVersionArtifact(type, null, null));
        mvd.getDependencies().addAll(dependencies);
        mvd.setDoc(this.asString(model.get("description")));
        mvd.setLicense(this.asString(model.get("license")));
        String author = this.asString(model.get("author.name"));
        if (author != null) {
            mvd.getAuthors().add(author);
        }
        if ((contributors = (Iterable)model.get("contributors")) != null) {
            for (Map contrib : contributors) {
                mvd.getAuthors().add(this.asString(contrib.get("name")));
            }
        }
        if (includeMembers) {
            mvd.setMembers(this.getMembers(moduleName, moduleArchive));
        }
        return mvd;
    }

    private Set<String> getMembers(String moduleName, File moduleArchive) {
        throw new RuntimeException("Not implemented yet");
    }

    private Object metaModelProperty(Map<String, Object> model, String propName) {
        String[] names = propName.split("\\.");
        for (int i = 0; i < names.length - 1; ++i) {
            if ((model = (Map)model.get(names[i])) != null) continue;
            return null;
        }
        return model.get(propName);
    }

    private String asString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Iterable) {
            Iterator iter = ((Iterable)obj).iterator();
            return iter.hasNext() ? (String)iter.next() : null;
        }
        return obj.toString();
    }

    private ModuleInfo getModuleInfo(Map<String, Object> model, String module, String version2, Overrides overrides) {
        try {
            return this.getModuleInfo(this.metaModelProperty(model, "dependencies"), module, version2, overrides);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to parse NPM package.json file", ex);
        }
    }

    private ModuleInfo getModuleInfo(Object obj, String moduleName, String version2, Overrides overrides) {
        if (obj == null) {
            return new ModuleInfo(moduleName, version2, null, null, null, Collections.emptySet());
        }
        if (!(obj instanceof Map)) {
            throw new RuntimeException("Expected an Object");
        }
        Map map = (Map)obj;
        HashSet<ModuleDependencyInfo> deps = new HashSet<ModuleDependencyInfo>();
        for (String depName : map.keySet()) {
            String depVersion = this.asString(map.get(depName));
            deps.add(new ModuleDependencyInfo("npm", depName, depVersion, false, false, Backends.JS));
        }
        ModuleInfo result = new ModuleInfo(moduleName, version2, null, null, null, deps);
        if (overrides != null) {
            result = overrides.applyOverrides(moduleName, version2, result);
        }
        return result;
    }

    @Override
    public boolean matchesModuleInfo(String moduleName, String moduleVersion, File moduleArchive, String query, Overrides overrides) {
        ModuleVersionDetails mvd = this.readModuleInfo(moduleName, moduleVersion, moduleArchive, false, overrides);
        if (mvd.getDoc() != null && this.matches(mvd.getDoc(), query)) {
            return true;
        }
        if (mvd.getLicense() != null && this.matches(mvd.getLicense(), query)) {
            return true;
        }
        for (String author : mvd.getAuthors()) {
            if (!this.matches(author, query)) continue;
            return true;
        }
        for (ModuleDependencyInfo dep : mvd.getDependencies()) {
            if (!this.matches(dep.getModuleName(), query)) continue;
            return true;
        }
        return false;
    }

    private boolean matches(String string, String query) {
        return string.toLowerCase().contains(query);
    }

    private File findNpmDescriptor(File jsFile) {
        File parent;
        File pkgFile = new File(parent, "package.json");
        for (parent = jsFile.getParentFile(); parent != null && !pkgFile.exists(); parent = parent.getParentFile()) {
            pkgFile = new File(parent, "package.json");
        }
        if (parent != null) {
            return pkgFile;
        }
        return null;
    }

    private Map<String, Object> loadJsonModel(File jsFile) {
        File pkgFile = this.findNpmDescriptor(jsFile);
        if (pkgFile != null) {
            try {
                return JavaScriptResolver.readNpmDescriptor(pkgFile);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }
}

