/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.impl;

import com.redhat.ceylon.cmr.api.CmrRepository;
import com.redhat.ceylon.cmr.api.RepositoryBuilder;
import com.redhat.ceylon.cmr.impl.LocalRepositoryBuilder;
import com.redhat.ceylon.cmr.impl.SecurityActions;
import com.redhat.ceylon.common.log.Logger;
import java.io.File;
import java.net.Proxy;
import java.util.ServiceLoader;

class RepositoryBuilderImpl
implements RepositoryBuilder {
    private final RepositoryBuilder.RepositoryBuilderConfig defaultConfig;
    private static final ServiceLoader<RepositoryBuilder> builders = ServiceLoader.load(RepositoryBuilder.class, RepositoryBuilderImpl.class.getClassLoader());
    private static final LocalRepositoryBuilder localBuilder = new LocalRepositoryBuilder();

    RepositoryBuilderImpl(Logger log, boolean offline, int timeout, Proxy proxy, String currentDirectory) {
        this.defaultConfig = new RepositoryBuilder.RepositoryBuilderConfig(log, offline, timeout, proxy, currentDirectory);
    }

    @Override
    public CmrRepository[] buildRepository(String token) throws Exception {
        return this.buildRepository(token, this.defaultConfig);
    }

    @Override
    public CmrRepository[] buildRepository(String token, RepositoryBuilder.RepositoryBuilderConfig config) throws Exception {
        if (token == null) {
            throw new IllegalArgumentException("Null repository");
        }
        String key = token.startsWith("${") ? token.substring(2, token.length() - 1) : token;
        String temp = SecurityActions.getProperty(key);
        if (temp != null) {
            token = temp;
        }
        for (RepositoryBuilder builder : builders) {
            CmrRepository[] repos = builder.buildRepository(token, config);
            if (repos == null) continue;
            return repos;
        }
        return localBuilder.buildRepository(token, config);
    }

    @Override
    public String absolute(File cwd, String token) throws Exception {
        for (RepositoryBuilder builder : builders) {
            String abstoken = builder.absolute(cwd, token);
            if (abstoken == null) continue;
            return abstoken;
        }
        return localBuilder.absolute(cwd, token);
    }
}

