/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.maven;

import com.redhat.ceylon.cmr.api.AbstractDependencyResolver;
import com.redhat.ceylon.cmr.api.DependencyContext;
import com.redhat.ceylon.cmr.api.ModuleDependencyInfo;
import com.redhat.ceylon.cmr.api.ModuleInfo;
import com.redhat.ceylon.cmr.api.Overrides;
import com.redhat.ceylon.cmr.impl.CMRJULLogger;
import com.redhat.ceylon.cmr.impl.IOUtils;
import com.redhat.ceylon.cmr.impl.NodeUtils;
import com.redhat.ceylon.cmr.maven.AetherUtils;
import com.redhat.ceylon.cmr.resolver.aether.DependencyDescriptor;
import com.redhat.ceylon.cmr.spi.Node;
import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.common.log.Logger;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.cmr.RepositoryException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;

public class MavenDependencyResolver
extends AbstractDependencyResolver {
    private static final Logger logger = new CMRJULLogger();
    private AetherUtils utils = new AetherUtils(logger, null, false, 20000, null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModuleInfo resolve(DependencyContext context, Overrides overrides) {
        ArtifactResult result;
        File mod;
        if (!context.ignoreInner() && (mod = (result = context.result()).artifact()) != null && mod.getName().toLowerCase().endsWith(".jar")) {
            String artifactId;
            String name = result.name();
            int p = name.indexOf(58);
            if (p < 0) {
                p = name.lastIndexOf(46);
            }
            if (p < 0) {
                return null;
            }
            String groupId = name.substring(0, p);
            String descriptorPath = String.format("META-INF/maven/%s/%s/pom.xml", groupId, artifactId = name.substring(p + 1));
            InputStream inputStream = IOUtils.findDescriptor(result, descriptorPath);
            if (inputStream != null) {
                try {
                    ModuleInfo moduleInfo = this.resolveFromInputStream(inputStream, name, result.version(), overrides);
                    return moduleInfo;
                }
                finally {
                    IOUtils.safeClose(inputStream);
                }
            }
        }
        return null;
    }

    @Override
    public ModuleInfo resolveFromFile(File file, String name, String version2, Overrides overrides) {
        DependencyDescriptor descriptor;
        if (!file.exists()) {
            return null;
        }
        try {
            descriptor = this.utils.getDependencies(file, name, version2);
        }
        catch (IOException e) {
            throw new RepositoryException("Failed to resolve pom", e);
        }
        return MavenDependencyResolver.toModuleInfo(descriptor, name, version2, overrides);
    }

    @Override
    public ModuleInfo resolveFromInputStream(InputStream stream, String name, String version2, Overrides overrides) {
        DependencyDescriptor descriptor;
        if (stream == null) {
            return null;
        }
        try {
            descriptor = this.utils.getDependencies(stream, name, version2);
        }
        catch (IOException e) {
            throw new RepositoryException("Failed to resolve pom", e);
        }
        return MavenDependencyResolver.toModuleInfo(descriptor, name, version2, overrides);
    }

    @Override
    public Node descriptor(Node artifact) {
        return NodeUtils.firstParent(artifact).getChild("pom.xml");
    }

    private static ModuleInfo toModuleInfo(DependencyDescriptor descriptor, String name, String version2, Overrides overrides) {
        HashSet<ModuleDependencyInfo> infos = new HashSet<ModuleDependencyInfo>();
        for (DependencyDescriptor dep : descriptor.getDependencies()) {
            infos.add(new ModuleDependencyInfo("maven", AetherUtils.toCanonicalForm(dep.getGroupId(), dep.getArtifactId()), dep.getVersion(), dep.isOptional(), false, Backends.JAVA, AetherUtils.toModuleScope(dep)));
        }
        String descrName = descriptor.getGroupId() + ":" + descriptor.getArtifactId();
        if (name != null && !name.equals(descrName)) {
            return null;
        }
        if (version2 != null && !version2.equals(descriptor.getVersion())) {
            return null;
        }
        ModuleInfo ret = new ModuleInfo(descrName, descriptor.getVersion(), descriptor.getGroupId(), descriptor.getArtifactId(), null, infos);
        if (overrides != null) {
            ret = overrides.applyOverrides(descrName, descriptor.getVersion(), ret);
        }
        return ret;
    }
}

