/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.resolver.aether;

import com.redhat.ceylon.cmr.resolver.aether.AetherResolverImpl;
import com.redhat.ceylon.cmr.resolver.aether.DependencyDescriptor;
import com.redhat.ceylon.cmr.resolver.aether.ExclusionDescriptor;
import com.redhat.ceylon.cmr.resolver.aether.GraphExclusionExclusionDescriptor;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.Exclusion;

public class DependencyNodeDependencyDescriptor
implements DependencyDescriptor {
    private DependencyNode node;
    private List<DependencyDescriptor> deps;
    private List<ExclusionDescriptor> exclusions;

    DependencyNodeDependencyDescriptor(AetherResolverImpl resolver, DependencyNode node) {
        this.node = node;
        this.deps = new ArrayList<DependencyDescriptor>(node.getChildren().size());
        for (DependencyNode dep : node.getChildren()) {
            this.deps.add(new DependencyNodeDependencyDescriptor(resolver, dep));
        }
        if (node.getDependency() != null) {
            this.exclusions = new ArrayList<ExclusionDescriptor>(node.getDependency().getExclusions().size());
            for (Exclusion x : node.getDependency().getExclusions()) {
                this.exclusions.add(new GraphExclusionExclusionDescriptor(x));
            }
        }
    }

    @Override
    public File getFile() {
        if (this.node.getArtifact().getExtension().equals("aar")) {
            File repoFolder = this.node.getArtifact().getFile().getParentFile();
            File explodedFolder = new File(repoFolder, "exploded");
            File exploded = new File(explodedFolder, "classes.jar");
            if (exploded.exists()) {
                return exploded;
            }
            try {
                DependencyNodeDependencyDescriptor.unzip(this.node.getArtifact().getFile(), "classes.jar", explodedFolder);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to extract AAR file: " + this.node.getArtifact().getFile(), e);
            }
            return exploded;
        }
        return this.node.getArtifact().getFile();
    }

    @Override
    public List<DependencyDescriptor> getDependencies() {
        return this.deps;
    }

    @Override
    public String getGroupId() {
        return this.node.getArtifact().getGroupId();
    }

    @Override
    public String getArtifactId() {
        return this.node.getArtifact().getArtifactId();
    }

    @Override
    public String getVersion() {
        return this.node.getArtifact().getVersion();
    }

    @Override
    public boolean isOptional() {
        return this.node.getDependency().isOptional();
    }

    public String toString() {
        return this.node.getArtifact().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File archive, String entryPath, File destinationFolder) throws IOException {
        if (destinationFolder.exists()) {
            if (!destinationFolder.isDirectory()) {
                throw new IOException("Destination is not a folder: " + destinationFolder);
            }
        } else if (!destinationFolder.mkdirs()) {
            throw new IOException("Cannot create destination folder: " + destinationFolder);
        }
        try (ZipFile zf = new ZipFile(archive);){
            ZipEntry entry = zf.getEntry(entryPath);
            if (entry == null) {
                throw new IOException("No such entry: " + entryPath);
            }
            String name = entryPath;
            if (entryPath.indexOf(47) != -1) {
                name = name.substring(entryPath.lastIndexOf(47) + 1, name.length());
            }
            File tmpOut = File.createTempFile(name, ".part", destinationFolder);
            try (InputStream zipIn = zf.getInputStream(entry);){
                try (BufferedOutputStream fileOut = new BufferedOutputStream(new FileOutputStream(tmpOut));){
                    int cnt;
                    byte[] bytes = new byte[8192];
                    while ((cnt = zipIn.read(bytes)) != -1) {
                        fileOut.write(bytes, 0, cnt);
                    }
                    fileOut.flush();
                }
                File out = new File(destinationFolder, name);
                if (out.exists() && !out.delete()) {
                    throw new IOException("Cannot delete destination file: " + out);
                }
                if (!tmpOut.renameTo(out)) {
                    throw new IOException("Cannot copy to destination file: " + out);
                }
            }
            finally {
                if (tmpOut.exists()) {
                    tmpOut.delete();
                }
            }
        }
    }

    @Override
    public boolean isProvidedScope() {
        return "provided".equals(this.node.getDependency().getScope());
    }

    @Override
    public boolean isCompileScope() {
        return "compile".equals(this.node.getDependency().getScope());
    }

    @Override
    public boolean isRuntimeScope() {
        return "runtime".equals(this.node.getDependency().getScope());
    }

    @Override
    public boolean isTestScope() {
        return "test".equals(this.node.getDependency().getScope());
    }

    @Override
    public List<ExclusionDescriptor> getExclusions() {
        return this.exclusions;
    }
}

