/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.cmr.webdav;

import com.redhat.ceylon.cmr.impl.AbstractRemoteContentStore;
import com.redhat.ceylon.cmr.impl.NodeUtils;
import com.redhat.ceylon.cmr.impl.URLContentStore;
import com.redhat.ceylon.cmr.repository.webdav.WebDAVInputStream;
import com.redhat.ceylon.cmr.repository.webdav.WebDAVRepository;
import com.redhat.ceylon.cmr.repository.webdav.WebDAVResource;
import com.redhat.ceylon.cmr.spi.ContentHandle;
import com.redhat.ceylon.cmr.spi.ContentOptions;
import com.redhat.ceylon.cmr.spi.Node;
import com.redhat.ceylon.cmr.spi.OpenNode;
import com.redhat.ceylon.cmr.spi.SizedInputStream;
import com.redhat.ceylon.common.log.Logger;
import com.redhat.ceylon.model.cmr.RepositoryException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class WebDAVContentStore
extends URLContentStore {
    private boolean forcedAuthenticationForPutOnHerd = false;
    private WebDAVRepository repository;

    public WebDAVContentStore(String root, Logger log, boolean offline, int timeout, Proxy proxy, String apiVersion) {
        super(root, log, offline, timeout, proxy, apiVersion);
        this.repository = new WebDAVRepository(timeout, null, null);
    }

    public WebDAVContentStore(String root, Logger log, boolean offline, int timeout, Proxy proxy, String username, String password) {
        super(root, log, offline, timeout, proxy);
        this.setUsername(username);
        this.setPassword(password);
        this.repository = new WebDAVRepository(timeout, username, password);
    }

    @Override
    public OpenNode create(Node parent, String child) {
        if (!this.connectionAllowed()) {
            return null;
        }
        try {
            if (!this.isHerd()) {
                this.mkdirs(parent);
            }
            return this.createNode(child);
        }
        catch (IOException e) {
            throw this.convertIOException(e);
        }
    }

    @Override
    public ContentHandle peekContent(Node node) {
        if (!this.connectionAllowed()) {
            return null;
        }
        try {
            String url = this.getUrlAsString(node);
            return this.repository.exists(url) ? new WebDAVContentHandle(url) : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public ContentHandle getContent(Node node) throws IOException {
        return new WebDAVContentHandle(this.getUrlAsString(node));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ContentHandle putContent(Node node, InputStream stream, ContentOptions options) throws IOException {
        if (!this.connectionAllowed()) {
            return null;
        }
        try {
            if (this.isHerd() && !this.forcedAuthenticationForPutOnHerd) {
                this.repository.exists(this.getUrlAsString(node));
                this.forcedAuthenticationForPutOnHerd = true;
            }
            Node parent = NodeUtils.firstParent(node);
            if (!this.isHerd()) {
                this.mkdirs(parent);
            }
            String pUrl = this.getUrlAsString(parent);
            String token = null;
            if (!this.isHerd()) {
                token = this.repository.lock(pUrl);
            }
            String url = this.getUrlAsString(node);
            try {
                this.repository.put(url, stream);
                WebDAVContentHandle webDAVContentHandle = new WebDAVContentHandle(url);
                return webDAVContentHandle;
            }
            catch (SocketTimeoutException x) {
                SocketTimeoutException ret = new SocketTimeoutException("Timed out writing to " + url);
                ret.initCause(x);
                throw ret;
            }
            finally {
                if (!this.isHerd()) {
                    this.repository.unlock(pUrl, token);
                }
            }
        }
        catch (IOException x) {
            throw this.convertIOException(x);
        }
    }

    private RepositoryException convertIOException(IOException x) {
        String msg = this.repository.getBetterExceptionMessage(x, this.root);
        if (msg != null) {
            return new RepositoryException(msg);
        }
        return new RepositoryException(x);
    }

    private void mkdirs(Node parent) throws IOException {
        if (parent == null) {
            return;
        }
        this.mkdirs(NodeUtils.firstParent(parent));
        String url = this.getUrlAsString(parent);
        if (!this.repository.exists(url)) {
            this.repository.createDirectory(url);
        }
    }

    @Override
    protected ContentHandle createContentHandle(Node parent, String child, String path, Node node) {
        return new WebDAVContentHandle(this.root + path);
    }

    @Override
    public Iterable<? extends OpenNode> find(Node parent) {
        if (!this.connectionAllowed()) {
            return Collections.emptyList();
        }
        String url = this.getUrlAsString(parent);
        try {
            ArrayList<AbstractRemoteContentStore.RemoteNode> nodes = new ArrayList<AbstractRemoteContentStore.RemoteNode>();
            List<WebDAVResource> resources = this.repository.list(url);
            for (WebDAVResource dr : resources) {
                String label = dr.getName();
                AbstractRemoteContentStore.RemoteNode node = new AbstractRemoteContentStore.RemoteNode(label);
                if (dr.isDirectory()) {
                    node.setContentMarker();
                } else {
                    node.setHandle(new WebDAVContentHandle(url + label));
                }
                nodes.add(node);
            }
            return nodes;
        }
        catch (IOException e) {
            this.log.debug("Failed to list url: " + url);
            return Collections.emptyList();
        }
    }

    @Override
    protected boolean urlExists(String path) {
        if (!this.connectionAllowed()) {
            return false;
        }
        try {
            return this.repository.exists(this.getUrlAsString(path));
        }
        catch (IOException e) {
            this.log.debug("Failed to check url: " + path);
            return false;
        }
    }

    @Override
    protected boolean urlExists(URL url) {
        if (!this.connectionAllowed()) {
            return false;
        }
        try {
            return this.repository.exists(url.toExternalForm());
        }
        catch (IOException e) {
            this.log.debug("Failed to check url: " + url);
            return false;
        }
    }

    public String toString() {
        return "WebDAV content store: " + this.root;
    }

    private class WebDAVContentHandle
    implements ContentHandle {
        private final String url;

        private WebDAVContentHandle(String url) {
            this.url = url;
        }

        @Override
        public boolean hasBinaries() {
            if (!WebDAVContentStore.this.connectionAllowed()) {
                return false;
            }
            try {
                List<WebDAVResource> list = WebDAVContentStore.this.repository.list(this.url);
                return list.size() == 1 && !list.get(0).isDirectory();
            }
            catch (IOException e) {
                WebDAVContentStore.this.log.warning("Cannot list resources: " + this.url + "; error - " + e);
                return false;
            }
        }

        @Override
        public InputStream getBinariesAsStream() throws IOException {
            SizedInputStream ret = this.getBinariesAsSizedStream();
            return ret != null ? ret.getInputStream() : null;
        }

        @Override
        public SizedInputStream getBinariesAsSizedStream() throws IOException {
            if (!WebDAVContentStore.this.connectionAllowed()) {
                return null;
            }
            WebDAVInputStream inputStream = WebDAVContentStore.this.repository.get(this.url);
            Long length = inputStream.getLength();
            return new SizedInputStream(inputStream.getInputStream(), length != null ? length : -1L);
        }

        @Override
        public File getContentAsFile() throws IOException {
            return null;
        }

        @Override
        public long getSize() throws IOException {
            if (WebDAVContentStore.this.connectionAllowed()) {
                Long length;
                if (WebDAVContentStore.this.isHerd()) {
                    return WebDAVContentStore.this.size(new URL(this.url));
                }
                List<WebDAVResource> list = WebDAVContentStore.this.repository.list(this.url);
                if (!list.isEmpty() && !list.get(0).isDirectory() && (length = list.get(0).getContentLength()) != null) {
                    return length;
                }
            }
            return -1L;
        }

        @Override
        public long getLastModified() throws IOException {
            if (WebDAVContentStore.this.connectionAllowed()) {
                Date modified;
                if (WebDAVContentStore.this.isHerd()) {
                    return WebDAVContentStore.this.lastModified(new URL(this.url));
                }
                List<WebDAVResource> list = WebDAVContentStore.this.repository.list(this.url);
                if (!list.isEmpty() && !list.get(0).isDirectory() && (modified = list.get(0).getModified()) != null) {
                    return modified.getTime();
                }
            }
            return -1L;
        }

        @Override
        public void clean() {
        }
    }
}

