/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common;

public class StatusPrinter {
    private int lineWidth;
    private int remaining;
    private static final char abbreviationChar = '\u2026';
    private static final String abbreviationString = "\u2026";
    private StringBuilder currentLine;
    private String capturedLine;

    public StatusPrinter() {
        this(Integer.getInteger("com.redhat.ceylon.common.tool.terminal.width", 80));
    }

    public StatusPrinter(int i) {
        this.lineWidth = i;
        this.remaining = i;
        this.currentLine = new StringBuilder(this.lineWidth);
    }

    public void clearLine() {
        if (this.currentLine.length() == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder(this.lineWidth + 2);
        sb.append('\r');
        for (int i = 0; i < this.lineWidth; ++i) {
            sb.append(' ');
        }
        sb.append('\r');
        System.err.print(sb.toString());
        System.err.flush();
        this.currentLine.setLength(0);
        this.remaining = this.lineWidth;
    }

    private void print(String part) {
        System.err.print(part);
        this.currentLine.append(part);
        this.remaining -= part.codePointCount(0, part.length());
        System.err.flush();
    }

    public void log(String str) {
        this.print(this.part(str));
    }

    public void log(String str, int sizeLimit) {
        this.print(this.part(str, sizeLimit));
    }

    public void logRight(String str) {
        this.print(this.partRight(str));
    }

    public void logRight(String str, int sizeLimit) {
        this.print(this.partRight(str, sizeLimit));
    }

    public String part(String str, int sizeLimit) {
        if (this.remaining == 0) {
            return "";
        }
        int codePoints = str.codePointCount(0, str.length());
        int max = Math.min(codePoints, sizeLimit);
        if (this.remaining >= max) {
            if (codePoints != max) {
                return this.limit(str, max);
            }
            return str;
        }
        return this.limit(str, this.remaining);
    }

    public String partRight(String str, int sizeLimit) {
        if (this.remaining == 0) {
            return "";
        }
        int codePoints = str.codePointCount(0, str.length());
        int max = Math.min(codePoints, sizeLimit);
        if (this.remaining >= max) {
            if (codePoints != max) {
                return this.leftPad(this.limit(str, max), this.remaining - max);
            }
            return this.leftPad(str, this.remaining - codePoints);
        }
        return this.limit(str, this.remaining);
    }

    public String part(String str) {
        if (this.remaining == 0) {
            return "";
        }
        int codePoints = str.codePointCount(0, str.length());
        if (this.remaining >= codePoints) {
            return str;
        }
        return this.limit(str, this.remaining);
    }

    public String partRight(String str) {
        if (this.remaining == 0) {
            return "";
        }
        int codePoints = str.codePointCount(0, str.length());
        if (this.remaining >= codePoints) {
            return this.leftPad(str, this.remaining - codePoints);
        }
        return this.limit(str, this.remaining);
    }

    private String leftPad(String str, int count) {
        if (count == 0) {
            return str;
        }
        StringBuilder b = new StringBuilder(str.length() + count);
        for (int i = 0; i < count; ++i) {
            b.append(' ');
        }
        b.append(str);
        return b.toString();
    }

    public int remainingForPercentage(double percentage) {
        return (int)Math.floor((double)this.remaining * percentage);
    }

    public String limit(String str, int sizeLimit) {
        int c;
        int codePoints = str.codePointCount(0, str.length());
        if (codePoints <= sizeLimit) {
            return str;
        }
        if (sizeLimit == 0) {
            return "";
        }
        if (sizeLimit == 1) {
            return abbreviationString;
        }
        StringBuilder sb = new StringBuilder();
        double half = (double)(sizeLimit - 1) / 2.0;
        int before = (int)Math.ceil(half);
        int after = (int)Math.floor(half);
        for (c = 0; c < before; ++c) {
            sb.appendCodePoint(str.codePointAt(c));
        }
        sb.append('\u2026');
        for (c = codePoints - after; c < codePoints; ++c) {
            sb.appendCodePoint(str.codePointAt(c));
        }
        return sb.toString();
    }

    public void captureLine() {
        this.capturedLine = this.currentLine.toString();
    }

    public void logCapturedLine() {
        this.clearLine();
        this.log(this.capturedLine);
    }

    public static boolean canPrint() {
        return System.console() != null;
    }

    public int getRemaining() {
        return this.remaining;
    }
}

