/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common.config;

import com.redhat.ceylon.common.config.CeylonConfig;
import com.redhat.ceylon.common.config.ConfigMessages;
import com.redhat.ceylon.common.config.Credentials;
import com.redhat.ceylon.common.config.Keystores;
import com.redhat.ceylon.common.config.Proxies;
import java.io.Console;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.UnrecoverableKeyException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Authentication {
    private static PasswordPrompt passwordPrompt = null;
    private Keystores keystores;
    private Proxies.Proxy proxy;

    public void installProxy() {
        if (this.proxy == null) {
            System.setProperty("java.net.useSystemProxies", "true");
        }
        if (this.proxy.getHost() == null) {
            System.setProperty("java.net.useSystemProxies", "false");
        } else {
            ProxySelector.setDefault(this.getProxySelector());
            Authenticator authenticator = this.getProxyAuthenticator();
            if (authenticator != null) {
                Authenticator.setDefault(authenticator);
            }
        }
    }

    public Proxy getProxy() {
        if (this.proxy != null && this.proxy.getHost() != null) {
            return new Proxy(Proxy.Type.valueOf(this.proxy.getType()), new InetSocketAddress(this.proxy.getHost(), this.proxy.getPort()));
        }
        return null;
    }

    public ProxySelector getProxySelector() {
        ProxySelector selector = null;
        if (this.proxy != null && this.proxy.getHost() != null) {
            selector = new ProxySelector(){

                @Override
                public List<Proxy> select(URI uri) {
                    String host = uri.getHost();
                    Proxy netProxy = null;
                    if (Authentication.this.proxy.getNonProxyHosts() != null) {
                        for (String nonProxiable : Authentication.this.proxy.getNonProxyHosts()) {
                            if (!nonProxiable.equals(host)) continue;
                            netProxy = Proxy.NO_PROXY;
                        }
                    }
                    if (netProxy == null) {
                        netProxy = Authentication.this.getProxy();
                    }
                    if (netProxy == null) {
                        netProxy = Proxy.NO_PROXY;
                    }
                    return Collections.singletonList(netProxy);
                }

                @Override
                public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
                }
            };
        }
        return selector;
    }

    public Authenticator getProxyAuthenticator() {
        Authenticator authenticator = null;
        if (this.proxy != null && this.proxy.getCredentials() != null && this.proxy.getCredentials().getUser() != null) {
            authenticator = new Authenticator(){

                @Override
                public PasswordAuthentication getPasswordAuthentication() {
                    UsernamePassword usernameAndPassword = Authentication.this.getUsernameAndPassword(Authentication.this.proxy.getCredentials());
                    return new PasswordAuthentication(usernameAndPassword.getUser(), usernameAndPassword.getPassword());
                }
            };
        }
        return authenticator;
    }

    public UsernamePassword getUsernameAndPassword(Credentials credentials) {
        Password p;
        if (credentials == null || credentials.getUser() == null) {
            return null;
        }
        if (credentials.getAlias() != null) {
            String passwordKeystore = credentials.getKeystore();
            Keystores.Store store = this.keystores.getStore(passwordKeystore);
            p = new StoredPassword(passwordKeystore, store, credentials.getAlias());
        } else {
            p = credentials.getUser() != null && credentials.getPassword() == null ? new PromptedPassword(credentials.getCredentialPrompt()) : new PlaintextPassword(credentials.getPassword());
        }
        return new UsernamePassword(credentials.getUser(), p);
    }

    public static synchronized PasswordPrompt getPasswordPrompt() {
        if (passwordPrompt == null) {
            passwordPrompt = new ConsolePasswordPrompt();
        }
        return passwordPrompt;
    }

    public static synchronized void setPasswordPrompt(PasswordPrompt passwordPrompt) {
        Authentication.passwordPrompt = passwordPrompt;
    }

    public Authentication(Keystores keystores, Proxies.Proxy proxy) {
        this.keystores = keystores;
        this.proxy = proxy;
    }

    public static Authentication get() {
        return Authentication.fromConfig(CeylonConfig.get());
    }

    public static Authentication fromConfig(CeylonConfig config) {
        return new Authentication(Keystores.withConfig(config), Proxies.withConfig(config).getProxy());
    }

    private static final class StoredPassword
    implements Password {
        private final String passwordKeystore;
        private final Keystores.Store store;
        private final String alias;
        private char[] password = null;

        private StoredPassword(String passwordKeystore, Keystores.Store store, String alias) {
            this.passwordKeystore = passwordKeystore;
            this.store = store;
            this.alias = alias;
        }

        private String msg(String key, Object ... args) {
            return ConfigMessages.msg((this.passwordKeystore == null ? "keystore.default." : "keystore.named.") + key, args);
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public char[] getPassword() {
            char[] cArray;
            char[] entryPass;
            block18: {
                if (this.password != null) {
                    return this.password;
                }
                char[] storePass = null;
                entryPass = null;
                try {
                    if (this.store.getFilename() != null && !this.store.fileExists()) {
                        throw new RuntimeException(this.msg("missing", this.store.getFilename(), this.passwordKeystore));
                    }
                    String protection = this.store.getProtection();
                    if (protection.equals("both") || protection.equals("store")) {
                        PromptedPassword storePassword = new PromptedPassword(this.msg("keystore.password.prompt", this.store.getFilename(), this.passwordKeystore));
                        storePass = storePassword.getPassword();
                    } else if (protection.equals("entry")) {
                        PromptedPassword entryPassword = new PromptedPassword(this.msg("entry.password.prompt", this.store.getFilename(), this.passwordKeystore));
                        entryPass = entryPassword.getPassword();
                    } else if (!protection.equals("none")) {
                        throw new RuntimeException(this.msg("unknown.protection", this.store.getFilename(), this.passwordKeystore, protection));
                    }
                    if ("both".equals(protection)) {
                        entryPass = storePass;
                    }
                    this.password = this.store.getPassword(this.alias, storePass, entryPass);
                    if (this.password == null) {
                        throw new RuntimeException(this.msg("no.alias", this.store.getFilename(), this.passwordKeystore, this.alias));
                    }
                    cArray = this.password;
                    if (storePass == null) break block18;
                }
                catch (UnrecoverableKeyException e) {
                    try {
                        throw new RuntimeException(this.msg("password.bad", this.store.getFilename(), this.passwordKeystore, this.alias));
                        catch (GeneralSecurityException e2) {
                            throw new RuntimeException(e2);
                        }
                        catch (Exception e3) {
                            throw new RuntimeException(e3);
                        }
                    }
                    catch (Throwable throwable) {
                        if (storePass != null) {
                            Arrays.fill(storePass, ' ');
                        }
                        if (entryPass != null) {
                            Arrays.fill(entryPass, ' ');
                        }
                        throw throwable;
                    }
                }
                Arrays.fill(storePass, ' ');
            }
            if (entryPass != null) {
                Arrays.fill(entryPass, ' ');
            }
            return cArray;
        }
    }

    private static class PromptedPassword
    implements Password {
        private final String prompt;

        public PromptedPassword(String prompt) {
            this.prompt = prompt;
        }

        @Override
        public char[] getPassword() {
            return Authentication.getPasswordPrompt().getPassword(this.prompt);
        }
    }

    public static class ConsolePasswordPrompt
    implements PasswordPrompt {
        private final Console console = System.console();

        public ConsolePasswordPrompt() {
            if (this.console == null) {
                throw new RuntimeException("No console available");
            }
        }

        @Override
        public char[] getPassword(String prompt) {
            return this.console.readPassword("%s: ", prompt);
        }
    }

    public static interface PasswordPrompt {
        public char[] getPassword(String var1);
    }

    private static class PlaintextPassword
    implements Password {
        private final String password;

        private PlaintextPassword(String password) {
            this.password = password;
        }

        @Override
        public char[] getPassword() {
            return this.password != null ? this.password.toCharArray() : null;
        }
    }

    private static interface Password {
        public char[] getPassword();
    }

    public static class UsernamePassword {
        private final String username;
        private final Password password;

        public UsernamePassword(String user, Password p) {
            this.username = user;
            this.password = p;
        }

        public String getUser() {
            return this.username;
        }

        public char[] getPassword() {
            return this.password.getPassword();
        }
    }
}

