/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common.config;

import com.redhat.ceylon.common.FileUtil;
import com.redhat.ceylon.common.config.CeylonConfig;
import com.redhat.ceylon.common.config.ConfigReader;
import com.redhat.ceylon.common.config.ConfigReaderListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class ConfigParser {
    private File configFile;
    private File currentDir;
    private CeylonConfig config;
    private InputStream in;

    public ConfigParser(File configFile) {
        this.configFile = configFile;
        this.currentDir = configFile.getParentFile();
    }

    public ConfigParser(InputStream in, File currentDir) {
        this.in = in;
        this.currentDir = currentDir;
    }

    public CeylonConfig parse(final boolean replaceVars) throws IOException {
        this.config = new CeylonConfig();
        if (this.configFile == null || this.configFile.isFile()) {
            if (this.configFile != null) {
                this.in = new FileInputStream(this.configFile);
            }
            ConfigReader reader = new ConfigReader(this.in, new ConfigReaderListener(){

                @Override
                public void setup() throws IOException {
                }

                @Override
                public void onSection(String section, String text) {
                }

                @Override
                public void onOption(String name, String value, String text) {
                    String[] oldval;
                    if (replaceVars) {
                        if (value.startsWith("${DIR}")) {
                            value = FileUtil.absoluteFile(ConfigParser.this.currentDir).getPath() + value.substring(6);
                        } else if (value.startsWith("${USER_DIR}")) {
                            value = FileUtil.absoluteFile(FileUtil.getUserDir()).getPath() + value.substring(11);
                        } else if (value.startsWith("${SYSTEM_DIR}")) {
                            value = FileUtil.absoluteFile(FileUtil.getSystemConfigDir()).getPath() + value.substring(13);
                        } else if ((value.startsWith("${CEYLON_HOME}") || value.startsWith("${INSTALL_DIR}")) && FileUtil.getInstallDir() != null) {
                            value = FileUtil.absoluteFile(FileUtil.getInstallDir()).getPath() + value.substring(14);
                        }
                    }
                    if ((oldval = ConfigParser.this.config.getOptionValues(name)) == null) {
                        ConfigParser.this.config.setOption(name, value);
                    } else {
                        String[] newVal = Arrays.copyOf(oldval, oldval.length + 1);
                        newVal[oldval.length] = value;
                        ConfigParser.this.config.setOptionValues(name, newVal);
                    }
                }

                @Override
                public void onComment(String text) {
                }

                @Override
                public void onWhitespace(String text) {
                }

                @Override
                public void cleanup() throws IOException {
                }
            });
            try {
                reader.process();
            }
            catch (IOException ex) {
                System.err.print("Error parsing configuration");
                if (this.configFile != null) {
                    System.err.print(" '" + FileUtil.relativeFile(this.configFile).getPath() + "'");
                }
                System.err.println(": " + ex.getMessage());
            }
        } else {
            throw new FileNotFoundException("Couldn't open configuration file");
        }
        return this.config;
    }
}

