/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common.tool;

import com.redhat.ceylon.common.tool.ArgumentModel;
import com.redhat.ceylon.common.tool.OptionModel;
import com.redhat.ceylon.common.tool.SubtoolModel;
import com.redhat.ceylon.common.tool.Tool;
import com.redhat.ceylon.common.tool.ToolLoader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class ToolModel<T extends Tool> {
    private String name;
    private ToolLoader loader;
    private Map<String, OptionModel<?>> optionsByName = new LinkedHashMap(1);
    private Map<Character, OptionModel<?>> optionsByShort = new HashMap(1);
    private List<ArgumentModel<?>> arguments = new ArrayList(1);
    private Method rest;
    private SubtoolModel<?> subtoolModel;
    private ToolModel<?> parentTool;

    public ToolModel(String name) {
        this.name = name;
    }

    public ToolLoader getToolLoader() {
        return this.loader;
    }

    public void setToolLoader(ToolLoader toolLoader) {
        this.loader = toolLoader;
    }

    public String getName() {
        return this.name;
    }

    public Collection<OptionModel<?>> getOptions() {
        return this.optionsByName.values();
    }

    public void addOption(OptionModel<?> option) {
        option.setToolModel(this);
        this.optionsByName.put(option.getLongName(), option);
        if (option.getShortName() != null) {
            this.optionsByShort.put(option.getShortName(), option);
        }
    }

    public OptionModel<?> getOption(String longName) {
        return this.optionsByName.get(longName);
    }

    public OptionModel<?> getOptionByShort(char shortName) {
        return this.optionsByShort.get(Character.valueOf(shortName));
    }

    public List<ArgumentModel<?>> getArguments() {
        return this.arguments;
    }

    public List<ArgumentModel<?>> getArgumentsAndSubtool() {
        ArrayList result = new ArrayList(this.getArguments());
        if (this.subtoolModel != null) {
            result.add(this.subtoolModel);
        }
        return result;
    }

    public void addArgument(ArgumentModel<?> argument) {
        if (!this.arguments.isEmpty() && this.arguments.get(this.arguments.size() - 1).getMultiplicity().isRange()) {
            throw new IllegalArgumentException("Arguments after variable-multiplicity arguments are not supported");
        }
        if (argument instanceof SubtoolModel) {
            throw new IllegalArgumentException();
        }
        argument.setToolModel(this);
        this.arguments.add(argument);
    }

    public void setRest(Method method) {
        this.rest = method;
    }

    public Method getRest() {
        return this.rest;
    }

    public boolean isTopLevel() {
        return this.getName().isEmpty();
    }

    public boolean isPorcelain() {
        return !this.isTopLevel();
    }

    public boolean isPlumbing() {
        return !this.isTopLevel();
    }

    public SubtoolModel<?> getSubtoolModel() {
        return this.subtoolModel;
    }

    public void setSubtoolModel(SubtoolModel<?> subtoolModel) {
        subtoolModel.setToolModel(this);
        this.subtoolModel = subtoolModel;
    }

    public ToolModel<?> getParentTool() {
        return this.parentTool;
    }

    public void setParentTool(ToolModel<?> parentTool) {
        this.parentTool = parentTool;
    }
}

