/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common.tools;

import com.redhat.ceylon.common.FileUtil;
import com.redhat.ceylon.common.OSUtil;
import com.redhat.ceylon.common.config.CeylonConfig;
import com.redhat.ceylon.common.config.CeylonConfigFinder;
import com.redhat.ceylon.common.tool.AnnotatedToolModel;
import com.redhat.ceylon.common.tool.Argument;
import com.redhat.ceylon.common.tool.ArgumentModel;
import com.redhat.ceylon.common.tool.CeylonBaseTool;
import com.redhat.ceylon.common.tool.Description;
import com.redhat.ceylon.common.tool.FatalToolError;
import com.redhat.ceylon.common.tool.ModelException;
import com.redhat.ceylon.common.tool.NoSuchToolException;
import com.redhat.ceylon.common.tool.Option;
import com.redhat.ceylon.common.tool.OptionArgument;
import com.redhat.ceylon.common.tool.OptionArgumentException;
import com.redhat.ceylon.common.tool.RemainingSections;
import com.redhat.ceylon.common.tool.ScriptToolModel;
import com.redhat.ceylon.common.tool.Summary;
import com.redhat.ceylon.common.tool.Tool;
import com.redhat.ceylon.common.tool.ToolError;
import com.redhat.ceylon.common.tool.ToolFactory;
import com.redhat.ceylon.common.tool.ToolLoader;
import com.redhat.ceylon.common.tool.ToolModel;
import com.redhat.ceylon.common.tool.Tools;
import com.redhat.ceylon.common.tools.CeylonToolLoader;
import com.redhat.ceylon.common.tools.CommandLine;
import com.redhat.ceylon.common.tools.Usage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@Summary(value="The top level Ceylon tool is used to execute other Ceylon tools")
@Description(value="If `--version` is present, print version information and exit. Otherwise `<tool-arguments>` should begin with the name of a ceylon tool or a list of comma-separated tool names which will be invoked one after the other with the same remaining command line arguments. The named tools are loaded and configured with the remaining command line arguments and control passes to those tools.")
@RemainingSections(value="## CONFIGURATION MECHANISM\n\nCeylon uses a simple text format to store customizations that are per repository and are per user. Such a configuration file may look like this:\n\n    #\n    # A '#' or ';' character indicates a comment.\n    #\n    \n    ; global settings\n    [defaults]\n        encoding = utf8\n        pager = false\n    \n    ; local repository\n    [repository \"LOCAL\"]\n        url = ./modules\n\n\nVarious commands read from the configuration file and adjust their operation accordingly. See ceylon-config(1) for a list and more details about the configuration mechanism.")
public class CeylonTool
implements Tool {
    private static final String ARG_LONG_VERSION = "--version";
    private static final String ARG_SHORT_VERSION = "-v";
    public static final int SC_OK = 0;
    public static final int SC_TOOL_ERROR = 1;
    public static final int SC_TOOL_EXCEPTION = 2;
    public static final int SC_ARGS = 2;
    public static final int SC_NO_SUCH_TOOL = 3;
    public static final int SC_TOOL_BUG = 5;
    public static final int SC_TOOL_CREATION = 6;
    private String toolName;
    private List<String> toolArgs = Collections.emptyList();
    private boolean stacktraces = false;
    private ToolLoader pluginLoader;
    private ToolFactory pluginFactory;
    private boolean version;
    private Tool toolCache;
    private Boolean paginate;
    private File cwd;
    private File config;
    private boolean noConfig;
    private CeylonConfig oldConfig = null;
    private List<String> defines;
    private Boolean showHome;
    private boolean showDistributionError;

    @Option(shortName=118)
    @Description(value="Print version information and exit, *ignoring all other options and arguments*.")
    public void setVersion(boolean version2) {
        this.version = version2;
    }

    @Option
    @Description(value="If an error propagates to the top level tool, print its stack trace.")
    public void setStacktraces(boolean stacktraces) {
        this.stacktraces = stacktraces;
    }

    public boolean getStacktraces() {
        return this.stacktraces;
    }

    @Option
    @Description(value="Pipe all Ceylon tool output into less (or if set, $CEYLON_PAGER or $PAGER) if standard output is a terminal. This overrides the `help.pager` and `defaults.pager` configuration options (see the \"Configuration Mechanism\" section below).")
    public void setPaginate(boolean paginate) {
        this.paginate = Boolean.TRUE;
    }

    public boolean getPaginate() {
        return this.paginate != null && this.paginate != false;
    }

    @Option
    @Description(value="Do not pipe Ceylon tool output into a pager.")
    public void setNoPager(boolean noPager) {
        this.paginate = Boolean.FALSE;
    }

    public boolean getNoPager() {
        return this.paginate != null && this.paginate == false;
    }

    @Option
    @Description(value="Outputs the value for CEYLON_HOME and exits.")
    public void setShowHome(boolean showHome) {
        this.showHome = showHome;
    }

    public boolean getShowHome() {
        return this.showHome != null && this.showHome != false;
    }

    public File getCwd() {
        return this.cwd;
    }

    @OptionArgument(longName="cwd", argumentName="dir")
    @Description(value="Specifies the current working directory for this tool. (default: the directory where the tool is run from)")
    public void setCwd(File cwd) {
        this.cwd = cwd;
    }

    public File getConfig() {
        return this.config;
    }

    @OptionArgument(longName="config", argumentName="file")
    @Description(value="Specifies the configuration file to use for this tool. (default: `./.ceylon/config`)")
    public void setConfig(File config) {
        this.config = config;
    }

    public boolean getNoConfig() {
        return this.noConfig;
    }

    @Option
    @Description(value="Specifies that no configuration file should be loaded for this tool.")
    public void setNoConfig(boolean noConfig) {
        this.noConfig = noConfig;
    }

    @OptionArgument(shortName=68, argumentName="key>=<value")
    @Description(value="Set a system property")
    public void setDefine(List<String> defines) {
        this.defines = defines;
    }

    @OptionArgument(argumentName="version-or-url")
    @Description(value="Determines which Ceylon distribution will be used to run the command. Passing any version except the current (1.3.2) will result in a one-time download of the requested version from the official Ceylon website.")
    public void setDistribution(String distribution) {
        this.showDistributionError = !distribution.isEmpty() && !distribution.equals("1.3.2");
    }

    @OptionArgument(argumentName="options")
    @Description(value="Flags added to the java command line, overriding the JAVA_OPTS environment variable.")
    public void setJava(String javaOptions) {
    }

    private void setSystemProperties() {
        if (this.defines != null) {
            for (String prop : this.defines) {
                int p = prop.indexOf(61);
                if (p <= 0) continue;
                String key = prop.substring(0, p);
                String val = prop.substring(p + 1);
                System.setProperty(key, val);
            }
        }
    }

    public void setCommand(String command) {
        this.toolName = command;
    }

    public void setCommandArguments(List<String> commandArgs) {
        this.toolArgs = commandArgs;
    }

    @Argument(argumentName="tool-arguments", multiplicity="*")
    public void setArgs(List<String> args) {
        this.setCommand(args.get(0));
        this.setCommandArguments(args.subList(1, args.size()));
    }

    public String getToolName() {
        return this.toolName;
    }

    public String[] getToolNames() {
        if (this.toolName == null) {
            return new String[0];
        }
        if (this.toolName.indexOf(44) != -1) {
            return this.toolName.split(",");
        }
        return new String[]{this.toolName};
    }

    public List<String> getToolArguments() {
        return this.toolArgs;
    }

    private static List<String> rearrangeArgs(String[] args) {
        ArrayList<String> result = new ArrayList<String>(args.length + 1);
        if (args.length == 0) {
            result.add("help");
        } else {
            List<String> argsList = Arrays.asList(args);
            for (int ii = 0; ii < args.length; ++ii) {
                int doubleDashIndex;
                String arg = args[ii];
                if (arg.equals("--help") || arg.equals("-h") || arg.equals("help")) {
                    result.add("help");
                    result.add("--");
                    continue;
                }
                if (arg.equals(ARG_LONG_VERSION) || arg.equals(ARG_SHORT_VERSION)) {
                    result.add(ARG_LONG_VERSION);
                    break;
                }
                if (arg.startsWith("-")) {
                    result.add(arg);
                    continue;
                }
                if (arg.isEmpty()) {
                    result.clear();
                    result.add("help");
                    break;
                }
                List<String> rest = argsList.subList(ii, args.length);
                int helpIndex = rest.indexOf("--help");
                if (helpIndex == -1) {
                    helpIndex = rest.indexOf("-h");
                }
                if (helpIndex != -1 && ((doubleDashIndex = rest.indexOf("--")) == -1 || helpIndex < doubleDashIndex)) {
                    result.add("help");
                    result.add(arg);
                    break;
                }
                result.add("--");
                result.addAll(rest);
                break;
            }
        }
        return result;
    }

    private static void version(PrintStream out) {
        out.println(Tools.progName() + " version " + "1.3.2 754a09a (Smile Tolerantly)");
    }

    public static void main(String ... args) throws Exception {
        int exit = CeylonTool.start(args);
        if (exit != 0) {
            System.exit(exit);
        }
    }

    public static int start(String ... args) throws Exception {
        if (args.length > 0 && (ARG_LONG_VERSION.equals(args[0]) || ARG_SHORT_VERSION.equals(args[0]))) {
            CeylonTool.version(System.out);
            return 0;
        }
        return new CeylonTool().bootstrap(args);
    }

    public int bootstrap(String ... args) throws Exception {
        int result = this.setup(args);
        if (result == 0) {
            result = this.execute();
        }
        return result;
    }

    public int setup(String ... args) throws Exception {
        int result;
        try {
            ToolModel model = this.getToolModel("");
            List<String> myArgs = CeylonTool.rearrangeArgs(CommandLine.parse(args));
            this.getPluginFactory().bindArguments(model, this, this, myArgs);
            this.setSystemProperties();
            this.oldConfig = this.setupConfig();
            result = 0;
        }
        catch (Exception e) {
            result = CeylonTool.handleException(this, e);
        }
        System.out.flush();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() throws Exception {
        int result = 0;
        try {
            String[] names;
            String[] stringArray;
            this.setSystemCwd();
            if (this.toolName != null) {
                stringArray = this.getToolNames();
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = null;
            }
            for (String singleToolName : names = stringArray) {
                ToolModel<Tool> model = this.getToolModel(singleToolName);
                Tool tool = this.getTool(model);
                CeylonConfig oldConfig2 = null;
                if (this.oldConfig == null) {
                    oldConfig2 = this.setupConfig(tool);
                }
                try {
                    this.run(model, tool);
                    result = 0;
                }
                finally {
                    if (oldConfig2 != null) {
                        CeylonConfig.set(oldConfig2);
                    }
                }
            }
        }
        catch (Exception e) {
            result = CeylonTool.handleException(this, e);
        }
        finally {
            if (this.oldConfig != null) {
                CeylonConfig.set(this.oldConfig);
                this.oldConfig = null;
            }
        }
        System.out.flush();
        return result;
    }

    public static int handleException(CeylonTool mainTool, Exception ex) throws Exception {
        ToolError err;
        int result = ex instanceof NoSuchToolException ? 3 : (ex instanceof ModelException ? 6 : (ex instanceof OptionArgumentException ? 2 : (ex instanceof FatalToolError ? 5 : (ex instanceof ToolError ? ((err = (ToolError)ex).isExitCodeProvided() ? err.getExitCode() : 1) : 2))));
        Usage.handleException(mainTool, mainTool.getToolName(), ex);
        return result;
    }

    private CeylonConfig setupConfig() throws IOException {
        File cwd = this.getCwd();
        if (!this.getNoConfig()) {
            File cfgFile = this.getConfig();
            if (cfgFile != null) {
                File absCfgFile = FileUtil.applyCwd(cwd, cfgFile);
                CeylonConfig config = CeylonConfigFinder.DEFAULT.loadConfigFromFile(absCfgFile);
                return CeylonConfig.set(config);
            }
            if (cwd != null && cwd.isDirectory()) {
                CeylonConfig config = CeylonConfigFinder.loadDefaultConfig(cwd);
                return CeylonConfig.set(config);
            }
        } else {
            return CeylonConfig.set(new CeylonConfig());
        }
        return null;
    }

    private CeylonConfig setupConfig(Tool tool) throws IOException {
        if (tool instanceof CeylonBaseTool) {
            CeylonBaseTool cbt = (CeylonBaseTool)tool;
            File cwd = cbt.getCwd();
            if (cwd != null && cwd.isDirectory()) {
                CeylonConfig config = CeylonConfigFinder.loadDefaultConfig(cwd);
                return CeylonConfig.set(config);
            }
            if (this.getCwd() != null) {
                cbt.setCwd(this.getCwd());
            }
        }
        return null;
    }

    private void setSystemCwd() {
        String cwd = null;
        if (this.getCwd() != null) {
            cwd = this.getCwd().getAbsolutePath();
        } else {
            cwd = System.getProperty("ceylon.cwd");
            if (cwd == null) {
                cwd = System.getProperty("user.dir");
            }
        }
        System.setProperty("ceylon.cwd", cwd);
    }

    @Override
    public void initialize(CeylonTool mainTool) {
    }

    @Override
    public void run() throws Exception {
        if (this.showDistributionError) {
            throw new IllegalArgumentException("Requested and actual Ceylon distribution versions are not the same");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(ToolModel<Tool> model, Tool tool) throws Exception {
        if (this.version) {
            CeylonTool.version(System.out);
        } else if (this.getShowHome()) {
            System.out.println(System.getProperty("ceylon.home"));
        } else if (model instanceof ScriptToolModel) {
            this.runScript((ScriptToolModel)model);
        } else {
            boolean setTCCL;
            ClassLoader savedTCCL = Thread.currentThread().getContextClassLoader();
            boolean bl = setTCCL = savedTCCL == null || savedTCCL != tool.getClass().getClassLoader();
            if (setTCCL) {
                Thread.currentThread().setContextClassLoader(tool.getClass().getClassLoader());
            }
            try {
                tool.run();
            }
            finally {
                if (setTCCL) {
                    Thread.currentThread().setContextClassLoader(savedTCCL);
                }
            }
        }
    }

    private void runScript(ScriptToolModel<?> model) {
        ArrayList<String> args = new ArrayList<String>(3 + this.toolArgs.size());
        if (OSUtil.isWindows()) {
            args.add("cmd.exe");
            args.add("/C");
        }
        args.add(model.getScriptName());
        args.addAll(this.toolArgs);
        ProcessBuilder processBuilder = new ProcessBuilder(args);
        CeylonTool.setupScriptEnvironment(processBuilder, model.getScriptName());
        processBuilder.redirectError(ProcessBuilder.Redirect.INHERIT);
        processBuilder.redirectInput(ProcessBuilder.Redirect.INHERIT);
        if (OSUtil.isWindows()) {
            processBuilder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        }
        if (this.getCwd() != null) {
            processBuilder.directory(this.getCwd());
        }
        try {
            int exit;
            Process process = processBuilder.start();
            if (!OSUtil.isWindows()) {
                String line;
                InputStream in = process.getInputStream();
                InputStreamReader inread = new InputStreamReader(in);
                BufferedReader bufferedreader = new BufferedReader(inread);
                while ((line = bufferedreader.readLine()) != null) {
                    System.out.println(line);
                }
            }
            if ((exit = process.waitFor()) != 0) {
                throw new ToolError("Script " + model.getScriptName() + " returned error exit code " + exit){};
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void setupScriptEnvironment(ProcessBuilder processBuilder, String script) {
        Map<String, String> env = processBuilder.environment();
        String ceylonHome = System.getProperty("ceylon.home");
        if (ceylonHome != null) {
            env.put("CEYLON_HOME", ceylonHome);
            String ceylonBin = ceylonHome + File.separator + "bin" + File.separator + "ceylon";
            if (OSUtil.isWindows()) {
                ceylonBin = ceylonBin + ".bat";
            }
            env.put("CEYLON", ceylonBin);
        }
        env.put("JAVA_HOME", System.getProperty("java.home"));
        env.put("CEYLON_VERSION_MAJOR", Integer.toString(1));
        env.put("CEYLON_VERSION_MINOR", Integer.toString(3));
        env.put("CEYLON_VERSION_RELEASE", Integer.toString(2));
        env.put("CEYLON_VERSION", "1.3.2");
        env.put("CEYLON_VERSION_FULL", "1.3.2 754a09a (Smile Tolerantly)");
        env.put("CEYLON_VERSION_NAME", "Smile Tolerantly");
        env.put("SCRIPT", script);
        env.put("SCRIPT_DIR", new File(script).getParent());
    }

    public Tool[] getTools() {
        String[] toolNames = this.getToolNames();
        Tool[] tools = new Tool[toolNames.length];
        for (int i = 0; i < toolNames.length; ++i) {
            tools[i] = this.getTool(this.getToolModel(toolNames[i]));
        }
        return tools;
    }

    public Tool getTool(ToolModel<?> model) {
        Tool tool = null;
        if (model == null) {
            ArgumentModel<?> argumentModel = this.getToolModel("").getArguments().get(0);
            argumentModel.setName("command");
            throw new NoSuchToolException(argumentModel, this.getToolName());
        }
        if (!(model instanceof AnnotatedToolModel)) {
            return null;
        }
        boolean useCache = false;
        if (this.toolName != null && this.toolName.equals(model.getName())) {
            useCache = true;
        }
        if (useCache && this.toolCache != null) {
            return this.toolCache;
        }
        tool = (Tool)this.getPluginFactory().bindArguments(model, this, this.toolArgs);
        if (useCache) {
            this.toolCache = tool;
        }
        return tool;
    }

    <T extends Tool> ToolModel<T> getToolModel(String toolName) {
        ToolModel model = this.getPluginLoader().loadToolModel(toolName);
        return model;
    }

    public <T extends Tool> ToolModel<T> getToolModel() {
        return this.getToolModel(this.getToolName());
    }

    ToolFactory getPluginFactory() {
        if (this.pluginFactory == null) {
            this.pluginFactory = new ToolFactory();
        }
        return this.pluginFactory;
    }

    public void setPluginFactory(ToolFactory toolFactory) {
        this.pluginFactory = toolFactory;
    }

    ToolLoader getPluginLoader() {
        if (this.pluginLoader == null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            this.pluginLoader = new CeylonToolLoader(classLoader);
        }
        return this.pluginLoader;
    }

    public void setToolLoader(ToolLoader toolLoader) {
        this.pluginLoader = toolLoader;
    }

    public Boolean getWantsPager() {
        return this.paginate;
    }
}

