/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common.tools.help;

import java.io.IOException;
import org.tautua.markdownpapers.ast.CharRef;
import org.tautua.markdownpapers.ast.Code;
import org.tautua.markdownpapers.ast.CodeSpan;
import org.tautua.markdownpapers.ast.CodeText;
import org.tautua.markdownpapers.ast.Comment;
import org.tautua.markdownpapers.ast.Document;
import org.tautua.markdownpapers.ast.Emphasis;
import org.tautua.markdownpapers.ast.Header;
import org.tautua.markdownpapers.ast.Image;
import org.tautua.markdownpapers.ast.InlineUrl;
import org.tautua.markdownpapers.ast.Item;
import org.tautua.markdownpapers.ast.Line;
import org.tautua.markdownpapers.ast.LineBreak;
import org.tautua.markdownpapers.ast.Link;
import org.tautua.markdownpapers.ast.List;
import org.tautua.markdownpapers.ast.Node;
import org.tautua.markdownpapers.ast.Paragraph;
import org.tautua.markdownpapers.ast.Quote;
import org.tautua.markdownpapers.ast.Resource;
import org.tautua.markdownpapers.ast.ResourceDefinition;
import org.tautua.markdownpapers.ast.Ruler;
import org.tautua.markdownpapers.ast.SimpleNode;
import org.tautua.markdownpapers.ast.Tag;
import org.tautua.markdownpapers.ast.TagAttribute;
import org.tautua.markdownpapers.ast.Text;
import org.tautua.markdownpapers.ast.Visitor;
import org.tautua.markdownpapers.util.Utils;

public class DocBookMarkdownVisitor
implements Visitor {
    private Appendable buffer;

    public DocBookMarkdownVisitor(Appendable buffer) {
        this.buffer = buffer;
    }

    public void visit(CharRef node) {
        this.append(node.getValue());
    }

    public void visit(Code node) {
        this.append("<programlisting>");
        this.visitChildrenAndAppendSeparator((Node)node, '\n');
        this.append("</programlisting>");
        this.append('\n');
    }

    public void visit(CodeSpan node) {
        this.append("<literal>");
        this.escapeAndAppend(node.getText());
        this.append("</literal>");
    }

    public void visit(CodeText node) {
        this.escapeAndAppend(node.getValue());
    }

    public void visit(Comment node) {
        this.append("<!--");
        this.append(node.getText());
        this.append("-->");
    }

    public void visit(Document node) {
        this.visitChildrenAndAppendSeparator((Node)node, '\n');
    }

    public void visit(Emphasis node) {
        switch (node.getType()) {
            case ITALIC: {
                this.append("<emphasis>");
                this.append(node.getText());
                this.append("</emphasis>");
                break;
            }
            case BOLD: {
                this.append("<emphasis role='bold'>");
                this.append(node.getText());
                this.append("</emphasis>");
                break;
            }
            case ITALIC_AND_BOLD: {
                this.append("<emphasis><emphasis role='bold'>");
                this.append(node.getText());
                this.append("</emphasis></emphasis>");
            }
        }
    }

    public void visit(Header node) {
        this.append("<title>");
        node.childrenAccept((Visitor)this);
        this.append("</title>");
        this.append('\n');
    }

    public void visit(Image node) {
        Resource resource = node.getResource();
        this.append("<informalfigure>");
        this.append("<mediaobject>");
        if (node.getText() != null) {
            this.append("<caption>");
            this.escapeAndAppend(node.getText());
            this.append("</caption>");
        }
        if (resource != null) {
            this.append("<imageobject");
            this.append(" fileref=\"");
            this.escapeAndAppend(resource.getLocation());
            this.append("\"/>");
        }
        if (resource != null) {
            this.append("<textobject>");
            this.append("<phrase>");
            this.escapeAndAppend(resource.getHint());
            this.append("</phrase>");
            this.append("</textobject>");
        }
        this.append("<caption>");
        this.escapeAndAppend(node.getText());
        this.append("</caption>");
        this.append("</mediaobject>");
        this.append("</informalfigure>");
    }

    public void visit(InlineUrl node) {
        this.append("<a href=\"");
        this.escapeAndAppend(node.getUrl());
        this.append("\">");
        this.escapeAndAppend(node.getUrl());
        this.append("</a>");
    }

    public void visit(Item node) {
        this.append("<listitem><para>");
        node.childrenAccept((Visitor)this);
        this.append("</para></listitem>");
        this.append('\n');
    }

    public void visit(Line node) {
        node.childrenAccept((Visitor)this);
    }

    public void visit(LineBreak node) {
        Line l = (Line)node.jjtGetParent();
        if (!l.isEnding()) {
            this.append("<br/>");
        }
    }

    public void visit(Link node) {
        Resource resource = node.getResource();
        if (resource == null) {
            if (node.isReferenced()) {
                this.append("[");
                node.childrenAccept((Visitor)this);
                this.append("]");
                if (node.getReference() != null) {
                    if (node.hasWhitespaceAtMiddle()) {
                        this.append(' ');
                    }
                    this.append("[");
                    this.append(node.getReference());
                    this.append("]");
                }
            } else {
                this.append("<a href=\"\">");
                node.childrenAccept((Visitor)this);
                this.append("</a>");
            }
        } else {
            this.append("<a");
            this.append(" href=\"");
            this.escapeAndAppend(resource.getLocation());
            if (resource.getHint() != null) {
                this.append("\" title=\"");
                this.escapeAndAppend(resource.getHint());
            }
            this.append("\">");
            node.childrenAccept((Visitor)this);
            this.append("</a>");
        }
    }

    public void visit(ResourceDefinition node) {
    }

    public void visit(List node) {
        if (node.isOrdered()) {
            this.append("<orderedlist>");
            this.append('\n');
            node.childrenAccept((Visitor)this);
            this.append("</orderedlist>");
        } else {
            this.append("<itemizedlist>");
            this.append('\n');
            node.childrenAccept((Visitor)this);
            this.append("</itemizedlist>");
        }
        this.append('\n');
    }

    public void visit(Paragraph node) {
        Node parent = node.jjtGetParent();
        if (parent instanceof Item && !((Item)parent).isLoose()) {
            this.visitChildrenAndAppendSeparator((Node)node, '\n');
            return;
        }
        this.append("<para>");
        this.visitChildrenAndAppendSeparator((Node)node, '\n');
        this.append("</para>");
        this.append('\n');
    }

    public void visit(Ruler node) {
        this.append("<hr/>");
        this.append('\n');
    }

    public void visit(Quote node) {
        this.append("<blockquote>");
        this.append('\n');
        node.childrenAccept((Visitor)this);
        this.append("</blockquote>");
        this.append('\n');
    }

    public void visit(SimpleNode node) {
        throw new IllegalArgumentException("can not process this element");
    }

    public void visit(Tag node) {
        this.append("<");
        this.append(node.getName());
        for (TagAttribute attribute : node.getAttributes()) {
            this.append(' ');
            this.append(attribute.getName());
            this.append("=\"");
            this.append(attribute.getValue());
            this.append("\"");
        }
        if (node.jjtGetNumChildren() == 0) {
            this.append("/>");
        } else {
            this.append(">");
            node.childrenAccept((Visitor)this);
            this.append("</");
            this.append(node.getName());
            this.append(">");
        }
    }

    public void visit(Text node) {
        if (node.jjtGetParent() instanceof Tag) {
            this.append(node.getValue());
        } else {
            this.escapeAndAppend(node.getValue());
        }
    }

    void visitChildrenAndAppendSeparator(Node node, char separator) {
        int count = node.jjtGetNumChildren();
        for (int i = 0; i < count; ++i) {
            node.jjtGetChild(i).accept((Visitor)this);
            if (i >= count - 1) continue;
            this.append(separator);
        }
    }

    void escapeAndAppend(String val) {
        for (char character : val.toCharArray()) {
            this.append(Utils.escape((char)character));
        }
    }

    void append(String val) {
        try {
            this.buffer.append(val);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void append(char val) {
        try {
            this.buffer.append(val);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

