/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.common.tools.help.model;

import com.redhat.ceylon.common.tool.SubtoolModel;
import com.redhat.ceylon.common.tool.ToolLoader;
import com.redhat.ceylon.common.tool.ToolModel;
import java.util.Stack;

public abstract class SubtoolVisitor {
    protected final ToolModel<?> root;
    protected final Stack<ToolModelAndSubtoolModel> ancestors = new Stack();

    public SubtoolVisitor(ToolModel<?> root) {
        this.root = root;
    }

    public void accept() {
        this.visit(this.root, null);
        if (this.root.getSubtoolModel() != null) {
            this.accept(this.root, this.root.getSubtoolModel());
        }
    }

    protected abstract void visit(ToolModel<?> var1, SubtoolModel<?> var2);

    protected void accept(ToolModel<?> parent, SubtoolModel<?> subtoolModel) {
        this.ancestors.push(new ToolModelAndSubtoolModel(parent, subtoolModel));
        ToolLoader subtoolLoader = subtoolModel.getToolLoader();
        for (String toolName : subtoolLoader.getToolNames()) {
            ToolModel model = subtoolLoader.loadToolModel(toolName);
            this.visit(model, subtoolModel);
            if (model.getSubtoolModel() == null) continue;
            this.accept(model, model.getSubtoolModel());
        }
        this.ancestors.pop();
    }

    public static class ToolModelAndSubtoolModel {
        private final ToolModel<?> model;
        private final SubtoolModel<?> subtoolModel;

        public ToolModelAndSubtoolModel(ToolModel<?> model, SubtoolModel<?> subtoolModel) {
            this.model = model;
            this.subtoolModel = subtoolModel;
        }

        public String getName() {
            return this.model.getName();
        }

        public ToolModel<?> getModel() {
            return this.model;
        }

        public SubtoolModel<?> getSubtoolModel() {
            return this.subtoolModel;
        }

        public String toString() {
            return this.model.getName();
        }
    }
}

