/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.compiler.java.codegen.AnnotationConstructorParameter;
import com.redhat.ceylon.compiler.java.codegen.AnnotationInvocation;
import com.redhat.ceylon.compiler.java.codegen.CeylonTransformer;
import com.redhat.ceylon.compiler.java.codegen.recovery.Errors;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.model.typechecker.model.Class;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Function;

public class AnnotationDeclarationVisitor
extends Visitor {
    private Tree.AnyMethod annotationConstructor;
    private AnnotationInvocation instantiation;
    private boolean checkingArguments;
    private boolean checkingInvocationPrimary;
    private final Errors errors;

    public AnnotationDeclarationVisitor(CeylonTransformer gen) {
        this.errors = gen.errors();
    }

    @Override
    public void handleException(Exception e, Node node) {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new RuntimeException(e);
    }

    public static boolean isAnnotationConstructor(Tree.AnyMethod def) {
        return AnnotationDeclarationVisitor.isAnnotationConstructor(def.getDeclarationModel());
    }

    public static boolean isAnnotationConstructor(Declaration def) {
        return def.isToplevel() && def instanceof Function && def.isAnnotation();
    }

    public static boolean isAnnotationClass(Tree.ClassOrInterface def) {
        return AnnotationDeclarationVisitor.isAnnotationClass(def.getDeclarationModel());
    }

    public static boolean isAnnotationClass(Declaration declarationModel) {
        return declarationModel instanceof Class && declarationModel.isAnnotation();
    }

    @Override
    public void visit(Tree.MethodDefinition d) {
        if (this.errors.hasAnyError(d)) {
            return;
        }
        if (AnnotationDeclarationVisitor.isAnnotationConstructor(d)) {
            this.annotationConstructor = d;
            this.instantiation = new AnnotationInvocation();
            this.instantiation.setConstructorDeclaration(d.getDeclarationModel());
            d.getDeclarationModel().setAnnotationConstructor(this.instantiation);
        }
        super.visit(d);
        if (AnnotationDeclarationVisitor.isAnnotationConstructor(d)) {
            this.instantiation = null;
            this.annotationConstructor = null;
        }
    }

    @Override
    public void visit(Tree.MethodDeclaration d) {
        if (this.errors.hasAnyError(d)) {
            return;
        }
        if (AnnotationDeclarationVisitor.isAnnotationConstructor(d) && d.getSpecifierExpression() != null) {
            this.annotationConstructor = d;
            this.instantiation = new AnnotationInvocation();
            this.instantiation.setConstructorDeclaration(d.getDeclarationModel());
            d.getDeclarationModel().setAnnotationConstructor(this.instantiation);
        }
        super.visit(d);
        if (AnnotationDeclarationVisitor.isAnnotationConstructor(d)) {
            this.instantiation = null;
            this.annotationConstructor = null;
        }
    }

    @Override
    public void visit(Tree.Parameter p) {
        if (this.annotationConstructor != null) {
            AnnotationConstructorParameter acp = new AnnotationConstructorParameter();
            acp.setParameter(p.getParameterModel());
            this.instantiation.addConstructorParameter(acp);
        }
    }
}

