/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.javax.lang.model.element.Modifier;
import com.redhat.ceylon.javax.lang.model.element.NestingKind;
import com.redhat.ceylon.javax.tools.ForwardingFileObject;
import com.redhat.ceylon.javax.tools.JavaFileObject;
import com.redhat.ceylon.langtools.tools.javac.util.JCDiagnostic;
import com.redhat.ceylon.langtools.tools.javac.util.List;

public class CeylonFileObject
extends ForwardingFileObject<JavaFileObject>
implements JavaFileObject {
    private final JavaFileObject f;
    private List<JCDiagnostic> errorList = List.nil();

    public CeylonFileObject(JavaFileObject f) {
        super(f);
        this.f = f;
    }

    public JavaFileObject getFile() {
        return this.f;
    }

    @Override
    public JavaFileObject.Kind getKind() {
        String n = this.f.getName();
        if (n.endsWith(JavaFileObject.Kind.CLASS.extension)) {
            return JavaFileObject.Kind.CLASS;
        }
        if (n.endsWith(JavaFileObject.Kind.SOURCE.extension) || n.endsWith(".ceylon")) {
            return JavaFileObject.Kind.SOURCE;
        }
        if (n.endsWith(JavaFileObject.Kind.HTML.extension)) {
            return JavaFileObject.Kind.HTML;
        }
        return JavaFileObject.Kind.OTHER;
    }

    @Override
    public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
        if (kind == JavaFileObject.Kind.SOURCE) {
            String n;
            String name = this.f.getName();
            if (name.endsWith(n = simpleName + ".ceylon")) {
                return true;
            }
            int limit = simpleName.indexOf("$$overload");
            if (limit >= 0 && name.endsWith(n = simpleName.substring(0, limit) + ".ceylon")) {
                return true;
            }
        }
        return this.f.isNameCompatible(simpleName, kind);
    }

    @Override
    public NestingKind getNestingKind() {
        return this.f.getNestingKind();
    }

    @Override
    public Modifier getAccessLevel() {
        return this.f.getAccessLevel();
    }

    public String toString() {
        return this.f.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CeylonFileObject) {
            return this.f.equals(((CeylonFileObject)obj).f);
        }
        return this.f.equals(obj);
    }

    public boolean hasError() {
        return !this.errorList.isEmpty();
    }

    public void addError(JCDiagnostic error) {
        this.errorList = this.errorList.prepend(error);
    }

    public boolean hasError(int pos) {
        for (JCDiagnostic error : this.errorList) {
            if (error.getStartPosition() <= (long)pos && (long)pos <= error.getEndPosition()) {
                return true;
            }
            if (error.getStartPosition() != -1L) continue;
            return true;
        }
        return false;
    }
}

