/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.compiler.java.codegen.AbstractTransformer;
import com.redhat.ceylon.compiler.java.codegen.AttributeDefinitionBuilder;
import com.redhat.ceylon.compiler.java.codegen.BugException;
import com.redhat.ceylon.compiler.java.codegen.CeylonCompilationUnit;
import com.redhat.ceylon.compiler.java.codegen.CeylonFileObject;
import com.redhat.ceylon.compiler.java.codegen.CeylonVisitor;
import com.redhat.ceylon.compiler.java.codegen.ClassDefinitionBuilder;
import com.redhat.ceylon.compiler.java.codegen.CodegenUtil;
import com.redhat.ceylon.compiler.java.codegen.Decl;
import com.redhat.ceylon.compiler.java.codegen.EeVisitor;
import com.redhat.ceylon.compiler.java.codegen.GetterSetterPairingVisitor;
import com.redhat.ceylon.compiler.java.codegen.LabelVisitor;
import com.redhat.ceylon.compiler.java.codegen.Naming;
import com.redhat.ceylon.compiler.java.codegen.ToplevelAttributesDefinitionBuilder;
import com.redhat.ceylon.compiler.java.codegen.recovery.HasErrorException;
import com.redhat.ceylon.compiler.java.loader.SourceDeclarationVisitor;
import com.redhat.ceylon.compiler.java.tools.CeylonPhasedUnit;
import com.redhat.ceylon.compiler.typechecker.context.PhasedUnit;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.TreeUtil;
import com.redhat.ceylon.javax.lang.model.element.Modifier;
import com.redhat.ceylon.javax.lang.model.element.NestingKind;
import com.redhat.ceylon.javax.tools.JavaFileObject;
import com.redhat.ceylon.langtools.tools.javac.tree.JCTree;
import com.redhat.ceylon.langtools.tools.javac.util.Context;
import com.redhat.ceylon.langtools.tools.javac.util.ListBuffer;
import com.redhat.ceylon.langtools.tools.javac.util.Name;
import com.redhat.ceylon.langtools.tools.javac.util.Options;
import com.redhat.ceylon.langtools.tools.javac.util.Position;
import com.redhat.ceylon.model.loader.NamingBase;
import com.redhat.ceylon.model.loader.model.OutputElement;
import com.redhat.ceylon.model.typechecker.model.FunctionOrValue;
import com.redhat.ceylon.model.typechecker.model.Parameter;
import com.redhat.ceylon.model.typechecker.model.Setter;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import com.redhat.ceylon.model.typechecker.model.Value;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public class CeylonTransformer
extends AbstractTransformer {
    private Options options;
    private Position.LineMap map;
    private JavaFileObject fileObject;
    public int disableAnnotations = 0;
    static final int DISABLE_MODEL_ANNOS = 1;
    static final int DISABLE_USER_ANNOS = 2;
    CeylonVisitor visitor;

    public static CeylonTransformer getInstance(Context context) {
        CeylonTransformer trans = context.get(CeylonTransformer.class);
        if (trans == null) {
            trans = new CeylonTransformer(context);
            context.put(CeylonTransformer.class, trans);
        }
        return trans;
    }

    public CeylonTransformer(Context context) {
        super(context);
        this.setup(context);
    }

    private void setup(Context context) {
        this.options = Options.instance(context);
        this.options.put("invokedynamic", "invokedynamic");
    }

    @Override
    public void setMap(Position.LineMap map) {
        this.map = map;
    }

    @Override
    protected Position.LineMap getMap() {
        return this.map;
    }

    public void setFileObject(JavaFileObject fileObject) {
        this.fileObject = fileObject;
    }

    public JavaFileObject getFileObject() {
        return this.fileObject;
    }

    public JCTree.JCCompilationUnit makeJCCompilationUnitPlaceholder(Tree.CompilationUnit t, JavaFileObject file, String pkgName, PhasedUnit phasedUnit) {
        JCTree.JCExpression pkg = pkgName != null ? this.getPackage(pkgName) : null;
        this.at(t);
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree> defs = this.makeDefs(t);
        CeylonCompilationUnit topLev = new CeylonCompilationUnit(com.redhat.ceylon.langtools.tools.javac.util.List.nil(), pkg, defs, null, null, null, null, t, phasedUnit);
        topLev.lineMap = this.getMap();
        topLev.sourcefile = file;
        topLev.isCeylonProgram = true;
        return topLev;
    }

    private com.redhat.ceylon.langtools.tools.javac.util.List<JCTree> makeDefs(Tree.CompilationUnit t) {
        final ListBuffer defs = new ListBuffer();
        t.visit(new SourceDeclarationVisitor(){

            @Override
            public void loadFromSource(Tree.Declaration decl) {
                if (!this.checkNative(decl)) {
                    return;
                }
                Stack<Tree.Declaration> ancestors = new Stack<Tree.Declaration>();
                long flags = decl instanceof Tree.AnyInterface ? 512L : 0L;
                String name = Naming.toplevelClassName("", decl);
                defs.add(this.makeClassDef(decl, flags, name, WantedDeclaration.Normal, defs, ancestors));
                if (decl instanceof Tree.AnyInterface) {
                    String implName = Naming.getImplClassName(name);
                    defs.add(this.makeClassDef(decl, 0L, implName, WantedDeclaration.InterfaceImpl, defs, ancestors));
                }
                if (Decl.isAnnotationClassNoModel(decl)) {
                    String annotationName = Naming.suffixName(NamingBase.Suffix.$annotation$, name);
                    defs.add(this.makeClassDef(decl, 8704L, annotationName, WantedDeclaration.Annotation, defs, ancestors));
                    if (Decl.isSequencedAnnotationClassNoModel((Tree.AnyClass)decl)) {
                        String annotationsName = Naming.suffixName(NamingBase.Suffix.$annotations$, name);
                        defs.add(this.makeClassDef(decl, 8704L, annotationsName, WantedDeclaration.AnnotationSequence, defs, ancestors));
                    }
                }
            }

            private JCTree makeClassDef(Tree.Declaration decl, long flags, String name, WantedDeclaration wantedDeclaration, ListBuffer<JCTree> toplevelDeclarations, Stack<Tree.Declaration> ancestors) {
                if (TreeUtil.hasAnnotation(decl.getAnnotationList(), "static", null)) {
                    flags |= 8L;
                }
                ListBuffer<JCTree.JCTypeParameter> typarams = new ListBuffer<JCTree.JCTypeParameter>();
                if (decl instanceof Tree.ClassOrInterface) {
                    Tree.ClassOrInterface classDecl = (Tree.ClassOrInterface)decl;
                    if (decl instanceof Tree.AnyInterface) {
                        for (Tree.Declaration ancestor : ancestors) {
                            if (!(ancestor instanceof Tree.ClassOrInterface)) continue;
                            this.addTypeParameters(typarams, (Tree.ClassOrInterface)ancestor);
                        }
                    }
                    this.addTypeParameters(typarams, classDecl);
                }
                ancestors.push(decl);
                JCTree.JCClassDecl ret = CeylonTransformer.this.make().ClassDef(CeylonTransformer.this.make().Modifiers(flags | 1L), CeylonTransformer.this.names().fromString(name), typarams.toList(), null, com.redhat.ceylon.langtools.tools.javac.util.List.nil(), this.makeClassBody(decl, wantedDeclaration, toplevelDeclarations, ancestors));
                ancestors.pop();
                return ret;
            }

            private void addTypeParameters(ListBuffer<JCTree.JCTypeParameter> typarams, Tree.ClassOrInterface classDecl) {
                if (classDecl.getTypeParameterList() != null) {
                    for (Tree.TypeParameterDeclaration typeParamDecl : classDecl.getTypeParameterList().getTypeParameterDeclarations()) {
                        typarams.add(CeylonTransformer.this.make().TypeParameter(CeylonTransformer.this.names().fromString("BOGUS-" + typeParamDecl.getIdentifier().getText()), com.redhat.ceylon.langtools.tools.javac.util.List.nil()));
                    }
                }
            }

            private com.redhat.ceylon.langtools.tools.javac.util.List<JCTree> makeClassBody(Tree.Declaration decl, WantedDeclaration wantedDeclaration, ListBuffer<JCTree> toplevelDeclarations, Stack<Tree.Declaration> ancestors) {
                if (wantedDeclaration == WantedDeclaration.Annotation) {
                    ListBuffer<JCTree.JCMethodDecl> body = new ListBuffer<JCTree.JCMethodDecl>();
                    for (Tree.Parameter param : ((Tree.ClassDefinition)decl).getParameterList().getParameters()) {
                        String name;
                        JCTree.JCExpression type = CeylonTransformer.this.make().TypeArray(CeylonTransformer.this.make().Type(CeylonTransformer.this.syms().stringType));
                        if (param instanceof Tree.InitializerParameter) {
                            name = ((Tree.InitializerParameter)param).getIdentifier().getText();
                        } else if (param instanceof Tree.ParameterDeclaration) {
                            Tree.TypedDeclaration typedDeclaration = ((Tree.ParameterDeclaration)param).getTypedDeclaration();
                            name = typedDeclaration.getIdentifier().getText();
                            type = this.getAnnotationTypeFor(typedDeclaration.getType());
                        } else {
                            name = "ERROR";
                        }
                        JCTree.JCMethodDecl method = CeylonTransformer.this.make().MethodDef(CeylonTransformer.this.make().Modifiers(1L), CeylonTransformer.this.names().fromString(name), type, com.redhat.ceylon.langtools.tools.javac.util.List.nil(), com.redhat.ceylon.langtools.tools.javac.util.List.nil(), com.redhat.ceylon.langtools.tools.javac.util.List.nil(), null, null);
                        body.append(method);
                    }
                    return body.toList();
                }
                if (wantedDeclaration == WantedDeclaration.AnnotationSequence) {
                    String name = Naming.toplevelClassName("", decl);
                    String annotationName = Naming.suffixName(NamingBase.Suffix.$annotation$, name);
                    JCTree.JCArrayTypeTree type = CeylonTransformer.this.make().TypeArray(CeylonTransformer.this.make().Ident(CeylonTransformer.this.names().fromString(annotationName)));
                    JCTree.JCMethodDecl method = CeylonTransformer.this.make().MethodDef(CeylonTransformer.this.make().Modifiers(1L), CeylonTransformer.this.names().fromString("value"), type, com.redhat.ceylon.langtools.tools.javac.util.List.nil(), com.redhat.ceylon.langtools.tools.javac.util.List.nil(), com.redhat.ceylon.langtools.tools.javac.util.List.nil(), null, null);
                    return com.redhat.ceylon.langtools.tools.javac.util.List.of(method);
                }
                ListBuffer<JCTree> defs2 = new ListBuffer<JCTree>();
                List<Tree.Statement> statements = null;
                if (decl instanceof Tree.ClassDefinition) {
                    statements = ((Tree.ClassDefinition)decl).getClassBody().getStatements();
                } else if (decl instanceof Tree.InterfaceDefinition && wantedDeclaration == WantedDeclaration.InterfaceImpl) {
                    statements = ((Tree.InterfaceDefinition)decl).getInterfaceBody().getStatements();
                }
                if (statements != null) {
                    for (Tree.Statement member : statements) {
                        String name;
                        if (!(member instanceof Tree.ClassOrInterface) || !this.checkNative((Tree.Declaration)member)) continue;
                        long flags = member instanceof Tree.AnyInterface ? 512L : 0L;
                        String initialName = Naming.toplevelClassName("", (Tree.Declaration)member);
                        if (member instanceof Tree.AnyInterface) {
                            StringBuffer strbuf = new StringBuffer();
                            for (Tree.Declaration part : ancestors) {
                                strbuf.append(part.getIdentifier().getText()).append("$");
                            }
                            name = strbuf.append(initialName).toString();
                        } else {
                            name = initialName;
                        }
                        JCTree def = this.makeClassDef((Tree.Declaration)member, flags, name, WantedDeclaration.Normal, toplevelDeclarations, ancestors);
                        if (member instanceof Tree.AnyInterface) {
                            toplevelDeclarations.add(def);
                            String implName = Naming.getImplClassName(initialName);
                            defs2.add(this.makeClassDef((Tree.Declaration)member, 0L, implName, WantedDeclaration.InterfaceImpl, defs2, ancestors));
                            continue;
                        }
                        defs2.add(def);
                    }
                }
                return defs2.toList();
            }

            private JCTree.JCExpression getAnnotationTypeFor(Tree.Type type) {
                if (type instanceof Tree.BaseType) {
                    String name = ((Tree.BaseType)type).getIdentifier().getText();
                    if (name.equals("String") || name.equals("Declaration")) {
                        return CeylonTransformer.this.make().Type(CeylonTransformer.this.syms().stringType);
                    }
                    if (name.equals("Boolean")) {
                        return CeylonTransformer.this.make().Type(CeylonTransformer.this.syms().booleanType);
                    }
                    if (name.equals("Integer")) {
                        return CeylonTransformer.this.make().Type(CeylonTransformer.this.syms().longType);
                    }
                    if (name.equals("Float")) {
                        return CeylonTransformer.this.make().Type(CeylonTransformer.this.syms().doubleType);
                    }
                    if (name.equals("Byte")) {
                        return CeylonTransformer.this.make().Type(CeylonTransformer.this.syms().byteType);
                    }
                    if (name.equals("Character")) {
                        return CeylonTransformer.this.make().Type(CeylonTransformer.this.syms().charType);
                    }
                    if (name.equals("Declaration") || name.equals("ClassDeclaration") || name.equals("InterfaceDeclaration") || name.equals("ClassOrInterfaceDeclaration")) {
                        return CeylonTransformer.this.make().Type(CeylonTransformer.this.syms().stringType);
                    }
                    return CeylonTransformer.this.make().TypeArray(CeylonTransformer.this.make().Type(CeylonTransformer.this.syms().stringType));
                }
                if (type instanceof Tree.SequencedType) {
                    return CeylonTransformer.this.make().TypeArray(this.getAnnotationTypeFor(((Tree.SequencedType)type).getType()));
                }
                if (type instanceof Tree.SequenceType) {
                    return CeylonTransformer.this.make().TypeArray(this.getAnnotationTypeFor(((Tree.SequenceType)type).getElementType()));
                }
                if (type instanceof Tree.IterableType) {
                    return CeylonTransformer.this.make().TypeArray(this.getAnnotationTypeFor(((Tree.IterableType)type).getElementType()));
                }
                if (type instanceof Tree.TupleType) {
                    Tree.Type sequencedType = ((Tree.TupleType)type).getElementTypes().get(0);
                    return this.getAnnotationTypeFor(sequencedType);
                }
                System.err.println("Unknown Annotation type: " + type);
                return CeylonTransformer.this.make().TypeArray(CeylonTransformer.this.make().Type(CeylonTransformer.this.syms().stringType));
            }

            @Override
            public void loadFromSource(Tree.ModuleDescriptor that) {
            }

            @Override
            public void loadFromSource(Tree.PackageDescriptor that) {
            }
        });
        return defs.toList();
    }

    public ListBuffer<JCTree> transformAfterTypeChecking(Tree.CompilationUnit t) {
        this.disableAnnotations = 0;
        this.naming.resetUniqueIds();
        GetterSetterPairingVisitor gspv = new GetterSetterPairingVisitor();
        t.visit(gspv);
        ToplevelAttributesDefinitionBuilder builder = new ToplevelAttributesDefinitionBuilder(this);
        LabelVisitor lv = new LabelVisitor();
        CeylonVisitor visitor = new CeylonVisitor(this, builder, lv, gspv);
        t.visit(lv);
        t.visit(visitor);
        ListBuffer<JCTree> result = new ListBuffer<JCTree>();
        result.appendList(visitor.getResult());
        result.appendList(builder.build());
        return result;
    }

    Name makeName(Iterable<String> components) {
        Iterator<String> iterator = components.iterator();
        String s = iterator.next();
        assert (!iterator.hasNext());
        return this.names().fromString(s);
    }

    String toFlatName(Iterable<String> components) {
        StringBuffer buf = new StringBuffer();
        Iterator<String> iterator = components.iterator();
        while (iterator.hasNext()) {
            buf.append(iterator.next());
            if (!iterator.hasNext()) continue;
            buf.append('.');
        }
        return buf.toString();
    }

    private JCTree.JCExpression getPackage(String fullname) {
        return this.makeQuotedQualIdentFromString(fullname);
    }

    public JCTree.JCImport transform(Tree.ImportPath that) {
        String[] names = new String[that.getIdentifiers().size()];
        int i = 0;
        for (Tree.Identifier component : that.getIdentifiers()) {
            names[i++] = component.getText();
        }
        return this.at(that).Import(this.makeQuotedQualIdent(null, names), false);
    }

    public com.redhat.ceylon.langtools.tools.javac.util.List<JCTree> transform(Tree.AnyAttribute decl) {
        return this.transformAttribute(decl, null);
    }

    public com.redhat.ceylon.langtools.tools.javac.util.List<JCTree> transform(Tree.AttributeSetterDefinition decl) {
        return this.transformAttribute(decl, null);
    }

    public com.redhat.ceylon.langtools.tools.javac.util.List<JCTree> transformAttribute(Tree.TypedDeclaration decl, Tree.AttributeSetterDefinition setterDecl) {
        Tree.Block block;
        Tree.SpecifierOrInitializerExpression expression;
        this.at(decl);
        TypedDeclaration declarationModel = decl.getDeclarationModel();
        String attrName = declarationModel.getName();
        String attrClassName = Naming.getAttrClassName(declarationModel, 0);
        if (decl instanceof Tree.AttributeDeclaration) {
            Tree.AttributeDeclaration adecl = (Tree.AttributeDeclaration)decl;
            expression = adecl.getSpecifierOrInitializerExpression();
            block = null;
        } else if (decl instanceof Tree.AttributeGetterDefinition) {
            expression = null;
            Tree.AttributeGetterDefinition gdef = (Tree.AttributeGetterDefinition)decl;
            block = gdef.getBlock();
        } else if (decl instanceof Tree.AttributeSetterDefinition) {
            Tree.AttributeSetterDefinition sdef = (Tree.AttributeSetterDefinition)decl;
            block = sdef.getBlock();
            expression = sdef.getSpecifierExpression();
            if (Decl.isLocal(decl)) {
                declarationModel = ((Tree.AttributeSetterDefinition)decl).getDeclarationModel().getParameter().getModel();
            }
        } else {
            throw new RuntimeException();
        }
        return this.transformAttribute(declarationModel, attrName, attrClassName, decl, block, expression, decl, setterDecl);
    }

    public com.redhat.ceylon.langtools.tools.javac.util.List<JCTree> transformAttribute(TypedDeclaration declarationModel, String attrName, String attrClassName, Tree.Declaration annotated, Tree.Block block, Tree.SpecifierOrInitializerExpression expression, Tree.TypedDeclaration decl, Tree.AttributeSetterDefinition setterDecl) {
        Setter setter;
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> scopeAnnotations;
        JCTree.JCExpression initialValue;
        ClassDefinitionBuilder classBuilder = ClassDefinitionBuilder.klass(this, attrClassName, null, false);
        HasErrorException expressionError = expression != null ? this.errors().getFirstExpressionErrorAndMarkBrokenness(expression.getExpression()) : null;
        AbstractTransformer.BoxingStrategy boxingStrategy = null;
        if (expressionError != null) {
            initialValue = this.make().Erroneous();
        } else if (Decl.isNonTransientValue(declarationModel) && !(expression instanceof Tree.LazySpecifierExpression)) {
            if (expression != null) {
                boxingStrategy = this.useJavaBox(declarationModel, declarationModel.getType()) && this.javaBoxExpression(expression.getExpression().getTypeModel(), declarationModel.getType()) ? AbstractTransformer.BoxingStrategy.JAVA : CodegenUtil.getBoxingStrategy(declarationModel);
                initialValue = this.expressionGen().transform(expression, boxingStrategy, declarationModel.getType());
            } else {
                Parameter p = CodegenUtil.findParamForDecl(attrName, declarationModel);
                if (p != null) {
                    boxingStrategy = CodegenUtil.getBoxingStrategy(p.getModel());
                    initialValue = this.naming.makeName(p.getModel(), 257);
                } else {
                    initialValue = null;
                }
            }
        } else {
            initialValue = null;
        }
        boolean memoized = declarationModel.isLate() && expression != null;
        AttributeDefinitionBuilder builder = AttributeDefinitionBuilder.wrapped(this, attrName, declarationModel, declarationModel.isToplevel(), memoized ? initialValue : null);
        builder.is(1L, declarationModel.isShared());
        if (this.isJavaStrictfp(declarationModel)) {
            builder.is(2048L, true);
        }
        if (this.isJavaSynchronized(declarationModel)) {
            builder.is(32L, true);
        }
        if (this.isJavaNative(declarationModel)) {
            builder.is(256L, true);
            builder.isJavaNative(true);
        }
        if (Decl.isBoxedVariable(declarationModel)) {
            classBuilder.restoreClassBuilder();
            if (expressionError != null) {
                return com.redhat.ceylon.langtools.tools.javac.util.List.of(this.makeThrowUnresolvedCompilationError(expressionError));
            }
            return com.redhat.ceylon.langtools.tools.javac.util.List.of(this.makeVariableBoxDecl(initialValue, declarationModel));
        }
        if (block == null && expression == null && !Decl.isToplevel(declarationModel)) {
            JCTree.JCExpression typeExpr = this.makeJavaType(this.getGetterInterfaceType(declarationModel));
            JCTree.JCVariableDecl var = this.makeVar(attrClassName, typeExpr, null);
            classBuilder.restoreClassBuilder();
            return com.redhat.ceylon.langtools.tools.javac.util.List.of(var);
        }
        if (decl != null) {
            scopeAnnotations = Decl.isToplevel(declarationModel) && setterDecl != null ? this.makeAtLocalDeclarations(decl, setterDecl) : this.makeAtLocalDeclarations(decl);
            builder.classAnnotations(scopeAnnotations);
        } else if (block != null) {
            scopeAnnotations = this.makeAtLocalDeclarations(block);
            builder.classAnnotations(scopeAnnotations);
        }
        if (Decl.isGetter(declarationModel) && declarationModel.isVariable() && Decl.isLocal(declarationModel) && (setter = ((Value)declarationModel).getSetter()) != null) {
            String setterClassName = Naming.getAttrClassName(setter, 0);
            JCTree.JCIdent setterClassNameExpr = this.naming.makeUnquotedIdent(setterClassName);
            builder.setterClass(this.makeSelect(setterClassNameExpr, "class"));
        }
        if (declarationModel instanceof Setter || declarationModel instanceof FunctionOrValue && ((FunctionOrValue)declarationModel).isParameter()) {
            JCTree.JCBlock setterBlock = this.makeSetterBlock(declarationModel, block, expression);
            builder.setterBlock(setterBlock);
            builder.skipGetter();
            if (Decl.isLocal(decl)) {
                Setter setter2 = (Setter)declarationModel.getContainer();
                String getterClassName = Naming.getAttrClassName(setter2.getGetter(), 0);
                JCTree.JCIdent getterClassNameExpr = this.naming.makeUnquotedIdent(getterClassName);
                builder.isSetter(this.makeSelect(getterClassNameExpr, "class"));
            }
        } else if (Decl.isValue(declarationModel)) {
            if (!declarationModel.isVariable() && !declarationModel.isLate()) {
                builder.immutable();
            }
        } else {
            boolean prevSyntheticClassBody = Decl.isLocal(declarationModel) ? this.expressionGen().withinSyntheticClassBody(true) : this.expressionGen().isWithinSyntheticClassBody();
            JCTree.JCBlock getterBlock = this.makeGetterBlock(declarationModel, block, expression);
            prevSyntheticClassBody = this.expressionGen().withinSyntheticClassBody(prevSyntheticClassBody);
            builder.getterBlock(getterBlock);
            if (Decl.isLocal(declarationModel)) {
                builder.immutable();
            } else if (setterDecl != null) {
                JCTree.JCBlock setterBlock = this.makeSetterBlock(setterDecl.getDeclarationModel(), setterDecl.getBlock(), setterDecl.getSpecifierExpression());
                builder.setterBlock(setterBlock);
                builder.userAnnotationsSetter(this.expressionGen().transformAnnotations(OutputElement.SETTER, setterDecl));
            } else {
                builder.immutable();
            }
        }
        if (annotated != null) {
            builder.userAnnotations(this.expressionGen().transformAnnotations(OutputElement.GETTER, annotated));
            builder.fieldAnnotations(this.expressionGen().transformAnnotations(OutputElement.FIELD, annotated));
        }
        if (Decl.isLocal(declarationModel)) {
            if (expressionError != null) {
                classBuilder.restoreClassBuilder();
                return com.redhat.ceylon.langtools.tools.javac.util.List.of(this.makeThrowUnresolvedCompilationError(expressionError));
            }
            builder.classAnnotations(this.makeAtLocalDeclaration(declarationModel.getQualifier(), false));
            if (initialValue != null) {
                builder.valueConstructor();
            }
            JCTree.JCExpression typeExpr = declarationModel instanceof Setter || declarationModel instanceof FunctionOrValue && ((FunctionOrValue)declarationModel).isParameter() ? this.makeQuotedIdent(attrClassName) : this.makeJavaType(this.getGetterInterfaceType(declarationModel));
            return builder.buildWithWrapperClass(classBuilder).append(this.makeLocalIdentityInstance(typeExpr, attrClassName, attrClassName, declarationModel.isShared(), initialValue));
        }
        if (expressionError != null) {
            builder.initialValueError(expressionError);
        } else if (!memoized && initialValue != null) {
            builder.initialValue(initialValue, boxingStrategy);
        }
        builder.is(8L, true);
        return builder.buildWithWrapperClass(classBuilder);
    }

    public JCTree.JCExpression transformAttributeGetter(TypedDeclaration declarationModel, JCTree.JCExpression expression) {
        String attrName = declarationModel.getName();
        String attrClassName = Naming.getAttrClassName(declarationModel, 0);
        JCTree.JCBlock getterBlock = this.makeGetterBlock(expression);
        AttributeDefinitionBuilder builder = AttributeDefinitionBuilder.indirect(this, attrName, declarationModel, declarationModel.isToplevel()).getterBlock(getterBlock).immutable();
        ClassDefinitionBuilder classBuilder = ClassDefinitionBuilder.klass(this, attrClassName, null, false);
        com.redhat.ceylon.langtools.tools.javac.util.List<JCTree> attr = builder.buildWithWrapperClass(classBuilder);
        JCTree.JCNewClass newExpr = this.makeNewClass(attrClassName, false, null);
        JCTree.JCExpression result = this.makeLetExpr(this.naming.temp(), com.redhat.ceylon.langtools.tools.javac.util.List.of((JCTree.JCStatement)attr.get(0)), newExpr);
        return result;
    }

    public com.redhat.ceylon.langtools.tools.javac.util.List<JCTree> transformModuleDescriptor(Tree.ModuleDescriptor module) {
        this.at(null);
        ClassDefinitionBuilder builder = ClassDefinitionBuilder.klass(this, "$module_", null, false);
        builder.modifiers(16L).annotations(this.makeAtModule(module));
        builder.getInitBuilder().modifiers(2L);
        builder.annotations(this.expressionGen().transformAnnotations(OutputElement.TYPE, module));
        for (Tree.ImportModule imported : module.getImportModuleList().getImportModules()) {
            if (!TreeUtil.isForBackend(imported.getAnnotationList(), Backend.Java, imported.getUnit())) continue;
            if (imported.getName() == null) {
                throw new BugException(imported, "unhandled module import");
            }
            String quotedName = imported.getName().replace('.', '$');
            com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> importAnnotations = this.expressionGen().transformAnnotations(OutputElement.FIELD, imported);
            JCTree.JCModifiers mods = this.make().Modifiers(25L, importAnnotations);
            Name fieldName = this.names().fromString(quotedName);
            builder.defs(com.redhat.ceylon.langtools.tools.javac.util.List.of(this.make().VarDef(mods, fieldName, this.make().Type(this.syms().stringType), this.makeNull())));
        }
        return builder.build();
    }

    public com.redhat.ceylon.langtools.tools.javac.util.List<JCTree> transformPackageDescriptor(Tree.PackageDescriptor pack) {
        this.at(null);
        ClassDefinitionBuilder builder = ClassDefinitionBuilder.klass(this, "$package_", null, false).modifiers(16L).annotations(this.makeAtPackage(pack.getUnit().getPackage()));
        builder.getInitBuilder().modifiers(2L);
        builder.annotations(this.expressionGen().transformAnnotations(OutputElement.TYPE, pack));
        return builder.build();
    }

    public com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCCompilationUnit> transformPackageInfo(CeylonCompilationUnit ccu) {
        final CeylonFileObject fo = (CeylonFileObject)((CeylonPhasedUnit)ccu.phasedUnit).getFileObject();
        ListBuffer<JCTree.JCCompilationUnit> packageInfos = new ListBuffer<JCTree.JCCompilationUnit>();
        for (Tree.PackageDescriptor pack : ccu.ceylonTree.getPackageDescriptors()) {
            com.redhat.ceylon.langtools.tools.javac.util.List<JCTree.JCAnnotation> packageAnnotations = this.expressionGen().transformAnnotations(OutputElement.PACKAGE, pack);
            if (packageAnnotations.isEmpty()) continue;
            JCTree.JCCompilationUnit packageInfo = this.make().TopLevel(packageAnnotations, this.naming.makeQuotedFQIdent(pack.getScope().getQualifiedNameString()), com.redhat.ceylon.langtools.tools.javac.util.List.nil());
            packageInfo.sourcefile = new JavaFileObject(){

                @Override
                public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
                    return "package-info".equals(simpleName) && JavaFileObject.Kind.SOURCE == kind;
                }

                @Override
                public URI toUri() {
                    return fo.toUri();
                }

                @Override
                public String getName() {
                    return fo.getName();
                }

                @Override
                public InputStream openInputStream() throws IOException {
                    return fo.openInputStream();
                }

                @Override
                public OutputStream openOutputStream() throws IOException {
                    return fo.openOutputStream();
                }

                @Override
                public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
                    return fo.openReader(ignoreEncodingErrors);
                }

                @Override
                public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
                    return fo.getCharContent(ignoreEncodingErrors);
                }

                @Override
                public Writer openWriter() throws IOException {
                    return fo.openWriter();
                }

                @Override
                public long getLastModified() {
                    return fo.getLastModified();
                }

                @Override
                public boolean delete() {
                    return fo.delete();
                }

                @Override
                public JavaFileObject.Kind getKind() {
                    return fo.getKind();
                }

                @Override
                public NestingKind getNestingKind() {
                    return fo.getNestingKind();
                }

                @Override
                public Modifier getAccessLevel() {
                    return fo.getAccessLevel();
                }
            };
            packageInfos.add(packageInfo);
        }
        return packageInfos.toList();
    }

    @Override
    public EeVisitor getEeVisitor() {
        return this.eeVisitor;
    }

    private static enum WantedDeclaration {
        Normal,
        Annotation,
        AnnotationSequence,
        InterfaceImpl;

    }
}

