/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.compiler.java.codegen.Decl;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import com.redhat.ceylon.langtools.tools.javac.main.Option;
import com.redhat.ceylon.langtools.tools.javac.util.Options;
import com.redhat.ceylon.model.loader.model.AnnotationProxyMethod;
import com.redhat.ceylon.model.typechecker.model.Declaration;
import com.redhat.ceylon.model.typechecker.model.Function;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.Package;
import com.redhat.ceylon.model.typechecker.model.TypedDeclaration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EeVisitor
extends Visitor {
    private final boolean eeOption;
    private final Set<String> imports;
    private final Set<String> annotations;
    private static final int EE = 1;
    private static final int TRANSIENT = 2;
    private static final int VOLATILE = 4;
    private static final int SYNCHRONIZED = 8;
    private static final int STRICTFP = 16;
    private Map<Declaration, Integer> eeModeDecls = new HashMap<Declaration, Integer>();
    private Set<Package> eeModePackages = new HashSet<Package>();
    private Set<Module> eeModeModules = new HashSet<Module>();

    public EeVisitor(Options options) {
        boolean bl = this.eeOption = options.get(Option.CEYLONEE) != null;
        if (options.getMulti(Option.CEYLONEEIMPORTS) != null) {
            this.imports = new HashSet<String>(options.getMulti(Option.CEYLONEEIMPORTS));
        } else {
            this.imports = new HashSet<String>();
            this.imports.add("javax.javaeeapi");
            this.imports.add("maven:\"javax:javaee-api\"");
        }
        if (options.getMulti(Option.CEYLONEEANNOTATIONS) != null) {
            this.annotations = new HashSet<String>(options.getMulti(Option.CEYLONEEANNOTATIONS));
        } else {
            this.annotations = new HashSet<String>();
            this.annotations.add("javax.xml.bind.annotation.XmlAccessorType");
            this.annotations.add("javax.persistence.Entity");
            this.annotations.add("javax.persistence.Embeddable");
            this.annotations.add("javax.inject.Inject");
            this.annotations.add("javax.ejb.Stateless");
            this.annotations.add("javax.ejb.Stateful");
            this.annotations.add("javax.ejb.MessageDriven");
            this.annotations.add("javax.ejb.Singleton");
        }
    }

    private boolean containsEeAnnotation(List<Tree.Annotation> annotations2) {
        for (Tree.Annotation a : annotations2) {
            String annotationTypeName;
            Declaration annoCtor;
            Tree.Primary prim = a.getPrimary();
            if (!(prim instanceof Tree.BaseMemberOrTypeExpression) || !((annoCtor = ((Tree.BaseMemberOrTypeExpression)prim).getDeclaration()) instanceof AnnotationProxyMethod) || !this.annotations.contains((annotationTypeName = ((AnnotationProxyMethod)annoCtor).proxyClass.iface.getQualifiedNameString()).replace("::", "."))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visit(Tree.Declaration that) {
        super.visit(that);
        Declaration a = that.getDeclarationModel();
        if (that.getAnnotationList() != null && that.getAnnotationList().getAnnotations() != null) {
            for (Tree.Annotation an : that.getAnnotationList().getAnnotations()) {
                Declaration ad = ((Tree.BaseMemberOrTypeExpression)an.getPrimary()).getDeclaration();
                if (ad == null) continue;
                String qualifiedName = ad.getQualifiedNameString();
                if ("java.lang::transient".equals(qualifiedName)) {
                    this.setModifier(a, 2);
                }
                if ("java.lang::volatile".equals(qualifiedName)) {
                    this.setModifier(a, 4);
                }
                if ("java.lang::synchronized".equals(qualifiedName)) {
                    this.setModifier(a, 8);
                }
                if (!"java.lang::strictfp".equals(qualifiedName)) continue;
                this.setModifier(a, 16);
            }
        }
    }

    private void setModifier(Declaration decl, int flag) {
        Integer mods = this.eeModeDecls.get(decl);
        int m = mods == null ? 0 : mods;
        this.eeModeDecls.put(decl, m |= flag);
    }

    @Override
    public void visit(Tree.ClassDefinition that) {
        super.visit(that);
        if (this.containsEeAnnotation(that.getAnnotationList().getAnnotations())) {
            this.setModifier(that.getDeclarationModel(), 1);
        }
    }

    @Override
    public void visit(Tree.Constructor that) {
        super.visit(that);
        if (this.containsEeAnnotation(that.getAnnotationList().getAnnotations())) {
            this.setModifier(Decl.getConstructedClass(that.getDeclarationModel()), 1);
        }
    }

    @Override
    public void visit(Tree.AnyAttribute that) {
        super.visit(that);
        if (this.containsEeAnnotation(that.getAnnotationList().getAnnotations())) {
            TypedDeclaration attribute = that.getDeclarationModel();
            if (attribute.isMember()) {
                this.setModifier(Decl.getClassOrInterfaceContainer(attribute), 1);
            } else if (attribute.isToplevel()) {
                this.setModifier(attribute, 1);
            }
        }
    }

    @Override
    public void visit(Tree.AnyMethod that) {
        super.visit(that);
        if (this.containsEeAnnotation(that.getAnnotationList().getAnnotations())) {
            Function method = that.getDeclarationModel();
            if (method.isMember()) {
                this.setModifier(Decl.getClassOrInterfaceContainer(method), 1);
            } else if (method.isToplevel()) {
                this.setModifier(method, 1);
            }
        }
    }

    @Override
    public void visit(Tree.PackageDescriptor that) {
        super.visit(that);
        if (this.containsEeAnnotation(that.getAnnotationList().getAnnotations())) {
            this.eeModePackages.add((Package)that.getScope());
        }
    }

    @Override
    public void visit(Tree.ModuleDescriptor that) {
        super.visit(that);
        that.getImportModuleList();
    }

    @Override
    public void visit(Tree.ImportModule that) {
        super.visit(that);
        if (that.getName() != null) {
            String name = that.getName();
            if (that.getNamespace() != null) {
                name = that.getNamespace().getText() + ":" + name + "";
            }
            if (this.imports.contains(name)) {
                this.eeModeModules.add(that.getUnit().getPackage().getModule());
            }
        }
    }

    @Override
    public void visit(Tree.CompilationUnit that) {
        if (!(this.eeOption || this.annotations.isEmpty() && this.imports.isEmpty())) {
            super.visit(that);
        }
    }

    public boolean isEeMode(Declaration d) {
        d = Decl.getToplevelDeclarationContainer(d);
        if (this.eeOption || this.eeModeModules.contains(Decl.getModule(d)) || this.eeModePackages.contains(Decl.getPackage(d))) {
            return true;
        }
        Integer mods = this.eeModeDecls.get(d);
        return mods != null && (mods & 1) != 0;
    }

    public String toString() {
        return this.getClass().getName() + "( imports: " + this.imports + ", annotations: " + this.annotations + ")";
    }

    public boolean isJavaTransient(Declaration d) {
        Integer mods = this.eeModeDecls.get(d);
        return mods != null && (mods & 2) != 0;
    }

    public boolean isJavaVolatile(Declaration d) {
        Integer mods = this.eeModeDecls.get(d);
        return mods != null && (mods & 4) != 0;
    }

    public boolean isJavaSynchronized(Declaration d) {
        Integer mods = this.eeModeDecls.get(d);
        return mods != null && (mods & 8) != 0;
    }

    public boolean isJavaStrictfp(Declaration d) {
        Integer mods = this.eeModeDecls.get(d);
        return mods != null && (mods & 0x10) != 0;
    }
}

