/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.langtools.tools.javac.tree.JCTree;
import com.redhat.ceylon.langtools.tools.javac.tree.Pretty;
import com.redhat.ceylon.langtools.tools.javac.util.Position;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class JavaPositionsRetriever {
    private InternalWriter writer = null;
    private PrettyToRetrievePositions pretty = null;
    private int currentPosition = 0;
    private Map<Integer, Set<Integer>> ceylonToJavaPositions = new TreeMap<Integer, Set<Integer>>();
    private Map<Integer, Set<Integer>> ceylonToJavaLines = new TreeMap<Integer, Set<Integer>>();
    private Map<JCTree, Integer> javaPositions = new HashMap<JCTree, Integer>();
    private Map<Integer, Set<Node>> ceylonNodesAtPosition = new TreeMap<Integer, Set<Node>>();
    private Position.LineMap javaLineMap = null;
    private Position.LineMap ceylonLineMap = null;
    private JCTree.JCCompilationUnit unit = null;

    public Position.LineMap getJavaLineMap() {
        return this.javaLineMap;
    }

    public Position.LineMap getCeylonLineMap() {
        return this.ceylonLineMap;
    }

    public JavaPositionsRetriever() {
        this.writer = new InternalWriter();
        this.pretty = new PrettyToRetrievePositions(this.writer);
    }

    public void retrieve(JCTree.JCCompilationUnit unit) {
        this.unit = unit;
        this.pretty.visitTopLevel(unit);
        this.ceylonLineMap = unit.getLineMap();
        this.javaLineMap = Position.makeLineMap(this.writer.toCharArray(), this.writer.toCharArray().length, false);
        for (Integer ceylonPosition : this.ceylonToJavaPositions.keySet()) {
            if (ceylonPosition == -1) continue;
            int ceylonLine = this.ceylonLineMap.getLineNumber(ceylonPosition);
            for (Integer javaPosition : this.ceylonToJavaPositions.get(ceylonPosition)) {
                int javaLine = this.javaLineMap.getLineNumber(javaPosition);
                Set<Object> set = null;
                if (!this.ceylonToJavaLines.containsKey(ceylonLine)) {
                    set = new TreeSet();
                    this.ceylonToJavaLines.put(ceylonLine, set);
                } else {
                    set = this.ceylonToJavaLines.get(ceylonLine);
                }
                set.add(javaLine);
            }
        }
    }

    public String getSourceCode() {
        return this.writer.toString();
    }

    private String addCeylonLinesComments(char[] source) {
        String annotatedSourceCode = "";
        BufferedReader reader = new BufferedReader(new CharArrayReader(source));
        String line = null;
        int javaLine = 1;
        try {
            while ((line = reader.readLine()) != null) {
                annotatedSourceCode = annotatedSourceCode + line;
                String ceylonLines = this.getCeylonLinesForJavaLine(this.revertMap(this.ceylonToJavaLines), javaLine);
                annotatedSourceCode = annotatedSourceCode + (ceylonLines.isEmpty() ? "" : " // line " + ceylonLines);
                annotatedSourceCode = annotatedSourceCode + "\n";
                ++javaLine;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return annotatedSourceCode;
    }

    public String getJavaSourceCodeWithCeylonLines() {
        return this.addCeylonLinesComments(this.writer.toCharArray());
    }

    private String formatCeylonPosition(int position) {
        String result = this.ceylonLineMap.getLineNumber(position) + " : " + this.ceylonLineMap.getColumnNumber(position);
        if (this.ceylonNodesAtPosition != null && this.ceylonNodesAtPosition.containsKey(position)) {
            LinkedList<String> nodeLabels = new LinkedList<String>();
            for (Node node : this.ceylonNodesAtPosition.get(position)) {
                nodeLabels.add(node.getNodeType() + " - " + node.getToken().getText());
            }
            result = result + "(" + nodeLabels + ")";
        }
        return result;
    }

    public String getJavaSourceCodeWithCeylonPositions() {
        final CharArrayWriter writer = new CharArrayWriter();
        Pretty printer = new Pretty(writer, true){
            int previousCeylonPosition;
            int previousPositionInString;
            {
                super(x0, x1);
                this.previousCeylonPosition = -1;
                this.previousPositionInString = 0;
            }

            private void outputCeylonPosition(JCTree tree) {
                try {
                    int currentCeylonPosition = tree.getPreferredPosition();
                    int currentPositionInString = writer.size();
                    if (this.previousCeylonPosition != currentCeylonPosition || this.previousPositionInString != currentPositionInString) {
                        if (currentCeylonPosition != -1 && currentCeylonPosition != 0) {
                            writer.write("/* " + JavaPositionsRetriever.this.formatCeylonPosition(currentCeylonPosition) + " */");
                        }
                        this.previousCeylonPosition = currentCeylonPosition;
                        this.previousPositionInString = writer.size();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void visitTopLevel(JCTree.JCCompilationUnit tree) {
                this.outputCeylonPosition(tree);
                super.visitTopLevel(tree);
            }

            @Override
            public void visitImport(JCTree.JCImport tree) {
                this.outputCeylonPosition(tree);
                super.visitImport(tree);
            }

            @Override
            public void visitClassDef(JCTree.JCClassDecl tree) {
                this.outputCeylonPosition(tree);
                super.visitClassDef(tree);
            }

            @Override
            public void visitMethodDef(JCTree.JCMethodDecl tree) {
                this.outputCeylonPosition(tree);
                super.visitMethodDef(tree);
            }

            @Override
            public void visitVarDef(JCTree.JCVariableDecl tree) {
                this.outputCeylonPosition(tree);
                super.visitVarDef(tree);
            }

            @Override
            public void visitSkip(JCTree.JCSkip tree) {
                this.outputCeylonPosition(tree);
                super.visitSkip(tree);
            }

            @Override
            public void visitBlock(JCTree.JCBlock tree) {
                this.outputCeylonPosition(tree);
                super.visitBlock(tree);
                tree.endpos = JavaPositionsRetriever.this.currentPosition - 1;
            }

            @Override
            public void visitDoLoop(JCTree.JCDoWhileLoop tree) {
                this.outputCeylonPosition(tree);
                super.visitDoLoop(tree);
            }

            @Override
            public void visitWhileLoop(JCTree.JCWhileLoop tree) {
                this.outputCeylonPosition(tree);
                super.visitWhileLoop(tree);
            }

            @Override
            public void visitForLoop(JCTree.JCForLoop tree) {
                this.outputCeylonPosition(tree);
                super.visitForLoop(tree);
            }

            @Override
            public void visitForeachLoop(JCTree.JCEnhancedForLoop tree) {
                this.outputCeylonPosition(tree);
                super.visitForeachLoop(tree);
            }

            @Override
            public void visitLabelled(JCTree.JCLabeledStatement tree) {
                this.outputCeylonPosition(tree);
                super.visitLabelled(tree);
            }

            @Override
            public void visitSwitch(JCTree.JCSwitch tree) {
                this.outputCeylonPosition(tree);
                super.visitSwitch(tree);
            }

            @Override
            public void visitCase(JCTree.JCCase tree) {
                this.outputCeylonPosition(tree);
                super.visitCase(tree);
            }

            @Override
            public void visitSynchronized(JCTree.JCSynchronized tree) {
                this.outputCeylonPosition(tree);
                super.visitSynchronized(tree);
            }

            @Override
            public void visitTry(JCTree.JCTry tree) {
                this.outputCeylonPosition(tree);
                super.visitTry(tree);
            }

            @Override
            public void visitCatch(JCTree.JCCatch tree) {
                this.outputCeylonPosition(tree);
                super.visitCatch(tree);
            }

            @Override
            public void visitConditional(JCTree.JCConditional tree) {
                this.outputCeylonPosition(tree);
                super.visitConditional(tree);
            }

            @Override
            public void visitIf(JCTree.JCIf tree) {
                this.outputCeylonPosition(tree);
                super.visitIf(tree);
            }

            @Override
            public void visitExec(JCTree.JCExpressionStatement tree) {
                this.outputCeylonPosition(tree);
                super.visitExec(tree);
            }

            @Override
            public void visitBreak(JCTree.JCBreak tree) {
                this.outputCeylonPosition(tree);
                super.visitBreak(tree);
            }

            @Override
            public void visitContinue(JCTree.JCContinue tree) {
                this.outputCeylonPosition(tree);
                super.visitContinue(tree);
            }

            @Override
            public void visitReturn(JCTree.JCReturn tree) {
                this.outputCeylonPosition(tree);
                super.visitReturn(tree);
            }

            @Override
            public void visitThrow(JCTree.JCThrow tree) {
                this.outputCeylonPosition(tree);
                super.visitThrow(tree);
            }

            @Override
            public void visitAssert(JCTree.JCAssert tree) {
                this.outputCeylonPosition(tree);
                super.visitAssert(tree);
            }

            @Override
            public void visitApply(JCTree.JCMethodInvocation tree) {
                this.outputCeylonPosition(tree);
                super.visitApply(tree);
            }

            @Override
            public void visitNewClass(JCTree.JCNewClass tree) {
                this.outputCeylonPosition(tree);
                super.visitNewClass(tree);
            }

            @Override
            public void visitNewArray(JCTree.JCNewArray tree) {
                this.outputCeylonPosition(tree);
                super.visitNewArray(tree);
            }

            @Override
            public void visitParens(JCTree.JCParens tree) {
                this.outputCeylonPosition(tree);
                super.visitParens(tree);
            }

            @Override
            public void visitAssign(JCTree.JCAssign tree) {
                this.outputCeylonPosition(tree);
                super.visitAssign(tree);
            }

            @Override
            public void visitAssignop(JCTree.JCAssignOp tree) {
                this.outputCeylonPosition(tree);
                super.visitAssignop(tree);
            }

            @Override
            public void visitUnary(JCTree.JCUnary tree) {
                this.outputCeylonPosition(tree);
                super.visitUnary(tree);
            }

            @Override
            public void visitBinary(JCTree.JCBinary tree) {
                this.outputCeylonPosition(tree);
                super.visitBinary(tree);
            }

            @Override
            public void visitTypeCast(JCTree.JCTypeCast tree) {
                this.outputCeylonPosition(tree);
                super.visitTypeCast(tree);
            }

            @Override
            public void visitTypeTest(JCTree.JCInstanceOf tree) {
                this.outputCeylonPosition(tree);
                super.visitTypeTest(tree);
            }

            @Override
            public void visitIndexed(JCTree.JCArrayAccess tree) {
                this.outputCeylonPosition(tree);
                super.visitIndexed(tree);
            }

            @Override
            public void visitSelect(JCTree.JCFieldAccess tree) {
                this.outputCeylonPosition(tree);
                super.visitSelect(tree);
            }

            @Override
            public void visitIdent(JCTree.JCIdent tree) {
                this.outputCeylonPosition(tree);
                super.visitIdent(tree);
            }

            @Override
            public void visitLiteral(JCTree.JCLiteral tree) {
                this.outputCeylonPosition(tree);
                super.visitLiteral(tree);
            }

            @Override
            public void visitTypeIdent(JCTree.JCPrimitiveTypeTree tree) {
                this.outputCeylonPosition(tree);
                super.visitTypeIdent(tree);
            }

            @Override
            public void visitTypeArray(JCTree.JCArrayTypeTree tree) {
                this.outputCeylonPosition(tree);
                super.visitTypeArray(tree);
            }

            @Override
            public void visitTypeApply(JCTree.JCTypeApply tree) {
                this.outputCeylonPosition(tree);
                super.visitTypeApply(tree);
            }

            @Override
            public void visitTypeParameter(JCTree.JCTypeParameter tree) {
                this.outputCeylonPosition(tree);
                super.visitTypeParameter(tree);
            }

            @Override
            public void visitWildcard(JCTree.JCWildcard tree) {
                this.outputCeylonPosition(tree);
                super.visitWildcard(tree);
            }

            @Override
            public void visitTypeBoundKind(JCTree.TypeBoundKind tree) {
                this.outputCeylonPosition(tree);
                super.visitTypeBoundKind(tree);
            }

            @Override
            public void visitErroneous(JCTree.JCErroneous tree) {
                this.outputCeylonPosition(tree);
                super.visitErroneous(tree);
            }

            @Override
            public void visitLetExpr(JCTree.LetExpr tree) {
                this.outputCeylonPosition(tree);
                super.visitLetExpr(tree);
            }

            @Override
            public void visitModifiers(JCTree.JCModifiers mods) {
                this.outputCeylonPosition(mods);
                super.visitModifiers(mods);
            }

            @Override
            public void visitAnnotation(JCTree.JCAnnotation tree) {
                this.outputCeylonPosition(tree);
                super.visitAnnotation(tree);
            }

            @Override
            public void visitTree(JCTree tree) {
                this.outputCeylonPosition(tree);
                super.visitTree(tree);
            }
        };
        printer.visitTopLevel(this.unit);
        return writer.toString();
    }

    private Map<Integer, Set<Integer>> revertMap(Map<Integer, Set<Integer>> ceylonToJava) {
        TreeMap<Integer, Set<Integer>> result = new TreeMap<Integer, Set<Integer>>();
        for (int ceylonLine : this.ceylonToJavaLines.keySet()) {
            for (int javaLine : this.ceylonToJavaLines.get(ceylonLine)) {
                Set<Integer> set = null;
                if (!result.containsKey(javaLine)) {
                    set = new TreeSet();
                    result.put(javaLine, set);
                } else {
                    set = (Set)result.get(javaLine);
                }
                set.add(ceylonLine);
            }
        }
        return result;
    }

    private String getCeylonLinesForJavaLine(Map<Integer, Set<Integer>> javaToCeylonLineMap, int javaLine) {
        String result = "";
        Set<Integer> ceylonLines = javaToCeylonLineMap.get(javaLine);
        if (ceylonLines != null) {
            boolean first = true;
            for (Integer ceylonLine : ceylonLines) {
                if (!first) {
                    result = result + ", ";
                } else {
                    first = false;
                }
                result = result + ceylonLine.toString();
            }
        }
        return result;
    }

    public Map<Integer, Set<Integer>> getCeylonToJavaLineMap() {
        return this.ceylonToJavaLines;
    }

    public void addCeylonNode(int tokenStartPosition, Node node) {
        Set<Object> set = null;
        if (!this.ceylonNodesAtPosition.containsKey(tokenStartPosition)) {
            set = new LinkedHashSet();
            this.ceylonNodesAtPosition.put(tokenStartPosition, set);
        } else {
            set = this.ceylonNodesAtPosition.get(tokenStartPosition);
        }
        set.add(node);
    }

    private class PrettyToRetrievePositions
    extends Pretty {
        public PrettyToRetrievePositions(Writer out) {
            super(out, true);
        }

        private void storePositions(JCTree tree) {
            int javaPosition = JavaPositionsRetriever.this.currentPosition;
            JavaPositionsRetriever.this.javaPositions.put(tree, javaPosition);
            int ceylonPosition = tree.getPreferredPosition();
            Set<Integer> set = null;
            if (!JavaPositionsRetriever.this.ceylonToJavaPositions.containsKey(ceylonPosition)) {
                set = new TreeSet();
                JavaPositionsRetriever.this.ceylonToJavaPositions.put(ceylonPosition, set);
            } else {
                set = (Set)JavaPositionsRetriever.this.ceylonToJavaPositions.get(ceylonPosition);
            }
            set.add(JavaPositionsRetriever.this.currentPosition);
        }

        @Override
        public void visitTopLevel(JCTree.JCCompilationUnit tree) {
            this.storePositions(tree);
            super.visitTopLevel(tree);
        }

        @Override
        public void visitImport(JCTree.JCImport tree) {
            this.storePositions(tree);
            super.visitImport(tree);
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl tree) {
            this.storePositions(tree);
            super.visitClassDef(tree);
        }

        @Override
        public void visitMethodDef(JCTree.JCMethodDecl tree) {
            this.storePositions(tree);
            super.visitMethodDef(tree);
        }

        @Override
        public void visitVarDef(JCTree.JCVariableDecl tree) {
            this.storePositions(tree);
            super.visitVarDef(tree);
        }

        @Override
        public void visitSkip(JCTree.JCSkip tree) {
            this.storePositions(tree);
            super.visitSkip(tree);
        }

        @Override
        public void visitBlock(JCTree.JCBlock tree) {
            this.storePositions(tree);
            super.visitBlock(tree);
            tree.endpos = JavaPositionsRetriever.this.currentPosition - 1;
        }

        @Override
        public void visitDoLoop(JCTree.JCDoWhileLoop tree) {
            this.storePositions(tree);
            super.visitDoLoop(tree);
        }

        @Override
        public void visitWhileLoop(JCTree.JCWhileLoop tree) {
            this.storePositions(tree);
            super.visitWhileLoop(tree);
        }

        @Override
        public void visitForLoop(JCTree.JCForLoop tree) {
            this.storePositions(tree);
            super.visitForLoop(tree);
        }

        @Override
        public void visitForeachLoop(JCTree.JCEnhancedForLoop tree) {
            this.storePositions(tree);
            super.visitForeachLoop(tree);
        }

        @Override
        public void visitLabelled(JCTree.JCLabeledStatement tree) {
            this.storePositions(tree);
            super.visitLabelled(tree);
        }

        @Override
        public void visitSwitch(JCTree.JCSwitch tree) {
            this.storePositions(tree);
            super.visitSwitch(tree);
        }

        @Override
        public void visitCase(JCTree.JCCase tree) {
            this.storePositions(tree);
            super.visitCase(tree);
        }

        @Override
        public void visitSynchronized(JCTree.JCSynchronized tree) {
            this.storePositions(tree);
            super.visitSynchronized(tree);
        }

        @Override
        public void visitTry(JCTree.JCTry tree) {
            this.storePositions(tree);
            super.visitTry(tree);
        }

        @Override
        public void visitCatch(JCTree.JCCatch tree) {
            this.storePositions(tree);
            super.visitCatch(tree);
        }

        @Override
        public void visitConditional(JCTree.JCConditional tree) {
            this.storePositions(tree);
            super.visitConditional(tree);
        }

        @Override
        public void visitIf(JCTree.JCIf tree) {
            this.storePositions(tree);
            super.visitIf(tree);
        }

        @Override
        public void visitExec(JCTree.JCExpressionStatement tree) {
            this.storePositions(tree);
            super.visitExec(tree);
        }

        @Override
        public void visitBreak(JCTree.JCBreak tree) {
            this.storePositions(tree);
            super.visitBreak(tree);
        }

        @Override
        public void visitContinue(JCTree.JCContinue tree) {
            this.storePositions(tree);
            super.visitContinue(tree);
        }

        @Override
        public void visitReturn(JCTree.JCReturn tree) {
            this.storePositions(tree);
            super.visitReturn(tree);
        }

        @Override
        public void visitThrow(JCTree.JCThrow tree) {
            this.storePositions(tree);
            super.visitThrow(tree);
        }

        @Override
        public void visitAssert(JCTree.JCAssert tree) {
            this.storePositions(tree);
            super.visitAssert(tree);
        }

        @Override
        public void visitApply(JCTree.JCMethodInvocation tree) {
            this.storePositions(tree);
            super.visitApply(tree);
        }

        @Override
        public void visitNewClass(JCTree.JCNewClass tree) {
            this.storePositions(tree);
            super.visitNewClass(tree);
        }

        @Override
        public void visitNewArray(JCTree.JCNewArray tree) {
            this.storePositions(tree);
            super.visitNewArray(tree);
        }

        @Override
        public void visitParens(JCTree.JCParens tree) {
            this.storePositions(tree);
            super.visitParens(tree);
        }

        @Override
        public void visitAssign(JCTree.JCAssign tree) {
            this.storePositions(tree);
            super.visitAssign(tree);
        }

        @Override
        public void visitAssignop(JCTree.JCAssignOp tree) {
            this.storePositions(tree);
            super.visitAssignop(tree);
        }

        @Override
        public void visitUnary(JCTree.JCUnary tree) {
            this.storePositions(tree);
            super.visitUnary(tree);
        }

        @Override
        public void visitBinary(JCTree.JCBinary tree) {
            this.storePositions(tree);
            super.visitBinary(tree);
        }

        @Override
        public void visitTypeCast(JCTree.JCTypeCast tree) {
            this.storePositions(tree);
            super.visitTypeCast(tree);
        }

        @Override
        public void visitTypeTest(JCTree.JCInstanceOf tree) {
            this.storePositions(tree);
            super.visitTypeTest(tree);
        }

        @Override
        public void visitIndexed(JCTree.JCArrayAccess tree) {
            this.storePositions(tree);
            super.visitIndexed(tree);
        }

        @Override
        public void visitSelect(JCTree.JCFieldAccess tree) {
            this.storePositions(tree);
            super.visitSelect(tree);
        }

        @Override
        public void visitIdent(JCTree.JCIdent tree) {
            this.storePositions(tree);
            super.visitIdent(tree);
        }

        @Override
        public void visitLiteral(JCTree.JCLiteral tree) {
            this.storePositions(tree);
            super.visitLiteral(tree);
        }

        @Override
        public void visitTypeIdent(JCTree.JCPrimitiveTypeTree tree) {
            this.storePositions(tree);
            super.visitTypeIdent(tree);
        }

        @Override
        public void visitTypeArray(JCTree.JCArrayTypeTree tree) {
            this.storePositions(tree);
            super.visitTypeArray(tree);
        }

        @Override
        public void visitTypeApply(JCTree.JCTypeApply tree) {
            this.storePositions(tree);
            super.visitTypeApply(tree);
        }

        @Override
        public void visitTypeParameter(JCTree.JCTypeParameter tree) {
            this.storePositions(tree);
            super.visitTypeParameter(tree);
        }

        @Override
        public void visitWildcard(JCTree.JCWildcard tree) {
            this.storePositions(tree);
            super.visitWildcard(tree);
        }

        @Override
        public void visitTypeBoundKind(JCTree.TypeBoundKind tree) {
            this.storePositions(tree);
            super.visitTypeBoundKind(tree);
        }

        @Override
        public void visitErroneous(JCTree.JCErroneous tree) {
            this.storePositions(tree);
            super.visitErroneous(tree);
        }

        @Override
        public void visitLetExpr(JCTree.LetExpr tree) {
            this.storePositions(tree);
            super.visitLetExpr(tree);
        }

        @Override
        public void visitModifiers(JCTree.JCModifiers mods) {
            this.storePositions(mods);
            super.visitModifiers(mods);
        }

        @Override
        public void visitAnnotation(JCTree.JCAnnotation tree) {
            this.storePositions(tree);
            super.visitAnnotation(tree);
        }

        @Override
        public void visitTree(JCTree tree) {
            this.storePositions(tree);
            super.visitTree(tree);
        }
    }

    private class InternalWriter
    extends CharArrayWriter {
        private InternalWriter() {
        }

        @Override
        public void write(int c) {
            super.write(c);
            JavaPositionsRetriever.this.currentPosition++;
        }

        @Override
        public void write(char[] chars) throws IOException {
            super.write(chars);
            JavaPositionsRetriever.this.currentPosition += chars.length;
        }

        @Override
        public void write(String string) throws IOException {
            super.write(string);
            JavaPositionsRetriever.this.currentPosition += string.length();
        }
    }
}

