/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.compiler.typechecker.analyzer.AnalyzerUtil;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.TreeUtil;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;
import java.util.List;

public class ThrowVisitor
extends Visitor {
    private int definitelyReturns = 0;
    private boolean definitelyBreaksOrContinues = false;
    private boolean canReturn = false;
    private boolean canExecute = true;
    private Boolean possiblyBreaks = null;
    private boolean unreachabilityReported = false;

    public boolean getDefinitelyReturnsViaThrow() {
        return (this.definitelyReturns & 2) != 0;
    }

    void definitelyReturns() {
        this.definitelyReturns |= 1;
    }

    void definitelyThrows() {
        this.definitelyReturns |= 2;
    }

    int beginDefiniteReturnScope() {
        int dr = this.definitelyReturns;
        this.definitelyReturns = 0;
        return dr;
    }

    int beginIndefiniteReturnScope() {
        return this.definitelyReturns;
    }

    void endDefiniteReturnScope(int dr) {
        this.definitelyReturns = dr;
        this.unreachabilityReported = false;
    }

    boolean beginReturnScope(boolean cr) {
        boolean ocr = this.canReturn;
        this.canReturn = cr;
        return ocr;
    }

    void endReturnScope(boolean cr) {
        this.canReturn = cr;
    }

    boolean beginStatementScope(boolean ce) {
        boolean oce = this.canExecute;
        this.canExecute = ce;
        return oce;
    }

    void endStatementScope(boolean ce) {
        this.canExecute = ce;
    }

    Boolean beginLoop() {
        Boolean efl = this.possiblyBreaks;
        this.possiblyBreaks = false;
        return efl;
    }

    void endLoop(Boolean efl) {
        this.possiblyBreaks = efl;
    }

    boolean beginLoopScope() {
        boolean obc = this.definitelyBreaksOrContinues;
        this.definitelyBreaksOrContinues = false;
        return obc;
    }

    void exitLoopScope() {
        this.definitelyBreaksOrContinues = true;
    }

    void endLoopScope(boolean bc) {
        this.definitelyBreaksOrContinues = bc;
    }

    void exitLoop() {
        this.possiblyBreaks = true;
    }

    boolean inLoop() {
        return this.possiblyBreaks != null;
    }

    Boolean pauseLoop() {
        Boolean efl = this.possiblyBreaks;
        this.possiblyBreaks = null;
        return efl;
    }

    void unpauseLoop(Boolean efl) {
        this.possiblyBreaks = efl;
    }

    boolean pauseLoopScope() {
        Boolean bc = this.definitelyBreaksOrContinues;
        this.definitelyBreaksOrContinues = false;
        return bc;
    }

    void unpauseLoopScope(boolean bc) {
        this.definitelyBreaksOrContinues = bc;
    }

    @Override
    public void visit(Tree.AttributeGetterDefinition that) {
        boolean c = this.beginReturnScope(true);
        int d = this.beginDefiniteReturnScope();
        super.visit(that);
        this.checkDefiniteReturn(that, TreeUtil.name(that.getIdentifier()));
        this.endDefiniteReturnScope(d);
        this.endReturnScope(c);
    }

    @Override
    public void visit(Tree.AttributeArgument that) {
        if (that.getSpecifierExpression() == null) {
            boolean c = this.beginReturnScope(true);
            int d = this.beginDefiniteReturnScope();
            super.visit(that);
            this.checkDefiniteReturn(that, TreeUtil.name(that.getIdentifier()));
            this.endDefiniteReturnScope(d);
            this.endReturnScope(c);
        } else {
            super.visit(that);
        }
    }

    private void checkDefiniteReturn(Node that, String name) {
        if (this.definitelyReturns != 0) {
            name = name == null ? "anonymous function" : "'" + name + "'";
            that.addError("does not definitely return: " + name + " has branches which do not end in a return statement");
        }
    }

    @Override
    public void visit(Tree.MethodDefinition that) {
        boolean c = this.beginReturnScope(true);
        int d = this.beginDefiniteReturnScope();
        super.visit(that);
        if (!that.getDeclarationModel().isDeclaredVoid()) {
            this.checkDefiniteReturn(that, TreeUtil.name(that.getIdentifier()));
        }
        this.endDefiniteReturnScope(d);
        this.endReturnScope(c);
    }

    @Override
    public void visit(Tree.MethodArgument that) {
        if (that.getSpecifierExpression() == null) {
            boolean c = this.beginReturnScope(true);
            int d = this.beginDefiniteReturnScope();
            super.visit(that);
            if (!that.getDeclarationModel().isDeclaredVoid()) {
                this.checkDefiniteReturn(that, TreeUtil.name(that.getIdentifier()));
            }
            this.endDefiniteReturnScope(d);
            this.endReturnScope(c);
        } else {
            super.visit(that);
        }
    }

    @Override
    public void visit(Tree.FunctionArgument that) {
        if (that.getExpression() == null) {
            Boolean efl = this.pauseLoop();
            boolean bc = this.pauseLoopScope();
            boolean c = this.beginReturnScope(true);
            int d = this.beginDefiniteReturnScope();
            super.visit(that);
            if (!that.getDeclarationModel().isDeclaredVoid()) {
                this.checkDefiniteReturn(that, null);
            }
            this.endDefiniteReturnScope(d);
            this.endReturnScope(c);
            this.unpauseLoop(efl);
            this.unpauseLoopScope(bc);
        } else {
            super.visit(that);
        }
    }

    @Override
    public void visit(Tree.AttributeDeclaration that) {
        if (!that.getDeclarationModel().isParameter() && that.getSpecifierOrInitializerExpression() != null && !(that.getSpecifierOrInitializerExpression() instanceof Tree.LazySpecifierExpression)) {
            this.checkExecutableStatementAllowed(that.getSpecifierOrInitializerExpression());
            super.visit(that);
        } else {
            super.visit(that);
        }
    }

    @Override
    public void visit(Tree.AttributeSetterDefinition that) {
        boolean c = this.beginReturnScope(true);
        int d = this.beginDefiniteReturnScope();
        super.visit(that);
        this.endReturnScope(c);
        this.endDefiniteReturnScope(d);
    }

    @Override
    public void visit(Tree.Constructor that) {
        this.checkReachable(that);
        boolean c = this.beginReturnScope(true);
        int d = this.beginDefiniteReturnScope();
        super.visit(that);
        this.endReturnScope(c);
        this.endDefiniteReturnScope(d);
    }

    @Override
    public void visit(Tree.Enumerated that) {
        this.checkReachable(that);
        boolean c = this.beginReturnScope(true);
        int d = this.beginDefiniteReturnScope();
        super.visit(that);
        this.endReturnScope(c);
        this.endDefiniteReturnScope(d);
    }

    @Override
    public void visit(Tree.ClassDefinition that) {
        boolean c = this.beginReturnScope(true);
        int d = this.beginDefiniteReturnScope();
        super.visit(that);
        this.endReturnScope(c);
        this.endDefiniteReturnScope(d);
    }

    @Override
    public void visit(Tree.InterfaceDefinition that) {
        boolean c = this.beginReturnScope(false);
        int d = this.beginDefiniteReturnScope();
        super.visit(that);
        this.endReturnScope(c);
        this.endDefiniteReturnScope(d);
    }

    @Override
    public void visit(Tree.ObjectDefinition that) {
        boolean c = this.beginReturnScope(true);
        int d = this.beginDefiniteReturnScope();
        super.visit(that);
        this.endReturnScope(c);
        this.endDefiniteReturnScope(d);
    }

    @Override
    public void visit(Tree.ObjectArgument that) {
        boolean c = this.beginReturnScope(true);
        int d = this.beginDefiniteReturnScope();
        super.visit(that);
        this.endReturnScope(c);
        this.endDefiniteReturnScope(d);
    }

    @Override
    public void visit(Tree.ObjectExpression that) {
        boolean c = this.beginReturnScope(true);
        int d = this.beginDefiniteReturnScope();
        super.visit(that);
        this.endReturnScope(c);
        this.endDefiniteReturnScope(d);
    }

    @Override
    public void visit(Tree.Body that) {
        boolean e = this.beginStatementScope(!(that instanceof Tree.InterfaceBody));
        super.visit(that);
        this.endStatementScope(e);
    }

    @Override
    public void visit(Tree.LazySpecifierExpression that) {
        boolean e = this.beginStatementScope(true);
        super.visit(that);
        this.endStatementScope(e);
    }

    @Override
    public void visit(Tree.Block that) {
        super.visit(that);
    }

    @Override
    public void visit(Tree.Declaration that) {
    }

    @Override
    public void visit(Tree.TypedArgument that) {
        Boolean efl = this.pauseLoop();
        boolean bc = this.pauseLoopScope();
        super.visit(that);
        this.unpauseLoop(efl);
        this.unpauseLoopScope(bc);
    }

    @Override
    public void visit(Tree.ExecutableStatement that) {
        boolean executable = true;
        if (that instanceof Tree.SpecifierStatement) {
            Tree.SpecifierStatement s = (Tree.SpecifierStatement)that;
            boolean bl = executable = !(s.getSpecifierExpression() instanceof Tree.LazySpecifierExpression) || !s.getRefinement();
        }
        if (executable) {
            this.checkExecutableStatementAllowed(that);
        }
        super.visit(that);
    }

    private void checkExecutableStatementAllowed(Node that) {
        if (!this.canExecute) {
            that.addError("statement or initializer may not occur directly in interface body");
        }
    }

    @Override
    public void visit(Tree.Return that) {
        if (!this.canReturn) {
            that.addError("nothing to return from");
        }
        super.visit(that);
        this.definitelyReturns();
        this.exitLoopScope();
    }

    @Override
    public void visit(Tree.Throw that) {
        super.visit(that);
        this.definitelyThrows();
        this.exitLoopScope();
    }

    @Override
    public void visit(Tree.Break that) {
        if (!this.inLoop()) {
            that.addError("no surrounding loop to break");
        }
        super.visit(that);
        this.exitLoop();
        this.exitLoopScope();
    }

    @Override
    public void visit(Tree.Continue that) {
        if (!this.inLoop()) {
            that.addError("no surrounding loop to continue");
        }
        super.visit(that);
        this.exitLoopScope();
    }

    @Override
    public void visit(Tree.Statement that) {
        if (!(that instanceof Tree.Variable)) {
            this.checkReachable(that);
        }
        super.visit(that);
    }

    private void checkReachable(Tree.Statement that) {
        if ((this.definitelyReturns != 0 || this.definitelyBreaksOrContinues) && !this.unreachabilityReported) {
            that.addError("unreachable code");
            this.unreachabilityReported = true;
        }
    }

    @Override
    public void visit(Tree.WhileStatement that) {
        this.checkExecutableStatementAllowed(that);
        this.checkReachable(that);
        int d = this.beginIndefiniteReturnScope();
        Boolean b = this.beginLoop();
        boolean bc = this.beginLoopScope();
        that.getWhileClause().visit(this);
        boolean definitelyDoesNotBreakFromWhile = this.possiblyBreaks == false;
        int definitelyReturnsFromWhile = this.definitelyReturns;
        this.endDefiniteReturnScope(d);
        this.endLoop(b);
        this.endLoopScope(bc);
        if (AnalyzerUtil.isAlwaysSatisfied(that.getWhileClause().getConditionList()) && (definitelyDoesNotBreakFromWhile || definitelyReturnsFromWhile != 0)) {
            this.definitelyReturns = definitelyReturnsFromWhile;
        }
    }

    @Override
    public void visit(Tree.ForStatement that) {
        int definitelyReturnsFromElse;
        this.checkExecutableStatementAllowed(that);
        this.checkReachable(that);
        int d = this.beginIndefiniteReturnScope();
        Boolean b = this.beginLoop();
        boolean bc = this.beginLoopScope();
        boolean atLeastOneIteration = false;
        Tree.ForClause forClause = that.getForClause();
        if (forClause != null) {
            forClause.visit(this);
            atLeastOneIteration = AnalyzerUtil.isAtLeastOne(forClause);
        }
        boolean definitelyDoesNotBreakFromFor = this.possiblyBreaks == false;
        int definitelyReturnsFromFor = atLeastOneIteration && definitelyDoesNotBreakFromFor ? this.definitelyReturns : 0;
        that.setExits(this.possiblyBreaks);
        this.endLoop(b);
        this.endLoopScope(bc);
        this.definitelyReturns = d | definitelyReturnsFromFor;
        Tree.ElseClause elseClause = that.getElseClause();
        if (elseClause != null) {
            elseClause.visit(this);
            definitelyReturnsFromElse = definitelyDoesNotBreakFromFor ? this.definitelyReturns : 0;
        } else {
            definitelyReturnsFromElse = 0;
        }
        this.endLoopScope(bc);
        this.definitelyReturns = d | definitelyReturnsFromFor | definitelyReturnsFromElse;
    }

    @Override
    public void visit(Tree.IfStatement that) {
        Tree.ConditionList cl;
        boolean breaksOrContinuesFromElse;
        int definitelyReturnsFromElse;
        this.checkExecutableStatementAllowed(that);
        this.checkReachable(that);
        int d = this.beginIndefiniteReturnScope();
        Boolean e = this.possiblyBreaks;
        boolean bc = this.definitelyBreaksOrContinues;
        Tree.IfClause ifClause = that.getIfClause();
        if (ifClause != null) {
            ifClause.visit(this);
        }
        int definitelyReturnsFromIf = this.definitelyReturns;
        Boolean possiblyBreaksFromIf = this.possiblyBreaks;
        boolean breaksOrContinuesFromIf = this.definitelyBreaksOrContinues;
        this.possiblyBreaks = e;
        this.endDefiniteReturnScope(d);
        this.endLoopScope(bc);
        Tree.ElseClause elseClause = that.getElseClause();
        if (elseClause != null) {
            elseClause.visit(this);
            definitelyReturnsFromElse = this.definitelyReturns;
            breaksOrContinuesFromElse = this.definitelyBreaksOrContinues;
        } else {
            definitelyReturnsFromElse = 0;
            breaksOrContinuesFromElse = false;
        }
        Boolean possiblyBreaksFromElse = this.possiblyBreaks;
        this.possiblyBreaks = e;
        this.endLoopScope(bc);
        Tree.ConditionList conditionList = cl = ifClause == null ? null : ifClause.getConditionList();
        if (AnalyzerUtil.isAlwaysSatisfied(cl)) {
            this.definitelyReturns = d | definitelyReturnsFromIf;
            this.possiblyBreaks = possiblyBreaksFromIf;
            this.definitelyBreaksOrContinues = bc || breaksOrContinuesFromIf;
        } else if (AnalyzerUtil.isNeverSatisfied(cl)) {
            this.definitelyReturns = d | definitelyReturnsFromElse;
            this.possiblyBreaks = possiblyBreaksFromElse;
            this.definitelyBreaksOrContinues = bc || breaksOrContinuesFromElse;
        } else {
            this.definitelyReturns = d | definitelyReturnsFromIf & definitelyReturnsFromElse;
            this.possiblyBreaks = e == null ? null : Boolean.valueOf(possiblyBreaksFromIf != false || possiblyBreaksFromElse != false);
            this.definitelyBreaksOrContinues = bc || breaksOrContinuesFromIf && breaksOrContinuesFromElse;
        }
    }

    @Override
    public void visit(Tree.SwitchStatement that) {
        this.checkExecutableStatementAllowed(that);
        this.checkReachable(that);
        int d = this.beginIndefiniteReturnScope();
        boolean bc = this.definitelyBreaksOrContinues;
        that.getSwitchClause().visit(this);
        int definitelyReturnsFromEveryCase = 3;
        boolean definitelyBreaksOrContinuesFromEveryCase = true;
        List<Tree.CaseClause> caseClauses = that.getSwitchCaseList().getCaseClauses();
        for (Tree.CaseClause cc : caseClauses) {
            cc.visit(this);
            definitelyReturnsFromEveryCase &= this.definitelyReturns;
            definitelyBreaksOrContinuesFromEveryCase = definitelyBreaksOrContinuesFromEveryCase && this.definitelyBreaksOrContinues;
            this.endDefiniteReturnScope(d);
            this.endLoopScope(bc);
        }
        Tree.ElseClause elseClause = that.getSwitchCaseList().getElseClause();
        if (elseClause != null) {
            elseClause.visit(this);
            definitelyReturnsFromEveryCase &= this.definitelyReturns;
            definitelyBreaksOrContinuesFromEveryCase = definitelyBreaksOrContinuesFromEveryCase && this.definitelyBreaksOrContinues;
            this.endDefiniteReturnScope(d);
            this.endLoopScope(bc);
        }
        this.definitelyReturns = d | definitelyReturnsFromEveryCase;
        this.definitelyBreaksOrContinues = bc || definitelyBreaksOrContinuesFromEveryCase;
    }

    @Override
    public void visit(Tree.TryCatchStatement that) {
        boolean definitelyBreaksOrContinuesFromFinally;
        int definitelyReturnsFromFinally;
        this.checkExecutableStatementAllowed(that);
        this.checkReachable(that);
        int d = this.beginIndefiniteReturnScope();
        boolean bc = this.definitelyBreaksOrContinues;
        Tree.TryClause tryClause = that.getTryClause();
        if (tryClause != null) {
            tryClause.visit(this);
        }
        int definitelyReturnsFromTry = this.definitelyReturns;
        boolean definitelyBreaksOrContinuesFromTry = this.definitelyBreaksOrContinues;
        this.endDefiniteReturnScope(d);
        this.endLoopScope(bc);
        int definitelyReturnsFromEveryCatch = 3;
        boolean definitelyBreaksOrContinuesFromEveryCatch = true;
        for (Tree.CatchClause cc : that.getCatchClauses()) {
            cc.visit(this);
            definitelyReturnsFromEveryCatch &= this.definitelyReturns;
            definitelyBreaksOrContinuesFromEveryCatch = definitelyBreaksOrContinuesFromEveryCatch && this.definitelyBreaksOrContinues;
            this.endDefiniteReturnScope(d);
            this.endLoopScope(bc);
        }
        Tree.FinallyClause finallyClause = that.getFinallyClause();
        if (finallyClause != null) {
            finallyClause.visit(this);
            definitelyReturnsFromFinally = this.definitelyReturns;
            definitelyBreaksOrContinuesFromFinally = this.definitelyBreaksOrContinues;
        } else {
            definitelyReturnsFromFinally = 0;
            definitelyBreaksOrContinuesFromFinally = false;
        }
        this.definitelyReturns = d | definitelyReturnsFromTry & definitelyReturnsFromEveryCatch | definitelyReturnsFromFinally;
        this.definitelyBreaksOrContinues = bc || definitelyBreaksOrContinuesFromTry && definitelyBreaksOrContinuesFromEveryCatch || definitelyBreaksOrContinuesFromFinally;
    }

    @Override
    public void visit(Tree.ExpressionStatement that) {
        super.visit(that);
        Tree.Expression expr = that.getExpression();
        if (expr != null) {
            Tree.Term t = expr.getTerm();
            if (t == null) {
                expr.addError("malformed expression statement");
            } else if (!(t instanceof Tree.InvocationExpression || t instanceof Tree.PostfixOperatorExpression || t instanceof Tree.PrefixOperatorExpression || t instanceof Tree.AssignmentOp)) {
                expr.addError("not a legal statement (not an invocation, assignment, or increment/decrement)", 3000);
            }
        }
    }

    @Override
    public void visit(Tree.Assertion that) {
        super.visit(that);
        if (AnalyzerUtil.isNeverSatisfied(that.getConditionList())) {
            this.definitelyThrows();
        }
    }
}

