/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.codegen;

import com.redhat.ceylon.model.typechecker.model.Type;
import java.util.List;

public class TypeVisitor {
    public void visitType(Type t) {
        Type qt = t.getQualifyingType();
        if (qt != null) {
            this.visitQualifyingType(t, qt);
        }
        if (t.isUnknown()) {
            this.visitUnknown();
        } else if (t.isUnion()) {
            this.visitUnion(t.getCaseTypes());
        } else if (t.isIntersection()) {
            this.visitIntersection(t.getSatisfiedTypes());
        } else if (t.isNothing()) {
            this.visitNothing();
        } else if (t.isTypeAlias()) {
            this.visitTypeAlias(t);
        } else if (t.isClass()) {
            this.visitClass(t);
        } else if (t.isInterface()) {
            this.visitInterface(t);
        }
    }

    public void visitClassOrInterface(Type t) {
        if (!t.getTypeArgumentList().isEmpty()) {
            this.visitTypeArguments(t, t.getTypeArgumentList());
        }
    }

    public void visitClass(Type t) {
        this.visitClassOrInterface(t);
    }

    public void visitInterface(Type t) {
        this.visitClassOrInterface(t);
    }

    public void visitTypeAlias(Type t) {
    }

    public void visitTypeArguments(Type typeConstructor, List<Type> typeArguments) {
        for (Type at : typeArguments) {
            this.visitType(at);
        }
    }

    public void visitNothing() {
    }

    public void visitIntersection(List<Type> intersectionTypes) {
        for (Type st : intersectionTypes) {
            this.visitType(st);
        }
    }

    public void visitUnion(List<Type> unionTypes) {
        for (Type ct : unionTypes) {
            this.visitType(ct);
        }
    }

    public void visitUnknown() {
    }

    public void visitQualifyingType(Type qualified, Type qualifying) {
        this.visitType(qualifying);
    }
}

