/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.loader;

import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.compiler.typechecker.tree.Tree;
import com.redhat.ceylon.compiler.typechecker.tree.TreeUtil;
import com.redhat.ceylon.compiler.typechecker.tree.Visitor;

public abstract class SourceDeclarationVisitor
extends Visitor {
    public abstract void loadFromSource(Tree.ModuleDescriptor var1);

    public abstract void loadFromSource(Tree.PackageDescriptor var1);

    public abstract void loadFromSource(Tree.Declaration var1);

    protected boolean checkNative(Tree.Declaration decl) {
        return TreeUtil.isForBackend(decl.getAnnotationList(), Backend.Java, decl.getUnit()) || TreeUtil.isForBackend(decl.getAnnotationList(), Backend.Header, decl.getUnit()) && this.hasImplementation(decl);
    }

    private boolean hasImplementation(Tree.Declaration decl) {
        if (decl instanceof Tree.AttributeDeclaration) {
            return ((Tree.AttributeDeclaration)decl).getSpecifierOrInitializerExpression() != null;
        }
        if (decl instanceof Tree.AttributeGetterDefinition) {
            return ((Tree.AttributeGetterDefinition)decl).getBlock() != null;
        }
        if (decl instanceof Tree.AttributeSetterDefinition) {
            return ((Tree.AttributeSetterDefinition)decl).getBlock() != null;
        }
        if (decl instanceof Tree.MethodDeclaration) {
            return ((Tree.MethodDeclaration)decl).getSpecifierExpression() != null;
        }
        if (decl instanceof Tree.MethodDefinition) {
            return ((Tree.MethodDefinition)decl).getBlock() != null;
        }
        return false;
    }

    @Override
    public void visit(Tree.ModuleDescriptor that) {
        this.loadFromSource(that);
    }

    @Override
    public void visit(Tree.PackageDescriptor that) {
        this.loadFromSource(that);
    }

    @Override
    public void visit(Tree.TypeAliasDeclaration that) {
        this.loadFromSource(that);
    }

    @Override
    public void visit(Tree.AnyClass that) {
        this.loadFromSource(that);
    }

    @Override
    public void visit(Tree.AnyInterface that) {
        this.loadFromSource(that);
    }

    @Override
    public void visit(Tree.ObjectDefinition that) {
        this.loadFromSource(that);
    }

    @Override
    public void visit(Tree.AnyMethod that) {
        this.loadFromSource(that);
    }

    @Override
    public void visit(Tree.AttributeDeclaration that) {
        this.loadFromSource(that);
    }

    @Override
    public void visit(Tree.AttributeGetterDefinition that) {
        this.loadFromSource(that);
    }
}

