/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.loader.model;

import com.redhat.ceylon.cmr.api.ModuleDependencyInfo;
import com.redhat.ceylon.cmr.api.ModuleInfo;
import com.redhat.ceylon.cmr.api.Overrides;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.api.VersionComparator;
import com.redhat.ceylon.cmr.ceylon.loader.ModuleNotFoundException;
import com.redhat.ceylon.common.Backend;
import com.redhat.ceylon.common.Backends;
import com.redhat.ceylon.common.ModuleUtil;
import com.redhat.ceylon.common.StatusPrinter;
import com.redhat.ceylon.common.Versions;
import com.redhat.ceylon.compiler.java.loader.CompilerModuleLoader;
import com.redhat.ceylon.compiler.java.tools.CeylonLog;
import com.redhat.ceylon.compiler.typechecker.analyzer.ModuleSourceMapper;
import com.redhat.ceylon.compiler.typechecker.analyzer.Warning;
import com.redhat.ceylon.compiler.typechecker.context.Context;
import com.redhat.ceylon.compiler.typechecker.context.PhasedUnits;
import com.redhat.ceylon.compiler.typechecker.tree.Node;
import com.redhat.ceylon.langtools.tools.javac.util.Log;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.cmr.JDKUtils;
import com.redhat.ceylon.model.cmr.ModuleScope;
import com.redhat.ceylon.model.loader.AbstractModelLoader;
import com.redhat.ceylon.model.loader.JdkProvider;
import com.redhat.ceylon.model.loader.model.LazyModule;
import com.redhat.ceylon.model.loader.model.LazyModuleManager;
import com.redhat.ceylon.model.typechecker.model.Module;
import com.redhat.ceylon.model.typechecker.model.ModuleImport;
import com.redhat.ceylon.model.typechecker.util.ModuleManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LazyModuleSourceMapper
extends ModuleSourceMapper {
    private final String encoding;
    private StatusPrinter statusPrinter;
    private boolean verbose;
    private CeylonLog log;

    public LazyModuleSourceMapper(Context context, LazyModuleManager moduleManager, StatusPrinter statusPrinter, boolean verbose, CeylonLog log) {
        this(context, moduleManager, statusPrinter, verbose, log, null);
    }

    public LazyModuleSourceMapper(Context context, LazyModuleManager moduleManager, StatusPrinter statusPrinter, boolean verbose, CeylonLog log, String encoding) {
        super(context, moduleManager);
        this.statusPrinter = statusPrinter;
        this.verbose = verbose;
        this.log = log;
        this.encoding = encoding;
    }

    @Override
    protected PhasedUnits createPhasedUnits() {
        PhasedUnits units = super.createPhasedUnits();
        if (this.encoding != null) {
            units.setEncoding(this.encoding);
        }
        return units;
    }

    @Override
    protected LazyModuleManager getModuleManager() {
        return (LazyModuleManager)super.getModuleManager();
    }

    @Override
    public void resolveModule(ArtifactResult artifact, Module module, ModuleImport moduleImport, LinkedList<Module> dependencyTree, List<PhasedUnits> phasedUnitsOfDependencies, boolean forCompiledModule) {
        String moduleName = module.getNameAsString();
        LazyModuleManager moduleManager = this.getModuleManager();
        boolean moduleLoadedFromSource = moduleManager.isModuleLoadedFromSource(moduleName);
        boolean isLanguageModule = module == module.getLanguageModule();
        AbstractModelLoader modelLoader = moduleManager.getModelLoader();
        if (modelLoader.getJdkProviderModule() == module) {
            modelLoader.setupAlternateJdk(module, artifact);
        }
        if ((moduleLoadedFromSource || forCompiledModule) && this.shouldAbortOnDuplicateModule(module, moduleName, modelLoader, dependencyTree)) {
            return;
        }
        if (moduleLoadedFromSource) {
            super.resolveModule(artifact, module, moduleImport, dependencyTree, phasedUnitsOfDependencies, forCompiledModule);
        } else if (forCompiledModule || isLanguageModule || moduleManager.shouldLoadTransitiveDependencies()) {
            modelLoader.addModuleToClassPath(module, artifact);
            LazyModule lazyModule = (LazyModule)module;
            if (!module.isDefaultModule()) {
                if (artifact.groupId() != null) {
                    module.setGroupId(artifact.groupId());
                }
                if (artifact.artifactId() != null) {
                    module.setArtifactId(artifact.artifactId());
                }
                if (!modelLoader.loadCompiledModule(module)) {
                    this.setupJavaModule(moduleImport, lazyModule, modelLoader, moduleManager, artifact);
                } else {
                    this.setupCeylonModule(moduleImport, lazyModule, modelLoader, moduleManager, artifact, dependencyTree);
                }
            }
            module.setAvailable(true);
        }
    }

    private void setupCeylonModule(ModuleImport moduleImport, LazyModule module, AbstractModelLoader modelLoader, ModuleManager moduleManager, ArtifactResult artifact, LinkedList<Module> dependencyTree) {
        Overrides overrides = this.getContext().getRepositoryManager().getOverrides();
        if (overrides != null) {
            HashSet<ModuleDependencyInfo> existingModuleDependencies = new HashSet<ModuleDependencyInfo>();
            for (ModuleImport i : module.getImports()) {
                Module m = i.getModule();
                if (m == null) continue;
                existingModuleDependencies.add(new ModuleDependencyInfo(i.getNamespace(), m.getNameAsString(), m.getVersion(), i.isOptional(), i.isExport(), i.getNativeBackends()));
            }
            ModuleInfo sourceModuleInfo = new ModuleInfo(artifact.name(), artifact.version(), artifact.groupId(), artifact.artifactId(), null, existingModuleDependencies);
            ModuleInfo newModuleInfo = overrides.applyOverrides(artifact.name(), artifact.version(), sourceModuleInfo);
            ArrayList<ModuleImport> newModuleImports = new ArrayList<ModuleImport>();
            for (ModuleDependencyInfo dep : newModuleInfo.getDependencies()) {
                Module dependency = moduleManager.getOrCreateModule(ModuleManager.splitModuleName(dep.getName()), dep.getVersion());
                Backends backends = dependency.getNativeBackends();
                ModuleImport newImport = new ModuleImport(dep.getNamespace(), dependency, dep.isOptional(), dep.isExport(), backends);
                newModuleImports.add(newImport);
            }
            module.overrideImports(newModuleImports);
        }
        if (!Versions.isJvmBinaryVersionSupported(module.getJvmMajor(), module.getJvmMinor())) {
            this.attachErrorToDependencyDeclaration(moduleImport, dependencyTree, "version '" + module.getVersion() + "' of module '" + module.getNameAsString() + "' was compiled by an incompatible version of the compiler (binary version " + module.getJvmMajor() + "." + module.getJvmMinor() + " of module is not compatible with binary version " + 8 + "." + 1 + " of this compiler)", true);
        }
    }

    private void setupJavaModule(ModuleImport moduleImport, LazyModule module, AbstractModelLoader modelLoader, ModuleManager moduleManager, ArtifactResult artifact) {
        module.setJava(true);
        module.setNativeBackends(Backend.Java.asSet());
        modelLoader.loadJava9Module(module, artifact.artifact());
        List<ArtifactResult> deps = artifact.dependencies();
        boolean forceExport = ModuleUtil.isMavenModule(module.getNameAsString()) && modelLoader.isFullyExportMavenDependencies();
        for (ArtifactResult dep : deps) {
            Module dependency;
            ModuleImport depImport;
            if (dep.moduleScope() != ModuleScope.COMPILE || dep.optional() || (depImport = moduleManager.findImport(module, dependency = moduleManager.getOrCreateModule(ModuleManager.splitModuleName(dep.name()), dep.version()))) != null) continue;
            moduleImport = new ModuleImport(dep.namespace(), dependency, dep.optional(), dep.exported() || forceExport && !dep.optional(), Backend.Java);
            module.addImport(moduleImport);
        }
    }

    private boolean shouldAbortOnDuplicateModule(Module module, String moduleName, AbstractModelLoader modelLoader, LinkedList<Module> dependencyTree) {
        String standardisedModuleName = ModuleUtil.toCeylonModuleName(moduleName);
        for (Module loadedModule : this.getContext().getModules().getListOfModules()) {
            String loadedModuleName = loadedModule.getNameAsString();
            String standardisedLoadedModuleName = ModuleUtil.toCeylonModuleName(loadedModuleName);
            boolean sameModule = loadedModuleName.equals(moduleName);
            boolean similarModule = standardisedLoadedModuleName.equals(standardisedModuleName);
            if (!sameModule && !similarModule || loadedModule.getVersion().equals(module.getVersion()) || !modelLoader.isModuleInClassPath(loadedModule)) continue;
            if (sameModule) {
                String[] versions = VersionComparator.orderVersions(module.getVersion(), loadedModule.getVersion());
                String error = "source code imports two different versions of module '" + moduleName + "': " + "version '" + versions[0] + "' and version '" + versions[1] + "'";
                this.addConflictingModuleErrorToModule(moduleName, dependencyTree.getFirst(), error);
            } else {
                String moduleB;
                String moduleA;
                if (loadedModuleName.compareTo(moduleName) < 0) {
                    moduleA = ModuleUtil.makeModuleName(loadedModuleName, loadedModule.getVersion());
                    moduleB = ModuleUtil.makeModuleName(moduleName, module.getVersion());
                } else {
                    moduleA = ModuleUtil.makeModuleName(moduleName, module.getVersion());
                    moduleB = ModuleUtil.makeModuleName(loadedModuleName, loadedModule.getVersion());
                }
                String error = "source code imports two different versions of similar modules '" + moduleA + "' and '" + moduleB + "'";
                this.addConflictingModuleWarningToModule(moduleA, dependencyTree.getFirst(), Warning.similarModule, error);
            }
            return true;
        }
        return false;
    }

    @Override
    public void attachErrorToDependencyDeclaration(ModuleImport moduleImport, List<Module> dependencyTree, String error, boolean isError) {
        String name = moduleImport.getModule().getNameAsString();
        JdkProvider jdkProvider = this.getJdkProvider();
        if (jdkProvider != null && jdkProvider.isJDKModule(name)) {
            error = "imported module '" + name + "' depends on JDK version '\"" + moduleImport.getModule().getVersion() + "\"' and you're compiling with Java " + jdkProvider.getJDKVersion();
        }
        super.attachErrorToDependencyDeclaration(moduleImport, dependencyTree, error, isError);
    }

    @Override
    public void addModuleDependencyDefinition(ModuleImport moduleImport, Node definition) {
        super.addModuleDependencyDefinition(moduleImport, definition);
        Module module = moduleImport.getModule();
        if (module == null) {
            return;
        }
        String nameAsString = module.getNameAsString();
        String version2 = module.getVersion();
        if (version2 != null && (JDKUtils.isJDKModule(nameAsString) || JDKUtils.isOracleJDKModule(nameAsString)) && JDKUtils.jdk.isLowerVersion(version2)) {
            definition.addUsageWarning(Warning.importsOtherJdk, "You import JDK7, which is provided by the JDK8 you are running on, but we cannot check that you are not using any JDK8-specific classes or methods. Upgrade your import to JDK8 if you depend on JDK8 classes or methods.", Backend.Java);
        }
    }

    @Override
    public Module getJdkModule() {
        return this.getModuleManager().getModelLoader().getJDKBaseModule();
    }

    @Override
    public Module getJdkProviderModule() {
        return this.getModuleManager().getModelLoader().getJdkProviderModule();
    }

    @Override
    public JdkProvider getJdkProvider() {
        return this.getModuleManager().getModelLoader().getJdkProvider();
    }

    @Override
    public void preResolveDependenciesIfRequired(RepositoryManager repositoryManager) {
        AbstractModelLoader modelLoader = this.getModuleManager().getModelLoader();
        if (!modelLoader.isFullyExportMavenDependencies()) {
            return;
        }
        if (this.statusPrinter != null) {
            this.statusPrinter.clearLine();
            this.statusPrinter.log("Pre-resolving dependencies");
        }
        if (this.verbose) {
            this.log.printRawLines(Log.WriterKind.NOTICE, "[Pre-resolving dependencies]");
        }
        Set<Module> compiledModules = this.getCompiledModules();
        HashMap<String, String> modules = new HashMap<String, String>();
        ModuleImport anyImport = null;
        for (Module module : compiledModules) {
            for (ModuleImport imp : module.getImports()) {
                if (imp.getModule() != null && compiledModules.contains(imp.getModule())) continue;
                if (anyImport == null) {
                    anyImport = imp;
                }
                modules.put(imp.getModule().getNameAsString(), imp.getModule().getVersion());
            }
        }
        if (this.statusPrinter != null) {
            this.statusPrinter.clearLine();
            this.statusPrinter.log("Pre-resolving found " + modules.size() + " to pre-resolve");
        }
        if (this.verbose) {
            this.log.printRawLines(Log.WriterKind.NOTICE, "[Pre-resolving " + modules.size() + " modules]");
        }
        if (modules.isEmpty()) {
            return;
        }
        Map.Entry first = modules.entrySet().iterator().next();
        CompilerModuleLoader ml = new CompilerModuleLoader(repositoryManager, null, modules, this.verbose, this.statusPrinter, this.log);
        boolean giveup = false;
        try {
            ml.loadModule((String)first.getKey(), (String)first.getValue(), ModuleScope.COMPILE);
        }
        catch (ModuleNotFoundException e) {
            this.attachErrorToDependencyDeclaration(anyImport, "Pre-resolving of module failed: " + e.getMessage(), true);
            giveup = true;
        }
        if (this.statusPrinter != null) {
            this.statusPrinter.clearLine();
            if (giveup) {
                this.statusPrinter.log("Pre-resolving failed");
            } else {
                this.statusPrinter.log("Pre-resolving resolved " + ml.getModuleCount());
            }
        }
        if (this.verbose) {
            if (giveup) {
                this.log.printRawLines(Log.WriterKind.NOTICE, "[Pre-resolved failed]");
            } else {
                this.log.printRawLines(Log.WriterKind.NOTICE, "[Pre-resolved " + ml.getModuleCount() + " modules]");
            }
        }
        if (giveup) {
            return;
        }
        Overrides overrides = repositoryManager.getOverrides();
        if (overrides == null) {
            overrides = Overrides.create();
            repositoryManager.setOverrides(overrides);
        }
        ml.setupOverrides(overrides);
        ml.cleanup();
    }
}

