/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.compiler.java.runtime.ide;

import com.redhat.ceylon.compiler.java.Util;
import com.redhat.ceylon.model.cmr.ArtifactResult;
import com.redhat.ceylon.model.cmr.ArtifactResultType;
import com.redhat.ceylon.model.cmr.Exclusion;
import com.redhat.ceylon.model.cmr.ModuleScope;
import com.redhat.ceylon.model.cmr.PathFilter;
import com.redhat.ceylon.model.cmr.Repository;
import com.redhat.ceylon.model.cmr.RepositoryException;
import com.redhat.ceylon.model.cmr.VisibilityType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;

public class Launcher {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        File descriptorFile;
        if (args.length < 2) {
            System.err.println("Expecting at least two arguments: module descriptor file and main class name");
            System.exit(1);
        }
        if (!((descriptorFile = new File(args[0])).exists() && descriptorFile.canRead() && descriptorFile.isFile())) {
            System.err.println("Module descriptor file cannot be read: " + descriptorFile);
            System.exit(1);
        }
        try {
            try (BufferedReader reader = new BufferedReader(new FileReader(descriptorFile));){
                Launcher.readModuleDescriptor(reader);
            }
            catch (IOException x) {
                x.printStackTrace();
                Launcher.error("IO error: " + x.getMessage());
            }
            Launcher.invokeMain(args);
        }
        catch (LauncherException x) {
            System.err.println(x.getMessage());
            System.exit(1);
        }
        finally {
            descriptorFile.delete();
        }
    }

    private static void invokeMain(String[] args) throws LauncherException {
        String main = args[1];
        if (main.isEmpty()) {
            Launcher.error("Main class cannot be empty");
        }
        try {
            Class<?> mainClass = Class.forName(main);
            Method m = mainClass.getMethod("main", String[].class);
            m.setAccessible(true);
            String[] newArgs = new String[args.length - 2];
            System.arraycopy(args, 2, newArgs, 0, newArgs.length);
            m.invoke(null, new Object[]{newArgs});
        }
        catch (ClassNotFoundException e) {
            Launcher.error("Main class not found: " + main);
        }
        catch (NoSuchMethodException e) {
            Launcher.error("Main method not found in: " + main);
        }
        catch (SecurityException e) {
            Launcher.error("Security exception when trying to obtain main for: " + main);
        }
        catch (IllegalAccessException e) {
            Launcher.error("Illegal access exception when invoking main for: " + main);
        }
        catch (IllegalArgumentException e) {
            Launcher.error("Illegal argument exception when invoking main for: " + main);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    private static void readModuleDescriptor(BufferedReader reader) throws IOException, LauncherException {
        String line;
        while ((line = reader.readLine()) != null) {
            File f;
            String file;
            String module = line;
            if (module.isEmpty()) {
                Launcher.error("Empty module line");
            }
            String version2 = null;
            if (!module.equals("default") && ((version2 = reader.readLine()) == null || version2.isEmpty())) {
                Launcher.error("Empty version line for " + module);
            }
            if ((file = reader.readLine()) == null || file.isEmpty()) {
                Launcher.error("Empty file line for " + module);
            }
            if (!((f = new File(file)).exists() && f.isFile() && f.canRead())) {
                Launcher.error("Cannot read " + file + " for " + module);
            }
            Util.loadModule(module, version2, Launcher.makeModuleArtifact(f), Launcher.class.getClassLoader());
        }
    }

    private static ArtifactResult makeModuleArtifact(final File f) {
        return new ArtifactResult(){

            @Override
            public String namespace() {
                return null;
            }

            @Override
            public String name() {
                return null;
            }

            @Override
            public String version() {
                return null;
            }

            @Override
            public boolean optional() {
                return false;
            }

            @Override
            public boolean exported() {
                return false;
            }

            @Override
            public ArtifactResultType type() {
                return null;
            }

            @Override
            public VisibilityType visibilityType() {
                return null;
            }

            @Override
            public File artifact() throws RepositoryException {
                return f;
            }

            @Override
            public List<ArtifactResult> dependencies() throws RepositoryException {
                return Collections.emptyList();
            }

            @Override
            public String repositoryDisplayString() {
                return "Unknown repository";
            }

            @Override
            public PathFilter filter() {
                return null;
            }

            @Override
            public Repository repository() {
                return null;
            }

            @Override
            public ModuleScope moduleScope() {
                return ModuleScope.COMPILE;
            }

            @Override
            public List<Exclusion> getExclusions() {
                return null;
            }

            @Override
            public String groupId() {
                return null;
            }

            @Override
            public String artifactId() {
                return null;
            }
        };
    }

    private static void error(String string) throws LauncherException {
        throw new LauncherException(string);
    }

    private static class LauncherException
    extends Exception {
        public LauncherException(String string) {
            super(string);
        }
    }
}

